/**************************************************************************//**
* \file     tunerAnnouncements.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef tunerAnnouncements_h
#define tunerAnnouncements_h


#include "datatypes/tunerDatatypes.h"
#include "datatypes/tVector.h"


#define IGNORE_ANNOUNCEMENTS 0x1f
#define ALWAYS_ALLOW_ANNOUNCEMENTS 0x1


namespace tuner
{
   namespace announcements
   {
      struct stTunerAnnouncements
      {
         tuner::common::enAnnouncement announcementId;
         tuner::common::enSourceId sourceId;
         tuner::common::enBand band;
         unsigned short priority;
      };

      struct stTunerAnnouncementInformation
      {
         tuner::common::enAnnouncement tunerAnnouncement;
         tuner::common::enSourceId tunerSourceId;
         tuner::common::enSrcActivity tunerSrcActivity;
      };

      struct stTunerAnnouncementSourceInformation
      {
     	 tuner::common::enSourceId tunerMainSource;
    	 tuner::common::enSourceId announcementSource;
      };
   }
}

   tuner::common::enBand oGetBand(tuner::common::enAnnouncement announcementId);
   tuner::common::enBand oGetAnnouncementSourceBand(tuner::common::enSourceId tunerSourceId);
   tuner::common::enSourceId oGetSourceId(tuner::common::enAnnouncement announcementId);
   tuner::common::enSourceId oGetMainSourceId(tuner::common::enSourceId announcementSource);
   tuner::common::enSourceId oGetAnnouncementSourceId(tuner::common::enSourceId tunerMainSource);

   unsigned short getDefaultPriority(tuner::common::enAnnouncement tunerAnnouncement);
   bool bIsAnnouncementSource(tuner::common::enSourceId announcementSource);
   tunerVector<tuner::common::enAnnouncement> oGetSourceAnnouncements(tuner::common::enSourceId tunerSourceId);


#endif // tunerAnnouncements_h
