/**************************************************************************//**
* \file     tunerAnnouncements.cpp
*
*           tunerAnnouncements method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "announcements/config/tunerAnnouncements.h"


using namespace tuner::common;
using namespace tuner::announcements;


static const stTunerAnnouncements atunerAnnouncements[] =
{
   #define TUNER_ANNOUNCEMENTS_MAP(announcementId, sourceId, bandId, priority)                  { announcementId, sourceId, bandId, priority},
   #include "tunerAnnouncements.dat"
   #undef TUNER_ANNOUNCEMENTS_MAP
};

static const stTunerAnnouncementSourceInformation aTunerAnnouncementSourceInformation[] =
{
   #define TUNER_ANNOUNCEMENT_SOURCE_MAP(tunerMainSource, tunerAnnouncementSource)                  { tunerMainSource, tunerAnnouncementSource},
   #include "tunerAnnouncements.dat"
   #undef TUNER_ANNOUNCEMENT_SOURCE_MAP
};

/**************************************************************************//**
*
******************************************************************************/
enBand oGetBand(tuner::common::enAnnouncement announcementId)
{
   const int mapSize = sizeof atunerAnnouncements / sizeof(stTunerAnnouncements);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (atunerAnnouncements[u32Index].announcementId == announcementId)
      {
         return atunerAnnouncements[u32Index].band;
      }
   }
   return BAND_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
enBand oGetAnnouncementSourceBand(tuner::common::enSourceId tunerSourceId)
{
   const int mapSize = sizeof atunerAnnouncements / sizeof(stTunerAnnouncements);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (atunerAnnouncements[u32Index].sourceId == tunerSourceId)
      {
         return atunerAnnouncements[u32Index].band;
      }
   }
   return BAND_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
enSourceId oGetSourceId(tuner::common::enAnnouncement announcementId)
{
   const int mapSize = sizeof atunerAnnouncements / sizeof(stTunerAnnouncements);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (atunerAnnouncements[u32Index].announcementId == announcementId)
      {
         return atunerAnnouncements[u32Index].sourceId;
      }
   }
   return SOURCEID_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
unsigned short getDefaultPriority(tuner::common::enAnnouncement announcementId)
{
	   const int mapSize = sizeof atunerAnnouncements / sizeof(stTunerAnnouncements);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (atunerAnnouncements[u32Index].announcementId == announcementId)
	      {
	         return atunerAnnouncements[u32Index].priority;
	      }
	   }
	   return IGNORE_ANNOUNCEMENTS;
}


/**************************************************************************//**
*
******************************************************************************/
tunerVector<tuner::common::enAnnouncement> oGetSourceAnnouncements(tuner::common::enSourceId tunerSourceId)
{
	tunerVector<tuner::common::enAnnouncement> announcementList;
	const int mapSize = sizeof atunerAnnouncements / sizeof(stTunerAnnouncements);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (atunerAnnouncements[u32Index].sourceId == tunerSourceId)
		{
			announcementList.push_back(atunerAnnouncements[u32Index].announcementId);
		}
	}
	return announcementList;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSourceId oGetMainSourceId(tuner::common::enSourceId announcementSource)
{
	const int mapSize = sizeof aTunerAnnouncementSourceInformation / sizeof(stTunerAnnouncementSourceInformation);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aTunerAnnouncementSourceInformation[u32Index].announcementSource == announcementSource)
		{
			return aTunerAnnouncementSourceInformation[u32Index].tunerMainSource;
		}
	}
	return tuner::common::SOURCEID_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSourceId oGetAnnouncementSourceId(tuner::common::enSourceId tunerMainSource)
{
	const int mapSize = sizeof aTunerAnnouncementSourceInformation / sizeof(stTunerAnnouncementSourceInformation);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aTunerAnnouncementSourceInformation[u32Index].tunerMainSource == tunerMainSource)
		{
			return aTunerAnnouncementSourceInformation[u32Index].announcementSource;
		}
	}
	return tuner::common::SOURCEID_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
bool bIsAnnouncementSource(tuner::common::enSourceId announcementSource)
{
	const int mapSize = sizeof aTunerAnnouncementSourceInformation / sizeof(stTunerAnnouncementSourceInformation);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aTunerAnnouncementSourceInformation[u32Index].announcementSource == announcementSource)
		{
			return true;
		}
	}
	return false;
}
