/**************************************************************************//**
* \file     clAnnouncements.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clAnnouncements_h
#define clAnnouncements_h

#include "datatypes/tunerDatatypes.h"
#include "announcements/clAnnouncementState.h"
#include "announcements/config/tunerAnnouncements.h"
#include "announcements/clAudioControl.h"
#include "datatypes/tString.h"
#include "datatypes/tMap.h"
#include "datatypes/tVector.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace tuner
{
   namespace announcements
   {
      class clTunerControl;

      class clAnnouncements
      {
      public:
         virtual ~clAnnouncements();
         static tuner::announcements::clAnnouncements* instance();
         static void deleteInstance();

         void vOnNewAnnouncementRequest(tuner::common::enAnnouncement announcementId, tuner::common::enSrcActivity tunerSrcActivity, tuner::common::enSourceId tunerSourceId,
        		 tuner::common::enSourceId activetunerSourceId,tuner::common::enSrcActivity activetunerSrcActivity);
         void vOnNewAnnouncementList(tunerVector<tuner::announcements::stTunerAnnouncementInformation>  announcementList, tuner::common::enSourceId activetunerSourceId,tuner::common::enSrcActivity activetunerSrcActivity);
         void vOnSourceChangeResponse(tuner::common::enSourceId sourceId, tuner::common::enSrcActivity tunerSrcActivity, tuner::common::enTunerState tunerState);
         void vOnNewTunerState(tuner::common::enTunerState tunerState);
         void vCancelAnnouncement();
		 void vClearAnnouncementStates();
         tuner::common::enAnnouncement oGetActiveAnnouncementId();
         tuner::common::enSrcActivity oGetActiveAnnouncementActivity();
         tuner::announcements::clAnnouncementState::enState oGetActiveAnnouncementState();
     	 tuner::common::enSrcActivity oGetActiveSessionActivity(); /*Added for NCG3D-39180*/
         void vSetPICode(unsigned short piCode);
         unsigned short oGetPICode();

         void vInit();
         void vDeInit();

         static tuner::announcements::clAnnouncements* m_poAnnouncements;

      private:
         clAnnouncements();
         void vPrintAnnouncementInformation();
         void vSynchronize();
         void vSynchronizeOnNewRequest();
		 void vSynchronizeConditionToActivateAnnouncement();
		 void vSynchronizeRequestedAnnouncementOfHigherPriority();
         bool bIsConditionToActivateAnnouncement();
         bool bIsSourceChangeRequired();
         void vRequestSourceChange();
         void vSetActiveAnnouncement();
         void vSendAnnouncementInformation();
         bool bIsRequestedAnnouncementActive();
         bool bIsRequestedAnnouncementOfHigherPriority();
         bool bIsAnnouncementOfMainSource();
         bool bIsTunerInBackGround();
         bool bPlayOtherAnnouncements();
		 bool bPlayAnnouncementInNonRadio();
         bool bIsTpSupportedInCurrentBand();
         bool bIsServiceFollowingActive();
         bool bIsRequestedStateCompleted(tuner::common::enAnnouncement announcementId, tuner::common::enSrcActivity tunerSrcActivity,  tuner::common::enSourceId tunerSourceId);
         bool bIsActiveStateFailed();
		 bool bIsRequestedStateIsSwitched(tuner::common::enSrcActivity tunerSrcActivity);
		 bool bIsRequestedAnnouncementPriorityIsLessThanOREqualActiveAnnounementPriority(tuner::common::enAnnouncement tunerAnnouncement);
		 bool bIsLowestPriorityAnnouncementSrcOffRequest(tuner::announcements::stTunerAnnouncementInformation  announcementInfo);
		 bool bIsActiveAnnounementSrcOffRequest(tunerVector<tuner::announcements::stTunerAnnouncementInformation>  announcementList);
         bool bIsRequestedAnnouncementFailed();
         bool bIsValidAnnouncementType(tuner::common::enAnnouncement announcementId);
         tuner::common::enAnnouncement oGetAnnouncement(tuner::common::enAnnouncement announcementId, tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
         tuner::announcements::stTunerAnnouncementInformation oGetHighestPriorityAnnouncement(tunerVector<tuner::announcements::stTunerAnnouncementInformation>  announcementList);
         tU8 u8getSourceFromAnnouncement(tuner::common::enAnnouncement announcementId);
         bool isPreferredAnnouncementSource(bool isDABPreferred, tuner::common::enSourceId tunerSourceId);
		 void vRestoreStoredVariables();


         tuner::announcements::clAnnouncementState requestedAnnouncement;
         tuner::announcements::clAnnouncementState activeAnnouncement;
         tuner::announcements::clAnnouncementState activesession;
		 tuner::announcements::clAnnouncementState requestedAnnouncementTemp;
		 tuner::announcements::clAnnouncementState activesessionTemp;
         tuner::announcements::clTunerControl* tunerControl;
         tuner::announcements::clAudioControl audioControl;
         unsigned short PICode;


      };
   }
}

#endif // clAnnouncements_h
