/**************************************************************************//**
* \file     clAnnouncementState.cpp
*
*           clAnnouncementState method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "announcements/clAnnouncementState.h"
#include "datatypes/tunerDatatypes.h"
#include "announcements/config/tunerAnnouncements.h"
#include "common/tuner_trace.h"


using namespace tuner::common;
using namespace tuner::announcements;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_ANNOUNCEMENTS
#include "trcGenProj/Header/clAnnouncementState.cpp.trc.h"
#endif




/**************************************************************************//**
* Constructor
******************************************************************************/
clAnnouncementState::clAnnouncementState()
   :state(ANNOUNCEMENT_COMPLETED)
   , tunerSource(SOURCEID_LIMIT)
   , announcementId(ANNOUNCEMENT_LIMIT)
   , tunerSrcActivity(SRCACTIVITY_UNKNOWN)
   , tunerState(TUNERSTATE_UNKNOWN)
   , priority(IGNORE_ANNOUNCEMENTS)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clAnnouncementState::~clAnnouncementState()
{

}


/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementState::vReset()
{
   state = ANNOUNCEMENT_COMPLETED;
   tunerSource = SOURCEID_LIMIT;
   announcementId = ANNOUNCEMENT_LIMIT;
   tunerSrcActivity = SRCACTIVITY_UNKNOWN;
   priority = IGNORE_ANNOUNCEMENTS;
   tunerState = TUNERSTATE_UNKNOWN;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsAnnouncementRequested()
{
   if (state == ANNOUNCEMENT_REQUESTED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsAnnouncementFailed()
{
   if (state == ANNOUNCEMENT_FAILED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsAnnouncementNotAllowed()
{
   if (state == ANNOUNCEMENT_NOT_ALLOWED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsAnnouncementRequestCompleted()
{
   if (state == ANNOUNCEMENT_COMPLETED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsAnnouncementRequestInProgress()
{
   if (state == ANNOUNCEMENT_REQUEST_IN_PROGRESS)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsActivateRequest()
{
   if (tunerSrcActivity == SRCON)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIsDeactivateRequest()
{
   if (tunerSrcActivity == SRCOFF || tunerSrcActivity == SRCPAUSE)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bIgnoreAnnouncement()
{
   if (priority == IGNORE_ANNOUNCEMENTS)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementState::bAlwaysPlayAnnouncement()
{
   if (priority == ALWAYS_ALLOW_ANNOUNCEMENTS)
   {
      return true;
   }
   return false;
}
