/**************************************************************************//**
* \file     clAnnouncementSettings.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clAnnouncementSettings_h
#define clAnnouncementSettings_h

#include "datatypes/tunerDatatypes.h"
#include "announcements/config/tunerAnnouncements.h"
#include "datatypes/tString.h"
#include "datatypes/tMap.h"


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace tuner
{
   namespace announcements
   {
      class clAnnouncementSettings
      {
      public:
         virtual ~clAnnouncementSettings();
         static tuner::announcements::clAnnouncementSettings* instance();
         static void deleteInstance();
         void vSetAnnouncementPriority(tuner::common::enAnnouncement announcement, unsigned short priority);
         void vSetPlayOtherAnnouncements(tuner::common::enSourceId tunerSourceId, tuner::common::enSourceId AnnouncementSource, bool bSupport);
         void vSetAnnouncementSurvivellenceModeSupport(tuner::common::enSourceId tunerSourceId, bool bSupport);
         void vOnNewTpState(tuner::common::enBand tunerBand, tuner::common::enTpState tpState );
         void vOnSourceFollowingState(tuner::common::enBand tunerBand, bool bSourceFollowing);

         bool bPlayOtherAnnouncements(tuner::common::enSourceId tunerSourceId, tuner::common::enSourceId AnnouncementType);
         bool bIsAnnouncementSurvivellenceModeSupport(tuner::common::enSourceId tunerSourceId);
         bool bIsTpSupportedInBand(tuner::common::enSourceId tunerSourceId);
         bool bIsServiceFollowingActive(tuner::common::enSourceId tunerSourceId);


         unsigned short u16GetAnnouncementPriority(tuner::common::enAnnouncement announcement);
         tuner::common::enAnnouncement oGetHighestPriorityAnnouncement(tuner::common::enSourceId tunerSourceId);
         tuner::announcements::stTunerAnnouncementInformation oGetHighestPriorityAnnouncement(tunerVector<tuner::announcements::stTunerAnnouncementInformation>  announcementList);

         static tuner::announcements::clAnnouncementSettings* m_poAnnouncementSettings;

      private:
         clAnnouncementSettings();
         void vInitializeDefaultValues();
         tunerMap<tuner::common::enAnnouncement, unsigned short> AnnouncementPriorityMap;
         tunerMap<tuner::common::enSourceId, tunerPair<tuner::common::enSourceId, bool> > TrafficAnnouncementInOtherSourceMap;
         tunerMap<tuner::common::enBand, tuner::common::enTpState> TpStateMap;
         tunerMap<tuner::common::enBand, bool> ServiceFollowingMap;
         tunerMap<tuner::common::enSourceId, bool> AnnoSurvivellenceMode;
      };
   }
}

#endif // clAnnouncementSettings_h
