/************************************************************************
* FILE:           clSessionControl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of the Class clSessionControl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/audio/clAudioSession.h"
#include "convTables/midwTunerMap.h"
#include "common/tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_SESSIONMANAGEMENT
#include "trcGenProj/Header/clSessionControl.cpp.trc.h"
#endif

using namespace tuner::sessionManagement::audio;
using namespace tuner::common;

clSessionControl* clSessionControl::m_poSessionControl = 0;


clSessionControl::clSessionControl()
:tunerState(TUNERSTATE_UNKNOWN)
, tunerBand(BAND_LIMIT)
{

}


clSessionControl::~clSessionControl(){

}


clSessionControl* clSessionControl::getInstance()
{
	if (m_poSessionControl != 0)
	{
		return m_poSessionControl;
	}
	m_poSessionControl = new clSessionControl();
	return m_poSessionControl;
}


void clSessionControl::vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, unsigned char audioSink){

	tunerState = getTunerState(midwTunerHeader);
	clAudioSession::instance()->vOnNewTunerState(tunerState, tuner::common::AMFMTUNER, audioSink);
}


void clSessionControl::vOnNewTunerState(midw_ext_fi_tcl_e8_DAB_SourceState::tenType dabTunerState){

	tunerState = getTunerState(dabTunerState);
	if((oGetRequestedSource() == tuner::common::DABANNOUNCEMENTS) && (clAudioSession::instance()->getRequestedSessionSrcActivity() == tuner::common::SRCOFF))
	{
		clAudioSession::instance()->vOnNewTunerState(tuner::common::TUNERTOBG, tuner::common::DABTUNER, 0xff);
	}
	else
	{
		clAudioSession::instance()->vOnNewTunerState(tunerState, tuner::common::DABTUNER, 0xff);
	}
}

void clSessionControl::vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, midw_fi_tcl_e8_Tun_MTCAudioSource::tenType midwTunerSource)
{
	tunerState = getTunerState(midwTunerHeader);
	clAudioSession::instance()->vOnNewTunerState(tunerState, getTunerSourceId(midwTunerSource));
}

void clSessionControl::vOnNewDabTunerState(tuner::common::enTunerState dabTunerState)
{
	clAudioSession::instance()->vOnNewDabTunerState(dabTunerState);
}


void clSessionControl::vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand){

   tunerBand = getTunerBand(midwTunerBand);
   clAudioSession::instance()->vOnNewTunerBand(tunerBand);
}


void clSessionControl::vRequestMute(bool bMute, bool bInterrupt){

	tuner::common::enBand activeTunerBand = getActiveTunerBand();
	ETG_TRACE_USR4(("SESSION_MGT: vRequestMute      activeTunerBand   = %d\n", ETG_ENUM(TUNER_BAND, (tU8)activeTunerBand) ));
	if((activeTunerBand != tuner::common::BANDNONE) && (activeTunerBand != tuner::common::BAND_LIMIT))
	{
		clAudioSession::instance()->vRequestMute(tuner::common::enMuteState(bMute), bInterrupt, oGetTunerSourceId(activeTunerBand));
	}
}


void clSessionControl::vOnDirectFrequencyResult(){

   clAudioSession::instance()->vOnDirectFrequencyResult();
}

bool clSessionControl::bOnDirectFrequency(midw_fi_tcl_e8_Band::tenType midwTunerMasterBand, unsigned int directFrequency)
{
	tuner::common::enSourceId tunerSourceId = getTunerSourceId(midwTunerMasterBand);
	if(tunerSourceId == tuner::common::SOURCEID_LIMIT)
	{
		ETG_TRACE_USR4(("SESSION_MGT:bOnDirectFrequency() invlaid request" ));
		return false; 
	}
	clAudioSession::instance()->vOnDirectFrequency(tunerSourceId, directFrequency);
	return true;
}


tuner::common::enTunerState clSessionControl::getActiveTunerState(tuner::common::enTunerClient tunerClient){
   ETG_TRACE_USR4(("SESSION_MGT: getActiveTunerState      TunerState   = %d\n", ETG_ENUM(TUNER_STATE, (tU8)clAudioSession::instance()->getActiveTunerState(tunerClient))));
   return clAudioSession::instance()->getActiveTunerState(tunerClient);
}


tuner::common::enBand clSessionControl::getActiveTunerBand(){

	return clAudioSession::instance()->oGetActiveTunerBand();
}

void clSessionControl::vOnServiceState(tuner::common::enTunerClient tunerClient, tuner::common::enTunerClientAvailability tunerClientAvailable)
{
	clAudioSession::instance()->vOnServiceState(tunerClient, tunerClientAvailable);
}

bool clSessionControl::bIsServiceUnAvailable(tuner::common::enSourceId tunerSourceId)
{
	return clAudioSession::instance()->bIsServiceUnAvailable(tunerSourceId);
}

tuner::common::enSourceId clSessionControl::oGetRequestedSource()
{
	return clAudioSession::instance()->getRequestedSessionSrc();
}

tuner::common::enSrcActivity clSessionControl::oGetRequestedSourceActivity()
{
	return clAudioSession::instance()->getRequestedSessionSrcActivity();
}
tuner::common::enSessionState clSessionControl::oGetRequestedSourceState()
{
	return clAudioSession::instance()->getRequestedSessionState();
}
tuner::common::enSourceId clSessionControl::getStoredPreviousSessionStateBeforeAnnoucementSrc()
{
	return clAudioSession::instance()->getStoredPreviousSessionStateBeforeAnnoucementSrc();
}
tuner::common::enSrcActivity clSessionControl::getStoredPreviousSessionStateBeforeAnnoucementSrcActivity()
{
	return clAudioSession::instance()->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity();
}
void clSessionControl::vLearnForever(bool bBGorFGLearnForever)
{
   clAudioSession::instance()->vFGBGLearnForever(bBGorFGLearnForever);
}
void clSessionControl::vTunerSetFGBGLearnForever(tuner::common::enSourceId tunerSourceId, bool bSupport)
{
   clAudioSession::instance()->vTunerSetFGBGLearnForever(tunerSourceId , bSupport);
}

void clSessionControl::vSetSBRVariant(bool bSBRVariant)
{
	clAudioSession::instance()->vSetSBRVariant(bSBRVariant);
}
