/************************************************************************
* FILE:           clDABTunerImpl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clDABTunerImpl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#include "sessionManagement/clDABTunerImpl.h"
#include "sessionManagement/audio/clAudioSession.h"
#include "convTables/midwTunerMap.h"
#include "Src_Chg/Header/tunmstr_DABClient_Handler.h"
#include "Src_Chg/Header/tunmstr_MsgToHMI.h"
#include "Src_Chg/Header/tunmstr_TunerClientHandler.h"
#include "kdsconfig/clConfigInterface.h"
using namespace tuner::sessionManagement::audio;
using namespace tuner::common;


clDABTunerImpl::clDABTunerImpl(tunmstr_DABClient_Handler* poDABClientHandler ,tunmstr_MsgToHMI* poTunerMsgToHMI,
		tunmstr_TunerClientHandler* poTunerClientHandler,clConfigInterface* poclConfigInterface)
   :m_poDABClientHandler(poDABClientHandler)
   ,m_poTunerMsgToHMI(poTunerMsgToHMI)
   ,m_poTunerClientHandler(poTunerClientHandler)
   ,m_poclConfigInterface(poclConfigInterface)
{

}


clDABTunerImpl::~clDABTunerImpl(){
	m_poDABClientHandler = 0;
	m_poTunerMsgToHMI = 0;
	m_poTunerClientHandler = 0;
	m_poclConfigInterface =0;
}

void clDABTunerImpl::vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool /*bInformSourceChange*/)
{
	if(m_poclConfigInterface != NULL)
	{
		if(m_poclConfigInterface->u32GetConfigData("SBR"))
		{
			m_poTunerClientHandler->vSend_MTCAudiosource(getMidwTunerHeader(tunerState), getMTCAudioSource(oGetBand(tunerSourceId), tunerSourceId), midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
		}
	}
	m_poDABClientHandler->vSend_s_Source_State(getMidwDabTunerState(tunerState));
}

void clDABTunerImpl::vOnAllocate(tuner::common::enSourceId /*tunerSourceId*/, tunerString /*inputDevice*/){


}


void clDABTunerImpl::vChangeBand(tuner::common::enBand /*tunerBand*/){

}


void clDABTunerImpl::vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState)
{
	m_poDABClientHandler->vSend_s_Set_Mute_State(getMidwDabSource(tunerSourceId),getMidwDabMuteState(tunerMuteState));
}



void clDABTunerImpl::vSetFrequency(tuner::common::enBand /*tunerBand*/, unsigned int /*frequency*/)
{

}

void clDABTunerImpl::vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone )
{
	m_poTunerMsgToHMI->vSend_g_Band_Info((tU8)tunerSourceId, bSetBandNone);
}

void clDABTunerImpl::vClearAnnouncementStates()
{
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_PTY31_DAB, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_PTY31);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB_TA, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_TA);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_PTY31);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_TA);
}

void clDABTunerImpl::vCancelAnnouncement()
{
	//No action
}
