/************************************************************************
* FILE:           clAMFMTunerImpl.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Header contents of the class clAMFMTunerImpl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#ifndef clAMFMTunerImpl_h
#define clAMFMTunerImpl_h


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_if.h"

#include "sessionManagement/clMidwTunerImpl.h"

class tunmstr_TunerClientHandler;
class tunmstr_MsgToHMI;
class clConfigInterface;
namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clTunerInterface;
         /**
          * @author pad1cob
          * @version 1.0
          * @created 27-Mar-2015 15:43:29
          */
         class clAMFMTunerImpl   : public tuner::sessionManagement::audio::clMidwTunerImpl
         {

            public:
               clAMFMTunerImpl(tunmstr_TunerClientHandler* poTunerClientHandler , tunmstr_MsgToHMI* poTunerMsgToHMI,
            		   clConfigInterface* poclConfigInterface);
               virtual ~clAMFMTunerImpl();
               virtual void vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
               virtual void vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool bInformSourceChange);
               virtual void vChangeBand(tuner::common::enBand tunerBand);
               virtual void vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState);
               virtual void vSetFrequency(tuner::common::enBand tunerBand, unsigned int frequency);
               virtual void vSetModulationAndSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
               virtual void vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone);
               virtual void vClearAnnouncementStates();
               virtual void vCancelAnnouncement();
               tunmstr_TunerClientHandler* m_poTunerClientHandler;
               tunmstr_MsgToHMI* m_poTunerMsgToHMI;
			   clConfigInterface* m_poclConfigInterface;
         };

      }
   }
}
#endif // !defined(clAMFMTunerImpl_h)
