/************************************************************************
* FILE:           clAMFMTunerImpl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clAMFMTunerImpl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#include "sessionManagement/clAMFMTunerImpl.h"
#include "sessionManagement/audio/clAudioSession.h"
#include "convTables/midwTunerMap.h"
#include "Src_Chg/Header/tunmstr_TunerClientHandler.h"
#include "Src_Chg/Header/tunmstr_MsgToHMI.h"
#include "kdsconfig/clConfigInterface.h"
using namespace tuner::sessionManagement::audio;


clAMFMTunerImpl::clAMFMTunerImpl(tunmstr_TunerClientHandler* poTunerClientHandler ,tunmstr_MsgToHMI* poTunerMsgToHMI,
		clConfigInterface* poclConfigInterface)
   :m_poTunerClientHandler(poTunerClientHandler)
   ,m_poTunerMsgToHMI(poTunerMsgToHMI)
   ,m_poclConfigInterface(poclConfigInterface)
{

}


clAMFMTunerImpl::~clAMFMTunerImpl(){
	m_poTunerClientHandler = 0;
	m_poTunerMsgToHMI = 0;
    m_poclConfigInterface = 0;
}


void clAMFMTunerImpl::vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool /*bInformSourceChange*/)
{
	if(m_poclConfigInterface != nullptr)
	{
		if(m_poclConfigInterface->u32GetConfigData("SBR"))
		{
			m_poTunerClientHandler->vSend_MTCAudiosource(getMidwTunerHeader(tunerState), getMTCAudioSource(oGetBand(tunerSourceId), tunerSourceId), getMidwBand(oGetBand(tunerSourceId)));
		}
		else
		{
			m_poTunerClientHandler->vSend_s_Audio_FG_BG_New(getMidwTunerHeader(tunerSourceId), getMidwTunerSubCommand(tunerState), getMidwAudioSink(tunerSourceId), getMidwTunerState(tunerState), getMidwPhysicalTuner(tunerSourceId), getMidwBand(oGetBand(tunerSourceId)));
		}
	}

}


void clAMFMTunerImpl::vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice){

   if (bSendAudioDeviceInformation(tunerSourceId))
   {
	   m_poTunerClientHandler->vSend_s_AudioDevice(inputDevice);
   }
}


void clAMFMTunerImpl::vChangeBand(tuner::common::enBand tunerBand){

   m_poTunerClientHandler->vSend_s_ChangeBand(getMidwBand(tunerBand));
}


void clAMFMTunerImpl::vOnMuteState(tuner::common::enSourceId /*tunerSourceId*/, tuner::common::enMuteState /*tunerMuteState*/)
{
	m_poTunerClientHandler->vSend_s_MuteState();
}


void clAMFMTunerImpl::vSetFrequency(tuner::common::enBand tunerBand, unsigned int frequency)
{
	m_poTunerClientHandler->vSend_s_DirectFrq_input(frequency, getMidwBand(tunerBand));
}


void clAMFMTunerImpl::vSetModulationAndSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity)
{
	   if (bSendAudioDeviceInformation(tunerSourceId))
	   {
		   m_poTunerClientHandler->vSend_s_DRMSourceActivity((enTunmstr_DRMSourceActivity)getMidwSrcActivity(tunerSrcActivity));
		   //m_poTunerClientHandler->vSend_s_DemodulationSwitch(getModulationSwitch(tunerSourceId), getMidwTunerState(tunerSrcActivity));
	   }
}

void clAMFMTunerImpl::vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone )
{
	m_poTunerMsgToHMI->vSend_g_Band_Info((tU8)tunerSourceId, bSetBandNone);
}

void clAMFMTunerImpl::vClearAnnouncementStates()
{
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_PTY31_FM, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_PTY31);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM_TA, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_TA);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_PTY31);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_TA);
	m_poTunerMsgToHMI->vSend_g_Announcement_Status(false, midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_WEATHER_ALERT, midw_fi_tcl_e8_AnnoTypes::FI_EN_TUNMSTR_ANNOTYPE_WEATHER_ALERT);
}

void clAMFMTunerImpl::vCancelAnnouncement()
{
	//No action
}
