/************************************************************************
 * FILE:           fc_tunermaster_if.h.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tunermaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    header contents of fc_tunermaster_if.h
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
 * 25.04.13		| NGP1KOR					   | First version of the G3g after porting from NISSAN LCN2Kai
							
 *************************************************************************/

/* --DO NOT PROTECT THIS FILE AGAINST DOUBLE INCLUDE !!! */

/* --General Information to the Component Maintainer

     Please remind that a modification of an interface can cause some trouble to the components 
     which import the interface. The interface file may only export files from the component or 
     another interface file.

*/

/* --COMPONENT INTERFACE(S) -- */

/* 
     Interface: GENERIC
     Description: $DESCRIPTION$
	 * 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*/

#ifdef FC_TUNERMASTER_S_IMPORT_INTERFACE_GENERIC
/* --Protection against double include of the interface. */
#ifndef FC_TUNERMASTER_S_ALREADY_INCLUDE_GENERIC
#define FC_TUNERMASTER_S_ALREADY_INCLUDE_GENERIC

/* --Includes. */
#include "../fc_tunermaster/Header/tunermaster_main.h"

#endif /* --FC_TMCTUNER_S_ALREADY_INCLUDE_GENERIC */
#else
#ifdef _WIN32
#pragma message ( "You have to define an interface for the component: FC_TUNERMASTER." ) 
#endif
#endif


#ifdef FC_TUNERMASTER_S_IMPORT_INTERFACE_GENERIC
/* --Protection against double include of the interface. */
#ifndef FC_TUNERMASTER_S_ALREADY_INCLUDE_MSG
#define FC_TUNERMASTER_S_ALREADY_INCLUDE_MSG
/* --Includes. */
#define FI_S_IMPORT_INTERFACE_TMCTUNERFI_STDVISITORS // not sure
#define FI_S_IMPORT_INTERFACE_TMCTUNERFI_ERRORCODES
#define FI_S_IMPORT_INTERFACE_TMCTUNERFI_TYPES
#define FI_S_IMPORT_INTERFACE_TMCTUNERFI_FUNCTIONIDS
#define FI_S_IMPORT_INTERFACE_TMCTUNERFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fi_gen_if.h" // Include tmctuner_fi in VOB:di_fi using "fi_gen_if.h"


/* Include Tuner FI */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

/*Include Tuner Master FI*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES



#include "midw_fi_if.h" 
/*Include for DAB FI*/
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#include "midw_ext_fi_if.h" 
#endif

#endif /* --FC_TUNERMASTER_S_ALREADY_INCLUDE_MSG */
#else
#ifdef _WIN32
#pragma message ( "You have to use a midw_fi interface for the component: FC_TUNERMASTER." ) 
#endif
#endif

