/************************************************************************
* FILE:           tunerArlMap.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date            | Author                       		 | Modification

*************************************************************************/


#ifndef tunerArlMap_h
#define tunerArlMap_h


#include "datatypes/tVector.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tunerDatatypes.h"
#define ARL_S_IMPORT_INTERFACE_GENERIC_AIL
#include "audio_routing_lib.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {

         struct stArlSourceMap
         {
            tuner::common::enSourceId tunerSourceId;
            arl_tenSource arlSource;
            arl_enMuteReason arlMuteReason;
         };
         
         struct stArlMuteStateMap
         {
            tuner::common::enMuteState tunerMuteState;
            arl_tenMuteState arlMuteState;
         };

         struct stArlSrcActivityMap
         {
            tuner::common::enSrcActivity tunerSrcActivity;
            arl_tSrcActivity::tenType arlSrcActivity;
            arl_tenActivity arlActivity;
         };

         struct stArlAudioSourceAvailabalityMap
         {
        	 tuner::common::enAudioSrcAvailability AudioSrcAvailability;
        	 arl_tenSrcAvailability arlSrcAvailability;
         };

         struct strArlAudioSourceAvailabalityReasonMap
         {
        	 tuner::common::enAudioSourceAvailabiltyReason AudioSourceAvailabiltyReason;
        	 arl_tenAvailabilityReason arlAvailabilityReason;
         };


         struct stArlMuteActionMap
         {
            tuner::common::enMuteState tunerMuteState;
            arl_tenMuteAction arlMuteAction;
         };

      }
   }
}

tuner::common::enSourceId getTunerSourceId(arl_tenSource arlSource);
tuner::common::enMuteState getTunerMuteState(arl_tenMuteState arlMuteState);
tuner::common::enSrcActivity getTunerSrcActivity(arl_tSrcActivity arlSrcActivity);
arl_tenSrcAvailability getArlSourceAvailibility(tuner::common::enAudioSrcAvailability AudioSrcAvailability);
arl_tenAvailabilityReason getArlSourceAvailibilityReason(tuner::common::enAudioSourceAvailabiltyReason AudioSourceAvailabiltyReason);
tuner::common::enAudioSrcAvailability getAudioSourceAvailabilty(arl_tenSrcAvailability arlSrcAvailability);
tuner::common::enAudioSourceAvailabiltyReason getAudioSourceAvailabiltyReason(arl_tenAvailabilityReason arlAvailabilityReason);
arl_tenActivity getArlActivity(tuner::common::enSrcActivity tunerSrcActivity);
arl_tenSource getArlSourceNumber(tuner::common::enSourceId tunerSourceId);
arl_tenMuteState getArlMuteState(tuner::common::enMuteState tunerMuteState);
arl_enMuteReason getArlMuteReason(tuner::common::enSourceId tunerSourceId);
arl_tenMuteAction getArlMuteAction(tuner::common::enMuteState tunerMuteState);
#endif // tunerArlMap_h
