/************************************************************************
* FILE:           tunerArlMap.cpp
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date            | Author                       		 | Modification

*************************************************************************/

#include "convTables/tunerArlMap.h"


using namespace tuner::sessionManagement::audio;
using namespace tuner::common;


static const stArlSourceMap atunerArlSourceMap[] =
{
   #define TUNER_ARL_SOURCE(tunerSourceId, arlSourceId, arlSrcAvailability, arlSrcAvailabilityReason, arlMuteReason)                  { tunerSourceId, arlSourceId, arlMuteReason},
   #include "tunerArlMap.dat"
   #undef TUNER_ARL_SOURCE
};

static const stArlMuteStateMap atunerArlMuteStateMap[] =
{
   #define TUNER_ARL_MUTESTATE(tunerMuteState, arlMuteState)                  { tunerMuteState, arlMuteState},
   #include "tunerArlMap.dat"
   #undef TUNER_ARL_MUTESTATE
};

static const stArlSrcActivityMap atunerArlSrcActivityMap[] =
{
   #define TUNER_ARL_SRCACTIVITY(tunerSrcActivity, arlSrcActivity, arlActivity)                  { tunerSrcActivity, arlSrcActivity, arlActivity},
   #include "tunerArlMap.dat"
   #undef TUNER_ARL_SRCACTIVITY
};

static const stArlAudioSourceAvailabalityMap astArlAudioSourceAvailabalityMap[]=
{
	#define TUNER_ARL_SOURCEAVILABILITY(tunerAudioAvailability, arlAudioSrcAvailability)                  { tunerAudioAvailability, arlAudioSrcAvailability},
	#include "tunerArlMap.dat"
	#undef TUNER_ARL_SOURCEAVILABILITY
};

static const strArlAudioSourceAvailabalityReasonMap astrArlAudioSourceAvailabalityReasonMap[]=
{
	#define TUNER_ARL_SOURCEAVILABILITY_REASON(tunerAudioAvailabilityReason, arlAudioSrcAvailabilityReason ) {tunerAudioAvailabilityReason, arlAudioSrcAvailabilityReason},
	#include "tunerArlMap.dat"
	#undef TUNER_ARL_SOURCEAVILABILITY_REASON
};


static const stArlMuteActionMap atunerArlMuteActionMap[] =
{
   #define TUNER_ARL_MUTEACTION(tunerMuteState, arlMuteAction)                  { tunerMuteState, arlMuteAction},
   #include "tunerArlMap.dat"
   #undef TUNER_ARL_MUTEACTION
};

/**************************************************************************//**
*
******************************************************************************/
enSourceId getTunerSourceId(arl_tenSource arlSource)
{
   
   const int numberofSources = sizeof atunerArlSourceMap / sizeof(stArlSourceMap);
   for (int u32Index = 0; u32Index < numberofSources; u32Index++)
   {
      if (atunerArlSourceMap[u32Index].arlSource == arlSource)
      {
         return atunerArlSourceMap[u32Index].tunerSourceId;
      }
   }
   return SOURCEID_LIMIT;

}
enAudioSrcAvailability getAudioSourceAvailabilty(arl_tenSrcAvailability arlSrcAvailability)
{
	const int numberofSources = sizeof astArlAudioSourceAvailabalityMap / sizeof(stArlAudioSourceAvailabalityMap);
	for (int u32Index = 0; u32Index < numberofSources; u32Index++)
	{
		if (astArlAudioSourceAvailabalityMap[u32Index].arlSrcAvailability == arlSrcAvailability)
		{
			return astArlAudioSourceAvailabalityMap[u32Index].AudioSrcAvailability;
		}
	}
	return AUDIOSOURCEAVAILABILITY__LIMIT;
}

enAudioSourceAvailabiltyReason getAudioSourceAvailabiltyReason(arl_tenAvailabilityReason arlAvailabilityReason)
{
	const int numberofSources = sizeof astrArlAudioSourceAvailabalityReasonMap/sizeof (strArlAudioSourceAvailabalityReasonMap);
	for (int u32Index = 0; u32Index < numberofSources; u32Index++)
	{
		if(astrArlAudioSourceAvailabalityReasonMap[u32Index].arlAvailabilityReason==arlAvailabilityReason)
		{
			return astrArlAudioSourceAvailabalityReasonMap[u32Index].AudioSourceAvailabiltyReason;
		}
	}
	return AUDIOSOURCEAVAILABILITYREASON__LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
arl_tenSrcAvailability getArlSourceAvailibility(tuner::common::enAudioSrcAvailability AudioSrcAvailability)
{
	const int numberofSources = sizeof astArlAudioSourceAvailabalityMap/sizeof (stArlAudioSourceAvailabalityMap);
	for (int u32Index = 0; u32Index < numberofSources; u32Index++)
		{
			if(astArlAudioSourceAvailabalityMap[u32Index].AudioSrcAvailability==AudioSrcAvailability)
			{
				return astArlAudioSourceAvailabalityMap[u32Index].arlSrcAvailability;
			}
		}
	arl_tenSrcAvailability availability = ARL_EN_SRC_NOT_AVAILABLE;
   return availability;
}


/**************************************************************************//**
*
******************************************************************************/
arl_tenAvailabilityReason getArlSourceAvailibilityReason(tuner::common::enAudioSourceAvailabiltyReason AudioSourceAvailabiltyReason)
{
	const int numberofSources = sizeof astrArlAudioSourceAvailabalityReasonMap/sizeof (strArlAudioSourceAvailabalityReasonMap);
	for (int u32Index = 0; u32Index < numberofSources; u32Index++)
		{
			if(astrArlAudioSourceAvailabalityReasonMap[u32Index].AudioSourceAvailabiltyReason==AudioSourceAvailabiltyReason)
			{
				return astrArlAudioSourceAvailabalityReasonMap[u32Index].arlAvailabilityReason;
			}
		}
   arl_tenAvailabilityReason reason = ARL_EN_REASON_ERROR;
   return reason;
}

/**************************************************************************//**
*
******************************************************************************/
enMuteState getTunerMuteState(arl_tenMuteState arlMuteState)
{
   
   const int mapSize = sizeof atunerArlMuteStateMap / sizeof(stArlMuteStateMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (atunerArlMuteStateMap[u32Index].arlMuteState == arlMuteState)
      {
         return atunerArlMuteStateMap[u32Index].tunerMuteState;
      }
   }
   return MUTESTATE_UNKNOWN;

}


/**************************************************************************//**
*
******************************************************************************/
enSrcActivity getTunerSrcActivity(arl_tSrcActivity arlSrcActivity)
{
   
   const int mapSize = sizeof atunerArlSrcActivityMap / sizeof(stArlSrcActivityMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (atunerArlSrcActivityMap[u32Index].arlSrcActivity == arlSrcActivity.enType)
      {
         return atunerArlSrcActivityMap[u32Index].tunerSrcActivity;
      }
   }
   return SRCACTIVITY_UNKNOWN;

}

/**************************************************************************//**
*
******************************************************************************/
arl_tenActivity getArlActivity(tuner::common::enSrcActivity tunerSrcActivity)
{
	   const int mapSize = sizeof atunerArlSrcActivityMap / sizeof(stArlSrcActivityMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
		  if (atunerArlSrcActivityMap[u32Index].tunerSrcActivity == tunerSrcActivity)
		  {
			 return atunerArlSrcActivityMap[u32Index].arlActivity;
		  }
	   }
   arl_tenActivity activity = ARL_EN_ISRC_ACT_OFF;
   return activity;

}


/**************************************************************************//**
*
******************************************************************************/
arl_tenSource getArlSourceNumber(tuner::common::enSourceId tunerSourceId)
{

   const int numberofSources = sizeof atunerArlSourceMap / sizeof(stArlSourceMap);
   for (int u32Index = 0; u32Index < numberofSources; u32Index++)
   {
      if (atunerArlSourceMap[u32Index].tunerSourceId == tunerSourceId)
      {
         return atunerArlSourceMap[u32Index].arlSource;
      }
   }
   return ARL_SRC_NONE;
}



/**************************************************************************//**
*
******************************************************************************/
arl_tenMuteState getArlMuteState(tuner::common::enMuteState tunerMuteState)
{

   const int mapSize = sizeof atunerArlMuteStateMap / sizeof(stArlMuteStateMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (atunerArlMuteStateMap[u32Index].tunerMuteState == tunerMuteState)
      {
         return atunerArlMuteStateMap[u32Index].arlMuteState;
      }
   }
   return ARL_EN_MUTESTATE_DEMUTE;

}


/**************************************************************************//**
*
******************************************************************************/
arl_enMuteReason getArlMuteReason(tuner::common::enSourceId tunerSourceId)
{

   const int numberofSources = sizeof atunerArlSourceMap / sizeof(stArlSourceMap);
   for (int u32Index = 0; u32Index < numberofSources; u32Index++)
   {
      if (atunerArlSourceMap[u32Index].tunerSourceId == tunerSourceId)
      {
         return atunerArlSourceMap[u32Index].arlMuteReason;
      }
   }
   return ARL_EN_MUTE_REASON_OTHER;
}


/**************************************************************************//**
*
******************************************************************************/
arl_tenMuteAction getArlMuteAction(tuner::common::enMuteState tunerMuteState)
{

   const int numberofSources = sizeof atunerArlMuteActionMap / sizeof(stArlMuteActionMap);
   for (int u32Index = 0; u32Index < numberofSources; u32Index++)
   {
      if (atunerArlMuteActionMap[u32Index].tunerMuteState == tunerMuteState)
      {
         return atunerArlMuteActionMap[u32Index].arlMuteAction;
      }
   }
   return ARL_EN_MUTEACTION_DEMUTE;
}
