/************************************************************************
* FILE:           midwTunerMap.cpp
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    midwTunerMap method class implementation
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date            | Author                       		 | Modification

*************************************************************************/

#include "convTables/midwTunerMap.h"


using namespace tuner::sessionManagement::audio;
using namespace tuner::common;
using namespace tuner::announcements;
using namespace tuner::MTCAudioSource;

static const stMidwTunerStateMap aMidwTunerStateMap[] =
{
   #define TUNER_MIDW_STATE(tunerState, midwSubCommand, bMidwTunerState, midwTunerHeader)                  { tunerState, midwSubCommand, bMidwTunerState, midwTunerHeader},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_STATE
};

static stMidwTunerSourceMap aMidwTunerSourceMap[] =
{
   #define TUNER_MIDW_SOURCE(tunerSourceId, midwTunerHeader, midwAudioSink, midwPhysicalTuner, bUpdateAudioDevice, modulationSwitch, midwTunermasterBand)                  { tunerSourceId, midwTunerHeader, midwAudioSink, midwPhysicalTuner, bUpdateAudioDevice, modulationSwitch, midwTunermasterBand},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_SOURCE
};

static const stMidwTunerBandMap aMidwTunerBandMap[] =
{
   #define TUNER_MIDW_BAND(tunerBand, midwBand)                  { tunerBand, midwBand},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_BAND
};

static const stMidwDabTunerStateMap aMidwDabTunerStateMap[] =
{
   #define DAB_MIDW_STATE(tunerState, midwDabTunerState)                  { tunerState, midwDabTunerState},
   #include "midwTunerMap.dat"
   #undef DAB_MIDW_STATE
};

static const stMidwDabTunerSourceMap aMidwDabTunerSourceMap[] =
{
   #define DAB_MIDW_SOURCE(tunerSourceId, midwDabSource)                  { tunerSourceId, midwDabSource},
   #include "midwTunerMap.dat"
   #undef DAB_MIDW_SOURCE
};

static const stMidwDabTunerMuteStateMap aMidwDabTunerMuteStateMap[] =
{
   #define DAB_MIDW_MUTESTATE(tunerMuteState, midwDabMuteState)                  { tunerMuteState, midwDabMuteState},
   #include "midwTunerMap.dat"
   #undef DAB_MIDW_MUTESTATE
};

static const stMidwDABAnnoSurvivellenceStateMap astMidwDABAnnoSurvivellenceStateMap[] =
{
   #define DAB_MIDW_ANNON_SURV_STATE(tunerSourceId, bDABAnnoSurvivellencesSupported)                  { tunerSourceId, bDABAnnoSurvivellencesSupported},
   #include "midwTunerMap.dat"
   #undef DAB_MIDW_ANNON_SURV_STATE
};

static const stMidwTunerAnnouncementsMap aMidwTunerAnnouncementsMap[] =
{
   #define TUNER_MIDW_ANNOUNCEMENTS(tunerAnnouncement, midwTunerAnnoMessage, tunerSrcActivity, tunerSourceId)                  { tunerAnnouncement, midwTunerAnnoMessage, tunerSrcActivity, tunerSourceId},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_ANNOUNCEMENTS
};

static const stMidwDabAnnouncementsMap aMidwDabAnnouncementsMap[] =
{
   #define DAB_MIDW_ANNOUNCEMENTS(tunerAnnouncement, midwAnnoType, tunerSourceId, tunerMasterAnnoType)                  { tunerAnnouncement, midwAnnoType, tunerSourceId, tunerMasterAnnoType},
   #include "midwTunerMap.dat"
   #undef DAB_MIDW_ANNOUNCEMENTS
};

static const stMidwTunerTpStateMap aMidwTunerTpStateMap[] =
{
   #define TUNER_MIDW_TPSTATE(tunerTpState, midwTpState)                  { tunerTpState, midwTpState},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_TPSTATE
};

static const stMidwDabAnnouncementStateMap aMidwDabAnnouncementStateMap[] =
{
   #define DAB_MIDW_ANNOUNCEMENT_STATE(midwDabAnnouncementState, tunerSrcActivity, bSelect)                  { midwDabAnnouncementState, tunerSrcActivity, bSelect},
   #include "midwTunerMap.dat"
   #undef DAB_MIDW_ANNOUNCEMENT_STATE
};

static const stMidwTunerAnnouncementResponseMap aMidwTunerAnnouncementResponseMap[] =
{
   #define TUNER_MIDW_ANNOUNCEMENTS_RESPONSE(tunerAnnouncement, midwTunerHeader, midwAudioSink, midwPhysicalTuner, bUpdateAudioDevice, midwAnnoType, tunerMasterAnnoType)                  { tunerAnnouncement, midwTunerHeader, midwAudioSink, midwPhysicalTuner, bUpdateAudioDevice, midwAnnoType, tunerMasterAnnoType},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_ANNOUNCEMENTS_RESPONSE
};

static const stMidwTunerSrcActivityMap aMidwTunerSrcActivityMap[] =
{
   #define TUNER_MIDW_SRCACTIVITY(tunerSrcActivity, tunerState, midwSubCommand, bMidwTunerState, midwTunerHeader, midwSrcActivity)                  { tunerSrcActivity, tunerState, midwSubCommand, bMidwTunerState, midwTunerHeader, midwSrcActivity},
   #include "midwTunerMap.dat"
   #undef TUNER_MIDW_SRCACTIVITY
};

static const stMTCAudioSource aMTCAudioSource[] =
{
   #define TUNER_MTC_AUDIO_SOURCE(tunerAnnouncement, tunerSourceId, tunerBand, MTCAudioSourceId) {tunerAnnouncement, tunerSourceId, tunerBand, MTCAudioSourceId},
   #include "midwTunerMap.dat"
   #undef TUNER_MTC_AUDIO_SOURCE
};

/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_SubCommand::tenType getMidwTunerSubCommand(tuner::common::enTunerState tunerState)
{
   const int mapSize = sizeof aMidwTunerStateMap / sizeof(stMidwTunerStateMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerStateMap[u32Index].tunerState == tunerState)
      {
         return aMidwTunerStateMap[u32Index].midwSubCommand;
      }
   }
   return midw_fi_tcl_e8_Tun_SubCommand::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
bool getMidwTunerState(tuner::common::enTunerState tunerState)
{
   const int mapSize = sizeof aMidwTunerStateMap / sizeof(stMidwTunerStateMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerStateMap[u32Index].tunerState == tunerState)
      {
         return aMidwTunerStateMap[u32Index].bMidwTunerState;
      }
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enTunerState getTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader)
{
   const int mapSize = sizeof aMidwTunerStateMap / sizeof(stMidwTunerStateMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerStateMap[u32Index].midwTunerHeader == midwTunerHeader)
      {
         return aMidwTunerStateMap[u32Index].tunerState;
      }
   }
   return tuner::common::TUNERSTATE_UNKNOWN;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_TunerHeader::tenType getMidwTunerHeader(tuner::common::enSourceId tunerSourceId)
{
	   const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerSourceMap[u32Index].tunerSourceId == tunerSourceId)
	      {
	         return aMidwTunerSourceMap[u32Index].midwTunerHeader;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_AudioSink::tenType getMidwAudioSink(tuner::common::enSourceId tunerSourceId)
{
	   const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerSourceMap[u32Index].tunerSourceId == tunerSourceId)
	      {
	         return aMidwTunerSourceMap[u32Index].midwAudioSink;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_AudioSink::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_PhysicalTuner::tenType getMidwPhysicalTuner(tuner::common::enSourceId tunerSourceId)
{
	   const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerSourceMap[u32Index].tunerSourceId == tunerSourceId)
	      {
	         return aMidwTunerSourceMap[u32Index].midwPhysicalTuner;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
bool bSendAudioDeviceInformation(tuner::common::enSourceId tunerSourceId)
{
	   const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerSourceMap[u32Index].tunerSourceId == tunerSourceId )
	      {
	         return aMidwTunerSourceMap[u32Index].bUpdateAudioDevice;
	      }
	   }
	   return false;
}


/**************************************************************************//**
*
******************************************************************************/
unsigned char getModulationSwitch(tuner::common::enSourceId tunerSourceId)
{
	   const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerSourceMap[u32Index].tunerSourceId == tunerSourceId )
	      {
	         return aMidwTunerSourceMap[u32Index].modulationSwitch;
	      }
	   }
	   return 0;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_TunerBand::tenType getMidwBand(tuner::common::enBand tunerBand)
{
	   const int mapSize = sizeof aMidwTunerBandMap / sizeof(stMidwTunerBandMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerBandMap[u32Index].tunerBand == tunerBand)
	      {
	         return aMidwTunerBandMap[u32Index].midwTunerBand;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
}


/**************************************************************************//**
*
******************************************************************************/
midw_ext_fi_tcl_e8_DAB_SourceState::tenType getMidwDabTunerState(tuner::common::enTunerState tunerState)
{
	   const int mapSize = sizeof aMidwDabTunerStateMap / sizeof(stMidwDabTunerStateMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabTunerStateMap[u32Index].tunerState == tunerState)
	      {
	         return aMidwDabTunerStateMap[u32Index].midwDabTunerState;
	      }
	   }
	   return midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_BACKGROUND;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enTunerState getTunerState(midw_ext_fi_tcl_e8_DAB_SourceState::tenType midwDabTunerState)
{
	   const int mapSize = sizeof aMidwDabTunerStateMap / sizeof(stMidwDabTunerStateMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabTunerStateMap[u32Index].midwDabTunerState == midwDabTunerState)
	      {
	         return aMidwDabTunerStateMap[u32Index].tunerState;
	      }
	   }
	   return tuner::common::TUNERSTATE_UNKNOWN;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enBand getTunerBand(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand)
{
	   const int mapSize = sizeof aMidwTunerBandMap / sizeof(stMidwTunerBandMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerBandMap[u32Index].midwTunerBand == midwTunerBand)
	      {
	         return aMidwTunerBandMap[u32Index].tunerBand;
	      }
	   }
	   return tuner::common::BAND_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
midw_ext_fi_tcl_e8_DAB_Source::tenType getMidwDabSource(tuner::common::enSourceId tunerSourceId)
{
	   const int mapSize = sizeof aMidwDabTunerSourceMap / sizeof(stMidwDabTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabTunerSourceMap[u32Index].tunerSourceId == tunerSourceId)
	      {
	         return aMidwDabTunerSourceMap[u32Index].midwDabSource;
	      }
	   }
	   return midw_ext_fi_tcl_e8_DAB_Source::FI_EN_DAB;
}


/**************************************************************************//**
*
******************************************************************************/
midw_ext_fi_tcl_e8_DAB_MuteStatus::tenType getMidwDabMuteState(tuner::common::enMuteState tunerMuteState)
{
	   const int mapSize = sizeof aMidwDabTunerMuteStateMap / sizeof(stMidwDabTunerMuteStateMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabTunerMuteStateMap[u32Index].tunerMuteState == tunerMuteState)
	      {
	         return aMidwDabTunerMuteStateMap[u32Index].midwDabMuteState;
	      }
	   }
	   return midw_ext_fi_tcl_e8_DAB_MuteStatus::FI_EN_DEMUTE;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enAnnouncement getAnnouncement(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementsMap / sizeof(stMidwTunerAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementsMap[u32Index].midwTunerAnnoMessage == midwTunerAnnoMessage)
	      {
	         return aMidwTunerAnnouncementsMap[u32Index].tunerAnnouncement;
	      }
	   }
	   return tuner::common::ANNOUNCEMENT_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSrcActivity getSrcActivity(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementsMap / sizeof(stMidwTunerAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementsMap[u32Index].midwTunerAnnoMessage == midwTunerAnnoMessage)
	      {
	         return aMidwTunerAnnouncementsMap[u32Index].tunerSrcActivity;
	      }
	   }
	   return tuner::common::SRCACTIVITY_UNKNOWN;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSourceId getTunerSourceId(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementsMap / sizeof(stMidwTunerAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementsMap[u32Index].midwTunerAnnoMessage == midwTunerAnnoMessage)
	      {
	         return aMidwTunerAnnouncementsMap[u32Index].tunerSourceId;
	      }
	   }
	   return tuner::common::SOURCEID_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
tunerVector<stTunerAnnouncementInformation> oGetAnnouncementList(std::vector<midw_ext_fi_tcl_DAB_AnnoElement> midwDabAnnouncementList)
{
   tunerVector<stTunerAnnouncementInformation> announcementList;
   for (unsigned int u32Index = 0; u32Index < midwDabAnnouncementList.size(); u32Index++)
   {
      stTunerAnnouncementInformation announcement;
      announcement.tunerAnnouncement = getAnnouncement(midwDabAnnouncementList[u32Index].u16AnnoType);
      announcement.tunerSourceId = getTunerSourceId(midwDabAnnouncementList[u32Index].u16AnnoType);
      announcement.tunerSrcActivity = getSrcActivity(midwDabAnnouncementList[u32Index].AnnoState.enType);
      announcementList.push_back(announcement);
   }
   return announcementList;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enAnnouncement getAnnouncement(unsigned short midwAnnoType)
{
	   const int mapSize = sizeof aMidwDabAnnouncementsMap / sizeof(stMidwDabAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabAnnouncementsMap[u32Index].midwAnnoType == midwAnnoType)
	      {
	         return aMidwDabAnnouncementsMap[u32Index].tunerAnnouncement;
	      }
	   }
	   return tuner::common::ANNOUNCEMENT_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSrcActivity getSrcActivity(midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::tenType midwDabAnnouncementState)
{
	   const int mapSize = sizeof aMidwDabAnnouncementStateMap / sizeof(stMidwDabAnnouncementStateMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabAnnouncementStateMap[u32Index].midwDabAnnouncementState == midwDabAnnouncementState)
	      {
	         return aMidwDabAnnouncementStateMap[u32Index].tunerSrcActivity;
	      }
	   }
	   return tuner::common::SRCACTIVITY_UNKNOWN;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSourceId getTunerSourceId(unsigned short midwAnnoType)
{
	   const int mapSize = sizeof aMidwDabAnnouncementsMap / sizeof(stMidwDabAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabAnnouncementsMap[u32Index].midwAnnoType == midwAnnoType)
	      {
	         return aMidwDabAnnouncementsMap[u32Index].tunerSourceId;
	      }
	   }
	   return tuner::common::SOURCEID_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_TunerHeader::tenType getMidwTunerHeader(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementResponseMap / sizeof(stMidwTunerAnnouncementResponseMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementResponseMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwTunerAnnouncementResponseMap[u32Index].midwTunerHeader;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_AudioSink::tenType getMidwAudioSink(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementResponseMap / sizeof(stMidwTunerAnnouncementResponseMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementResponseMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwTunerAnnouncementResponseMap[u32Index].midwAudioSink;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_AudioSink::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_PhysicalTuner::tenType getMidwPhysicalTuner(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementResponseMap / sizeof(stMidwTunerAnnouncementResponseMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementResponseMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwTunerAnnouncementResponseMap[u32Index].midwPhysicalTuner;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_SubCommand::tenType getMidwTunerSubCommand(tuner::common::enSrcActivity tunerSrcActivity)
{
   const int mapSize = sizeof aMidwTunerSrcActivityMap / sizeof(stMidwTunerSrcActivityMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerSrcActivityMap[u32Index].tunerSrcActivity == tunerSrcActivity)
      {
         return aMidwTunerSrcActivityMap[u32Index].midwSubCommand;
      }
   }
   return midw_fi_tcl_e8_Tun_SubCommand::FI_EN_INVALID_TYPE;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_DRMSourceActivity::tenType getMidwSrcActivity(tuner::common::enSrcActivity tunerSrcActivity)
{
   const int mapSize = sizeof aMidwTunerSrcActivityMap / sizeof(stMidwTunerSrcActivityMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerSrcActivityMap[u32Index].tunerSrcActivity == tunerSrcActivity)
      {
         return aMidwTunerSrcActivityMap[u32Index].midwSrcActivity;
      }
   }
   return midw_fi_tcl_e8_Tun_DRMSourceActivity::FI_EN_OFF;
}


/**************************************************************************//**
*
******************************************************************************/
bool getMidwTunerState(tuner::common::enSrcActivity tunerSrcActivity)
{
   const int mapSize = sizeof aMidwTunerSrcActivityMap / sizeof(stMidwTunerSrcActivityMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerSrcActivityMap[u32Index].tunerSrcActivity == tunerSrcActivity)
      {
         return aMidwTunerSrcActivityMap[u32Index].bMidwTunerState;
      }
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSrcActivity getSrcActivity(tuner::common::enTunerState tunerState)
{
   const int mapSize = sizeof aMidwTunerSrcActivityMap / sizeof(stMidwTunerSrcActivityMap);
   for (int u32Index = 0; u32Index < mapSize; u32Index++)
   {
      if (aMidwTunerSrcActivityMap[u32Index].tunerState == tunerState)
      {
         return aMidwTunerSrcActivityMap[u32Index].tunerSrcActivity;
      }
   }
   return SRCACTIVITY_UNKNOWN;
}


/**************************************************************************//**
*
******************************************************************************/
unsigned short getDabAnnouncementType(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwDabAnnouncementsMap / sizeof(stMidwDabAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabAnnouncementsMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwDabAnnouncementsMap[u32Index].midwAnnoType;
	      }
	   }
	   return 0;
}

/**************************************************************************//**
*
******************************************************************************/
unsigned short getDABTunerMasterAnnouncement(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwDabAnnouncementsMap / sizeof(stMidwDabAnnouncementsMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabAnnouncementsMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwDabAnnouncementsMap[u32Index].tunerMasterAnnoType;
	      }
	   }
	   return 0;
}


/**************************************************************************//**
*
******************************************************************************/
bool getSelectValue(tuner::common::enSrcActivity tunerSrcActivity)
{
	   const int mapSize = sizeof aMidwDabAnnouncementStateMap / sizeof(stMidwDabAnnouncementStateMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwDabAnnouncementStateMap[u32Index].tunerSrcActivity == tunerSrcActivity)
	      {
	         return aMidwDabAnnouncementStateMap[u32Index].bSelect;
	      }
	   }
	   return false;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enTpState getTunerTpState(midw_fi_tcl_e8_AtStationTPinfo::tenType midwTpState)
{
	   const int mapSize = sizeof aMidwTunerTpStateMap / sizeof(stMidwTunerTpStateMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerTpStateMap[u32Index].midwTpState == midwTpState)
	      {
	         return aMidwTunerTpStateMap[u32Index].tunerTpState;
	      }
	   }
	   return tuner::common::TPSTATE_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
midw_fi_tcl_e8_Tun_AnnoTypes::tenType getMidwAnnoType(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementResponseMap / sizeof(stMidwTunerAnnouncementResponseMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementResponseMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwTunerAnnouncementResponseMap[u32Index].midwAnnoType;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_AnnoTypes::FI_EN_INVALID_TYPE;
}
/**************************************************************************//**
*
******************************************************************************/
unsigned char getAMFMTunerMasterAnnouncement(tuner::common::enAnnouncement tunerAnnouncement)
{
	   const int mapSize = sizeof aMidwTunerAnnouncementResponseMap / sizeof(stMidwTunerAnnouncementResponseMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerAnnouncementResponseMap[u32Index].tunerAnnouncement == tunerAnnouncement)
	      {
	         return aMidwTunerAnnouncementResponseMap[u32Index].tunerMasterAnnoType;
	      }
	   }
	   return midw_fi_tcl_e8_Tun_AnnoTypes::FI_EN_INVALID_TYPE;
}
/**************************************************************************//**
*
******************************************************************************/
tuner::common::enSourceId getTunerSourceId(midw_fi_tcl_e8_Band::tenType midwTunermasterBand)
{
	   const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	   for (int u32Index = 0; u32Index < mapSize; u32Index++)
	   {
	      if (aMidwTunerSourceMap[u32Index].midwTunermasterBand == midwTunermasterBand)
	      {
	         return aMidwTunerSourceMap[u32Index].tunerSourceId;
	      }
	   }
	   return tuner::common::SOURCEID_LIMIT;
}
/**************************************************************************//**
*
******************************************************************************/
bool bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::enSourceId tunerSourceId)
{
	const int mapSize = sizeof astMidwDABAnnoSurvivellenceStateMap / sizeof(stMidwDABAnnoSurvivellenceStateMap);
	 for (int u32Index = 0; u32Index < mapSize; u32Index++)
	 {
		 if (astMidwDABAnnoSurvivellenceStateMap[u32Index].tunerSourceId == tunerSourceId)
		 {
			 return astMidwDABAnnoSurvivellenceStateMap[u32Index].bDABAnnoSurvivellencesSupported;
		 }
	 }
	return false;
}
/**************************************************************************//**
*
******************************************************************************/
void vSetMidwTunerSource(tU32 u32CombiBand, tU32 u32AvailableBand)
{
	if(u32CombiBand & READ_DRM_MODULATION_BIT)
	{
		vSetCB1forDRMandBandForAM(u32CombiBand,u32AvailableBand);
	}
	else
	{
		vSetNoneforDRMandBandForAM(u32CombiBand,u32AvailableBand);
	}
}
/**************************************************************************//**
*
******************************************************************************/
void vSetCB1forDRMandBandForAM(tU32 /*u32CombiBand*/, tU32 u32AvailableBand)
{
	const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		switch(aMidwTunerSourceMap[u32Index].tunerSourceId)
		{
			case DRM:
			aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1;
			break;

			case AM:
			if(u32AvailableBand & LW_BIT_SET)
			{
				aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW;
			}
			else if(u32AvailableBand & MW_BIT_SET)
			{
				aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
			}
			else
			{
				aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
			}
			break;

			default: break;
		}
	}
}
/**************************************************************************//**
*
******************************************************************************/
void vSetNoneforDRMandBandForAM(tU32 u32CombiBand, tU32 u32AvailableBand)
{
	const int mapSize = sizeof aMidwTunerSourceMap / sizeof(stMidwTunerSourceMap);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		switch(aMidwTunerSourceMap[u32Index].tunerSourceId)
		{
			case AM:
			if(u32CombiBand & LW_MW_BITS_SET)
			{
				aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1;
			}
			else
			{
				if(u32AvailableBand & LW_BIT_SET)
				{
					aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW;
				}
				else if(u32AvailableBand & MW_BIT_SET)
				{
					aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
				}
				else
				{

				}
			}
			break;

			case DRM:
			aMidwTunerSourceMap[u32Index].midwTunermasterBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
			break;

			default: break;
		}
	}
}
/***
 *
 */
midw_fi_tcl_e8_Tun_TunerHeader::tenType getMidwTunerHeader(tuner::common::enTunerState tunerState)
{
	const int mapSize = sizeof aMidwTunerStateMap / sizeof(stMidwTunerStateMap);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aMidwTunerStateMap[u32Index].tunerState == tunerState)
		{
			return aMidwTunerStateMap[u32Index].midwTunerHeader;
		}
	}
	return midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE;
}

/**
 *
 */
midw_fi_tcl_e8_Tun_MTCAudioSource::tenType getMTCAudioSource(tuner::common::enBand tunerBand, tuner::common::enSourceId tunerSourceId)
{
	const int mapSize = sizeof aMTCAudioSource / sizeof(stMTCAudioSource);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aMTCAudioSource[u32Index].tunerBand == tunerBand && aMTCAudioSource[u32Index].tunerSourceId == tunerSourceId)
		{
			return aMTCAudioSource[u32Index].MTCAudioSourceId;
		}
	}
	return midw_fi_tcl_e8_Tun_MTCAudioSource::FI_EN_TUN_LASTAUDIOSOURCE;
}

/**
 *
 */
midw_fi_tcl_e8_Tun_MTCAudioSource::tenType getMTCAudioSource(tuner::common::enAnnouncement tunerAnnouncement)
{
	const int mapSize = sizeof aMTCAudioSource / sizeof(stMTCAudioSource);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aMTCAudioSource[u32Index].tunerAnnouncement == tunerAnnouncement)
		{
			return aMTCAudioSource[u32Index].MTCAudioSourceId;
		}
	}
	return midw_fi_tcl_e8_Tun_MTCAudioSource::FI_EN_TUN_LASTAUDIOSOURCE;
}

/**
 *
 */
tuner::common::enSourceId getTunerSourceId(midw_fi_tcl_e8_Tun_MTCAudioSource::tenType midwMTCSourceId)
{
	const int mapSize = sizeof aMTCAudioSource / sizeof(stMTCAudioSource);
	for (int u32Index = 0; u32Index < mapSize; u32Index++)
	{
		if (aMTCAudioSource[u32Index].MTCAudioSourceId == midwMTCSourceId)
		{
			return aMTCAudioSource[u32Index].tunerSourceId;
		}
	}
	return tuner::common::SOURCEID_LIMIT;
}
