
/************************************************************************
* FILE:           clDABAnnouncementsImpl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clDABAnnouncementsImpl
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date        | Author		 | Modification
* 27-Mar-2015 | pad1cob      | 
*************************************************************************/

#include "announcements/clDABAnnouncementsImpl.h"
#include "sessionManagement/audio/clAudioSession.h"
#include "convTables/midwTunerMap.h"
#include "Src_Chg/Header/tunmstr_DABClient_Handler.h"
#include "Src_Chg/Header/tunmstr_TunerClientHandler.h"
#include "kdsconfig/clConfigInterface.h"

using namespace tuner::announcements;
using namespace tuner::common;


clDABAnnouncementsImpl::clDABAnnouncementsImpl(tunmstr_DABClient_Handler* poDABClientHandler, tunmstr_MsgToHMI* poMsgToHMI,
		tunmstr_TunerClientHandler* poTunerClientHandler, clConfigInterface* poclConfigInterface)
   :m_poDABClientHandler(poDABClientHandler)
   ,m_potunmstr_MsgToHMI(poMsgToHMI)
   ,m_poTunerClientHandler(poTunerClientHandler)
   ,m_poclConfigInterface(poclConfigInterface)

{

}


clDABAnnouncementsImpl::~clDABAnnouncementsImpl(){
	m_poDABClientHandler = 0;
	m_potunmstr_MsgToHMI = 0;
	m_poTunerClientHandler = 0;
	m_poclConfigInterface = 0;
}


void clDABAnnouncementsImpl::vOnAnnouncementState(tuner::common::enAnnouncement announcementId,
		tuner::common::enSrcActivity tunerSrcActivity, tuner::common::enTunerState /*tunerState*/)
{
	if(m_poDABClientHandler == 0 || m_potunmstr_MsgToHMI == 0 || m_poclConfigInterface == 0)
	{
		return;
	}
	if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
		if(tunerSrcActivity == tuner::common::SRCOFF)
		{
			m_poTunerClientHandler->vSend_MTCAudiosource(midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE, midw_fi_tcl_e8_Tun_MTCAudioSource::FI_EN_TUN_LASTAUDIOSOURCE, midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID, true);
		}
		else
		{
			m_poTunerClientHandler->vSend_MTCAudiosource(midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND, getMTCAudioSource(announcementId), midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
		}
	}
	m_poDABClientHandler->vSend_s_SlectAnno(getDabAnnouncementType(announcementId), getSelectValue(tunerSrcActivity));
}


void clDABAnnouncementsImpl::vCancelAnnouncement(tuner::common::enAnnouncement /*announcementId*/){

	if(m_poDABClientHandler == 0)
	{
		return;
	}
	m_poDABClientHandler->vSend_s_StopAnno();
}

void clDABAnnouncementsImpl::vOnAnnouncementCompleted(tuner::common::enAnnouncement announcementId,
        			tuner::common::enSrcActivity tunerSrcActivity)
{
	m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(getSelectValue(tunerSrcActivity), (tU8)midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB,  (tU8)getDABTunerMasterAnnouncement(announcementId));
	m_potunmstr_MsgToHMI->vUpdateAnnouncementStatusValues(getSelectValue(tunerSrcActivity),(tU8) midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB,  (tU8)getDABTunerMasterAnnouncement(announcementId));
}
