
/************************************************************************
* FILE:           clAudioImpl.h
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    header contents of the Class clAudioImpl
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author		 | Modification
* 27-Mar-2015 | pad1cob      |  
*************************************************************************/

#ifndef clAudioImpl_h
#define clAudioImpl_h

#include "convTables/tunerArlMap.h"
#include "announcements/interface/clAudioInterface.h"

namespace tuner
{
   namespace sessionManagement
   {
   	   namespace audio
   	   {
   	   	   class clArlSourceImpl;
   	   }
   }

   namespace announcements
   {
      /**
       * @author pad1cob
       * @version 1.0
       * @created 27-Mar-2015 15:43:29
       */
      class clAudioImpl : public tuner::announcements::clAudioInterface
      {

      public:
         clAudioImpl(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl);
         virtual ~clAudioImpl();

         virtual void vRequestSourceChange(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity);
         virtual tuner::common::enSourceId getActiveSource();
         virtual tuner::common::enSrcActivity getActiveSourceActivity();
		 virtual tuner::common::enSourceId getRequestedSource();
         virtual tuner::common::enSrcActivity getRequestedSourceActivity();

      private:
         tuner::sessionManagement::audio::clArlSourceImpl* m_poArlSourceImpl;
		 tuner::common::enSourceId requestedSourceId;
		 tuner::common::enSrcActivity requestedSourceActivity;

      };
   }
}
#endif // !defined(clAudioImpl_h)
