
/************************************************************************
* FILE:           clAnnouncementControl.h
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    header contents of the Class clAnnouncementControl
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author		 | Modification
* 27-Mar-2015 | pad1cob      | 
*************************************************************************/

#ifndef clAnnouncementControl_h
#define clAnnouncementControl_h


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_if.h"

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h"


#include "sessionManagement/audio/interface/clTunerInterface.h"
#include "datatypes/tString.h"
#include "datatypes/tVector.h"

namespace tuner
{
   namespace announcements
   {
      /**
       * @author pad1cob
       * @version 1.0
       * @created 27-Mar-2015 15:43:29
       */
      class clAnnouncementControl :  public tuner::sessionManagement::audio::clTunerInterface
      {

      public:
         clAnnouncementControl();
         virtual ~clAnnouncementControl();

         virtual void vOnNewAnnouncementMessage(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage,tuner::common::enSourceId tunerSourceId,tuner::common::enSrcActivity tunerSrcActivity);
         virtual void vOnNewAnnouncementList(tunerVector<midw_ext_fi_tcl_DAB_AnnoElement> midwDabAnnouncementList,tuner::common::enSourceId tunerSourceId,tuner::common::enSrcActivity tunerSrcActivity);
         virtual void vSetAnnouncementPriority(tuner::common::enAnnouncement announcement, unsigned short priority);
         virtual void vOnNewTpState(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand, midw_fi_tcl_e8_AtStationTPinfo::tenType midwTpState);
         virtual void vOnNewTpState(tuner::common::enBand tunerBand, tuner::common::enTpState  tpState);
         virtual void vOnSourceFollowingState(tuner::common::enBand tunerBand, bool bSourceFollowing);
         virtual void vCancelAnnouncement(midw_fi_tcl_StopAnnouncements::tenType midwCancelAnnouncement);
         virtual unsigned short oGetActiveMidwAnnouncementId();

          virtual void vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
          virtual void vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool bInformSourceChange);
          virtual void vChangeBand(tuner::common::enBand tunerBand);
          virtual void vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState);
          virtual void vSetFrequency(tuner::common::enBand tunerBand, unsigned int frequency);
          virtual void vSetModulationAndSrcActivity(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity);
		  virtual void vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone );
		  virtual void vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, unsigned char audioSink);
		  virtual void vOnNewTunerState(tuner::common::enTunerState dabTunerState);
		  void vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, midw_fi_tcl_e8_Tun_MTCAudioSource::tenType midwTunerSource);
		  bool bIsRepeatedAnnouncementRequest(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage);
		  void vClearAnnouncementStates();
		  void vSetPICode(unsigned short piCode);
		  unsigned short oGetPICode();
		  void vSetAnnouncementSwitch(bool TPState);
		  bool bIsAnnouncementSwitchOn();

		  void vCancelAnnouncement();
		  void vUpdateStreamRouterServiceState(tuner::common::enTunerClientAvailability tunerClientAvailable);
		  void vResetAnnouncementsStates();

      private:
		  bool bTPState;
		  tuner::common::enTunerClientAvailability streamRouterServiceAvailable;
      };

   }
}
#endif // !defined(clAnnouncementControl_h)
