
/************************************************************************
* FILE:           clAMFMAnnouncementsImpl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clAMFMAnnouncementsImpl
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author		 | Modification
* 27-Mar-2015 | pad1cob      |  
*************************************************************************/


#include "announcements/clAMFMAnnouncementsImpl.h"
#include "sessionManagement/audio/clAudioSession.h"
#include "convTables/midwTunerMap.h"
#include "Src_Chg/Header/tunmstr_TunerClientHandler.h"
#include "kdsconfig/clConfigInterface.h"
using namespace tuner::announcements;


clAMFMAnnouncementsImpl::clAMFMAnnouncementsImpl(tunmstr_TunerClientHandler* poTunerClientHandler, 
tunmstr_MsgToHMI* poTunmstr_MsgToHMI,clConfigInterface* poclConfigInterface)
   :m_poTunerClientHandler(poTunerClientHandler),
   m_poTunmstr_MsgToHMI(poTunmstr_MsgToHMI),
   m_poclConfigInterface(poclConfigInterface)
{

}


clAMFMAnnouncementsImpl::~clAMFMAnnouncementsImpl(){
	m_poTunerClientHandler = 0;
	m_poTunmstr_MsgToHMI = 0;
    m_poclConfigInterface = 0;
}


void clAMFMAnnouncementsImpl::vOnAnnouncementState(tuner::common::enAnnouncement announcementId,
		tuner::common::enSrcActivity tunerSrcActivity, tuner::common::enTunerState tunerState){

	if((m_poTunerClientHandler == 0 || m_poTunmstr_MsgToHMI == 0) || (m_poclConfigInterface == nullptr))
	{
		return;
	}
	if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
		if(tunerSrcActivity == tuner::common::SRCOFF)
		{
			m_poTunerClientHandler->vSend_MTCAudiosource(midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE, midw_fi_tcl_e8_Tun_MTCAudioSource::FI_EN_TUN_LASTAUDIOSOURCE, midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID, true);
		}
		else
		{
			m_poTunerClientHandler->vSend_MTCAudiosource(midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND, getMTCAudioSource(announcementId), midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
		}
	}
	else
	{
		if(tunerSrcActivity == tuner::common::SRCOFF)
		{
			m_poTunerClientHandler->vSend_s_Audio_FG_BG_New(getMidwTunerHeader(announcementId), getMidwTunerSubCommand(tunerSrcActivity), getMidwAudioSink(announcementId), (tU8)getMidwTunerState(tunerState), getMidwPhysicalTuner(announcementId));
		}
		else
		{
			m_poTunerClientHandler->vSend_s_Audio_FG_BG_New(getMidwTunerHeader(announcementId), getMidwTunerSubCommand(tunerSrcActivity), getMidwAudioSink(announcementId), (tU8)getMidwTunerState(tunerSrcActivity), getMidwPhysicalTuner(announcementId));
		}
	}
}


void clAMFMAnnouncementsImpl::vCancelAnnouncement(tuner::common::enAnnouncement announcementId){

	if(m_poTunerClientHandler == 0)
	{
		return;
	}
   if(tuner::common::WEATHERALERT == announcementId)
   {
      //already handled in clAnnouncements::vCancelAnnouncement() in annon lib.
      //clAMFMAnnouncementsImpl::vCancelAnnouncement with weather alert should not be called
   }
   else
   {
      m_poTunerClientHandler->vSend_s_Stop_Anno(getMidwAnnoType(announcementId));
   }
}

void clAMFMAnnouncementsImpl::vOnAnnouncementCompleted(tuner::common::enAnnouncement announcementId,
        			tuner::common::enSrcActivity tunerSrcActivity)
{
   tU8 u8Source = midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1;
   if(tuner::common::WEATHERALERT == announcementId)
   {
      u8Source = midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_WEATHER_ALERT;
   }
   m_poTunmstr_MsgToHMI->vSend_g_Announcement_Status(getSelectValue(tunerSrcActivity), u8Source, getAMFMTunerMasterAnnouncement(announcementId));
	m_poTunmstr_MsgToHMI->vUpdateAnnouncementStatusValues(getSelectValue(tunerSrcActivity), u8Source, getAMFMTunerMasterAnnouncement(announcementId));
	return;
}

