/************************************************************************
 * FILE:           tunmstr_SrcChg_AnnoHandler.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    Class to handle Auto store functionalities
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	 | Author                       | Modification
 * 07-07-2013	 | RBEI/ECV3 Pallavi HN   		| initial version
 *
 *************************************************************************/

//------------
// includes
//------------
#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


//---------------------------------------

//-------------------
// Internal includes
//-------------------
#include "fc_tunermaster_featureControl.h"

#include "tunermaster_main.h"
#include "tunermaster_Config.h"

#include "tunmstr_TunerClientHandler.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunermaster_defines.h"
#include "tunmstr_MsgToHMI.h"
#include "tunmstr_MsgFromHMI.h"
#include "tunmstr_AudioClientHandler.h"
#include "tunmstr_SrcChg_Defines.h"
#include "kdsconfig/clConfigInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_SrcChg_AnnoHandler.cpp.trc.h"
#endif



/*************************************************************************
 *
 * FUNCTION: tunmstr_SrcChg_AnnoHandler::tunmstr_SrcChg_AnnoHandler(ccademo_tclApp* poGWMainApp)
 *
 * DESCRIPTION: constructor, creates object tunmstr_SrcChg_AnnoHandler - object
 *
 * PARAMETER: ccademo_tclApp* poGWMainApp: main - object of this application
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tunmstr_SrcChg_AnnoHandler::tunmstr_SrcChg_AnnoHandler(  ):
m_potunmstr_SrcChgManager(NULL),\
m_potunmstr_MsgFromHMI(NULL),\
m_potunmstr_DABClient_Handler(NULL),\
m_potunmstr_TunerClientHandler(NULL),\
m_potunmaster_Config(NULL),\
m_potunmstr_MsgToHMI(NULL),\
m_potunmstr_AudioClientHandler(NULL),\
m_poclConfigInterface(NULL)
{
	/* Assign Tuner main Application pointer */
	m_u16Cmd_Cntr = 0x00;
	m_ActiveAnnoSrc = TunMstr_AnnoActive_None;
	m_blAnno_Active = FALSE;
	m_blTPState_DAB = FALSE;
	m_blTPState_TUN = FALSE;
	m_blLast_TASource_FMTA = FALSE;
	m_blDABTAEnded = FALSE;
	m_AnnoSrcChgRequest.u8AnnoType = TUNMASTER_INVALID;
	m_AnnoSrcChgRequest.u8Source = TUNMASTER_INVALID;
	m_AnnoSrcChgRequest.u8AnnoState = TUNMASTER_INVALID;
	m_u32AnnoButtonState_FM = 0;
	m_u32AnnoButtonState_DAB = 0;
}

/*************************************************************************
 *
 * FUNCTION: tunmstr_SrcChg_AnnoHandler::~tunmstr_SrcChg_AnnoHandler( )
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tunmstr_SrcChg_AnnoHandler::~tunmstr_SrcChg_AnnoHandler( )
{
	m_u16Cmd_Cntr = 0x00;
	m_ActiveAnnoSrc = TunMstr_AnnoActive_None;
	m_blTPState_DAB = FALSE;
	m_blTPState_TUN = FALSE;
	m_blLast_TASource_FMTA = FALSE;
	m_blLast_TASource_FMTA = FALSE;
	m_blDABTAEnded = FALSE;
	m_blAnno_Active = FALSE;

	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmaster_Config = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_AudioClientHandler =NULL;
	m_poclConfigInterface = NULL;
	m_AnnoSrcChgRequest.u8AnnoType = TUNMASTER_INVALID;
	m_AnnoSrcChgRequest.u8Source = TUNMASTER_INVALID;
	m_AnnoSrcChgRequest.u8AnnoState = TUNMASTER_INVALID;
	m_u32AnnoButtonState_FM = 0;
	m_u32AnnoButtonState_DAB = 0;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = potunmstr_SrcChgManager;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_SrcChgManager != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_SrcChg_AnnoHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI= ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgFromHMI != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_SrcChg_AnnoHandler::vSet_tunmaster_DABClient_Handler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_DABClient_Handler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler )
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler= ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_DABClient_Handler != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_TunerClientHandler( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler)
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler= ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_TunerClientHandler != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_SrcChg_AnnoHandler::vSet_tunmaster_Config_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmaster_Config*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config= ( tunmaster_Config* )potunmaster_Config;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmaster_Config != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_MsgToHMI_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = potunmstr_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgToHMI != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_AudioClientHandler_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_AudioClientHandler_Ptr( tunmstr_AudioClientHandler* potunmstr_AudioClientHandler )
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = potunmstr_AudioClientHandler;
	}
	else
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT ( potunmstr_AudioClientHandler != NULL );
#endif
	}
}

/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}


/*************************************************************************
 *
 * FUNCTION:    blGetTPState(  )
 *
 * DESCRIPTION: Returns Status of Band Change Flasg
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tU8 tunmstr_SrcChg_AnnoHandler::u8GetTPSource()const
{
	if(m_potunmstr_SrcChgManager == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return 0;
	}

	if( (m_potunmstr_SrcChgManager->u8GetDABState() == (tU8)TUNMSTR_SRCCHG_FOREGROUND ) || \
			( (m_potunmstr_SrcChgManager->u8GetTunerState() == (tU8)TUNMSTR_SRCCHG_BACKGROUND ) && (m_blTPState_TUN == FALSE)))
	{
		// TP update use cases from DAB
		/*
		 * 1) DAB is FG source
		 * 2) Both DAB and FM is in BG and FM not tuned to TP station
		 * */
		return((tU8)TUNMSTR_SRCCHG_SOURCE_DAB);

	}
	else
	{
		return((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM);
		// else by default return Tuner TP state value
	}
}

/*************************************************************************
 *
 * FUNCTION:    tBool blGetTA_Anno_Status()
 *
 * DESCRIPTION: returns currents active anno source
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blGetTA_Anno_Status()const
{
	return (tU8)m_ActiveAnnoSrc;
}
/*************************************************************************
 *
 * FUNCTION:    tBool vSetDABTA_Ended()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSetDABTA_Ended(const tBool blTA_State)
{
	m_blDABTAEnded = blTA_State;
}
/*************************************************************************
 *
 * FUNCTION:    tBool blGetDABTA_Ended()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blGetDABTA_Ended()const
{
	return m_blDABTAEnded;
}
/*************************************************************************
 *
 * FUNCTION:    tBool vSetLastFMTA_ActiveStatus()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSetLastFMTA_ActiveStatus(const tBool blTA_State)
{
	m_blLast_TASource_FMTA = blTA_State;
}
/*************************************************************************
 *
 * FUNCTION:    tBool blGetDABTA_Ended()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blGetTPState_DAB()const
{
	return m_blTPState_DAB;
}
/*************************************************************************
 *
 * FUNCTION:    tBool blGetDABTA_Ended()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blGetTPState_FM()const
{
	return m_blTPState_TUN;
}
/*************************************************************************
 *
 * FUNCTION:    tBool blGetDABTA_Ended()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blGetLastFMTA_ActiveStatus()const
{
	return m_blLast_TASource_FMTA;
}

/*******************************************************************************
 *FUNCTION:    vCheckForTPStatus
 *
 *DESCRIPTION: This function will info about TP station of currently tuned station.
 *
 *PARAMETER:
 *           su8TPStatus, u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vCheckForTPStatus(tU8 u8TPStatus, tU8 u8Source)
{
	if(m_potunmstr_MsgToHMI ==NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}
	ETG_TRACE_USR4(("vCheckForTPStatus()->u8TPStatus=%d u8Source=%d",u8TPStatus,u8Source));
	switch (u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
	{
		vHandleTPState_FM(u8TPStatus);

	}// end of case FM
	break;

	case TUNMSTR_SRCCHG_SOURCE_DAB:
	{
		vHandleTPState_DAB(u8TPStatus);
		break;
	}
	default:
		break;
	};//end of switch

}//end of function
/*******************************************************************************
 *FUNCTION:    vCheckForTA_Anno
 *
 *DESCRIPTION: This function will hanlde TA Announcment hint
 *
 *PARAMETER:
 *           tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoType
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vCheckForTA_Anno(tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoType)
{
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForTA_Anno-> u16AnnoType =%d, blTA_Anno =%d, u8Source =%d",
			u16AnnoType, blTA_Anno , u8Source));
	if((blTA_Anno == TRUE) && (m_ActiveAnnoSrc == TunMstr_AnnoActive_None))
	{
		vHandlerForTA_Anno(blTA_Anno, u16AnnoType);

	}// if No other Announcment source is active, place request to ARL directly to turn on Announcment type.
	else if ((blTA_Anno == TRUE) && ((m_ActiveAnnoSrc != TunMstr_AnnoActive_None)))
	{
		vEndAnnoSrc(u16AnnoType, u8Source, TRUE); // check for ARL update required
		//vHandlerForTA_Anno(blTA_Anno, u16AnnoType);
	}// End active Other Anno source and then actiavte TA
	else if(blTA_Anno == FALSE)
	{
		vHandlerForTA_Anno(blTA_Anno, u16AnnoType);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForTA_Anno-> Pass to TA handler"));
	}// Pass on to next handler function
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForTA_Anno-> Not a valid case"));
	}// Not a valid case
}
/*******************************************************************************
 *FUNCTION:    vHandlerForTA_Anno
 *
 *DESCRIPTION: This function will info about TA Announcement status
 *
 *PARAMETER:
 *           u8TA_Anno, u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandlerForTA_Anno(tBool blTA_Anno, tU16 u16AnnoType)
{
	ETG_TRACE_USR4(("vHandlerForTA_Anno()TA_Anno=%d AnnoType=%d",blTA_Anno,u16AnnoType));
	switch (u16AnnoType)
	{
	case TunMstr_AnnoActive_FMTA:
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandlerForTA_Anno-TUNMSTR_SRCCHG_SOURCE_TUN1FM,inside FM case"));
		vHandle_FMTA(blTA_Anno);
		//Pass to FM TA handling function
		break;
	}
	case TunMstr_AnnoActive_DABTA:
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandlerForTA_Anno-TUNMSTR_SRCCHG_SOURCE_DAB,inside DAB case"));
		vHandleDABTA(blTA_Anno);
		break;
	}
	default:
		break;

	};//end of switch

}//end of the function
/*******************************************************************************
 *FUNCTION:    vHandle_FMTA
 *
 *DESCRIPTION: Handler to handle TA from FM.
 *
 *PARAMETER:
 *           u8TA_Anno, u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandle_FMTA(tBool blTA_Anno)
{
	if((m_potunmstr_MsgToHMI ==NULL) || (m_potunmstr_SrcChgManager == NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			|| (m_potunmstr_DABClient_Handler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA, ASSERT!!!!!!!!!!!!!!!!!"));
		return;
	}
	switch (blTA_Anno)
	{
	case TRUE:
	{
		tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
		//tBool blTunState = u8GetTunerState();
		if((m_ActiveAnnoSrc == TunMstr_AnnoActive_FMTA) ||(m_potunmstr_SrcChgManager->blGetTestMode_Status() == TRUE))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA-FM_TA_ACTIVE, Either TA was already active or test mode was active, hence return"
					"TA_Anno_Active=%d TestMode=%d",
					m_ActiveAnnoSrc,m_potunmstr_SrcChgManager->blGetTestMode_Status()  ));
			break;
		}
		if(((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8DABState) && (m_potunmstr_DABClient_Handler->blGetFmServiceFollowActive()))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA , DAB in FG and FM service follow is active "));
			vStartAnnoSrc(TunMstr_AnnoActive_FMTA);
		}
		else if( ((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8DABState) && (m_blTPState_DAB == TRUE))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA-FM_TA_ACTIVE, DAB is in FG and playing TP station,hence No Anno"));
			//if DAB is in FG, current playing station is TP station, then TA cant't be sent from FM
		}
		else if( ((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8DABState) && (m_blTPState_DAB == FALSE))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA-FM_TA_ACTIVE, DAB FG & non-TP station, TA on request sent to HMI"));
			vStartAnnoSrc(TunMstr_AnnoActive_FMTA);
			//vSetActiveAnnoSrc(TunMstr_AnnoActive_FMTA);
			//DAB is in FG but current station is non-TP station, then TA from FM will be sent to FG
			//m_blFMTA_StartRequest falg is set to solve NIKAI 5689
		}
		else
		{
			vStartAnnoSrc(TunMstr_AnnoActive_FMTA);
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA-FM_TA_ACTIVE, FM_TA-- ON sent to HMI"));
			//m_blFMTA_StartRequest falg is set to solve NIKAI 5689
			//In FM and No active Announcement, then TA from FM will be put through
		}
		break;
	}//end of case FM_TA_ACTIVE
	case FALSE:
	{
			vEndAnnoSrc(TunMstr_AnnoActive_FMTA ,(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM, FALSE);
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_FMTA-FM_TA_STOP, FM_TA OFF sent to HMI"));
			// if current anno is from FM TA then stop the announcement
		break;
	}//end of case FM_TA_STOP
	default:
		break;
		//To Indicate Last TA Soucre was FM, This will help in sending FM source to BG, when there is source change during TA Anno.
	}//end of Switch
}//end of Function
/*******************************************************************************
 *FUNCTION:    vCheckForStop_Anno
 *
 *DESCRIPTION: This function will info about TA Announcement status
 *
 *PARAMETER:
 *           u8TA_Anno, u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vCheckForStop_Anno(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgToHMI ==NULL) || (m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_SrcChgManager ==NULL) ||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		(m_potunmstr_AudioClientHandler == NULL) ||
#endif
		(m_potunmstr_DABClient_Handler ==NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		return;
	}
	tU8 u8TA_Source = m_potunmstr_SrcChgManager->u8GetCurrentTA_Source();
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
	ETG_TRACE_USR4(("vCheckForStop_Anno()->"
			"Current_TASource=%d m_ActiveAnnoSrc=%d m_blTPState_TUN=%d u8DABState=%d",
			u8TA_Source,m_ActiveAnnoSrc, m_blTPState_TUN,u8DABState ));
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart oMsgData;

	vGetDatafromAMT(poMessage,oMsgData);
	tU8 u8Stop_Anno = (tU8)oMsgData.StopAnnouncements.enType;

	// extract the Message Info
	if((u8TA_Source== (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA)||(u8TA_Source== (tU8)TUNMSTR_SRCCHG_SOURCE_FMPTY31))
	{
		m_potunmstr_TunerClientHandler->vSend_s_Stop_Anno(u8Stop_Anno);
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_FM_TA,TUNMSTR_SRCCHG_ACTION_OFF ) ;
		vSend_Src_Chg_Request ((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA, (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
	}
	else if ((u8TA_Source == (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA)||(u8TA_Source== (tU8)TUNMSTR_SRCCHG_SOURCE_DABPTY31)
			|| (u8TA_Source == (tU8)TUNMSTR_SRCCHG_SOURCE_DABOTHER))
	{
		m_potunmstr_DABClient_Handler->vSend_s_StopAnno();
		vSend_Src_Chg_Request ((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA, (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_DAB_TA, TUNMSTR_SRCCHG_ACTION_OFF);
		//m_potunmstr_MsgToHMI->vSend_g_SourceChange(TUNMSTR_SRCCHG_SOURCE_DAB_TA,TUNMSTR_SRCCHG_ACTION_OFF ) ;
	}


}//end of Function
/*******************************************************************************
 *FUNCTION:    vSetTA_Anno_State
 *
 *DESCRIPTION: with this function, currtent tuned band value is updated.
 *
 *PARAMETER:
 *           u8TA_Anno, u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler :: vSetTA_Anno_State(const tU8 u8TA_Anno)
{
	m_blAnno_Active = (tBool)u8TA_Anno;

}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_SrcChg_AnnoHandler::vHandleTunerServiceUnavil( )
 *
 * DESCRIPTION:  Follwing operations are performed when Tuner service is unavil.
 * Delete Error Handler timer and related flags
 * Send Pending Result to ARL
 * Check if Nesting commands exist, if so clear them.
 *
 * PARAMETER:    -None
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandleTPState_FM(tU8 u8Status)
{

	if((m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}
	tBool blTP_Active =TUNMSTR_FMTPSTATUS_ACTIVE;
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
	tU8 u8TunerState = m_potunmstr_SrcChgManager->u8GetTunerState();
	if(blTP_Active ==  TRUE)

		// possible TP active status from ADR3
	{
		if(( u8DABState == (tU8)TUNMSTR_SRCCHG_FOREGROUND ) && (m_blTPState_DAB == TRUE))
		{
			m_blTPState_TUN = TRUE;
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_FM, DAB in FG, only Channel Info msg will be considered"));
		}// only when DAB is in FG and tuned to TP station, FM TP state should not be considerd.
		else
		{
			m_blTPState_TUN = TRUE;
			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
					ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_TP_STATE _
					ET_EN_T8 _ m_blTPState_TUN _
					ET_EN_DONE );
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_TUN, (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM);
		}// In all other case, FM TP status can be used for display update.
	}

	else {
		// For TP inactive case

		if(((m_blTPState_DAB == TRUE) && (u8DABState == (tU8)TUNMSTR_SRCCHG_FOREGROUND)) \
				||( (u8DABState == (tU8)TUNMSTR_SRCCHG_BACKGROUND) && ((u8TunerState == (tU8)TUNMSTR_SRCCHG_BACKGROUND))))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_FM, TP state will be updated only with Channel Info msg in this case"));
			m_blTPState_TUN = FALSE;
			// use cases this condition would address
			/*
			 * 1)FM in BG- DAB FG source, tuned to TP service. If we received CM_TAInfo with PI = 0, TP state will not be considered from FM
			 * 2) both FM and DAB in BG, TP state from DAB is true, and from FM its False. IN that case TP value of DAB is considered.
			 * 3) DAB is in BG, and Tuner in FG with non-TP station
			 */
		}
		else
		{
			m_blTPState_TUN = FALSE;
			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
					ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_TP_STATE_2 _
					ET_EN_T8 _ m_blTPState_TUN _
					ET_EN_DONE );
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_TUN, (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM);
			// In all other case case, TP state from FM will be used to update display.
		}
	}

}// end of function
/*************************************************************************
 *
 * FUNCTION:     tunmstr_SrcChg_AnnoHandler::vHandleTunerServiceUnavil( )
 *
 * DESCRIPTION:  Follwing operations are performed when Tuner service is unavil.
 * Delete Error Handler timer and related flags
 * Send Pending Result to ARL
 * Check if Nesting commands exist, if so clear them.
 *
 * PARAMETER:    -None
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB(tU8 u8Status)
{
	if((m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}


	tBool blVisible =m_potunmstr_SrcChgManager-> blGetDABVisibalityStatus();
	tBool blTP_Active=(tBool)TUNMSTR_DABTPSTATUS_ACTIVE;
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, u8Status=%d blTP_Active=%d",u8Status,blTP_Active));
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
	tU8 u8TunerState = m_potunmstr_SrcChgManager->u8GetTunerState();
	//TP state of DAB has to be processed only when DAB is in FG
	switch (blTP_Active)
	{
	case TRUE:
	{

		if(( u8DABState == (tU8)TUNMSTR_SRCCHG_FOREGROUND ) ||(blVisible== (tU8)TUNMSTR_SRCCHG_VISIBLE))
		{
			m_blTPState_DAB = TRUE;
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_DAB, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, DAB in FG, Update TP state with Channel Info"));
			// When DAB is in FG
			// to solve JIRA issue NIKAI-3964
		}

		else if((m_blTPState_TUN == FALSE) && (u8TunerState == (tU8)TUNMSTR_SRCCHG_BACKGROUND ))
		{
			m_blTPState_DAB = TRUE;
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_DAB, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
			ETG_TRACE_USR4(("vHandleTPState_DAB()->AMFM tunrner is in BG and tuned to Non TP station-->Update DAB TP"));
			//Use cases coverd in this condition
			/*
			 * 1) When FM is in BG and DAB tuned to TP service
			 * 2) When Both FM and DAB in BG, and only DAB tuned to TP service
			 * */
		}
		else
		{
			m_blTPState_DAB = TRUE;
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, Default case: No update sent"));
		}

	}break;
	case  FALSE:
	{
		//If DAB state is in FG and Tuned to Non TP station but,in  BG FM is tuned to TP station
		if((u8DABState == (tU8)TUNMSTR_SRCCHG_FOREGROUND)&& (m_blTPState_TUN == TRUE))
		{
			m_blTPState_DAB = FALSE;
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_TUN, (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM);
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, DAB in FG, Update TP state with FM TP state"));
		}
		//If DAB state is in FG and dab is Tuned to Non TP station but,in  BG FM is not tuned to TP station
		else if((u8DABState == (tU8)TUNMSTR_SRCCHG_FOREGROUND) && (m_blTPState_DAB == TRUE))
		{
			m_blTPState_DAB = FALSE;
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_DAB, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, DAB in FG, Update TP state with Channel Info"));
		}
		//Both FM and DAB tuner is in BG and not tuned to Tp station
		else if((u8DABState == (tU8)TUNMSTR_SRCCHG_BACKGROUND) && (u8TunerState == (tU8)TUNMSTR_SRCCHG_BACKGROUND) && (m_blTPState_TUN == FALSE))
		{

			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, Playing Non-Radio Source"))
									m_blTPState_DAB = FALSE;
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_blTPState_DAB, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
		}
		else
		{
			m_blTPState_DAB = FALSE;
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleTPState_DAB, No Update required, No update sent"))

		}
	}break;
	};// end of switch

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
			ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_TP_STATE _
			ET_EN_T8 _ m_blTPState_DAB _
			ET_EN_DONE );
}

/*************************************************************************
 *
 * FUNCTION:    blGetTPState(  )
 *
 * DESCRIPTION: Returns Status of Band Change Flasg
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blGetTPState()const
{
	if(m_potunmstr_SrcChgManager ==NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return 0;
	}
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
	tU8 u8TunerState = m_potunmstr_SrcChgManager->u8GetTunerState();
	if( (u8DABState == (tU8)TUNMSTR_SRCCHG_FOREGROUND ) ||( (u8TunerState == (tU8)TUNMSTR_SRCCHG_BACKGROUND ) && (m_blTPState_TUN == FALSE)))
	{
		// TP update use cases from DAB
		/*
		 * 1) DAB is FG source
		 * 2) Both DAB and FM is in BG and FM not tuned to TP station
		 * */
		return(m_blTPState_DAB);

	}
	else
	{
		return(m_blTPState_TUN);
		// else by default return Tuner TP state value
	}
}

/*************************************************************************
 *
 * FUNCTION: tunmstr_SrcChg_AnnoHandler::vHandleAnnoStatusInfo( )
 *
 * DESCRIPTION: Handler function for activation/decativation of Anno soft keys
 *
 * PARAMETER:tU32 u32AnnoType,tU8 u8Source
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler:: vHandleAnnoStatusInfo(tU32 u32AnnoType,tU8 u8Source)
{
	if((m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_DABClient_Handler == NULL))
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT ( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT ( m_potunmstr_DABClient_Handler != NULL );

		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoStatusInfo-> ASSERT!!!!!!!!!!!!!!!!!"));
		return;
	}

	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoStatusInfo-> AnnoType = %d u8Source = %d",u32AnnoType,u8Source));

	tU8 u8FMAnnoType = 0;

	if((u8Source & TUNMSTR_SOURCEANNO_FM))
	{
		u8FMAnnoType = (tU8)(u32AnnoType & (tU32)TUNMSTR_ANNOSTATE_PTYOFF_TAON); //TA bit

		u8FMAnnoType = (tU8)(((m_potunmstr_TunerClientHandler->bGetPTYState()<<0x01) | (u8FMAnnoType>>0x01)));
		// Send TP state in bit0 and PTY state in bit1
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoStatusInfo-> FMAnnoType =%d",u8FMAnnoType));
	}
	if(u8Source & (tU8)midw_fi_tcl_b8_SourceAnno::FI_C_U8_BIT_TUNMSTR_ANNOSRC_WEATHER)
	{
	   if(u32AnnoType & midw_fi_tcl_b32_AnnoType::FI_C_U32_BIT_TUNMSTR_ANNOTYPE_WEATHERALERT)
	   u8FMAnnoType = u8FMAnnoType | midw_fi_tcl_b8_AnnoTypes::FI_C_U8_BIT_WEATHERALERT ;
	}
	switch(u8Source)
	{
	case TUNMSTR_SOURCEANNO_FM:
	case TUNMSTR_SOURCEANNO_FM_WB:
	case TUNMSTR_SOURCEANNO_WB:
	{
		m_potunmstr_TunerClientHandler->vSend_s_SetAnnouncementSwitch(u8FMAnnoType);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHanldeAnnostatusInfo-> Request for FM sent"));
	}break;
	case TUNMSTR_SOURCEANNO_DAB:
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoStatusInfo-> DABAnnoType =%d",u32AnnoType));
		m_potunmstr_DABClient_Handler->vSend_s_Anno_Config((tU16)u32AnnoType);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHanldeAnnostatusInfo-> Request for DAB sent"));
	}break;
	case TUNMSTR_SOURCEANNO_BOTH:
	{
		m_potunmstr_TunerClientHandler->vSend_s_SetAnnouncementSwitch(u8FMAnnoType);
		m_potunmstr_DABClient_Handler->vSend_s_Anno_Config((tU16)u32AnnoType);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHanldeAnnostatusInfo-> Request for  Both Source sent"));

	}break;
	case TUNMSTR_SOURCEANNO_NONE:
	default:
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHanldeAnnostatusInfo-> Invalid case"));
		break;

	};//end of switch
}// end of Function

/*************************************************************************
 *
 * FUNCTION: tunmstr_SrcChg_AnnoHandler::vHandleAnnoConfig( )
 *
 * DESCRIPTION: This function is used tos et Anno realted features for FM source
 *
 * PARAMETER:tBool blAnno_Status,tU8 u8Type,tU8 u8Source
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandleAnnoConfig(tU32 u32AnnoConfig)
{

	if(m_potunmstr_MsgToHMI == NULL)
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgToHMI != NULL );

		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoConfig-> ASSERT!!!!!!!!!!!!!!!!!"));
		return;
	}

	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoConfig-> u32AnnoConfig: %d",u32AnnoConfig));

	vSetButtonState_DAB(u32AnnoConfig);

	m_potunmstr_MsgToHMI->vSend_g_AnnoButton_Status((tU8)TUNMSTR_SRCCHG_SOURCE_DAB, u32GetAnnoButtonState_DAB());
}// end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vGetDatafromAMT
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}

}


/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vHandle_AnnoMSG
 *
 *DESCRIPTION:
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandle_AnnoMSG(tU16 u16AnnoType, tU8 u8Source, tBool AnnoState)
{
	if((NULL==m_potunmstr_SrcChgManager)||(NULL==m_poclConfigInterface))
	{
			return ;
	}
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandle_AnnoMSG-> AnnoType = %d Source =%d  AnnoState =%d",
			u16AnnoType, u8Source, AnnoState));
	tBool bCheckAnno = TRUE;
	tU8 u8TunerState = m_potunmstr_SrcChgManager->u8GetTunerState();
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
    if(TUNMSTR_TUNER_STATE_BG_INVALID || (m_potunmstr_SrcChgManager->u8GetCurrentSource() == TUNMSTR_SRCCHG_SOURCE_TUN1AM))
	{
		tU8 u8TraficAnnoInOtherSrc = (tU8)(((m_poclConfigInterface->u32GetConfigData("TraficAnnoInOtherSrc")) & 0x04) >> 0x02);
		if(u8TraficAnnoInOtherSrc == 0x00 && u8Source != TUNMSTR_SRCCHG_SOURCE_TUN1FM)
		{
			bCheckAnno = FALSE;
		}
		else if(u8TraficAnnoInOtherSrc == 0x01 && u8Source != TUNMSTR_SRCCHG_SOURCE_DAB)
		{
			bCheckAnno = FALSE;
		}
		else
		{
			// check anno msg
		}
	}

	if(bCheckAnno)
	{
		switch (u16AnnoType)
		{
		case TunMstr_AnnoActive_FMPTY:
		case TunMstr_AnnoActive_DABPTY:
		{
			vCheckForPTY31_Anno(AnnoState,u8Source,u16AnnoType);
		}
		break;

		case TunMstr_AnnoActive_FMTA:
		case TunMstr_AnnoActive_DABTA:
		{
			vCheckForTA_Anno(AnnoState,u8Source,u16AnnoType);
		}
		break;
		case TunMstr_AnnoActive_DABWarning:
		case TunMstr_AnnoActive_DABNews:
		case TunMstr_AnnoActive_DABTransport:
		case TunMstr_AnnoActive_DABWeather:
		case TunMstr_AnnoActive_DABEvent:
		case TunMstr_AnnoActive_DABSplEvent:
		case TunMstr_AnnoActive_DABPI:
		case TunMstr_AnnoActive_DABSports:
		case TunMstr_AnnoActive_DABFinance:
		{
			vCheckForOther_Anno(AnnoState,u8Source,u16AnnoType);
		}
		break;
		default:
			break;
		};
	}
}

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vHandleAnnoConfig_Other
 *
 *DESCRIPTION:
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vCheckForOther_Anno(tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoOtherType)
{
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForOther_Anno-> u16AnnoType =%d, blTA_Anno =%d, u8Source =%d",
			u16AnnoOtherType, blTA_Anno , u8Source));

	if((blTA_Anno == TRUE) && (m_ActiveAnnoSrc == TunMstr_AnnoActive_None))
	{
		vStartAnnoSrc(u16AnnoOtherType);
		//vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoOtherType);
	}// if No other Announcment source is active, place request to ARL directly to turn on Announcment type.
	else if ((blTA_Anno == TRUE) && ((m_ActiveAnnoSrc != TunMstr_AnnoActive_None)))
	{
		vEndAnnoSrc(u16AnnoOtherType ,u8Source, TRUE); // check for ARL update required
		//vStartAnnoSrc(u16AnnoOtherType);
		//vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoOtherType);
	}//if there is request to end Other Anno Type, check if already ist active and then end it
	else if(blTA_Anno == FALSE)
	{
		vEndAnnoSrc(u16AnnoOtherType ,u8Source, FALSE);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForTA_Anno-> Pass to TA handler"));
	}// Pass on to next handler function
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForOther_Anno-> Not a valid case"));
	}// End PTY31 active Anno

}
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vCheckForPTY31_Anno
 *
 *DESCRIPTION:This function will handle PTY 31 Announcment types
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vCheckForPTY31_Anno(tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoType)
{
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForPTY31_Anno-> u16AnnoType =%d, blTA_Anno =%d, u8Source =%d",
			u16AnnoType, blTA_Anno , u8Source));

	if((blTA_Anno == TRUE) && (m_ActiveAnnoSrc == TunMstr_AnnoActive_None))
	{
		vStartAnnoSrc(u16AnnoType);
	}// if No other Announcment source is active, place request to ARL directly to turn on Announcment type.
	else if((blTA_Anno == TRUE) && (m_ActiveAnnoSrc != TunMstr_AnnoActive_None))
	{
		vEndAnnoSrc(u16AnnoType ,u8Source, TRUE); // Check for ARL update required
		//vStartAnnoSrc(u16AnnoType);
	}// if Someother Anno type is active, 1st end it active, then start new Anno
	else if (blTA_Anno == FALSE)
	{
		vEndAnnoSrc(u16AnnoType,u8Source, FALSE); // Check for ARL update not required
	}// End PTY31 active Anno
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vCheckForPTY31_Anno-> Not a Valid case"));
	}
}

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::u8ConvertAnnoSrcValues
 *
 *DESCRIPTION: Since in Audio  all Announcment types  are treated as signle aource,
 *DESCRIPTION: this function is used for source value converation which can be sent to Audio
 *
 *PARAMETER:
 *           tU8 u8Source
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tU8 tunmstr_SrcChg_AnnoHandler::u8ConvertAnnoSrcValues(tU8 u8Source)const
{
	tU8 u8ARLAnno_Src = 0xff;
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
	{
		u8ARLAnno_Src = (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_DAB:
	{
		u8ARLAnno_Src = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA;
	}break;
	default:
		break;
	}// end of Switch
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::u8ConvertAnnoSrcValues-> Source =%d  ",
			u8ARLAnno_Src));
	return u8ARLAnno_Src;
}// end of funtcion
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::blCheckPTYAnnoActive
 *
 *DESCRIPTION: This function will check if PTY 31 annoucnemnt type is active source
 *
 *PARAMETER:
 *           tU8 u8Source
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blCheckPTYAnnoActive()const
{
	tBool blPTYActive ;
	if((m_ActiveAnnoSrc == TunMstr_AnnoActive_FMPTY) || (m_ActiveAnnoSrc == TunMstr_AnnoActive_DABPTY))
	{
		blPTYActive = TRUE;
	}
	else
	{
		blPTYActive = FALSE;
	}
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::blCheckPTYAnnoActive-> blPTYActive =%d  ",
			blPTYActive));
	return blPTYActive;
}

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::blCheckTAAnnoActive
 *
 *DESCRIPTION: This function will check if TA annoucnemnt type is active source
 *
 *PARAMETER:
 *           tU8 u8Source
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tBool tunmstr_SrcChg_AnnoHandler::blCheckTAAnnoActive()const
{
	tBool blTAActive ;
	if((m_ActiveAnnoSrc == TunMstr_AnnoActive_FMTA) || (m_ActiveAnnoSrc == TunMstr_AnnoActive_DABTA))
	{
		blTAActive = TRUE;
	}
	else
	{
		blTAActive = FALSE;
	}
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::blCheckTAAnnoActive-> blTAActive =%d  ",
			blTAActive));
	return blTAActive;
}// end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vEndAnnoSrc
 *
 *DESCRIPTION: This function will send request to terminate active annoucnemnt type
 *
 *PARAMETER:
 *           tU16 u16AnnoType ,tU8 u8Source, tBool bCheckARLUpdate
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vEndAnnoSrc(tU16 u16AnnoType ,tU8 u8Source, tBool bCheckARLUpdate)
{
	if((m_potunmstr_DABClient_Handler ==NULL) || (m_potunmstr_TunerClientHandler == NULL) ||(m_potunmstr_SrcChgManager ==NULL) ||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
				(m_potunmstr_MsgToHMI == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vEndAnnoSrc-> Anno_Active =%d, u16AnnoType =%d,u8Source = %d" ,
			m_ActiveAnnoSrc, u16AnnoType , u8Source));

	if((bCheckARLUpdate == TRUE) && (! blCheckARLUpdate_Required(u16AnnoType)))
	{
		//m_potunmstr_SrcChgManager->vHandleAnnoSrc_OFF(u8ConvertCurrentAnnoSource(m_ActiveAnnoSrc));
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::Send anno ON request, AnnoType : %d",u16AnnoType));
		vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoType);
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_ON(u8ConvertCurrentAnnoSource(m_ActiveAnnoSrc));
		//m_ActiveAnnoSrc =TunMstr_AnnoActive_None;
		return;
	}// if already Anno is active, end that Anno 1st
	switch (m_ActiveAnnoSrc)
	{
	case TunMstr_AnnoActive_FMPTY:
	case TunMstr_AnnoActive_FMTA:
	{
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_FM_TA,TUNMSTR_SRCCHG_ACTION_OFF);
		vSend_Src_Chg_Request ((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA, (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vEndAnnoSrc-> FM Anno source OFF request sent to ARL "));
	}break;
	case TunMstr_AnnoActive_DABPTY:
	case TunMstr_AnnoActive_DABTA:
	case TunMstr_AnnoActive_DABTransport:
	case TunMstr_AnnoActive_DABWarning:
	case TunMstr_AnnoActive_DABNews:
	case TunMstr_AnnoActive_DABWeather:
	case TunMstr_AnnoActive_DABEvent:
	case TunMstr_AnnoActive_DABSplEvent:
	case TunMstr_AnnoActive_DABPI:
	case TunMstr_AnnoActive_DABSports:
	case TunMstr_AnnoActive_DABFinance:
	{
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_DAB_TA,TUNMSTR_SRCCHG_ACTION_OFF);
		vSend_Src_Chg_Request ((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA, (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vEndAnnoSrc-> DAB Anno source OFF request sent to ARL "));
	}break;
	default:
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vEndAnnoSrc-> Default case"));
		break;
	}// end of switch
	//m_ActiveAnnoSrc =TunMstr_AnnoActive_None;
}//end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vStartAnnoSrc
 *
 *DESCRIPTION: This function will send request to terminate active annoucnemnt type
 *
 *PARAMETER:
 *           tU8 u8Source
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vStartAnnoSrc(tU16 u16AnnoType)
{
	if((m_potunmstr_SrcChgManager ==NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		return;
	}

	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vStartAnnoSrc-> FM Anno source ON request sent to ARL :::::: Anno_Active =%d AnnoType =%d" , m_blAnno_Active, u16AnnoType));

	/*if((m_ActiveAnnoSrc !=  TunMstr_AnnoActive_None) &&(! blCheckARLUpdate_Required(u16AnnoType , TRUE)))
	{
		tU8 u8ActiveSource = u8ConvertCurrentAnnoSource(u16AnnoType);
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_ON(u8ActiveSource);
		vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoType);
		return;
	}// if already Anno is active, end that Anno 1st*/

	switch (u16AnnoType)
	{
	case TunMstr_AnnoActive_FMPTY:
	case TunMstr_AnnoActive_FMTA:
	{
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_FM_TA,TUNMSTR_SRCCHG_ACTION_ON);
		vSend_Src_Chg_Request ((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA, (tU8)TUNMSTR_SRCCHG_ACTION_ON);
		vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoType);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vStartAnnoSrc-> FM Anno source ON request sent to ARL "));
	}break;
	case TunMstr_AnnoActive_DABPTY:
	case TunMstr_AnnoActive_DABTA:
	case TunMstr_AnnoActive_DABTransport:
	case TunMstr_AnnoActive_DABWarning:
	case TunMstr_AnnoActive_DABNews:
	case TunMstr_AnnoActive_DABWeather:
	case TunMstr_AnnoActive_DABEvent:
	case TunMstr_AnnoActive_DABSplEvent:
	case TunMstr_AnnoActive_DABPI:
	case TunMstr_AnnoActive_DABSports:
	case TunMstr_AnnoActive_DABFinance:
	{
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_DAB_TA,TUNMSTR_SRCCHG_ACTION_ON);
		vSend_Src_Chg_Request ((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA, (tU8)TUNMSTR_SRCCHG_ACTION_ON);
		vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoType);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vStartAnnoSrc-> DAB Anno source ON request sent to ARL "));
	}break;
	default:
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vStartAnnoSrc-> Default case"));
		break;
	}// end of switch

}//end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::blCheckARLUpdate_Required
 *
 *DESCRIPTION: this function will check if we have to send source change update to ARL
 *
 *PARAMETER:
 *           tU8 u8Source
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tBool  tunmstr_SrcChg_AnnoHandler:: blCheckARLUpdate_Required(tU16 u16SourceTA)
{
	if((m_potunmstr_SrcChgManager ==NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		return FALSE;
	}
	tU8 u8Source = m_potunmstr_SrcChgManager->u8GetCurrentTA_Source();
	tU8 u8SourceTA = u8ConvertCurrentAnnoARLSource(u16SourceTA);
	tU8 u8AnnoSource = 0xff;
	tBool blUpdateReq = FALSE;
	if((tU8)TUNMSTR_TUNER_FMANNO_SRC)
	{
		u8AnnoSource = (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
	}// check if annos ource belongs to FM
	else
	{
		u8AnnoSource = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA;
	}// else it eblongs to DAB
	if(u8SourceTA !=  u8AnnoSource)
	{
		blUpdateReq = TRUE;
	}// if active annos ource and requested are different, then update is required to ARL
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vUpdateActiveAnno_Src->blUpdateReq =%d, u8Source =%d, u8AnnoSource =%d", blUpdateReq, u8SourceTA, u8AnnoSource));
	return blUpdateReq;
}


/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vHandleDABTA
 *
 *DESCRIPTION: Helper function to handle DAB TA Announcment
 *
 *PARAMETER:
 *           tU8 u8Source
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandleDABTA(tBool blStatus)
{
	if((m_potunmstr_MsgToHMI ==NULL) || (m_potunmstr_SrcChgManager == NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			)
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA, ASSERT!!!!!!!!!!!!!!!!!"));
		return;
	}
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();
	tU8  u8TunState = m_potunmstr_SrcChgManager->u8GetTunerState();
	ETG_TRACE_USR4(("u8DABState=%d u8TunState=%d m_ActiveAnnoSrc=%d m_blTPState_TUN=%d",u8DABState,u8TunState,m_ActiveAnnoSrc,m_blTPState_TUN));
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA-TUNMSTR_SRCCHG_SOURCE_DAB,inside DAB case u8TA_Anno=%d m_ActiveAnnoSrc=%d",
			blStatus,m_ActiveAnnoSrc));
	if(!((u32GetAnnoButtonState_DAB() & (tU32)TUNMSTR_SRCCHG_STATUS_TUNMSTR_TP_ON) >> 1))
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA-TUNMSTR_SRCCHG_SOURCE_DAB,TA button is disabled"));
		return;
	}// if TA  Annocunemcent is not active in DAB, dont hanlde annoucements
	if (((tU8)TUNMSTR_SRCCHG_BACKGROUND != u8DABState) && (m_ActiveAnnoSrc == TunMstr_AnnoActive_None) &&\
			(blStatus == TRUE) &&(m_potunmstr_SrcChgManager->blGetTestMode_Status()  == FALSE))
	{
		vStartAnnoSrc((tU16)TunMstr_AnnoActive_DABTA);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA-TUNMSTR_SRCCHG_SOURCE_DAB,DAB_TA-ON sent to HMI"));
	}// DAB TA anno has to be put though only if DAB is FG source and its state is DAB pending
	else if(((tU8)TUNMSTR_SRCCHG_BACKGROUND == u8DABState) && ((tU8)TUNMSTR_SRCCHG_BACKGROUND == u8TunState) \
			&& (m_ActiveAnnoSrc == TunMstr_AnnoActive_None) && (m_blTPState_TUN == FALSE))
	{
		vStartAnnoSrc((tU16)TunMstr_AnnoActive_DABTA);
		//m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(TUNMSTR_SRCCHG_SOURCE_DAB_TA,TUNMSTR_SRCCHG_ACTION_ON);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA-TUNMSTR_SRCCHG_SOURCE_DAB,DAB_TA-ON sent to HMI, as FM in BG no TA from FM"));
		// DAB and Tuner in BG, and FM not tuned to TP station
	}
	else if (blStatus == FALSE)
	{
		vEndAnnoSrc(TunMstr_AnnoActive_DABTA ,(tU8)TUNMSTR_SRCCHG_SOURCE_DAB, FALSE);
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA-TUNMSTR_SRCCHG_SOURCE_DAB,DAB_TA-OFF sent to HMI"));
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleDABTA-TUNMSTR_SRCCHG_SOURCE_DAB,Unknown case"));
	}
}

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vHandleDABTA
 *
 *DESCRIPTION: Helper function to handle DAB TA Announcment
 *
 *PARAMETER:
 *           tU16 u16AnnoType
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tU8 tunmstr_SrcChg_AnnoHandler::u8GetTunmst_AnnoTypes(tU16 u16AnnoType)const
{
	tU8 AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_INVALID;
	// to make lint happy
	switch (u16AnnoType)
	{
	case TunMstr_AnnoActive_FMPTY:
	case TunMstr_AnnoActive_DABPTY:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPES_PTY31;
	}
	break;
	case TunMstr_AnnoActive_FMTA:
	case TunMstr_AnnoActive_DABTA:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_TA;
	}
	break;
	case TunMstr_AnnoActive_DABWarning:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_WARNING;
	}
	break;
	case TunMstr_AnnoActive_DABNews:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_NEWS;
	}
	break;
	case TunMstr_AnnoActive_DABWeather:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_WEATHER;
	}
	break;
	case TunMstr_AnnoActive_DABEvent:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_EVENT;
	}
	break;
	case TunMstr_AnnoActive_DABSplEvent:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_SPECIALEVENT;
	}
	break;
	case TunMstr_AnnoActive_DABPI:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_PROGRAMME;
	}
	break;
	case TunMstr_AnnoActive_DABSports:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_SPORT;
	}
	break;
	case TunMstr_AnnoActive_DABFinance:
	{
		AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_FINANCE;
	}
	break;

	default:
		break;
	}

	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::u8GetTunmst_AnnoTypes-> AnnoType=%d" , AnnoType));
	return AnnoType;
}//end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vSend_Src_Chg_Request
 *
 *DESCRIPTION: Helper function to handle Source Change Request
 *
 *PARAMETER:
 *           tU8 u8Source, tU8 u8Action
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSend_Src_Chg_Request(tU8 u8Source, tU8 u8Action)
{
	if((m_potunmstr_MsgToHMI ==NULL) || (m_poclConfigInterface == NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			)
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vSend_Src_Chg_Request, ASSERT!!!!!!!!!!!!!!!!!"));
		return;
	}
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vSend_Src_Chg_Request()"));
	tU8 u8AnnouncementRequestHandling = (tU8)m_poclConfigInterface->u32GetConfigData("AnnouncementRequestHandling");

	if(u8AnnouncementRequestHandling == TUNMSTR_ANNO_HANDLING_ARL)
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vSend_Src_Chg_Request(),send request to ARL"));
		//vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoType);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request(u8Source,u8Action);
#endif
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vSend_Src_Chg_Request(),send request to HMI"));
		vUpdateAnnoSrcChgRequest(u8Source,u8Action);
		m_potunmstr_MsgToHMI->vSend_g_SourceChange(u8Source,u8Action);
	}
}//end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChg_AnnoHandler::vSetActiveAnnoSrc
 *
 *DESCRIPTION: Set function to Update the Active Anno Src
 *
 *PARAMETER:
 *           tU8 u8ActiveAnnoSrc
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSetActiveAnnoSrc(enActiveAnnoSource u16ActiveAnnoSrc)
{
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vSetActiveAnnoSrc() : %d",u16ActiveAnnoSrc));

	m_ActiveAnnoSrc = u16ActiveAnnoSrc;
}//end of function


tU8 tunmstr_SrcChg_AnnoHandler::u8ConvertCurrentAnnoSource(tU16 u16AnnoType)
{
	tU8 u8AnnoSrc = 0xFF;
	switch (u16AnnoType)
	{
		case TunMstr_AnnoActive_FMPTY:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_FMPTY31;
		}
		break;
		case TunMstr_AnnoActive_FMTA:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_FM_TA;
		}
		break;
		case TunMstr_AnnoActive_DABPTY:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_DABPTY31;
		}
		break;
		case TunMstr_AnnoActive_DABTA:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_DAB_TA;
		}
		break;
		case TunMstr_AnnoActive_DABTransport:
		case TunMstr_AnnoActive_DABWarning:
		case TunMstr_AnnoActive_DABNews:
		case TunMstr_AnnoActive_DABWeather:
		case TunMstr_AnnoActive_DABEvent:
		case TunMstr_AnnoActive_DABSplEvent:
		case TunMstr_AnnoActive_DABPI:
		case TunMstr_AnnoActive_DABSports:
		case TunMstr_AnnoActive_DABFinance:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_DABOTHER;
		}
		break;
		default:
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::u8ConvertCurrentAnnoSource, inside default case"));
			break;
	}
	return u8AnnoSrc;
}


tU8 tunmstr_SrcChg_AnnoHandler::u8ConvertCurrentAnnoARLSource(tU16 u16AnnoType)
{
	tU8 u8AnnoSrc = 0xFF;
	switch (u16AnnoType)
	{
		case TunMstr_AnnoActive_FMPTY:
		case TunMstr_AnnoActive_FMTA:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_FM_TA;
		}
		break;
		case TunMstr_AnnoActive_DABPTY:
		case TunMstr_AnnoActive_DABTA:
		case TunMstr_AnnoActive_DABTransport:
		case TunMstr_AnnoActive_DABWarning:
		case TunMstr_AnnoActive_DABNews:
		case TunMstr_AnnoActive_DABWeather:
		case TunMstr_AnnoActive_DABEvent:
		case TunMstr_AnnoActive_DABSplEvent:
		case TunMstr_AnnoActive_DABPI:
		case TunMstr_AnnoActive_DABSports:
		case TunMstr_AnnoActive_DABFinance:
		{
			u8AnnoSrc = TUNMSTR_SRCCHG_SOURCE_DAB_TA;
		}
		break;
		default:
			ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::u8ConvertCurrentAnnoARLSource, inside default case"));
			break;
	}
	return u8AnnoSrc;
}


/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChg_AnnoHandler::vUpdateAnnoSrcChgRequest()
 *
 *  DESCRIPTION: Helper function to update anno src chg request
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vUpdateAnnoSrcChgRequest(tU8 u8Source , tU8 u8AnnoState)
{
	m_AnnoSrcChgRequest.u8AnnoState = u8AnnoState;
	m_AnnoSrcChgRequest.u8Source = u8Source;
	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vUpdateAnnoSrcChgRequest()-> AnnoState :%d, \
			u8Source : %d", m_AnnoSrcChgRequest.u8AnnoState,m_AnnoSrcChgRequest.u8Source));
}

/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChg_AnnoHandler::vHandleAnnoSwitchState()
 *
 *  DESCRIPTION: function to update Anno Switch Status
 *
 *  PARAMETER:   tBool bTAState , tBool bPTYState
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vHandleAnnoSwitchState(tBool bTAState , tBool bPTYState, tBool bWeatherAlertState)
{

	if(m_potunmstr_MsgToHMI == NULL)
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgToHMI != NULL );

		ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoSwitchState-> ASSERT!!!!!!!!!!!!!!!!!"));
		return;
	}

	ETG_TRACE_USR4(("tunmstr_SrcChg_AnnoHandler::vHandleAnnoSwitchState()-> bTAState :%d, bPTYState: %d bWeatherAlertState: %d",
			bTAState, bPTYState, bWeatherAlertState));
	midw_fi_tcl_b32_AnnoType annoType;
	annoType.u32Value = 0;
	if(bPTYState == true)
	{
	   annoType.vSetTUNMSTR_ANNOTYPE_PTY(true);
	}
	if(bTAState == true)
	{
	   annoType.vSetTUNMSTR_ANNOTYPE_TA(true);
	}
	tU8 u8Source = TUNMSTR_SRCCHG_SOURCE_TUN1FM;
	m_potunmstr_MsgToHMI->vSend_g_AnnoButton_Status(u8Source, (tU32)annoType.u32Value);
   if(bWeatherAlertState == true)
   {
      annoType.vSetTUNMSTR_ANNOTYPE_WEATHERALERT(true);
   }
	if(bWeatherAlertState)
	{
		m_potunmstr_MsgToHMI->vSend_g_AnnoButton_Status(midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_WEATHER_ALERT, (tU32)annoType.u32Value);
	} 

}


/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChg_AnnoHandler::vSetAnnoButtonState_FM()
 *
 *  DESCRIPTION: function to update Anno Switch Status FM
 *
 *  PARAMETER: tU32 u32FMAnnoState
 *
 *
 *  RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSetAnnoButtonState_FM(tU32 u32FMAnnoState)
{
	m_u32AnnoButtonState_FM = u32FMAnnoState;
}


/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChg_AnnoHandler::u32GetAnnoButtonState_FM()
 *
 *  DESCRIPTION: function to return Anno Switch Status FM
 *
 *  PARAMETER: None
 *
 *
 *  RETURNVALUE: tU32
 *
 *************************************************************************/
tU32 tunmstr_SrcChg_AnnoHandler::u32GetAnnoButtonState_FM() const
{
	return m_u32AnnoButtonState_FM;
}

/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChg_AnnoHandler::vSetButtonState_DAB()
 *
 *  DESCRIPTION: function to update Anno Switch Status DAB
 *
 *  PARAMETER: tU32 u32FMAnnoState
 *
 *
 *  RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmstr_SrcChg_AnnoHandler::vSetButtonState_DAB(tU32 u32DABAnnoState)
{
	m_u32AnnoButtonState_DAB = u32DABAnnoState;
}


/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChg_AnnoHandler::u32GetAnnoButtonState_DAB()
 *
 *  DESCRIPTION: function to return Anno Switch Status DAB
 *
 *  PARAMETER: None
 *
 *
 *  RETURNVALUE: tU32
 *
 *************************************************************************/
tU32 tunmstr_SrcChg_AnnoHandler::u32GetAnnoButtonState_DAB() const
{
	return m_u32AnnoButtonState_DAB;
}

