/************************************************************************
 * FILE:           tunmstr_Preset_Handler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    Class to handle Preset feature
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date			 | Author										| Modification
 * 01-05-2013	 | RBEI/ECV3 Priya Prabhuswamy(rrb1kor)			| initial version
 *************************************************************************/

#include "fc_tunermaster_featureControl.h"

#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#ifndef tunmstr_SrcChgManager_H
#include "tunmstr_SrcChgManager.h"
#endif
#ifndef TUNMSTR_SRCCHG_SRCCHG_DEFINES_H
#include "tunmstr_SrcChg_Defines.h"
#endif
#ifndef TUNMSTR_TUNERCLIENTHANDLER_H
#include "tunmstr_TunerClientHandler.h"
#endif
#ifndef TUNMSTR_MUTEHANDLER_H_
#include "tunmstr_MuteHandler.h"
#endif
#ifndef tunmaster_Config_H
#include "tunermaster_Config.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#ifndef GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif
#endif
#ifndef TUNMSTR_SRCCHG_TRACE_H
#include "tunmstr_SrcChg_Trace.h"
#endif

#include "kdsconfig/clConfigInterface.h"

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
#include "tunermaster_SXMClient.h"
#include "tunermaster_SXMchannelartClient.h"
#endif

//Include for ETG trace
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_Preset_Handler.cpp.trc.h"
#endif

//Macro to check the Mixed Preset List
//#define TUNMSTR_IsMixedPresetList(u8List)((u8List==midw_fi_tcl_e8_List::FI_EN_BANK_MIX1) ||(u8List==midw_fi_tcl_e8_List::FI_EN_BANK_MIX2)||(u8List==midw_fi_tcl_e8_List::FI_EN_BANK_MIX3)||(u8List==midw_fi_tcl_e8_List::FI_EN_BANK_MIX_AST))
midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatusMixed;

#define DRM_MODULATION_TYPE 2

/*************************************************************************
 * FUNCTION:     tunmstr_Preset_Handler
 *
 * DESCRIPTION:  Initialize all the member variable to default values
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunmstr_Preset_Handler::tunmstr_Preset_Handler(tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl)
#else
tunmstr_Preset_Handler::tunmstr_Preset_Handler()
#endif
{
	ETG_TRACE_USR4(("tunmstr_Preset_Handler()"));
	m_potunmstr_SrcChgManager=NULL;
	m_potunmstr_MsgFromHMI=NULL;
	m_potunmaster_Config=NULL;
	m_potunmstr_AudioClientHandler=NULL;
	m_potunmstr_TunerClientHandler=NULL;
	m_potunmstr_DABClient_Handler=NULL;
	m_potunmstr_MsgToHMI=NULL;
	m_potunmstr_MuteHandler = NULL;
	m_poclConfigInterface = NULL;
#ifdef INCLUDE_PROFILE_MANAGER
	m_poPMClient = NULL;
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_potunermaster_SXMClient = nullptr;
	m_potunermaster_SXMchannelartClient = NULL;
	m_u16ChannelArtCmdCounter = TUNMSTR_SRCCHG_INVALID;
	m_u16ChannelArtRegID = AMT_C_U16_REGID_INVALID;
	m_u16ChannelArtSourceAppID = TUNMSTR_SRCCHG_INVALID;
#endif

	m_poStoreRequest.blReguestPending=FALSE;
	m_poStoreRequest.eBand.enType=(midw_fi_tcl_e8_Band::tenType)TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.eList.enType=(midw_fi_tcl_e8_List::tenType)TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.u8Element_ID=TUNMSTR_SRCCHG_INVALID;
	m_poPresetHandling.u8Band = 0xFF;
	m_poPresetHandling.u8Element_ID = 0xFF;
	m_poPresetHandling.u8List = 0xFF;
	m_poPresetHandling.u8PresetAction = 0xFF;
	m_poPresetHandling.u32Frequency = 0;
	m_poPresetHandling.u32PI = 0;
	m_poPresetHandling.u16SecondaryPI = 0;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	m_poPresetHandling.sKey = NULL;
	m_poPresetHandling.u8PresetType = 0;	
#endif
	m_ePresetReguest=None;
	m_u16CmdCounter=TUNMSTR_SRCCHG_INVALID;
	m_u16RegID=AMT_C_U16_REGID_INVALID;
	m_u16SourceAppID=TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentBand=TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentStoredBand=TUNMSTR_SRCCHG_INVALID;
	m_PresetSaveElemementID = 0;
	bStartUpFlag=FALSE;
	m_u8StartUp_HMI_Update = 0;
	m_u8TunerStartUp_HMI_Update=0xFF;
	m_u8SXMStartUp_HMI_Update=0xFF;
	m_u8ElemID_Delete = 0x00;
#ifdef INCLUDE_PROFILE_MANAGER
	m_bProfile_PresetOperation = false;
#endif

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlImpl = poArlImpl;
#endif
	//bHMI_Update_Flag=FALSE;

};

/*************************************************************************
 * FUNCTION:     ~tunmstr_Preset_Handler
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tunmstr_Preset_Handler::~tunmstr_Preset_Handler()
{
	m_potunmstr_SrcChgManager=NULL;
	m_potunmstr_MsgFromHMI=NULL;
	m_potunmaster_Config=NULL;
	m_potunmstr_AudioClientHandler=NULL;
	m_potunmstr_TunerClientHandler=NULL;
	m_potunmstr_DABClient_Handler=NULL;
	m_potunmstr_MsgToHMI=NULL;
	m_potunmstr_MuteHandler = NULL;
	m_poclConfigInterface = NULL;
	m_poStoreRequest.blReguestPending=FALSE;
	m_poStoreRequest.eBand.enType=(midw_fi_tcl_e8_Band::tenType)TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.eList.enType=(midw_fi_tcl_e8_List::tenType)TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.u8Element_ID=TUNMSTR_SRCCHG_INVALID;
	m_poPresetHandling.u8Band = 0xFF;
	m_poPresetHandling.u8Element_ID = 0xFF;
	m_poPresetHandling.u8List = 0xFF;
	m_poPresetHandling.u8PresetAction = 0xFF;
	m_poPresetHandling.u32Frequency = 0;
	m_poPresetHandling.u32PI = 0;
	m_poPresetHandling.u16SecondaryPI = 0;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	m_poPresetHandling.sKey = NULL;
	m_poPresetHandling.u8PresetType = 0;	
#endif
	m_ePresetReguest=None;
	m_u16CmdCounter=TUNMSTR_SRCCHG_INVALID;
	m_u16RegID=AMT_C_U16_REGID_INVALID;
	m_u16SourceAppID=TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentBand=TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentStoredBand=TUNMSTR_SRCCHG_INVALID;
	bStartUpFlag=FALSE;
	m_u8StartUp_HMI_Update = 0;
	m_u8TunerStartUp_HMI_Update=0xFF;
	m_u8SXMStartUp_HMI_Update=0xFF;
	m_u8ElemID_Delete = 0x00;
#ifdef INCLUDE_PROFILE_MANAGER
	m_bProfile_PresetOperation = false;
	m_poPMClient = NULL;
#endif


#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_potunermaster_SXMClient = nullptr;
	m_potunermaster_SXMchannelartClient = NULL;
	m_u16ChannelArtCmdCounter = TUNMSTR_SRCCHG_INVALID;
	m_u16ChannelArtRegID = AMT_C_U16_REGID_INVALID;
	m_u16ChannelArtSourceAppID = TUNMSTR_SRCCHG_INVALID;
#endif


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlImpl = 0x00;
#endif

	//bHMI_Update_Flag=FALSE;
	oStatusMixed.ListOfStations.clear();
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_SrcChgManager_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_SrcChgManager pointer member variable m_potunmstr_SrcChgManager 
 *
 * PARAMETER:    tunmstr_SrcChgManager* potunmstr_SrcChgManager
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = ( tunmstr_SrcChgManager* )potunmstr_SrcChgManager;
	}
	else
	{
		m_potunmstr_SrcChgManager = NULL;
		NORMAL_M_ASSERT ( potunmstr_SrcChgManager != NULL );

	}
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_MsgFromHMI_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_MsgFromHMI pointer member variable m_potunmstr_MsgFromHMI 
 *
 * PARAMETER:    tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI = ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}
	else
	{
		m_potunmstr_MsgFromHMI = NULL;
		NORMAL_M_ASSERT ( potunmstr_MsgFromHMI != NULL );

	}
}
/*************************************************************************
 * FUNCTION:     vSet_tunmaster_Config_Ptr
 *
 * DESCRIPTION:  Update the tunmaster_Config pointer member variable m_potunmaster_Config
 *
 * PARAMETER:    tunmaster_Config* potunmaster_Config
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config = ( tunmaster_Config* )potunmaster_Config;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmaster_Config != NULL );
	}
}
/*************************************************************************
 * FUNCTION:     vSet_tunmstr_AudioClientHandler_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_AudioClientHandler pointer member variable m_potunmstr_AudioClientHandler
 *
 * PARAMETER:    tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = ( tunmstr_AudioClientHandler* )potunmstr_AudioClientHandler;
	}
	else
	{
		m_potunmstr_AudioClientHandler = NULL;
		NORMAL_M_ASSERT ( potunmstr_AudioClientHandler != NULL );

	}
}
/*************************************************************************
 * FUNCTION:     vSet_tunmstr_TunerClientHandler_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_TunerClientHandler pointer member variable m_potunmstr_TunerClientHandler
 *
 * PARAMETER:    tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler = ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT( potunmstr_TunerClientHandler != NULL );
	}
}
/*************************************************************************
 * FUNCTION:     vSet_tunmstr_DABClient_Handler_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_DABClient_Handler pointer member variable m_potunmstr_DABClient_Handler
 *
 * PARAMETER:    tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}
	else
	{
		m_potunmstr_DABClient_Handler = NULL ;
		NORMAL_M_ASSERT( potunmstr_DABClient_Handler != NULL );

	}
}
/*************************************************************************
 * FUNCTION:     vSet_tunmstr_MsgToHMI_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_MsgToHMI pointer member variable m_potunmstr_MsgToHMI
 *
 * PARAMETER:    tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = ( tunmstr_MsgToHMI* )potunmstr_MsgToHMI;
	}
	else
	{
		m_potunmstr_MsgToHMI = NULL ;
		NORMAL_M_ASSERT( potunmstr_MsgToHMI != NULL );

	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MuteHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_MuteHandler
 *
 * PARAMETER:   tunmstr_MuteHandler* potunmstr_MuteHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler)

{
	if( potunmstr_MuteHandler != NULL )
	{
		m_potunmstr_MuteHandler = ( tunmstr_MuteHandler* )potunmstr_MuteHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MuteHandler != NULL );

	}
}

/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}
	else
	{
		m_poclConfigInterface = NULL;
		NORMAL_M_ASSERT( poclConfigInterface != NULL );

	}

}

#ifdef INCLUDE_PROFILE_MANAGER
/*************************************************************************
* FUNCTION:    vSet_tunmstr_PMClient_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   (tunermaster_PMClient* poPMClientPtr)
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_PMClient_Ptr(tunermaster_PMClient* poPMClientPtr)
{
	if( poPMClientPtr != NULL )
	{
		m_poPMClient = poPMClientPtr;
	}
	else
	{
		NORMAL_M_ASSERT( poPMClientPtr != NULL );
	}

}
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
* FUNCTION:    vSet_tunmstr_SXMClient_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   tunermaster_SXMClient* potunermaster_SXMClient
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_SXMClient_Ptr(tunermaster_SXMClient* potunermaster_SXMClient)
{
	if( potunermaster_SXMClient != NULL )
	{
		m_potunermaster_SXMClient = potunermaster_SXMClient;
	}
	else
	{
		ETG_TRACE_USR4(("potunermaster_SXMClient Error NULL"));
	}

}

/*************************************************************************
* FUNCTION:    vSet_tunmstr_SXMChannelArtClient_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   tunermaster_SXMchannelartClient* potunermaster_SXMClient
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_Preset_Handler::vSet_tunmstr_SXMChannelArtClient_Ptr(tunermaster_SXMchannelartClient* potunermaster_SXMchannelartClient)
{
	if( potunermaster_SXMchannelartClient != NULL )
	{
		m_potunermaster_SXMchannelartClient = potunermaster_SXMchannelartClient;
	}
	else
	{
		ETG_TRACE_USR4(("potunermaster_SXMClient Error NULL"));
	}

}
#endif


/*************************************************************************
 * FUNCTION:     vHandlePresetConfig()
 *
 * DESCRIPTION:  Handler function to Handle Preset Configuration Read from KDS
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandlePresetConfig()const
{
	ETG_TRACE_USR4(("entered into vHandlePresetConfig()"));
	//if(supportsmixedpreset)
	{
	}
}
/*************************************************************************
 * FUNCTION:    u8ConvFiBandtoTunmstrBand
 *
 * DESCRIPTION: Converters midw_fi_tcl_e8_Band band type to Tuner-master Band Type
 *
 * PARAMETER:    midw_fi_tcl_e8_Band eBand
 *
 * RETURNVALUE:  tU8 u8Band
 *
 *************************************************************************/
tU8 tunmstr_Preset_Handler::u8ConvFiBandtoTunmstrBand(tU8 u8RequestBand,tU8 u8RequestedList)const
{
	tU8 u8RetBand=TUNMSTR_SRCCHG_INVALID;
	switch(u8RequestBand)
	{
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
		{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			u8RetBand=(tU8)tuner::common::BANDFM;
#else
			u8RetBand=(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM;
#endif

			break;
		}
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
		{
			if((midw_fi_tcl_e8_List::FI_EN_BANK_DRM1==u8RequestedList)||(midw_fi_tcl_e8_List::FI_EN_BANK_DRM_AST==u8RequestedList))
			{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				u8RetBand=(tU8)tuner::common::BANDCB1;
#else
				u8RetBand=(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM;
#endif

			}
			else
			{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
				u8RetBand=(tU8)tuner::common::BANDCB1;
#else
				u8RetBand =(tU8) tuner::common::BANDMW;
#endif
				u8RetBand=(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM;
#endif

			}
			break;
		}
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1:
      {
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
            u8RetBand=(tU8)tuner::common::BANDCB1;
#else
            u8RetBand=(tU8)TUNMSTR_SRCCHG_SOURCE_DRM;
#endif
      }
		break;
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB:
		{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			u8RetBand=(tU8)tuner::common::BANDDAB;
#else
			u8RetBand=(tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
#endif

			break;
		}
		default:
		{
			break;
		}
	}
	ETG_TRACE_USR4(("u8ConvFiBandtoTunmstrBand()->u8RetBand=%d",u8RetBand));
	return u8RetBand;
}
/*************************************************************************
 * FUNCTION:      vHandlePreset
 *
 * DESCRIPTION:   Handler function for Method TUNMSTR_S_PRESET_HANDLING
 *
 * PARAMETER:     amt_tclServiceData* poMessage
 *
 * RETURNVALUE:   void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandlePreset(amt_tclServiceData* poMessage)
{
	if(m_potunmstr_MsgFromHMI==NULL)
	{
	     NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		return;
	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart oMsgData;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMsgData);
	m_u16SourceAppID=poMessage->u16GetSourceAppID();
	m_u16CmdCounter=poMessage->u16GetCmdCounter();
	m_u16RegID=poMessage->u16GetRegisterID();
	stPresetHandlingParam oPresetHandlingParam;
	oPresetHandlingParam.u8PresetAction=(tU8)oMsgData.Preset_Action.enType;
	oPresetHandlingParam.u8Band=(tU8)oMsgData.Band.enType;
	oPresetHandlingParam.u8List=(tU8)oMsgData.List.enType;
	oPresetHandlingParam.u8Element_ID=(tU8)oMsgData.u8Element_ID;
	oPresetHandlingParam.u32Frequency = (tU32)oMsgData.Frequency;
	oPresetHandlingParam.u32PI = (tU32)oMsgData.PI;
	oPresetHandlingParam.u16SecondaryPI = (tU16)oMsgData.SecondaryPI;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	oPresetHandlingParam.sKey = oMsgData.Key;
	oPresetHandlingParam.u8PresetType = (tU8)oMsgData.PresetType.enType;
#endif
	ETG_TRACE_USR4(("PresetList::Request-->PresetAction=%d",
	(tU8)oPresetHandlingParam.u8PresetAction));
	ETG_TRACE_USR4(("PresetList::Request-->Band=%d",oPresetHandlingParam.u8Band));
	ETG_TRACE_USR4(("PresetList::Request-->List=%d",oPresetHandlingParam.u8List));
	ETG_TRACE_USR4(("PresetList::Request-->Frequency=%d",oPresetHandlingParam.u32Frequency));
	ETG_TRACE_USR4(("PresetList::Request-->PI=%d",oPresetHandlingParam.u32PI));
	ETG_TRACE_USR4(("PresetList::Request-->SecondaryPI=%d",oPresetHandlingParam.u16SecondaryPI));

	if (oPresetHandlingParam.u8List == (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_MIX1)
	{
		if (oPresetHandlingParam.u8PresetAction != (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL)
		{
			//Conv_Mix_To_BandType(&oPresetHandlingParam);
			if( (oMsgData.Preset_Action.enType == midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETUP) ||
					(oMsgData.Preset_Action.enType == midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDOWN))
			{
				 vHandleSkipPreset((tU8)oMsgData.Preset_Action.enType);
				 return;
			}
		}
		else
		{
			ETG_TRACE_USR4(("PresetList::Request-->MixedPresetList DeleteAllPreset"));

			if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
			{
				Inc_m_u8TunerStartUp_HMI_Update();
				vHandleTunerNormalPresetDeleteAll(oPresetHandlingParam);
#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
				Inc_m_u8SXMStartUp_HMI_Update();
				vHandleSXMNormalPresetDeleteAll(oPresetHandlingParam);
#endif
			}
			else
			{
				Inc_m_u8StartUp_HMI_Update();
				vHandleTunerNormalPresetDeleteAll(oPresetHandlingParam);
				Inc_m_u8StartUp_HMI_Update();
				vHandleDABNormalPresetDeleteAll(oPresetHandlingParam);
			}
			return;
		}
	}

	switch(oPresetHandlingParam.u8Band)
	{
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1:
	{
		if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL)
		{
			vHandleTunerNormalPresetRecall(oPresetHandlingParam);
		}
		else if ((oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE)
				|| (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_SPECIALPRESETSAVE))
		{
			vHandleTunerNormalPresetSave(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE)
		{
			vHandleTunerNormalPresetDelete(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL)
		{
			vHandleTunerNormalPresetDeleteAll(oPresetHandlingParam);
		}
		break;
	}

	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB:
	{
		if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL)
		{
			vHandleDABNormalPresetRecall(oPresetHandlingParam);
		}
		else if ((oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE)
					|| ((oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_SPECIALPRESETSAVE)))
		{
			vHandleDABNormalPresetSave(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE)
		{
			vHandleDABNormalPresetDelete(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL)
		{
			vHandleDABNormalPresetDeleteAll(oPresetHandlingParam);
		}
		break;
	}

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_SXM:
	{
		if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL)
		{
			vHandleSXMNormalPresetRecall(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE)
		{
			vHandleSXMNormalPresetSave(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE)
		{
			vHandleSXMNormalPresetDelete(oPresetHandlingParam);
		}
		else if (oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL)
		{
			vHandleSXMNormalPresetDeleteAll(oPresetHandlingParam);
		}
		else if(oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_GETPRESETLIST)
		{
			vSendSXMGetPresetList();
		}
		break;
	}
#endif

	default:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
		tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_ERROR;
		vSendMsg(u8OpCode,oMethodResult);
		break;
	}
	}
}


/*************************************************************************
 * FUNCTION:     vHandleSkipPreset
 *
 * DESCRIPTION:  Function to handle next/prev preset requests
 *
 * PARAMETER:    tU8 u8PresetDirection
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleSkipPreset(tU8 u8PresetDirection)
{
	if(m_potunmstr_MsgToHMI==NULL)
	{
	     NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}

	tU8 u8ActivePreset = m_potunmstr_MsgToHMI->u8GetActivePreset();
	tBool bEmptyList = TRUE;
	ETG_TRACE_USR4(("vHandleSkipPreset(), Active PresetAutoCompare : %d", u8ActivePreset));


	if(u8ActivePreset > oStatusMixed.ListOfStations.size())
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
		oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
		oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
		oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
		tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		vSendMsg( u8OpCode,oMethodResult);
		return;
	}

	for(auto it:oStatusMixed.ListOfStations)
	{
		if(it.Band.enType != midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE)
		{
			bEmptyList = FALSE;
			break;
		}
	}

	if(!bEmptyList) // not an empty list
	{
		tBool bCheckPresetList = TRUE;
		tU8 u8Index = 0xFF;

		if((u8ActivePreset == 0xFF) || (u8ActivePreset == 0))
			u8Index = 0;
		else
			u8Index = u8ActivePreset;

		if(u8PresetDirection == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETUP)
		{
			for(; bCheckPresetList == TRUE; u8Index++)
			{
				if(u8Index == oStatusMixed.ListOfStations.size())
					u8Index = 0;

				vRecallAvailablePreset(u8Index , bCheckPresetList);
			}
		}
		else
		{
			if(u8Index >= 0x02)
				u8Index = (tU8)(u8Index-0x02);
			else
				u8Index = (tU8)(oStatusMixed.ListOfStations.size() - 1);

			for(; bCheckPresetList == TRUE; u8Index--)
			{
				vRecallAvailablePreset(u8Index , bCheckPresetList);

				if(u8Index == 0)
					u8Index = (tU8)oStatusMixed.ListOfStations.size();
			}
		}
	}
	else
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
		oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
		oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
		oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
		tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		vSendMsg( u8OpCode,oMethodResult);
	}
}

/*************************************************************************
 * FUNCTION:     vRecallAvailablePreset
 *
 * DESCRIPTION:  Function to recall next/prev preset
 *
 * PARAMETER:    tU8 u8Index , tBool &bCheckPresetList
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vRecallAvailablePreset(tU8 u8Index , tBool &bCheckPresetList)
{

	switch((tU8)oStatusMixed.ListOfStations.at(u8Index).Band.enType)
	{
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1:
		{
			stPresetHandlingParam oPresetHandlingParam;
			oPresetHandlingParam.u8Band = (tU8)oStatusMixed.ListOfStations.at(u8Index).Band.enType;
			oPresetHandlingParam.u8Element_ID = (tU8)(u8Index+1);
			oPresetHandlingParam.u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
			vHandleTunerNormalPresetRecall(oPresetHandlingParam);
			bCheckPresetList = FALSE;
			break;
		}

		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB:
		{
			stPresetHandlingParam oPresetHandlingParam;
			oPresetHandlingParam.u8Band = (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
			oPresetHandlingParam.u8Element_ID = (tU8)(u8Index+1);
			oPresetHandlingParam.u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
			vHandleDABNormalPresetRecall(oPresetHandlingParam);
			bCheckPresetList = FALSE;
			break;
		}
#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_SXM:
		{
			stPresetHandlingParam oPresetHandlingParam;
			oPresetHandlingParam.u8Band = (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_SXM;
			oPresetHandlingParam.u8Element_ID = (tU8)(u8Index+1);
			oPresetHandlingParam.u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
			vHandleSXMNormalPresetRecall(oPresetHandlingParam);
			bCheckPresetList = FALSE;
			break;
		}
#endif
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE:
		{
			bCheckPresetList = TRUE;
			break;
		}
		default:
			bCheckPresetList = FALSE;
			break;
	}
}


/*************************************************************************
 * FUNCTION:     vHandleTunerNormalPresetRecall
 *
 * DESCRIPTION:  Function to handle the AM/FM tuner Normal Preset recall request
 *
 * PARAMETER:    stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleTunerNormalPresetRecall( stPresetHandlingParam oPresetHandlingParam)
{

	if((m_potunmstr_SrcChgManager==NULL)||(m_potunmstr_TunerClientHandler==NULL) || (NULL == m_poclConfigInterface))
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tU8 u8TunState= clSessionControl::getInstance()->getActiveTunerState(tuner::common::AMFMTUNER);
	tU8 u8ActiveTunerBand = clSessionControl::getInstance()->getActiveTunerBand();
	ETG_TRACE_USR4(("PresetList::Request->PresetRecall Tuner Band = %d",u8ActiveTunerBand));
#else
	tU8 u8TunState=m_potunmstr_SrcChgManager->u8GetTunerState();
	m_u8CurrentBand = m_potunmstr_SrcChgManager->u8ConvertSrcToBand(m_potunmstr_SrcChgManager->u8GetCurrentSource());
#endif

	ETG_TRACE_USR4(("PresetList::Request->PresetRecall Tuner State=%d",u8TunState));
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;

	tU8 u8Band =u8ConvFiBandtoTunmstrBand((tU8)(midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band,oPresetHandlingParam.u8List);
	ETG_TRACE_USR4(("PresetList::Request->PresetRecall CurrentBand=%d",m_u8CurrentBand));
	ETG_TRACE_USR4(("PresetList::Request->PresetRecall Band=%d",u8Band));

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");

	if( blIsmixedPreset==TRUE && oPresetHandlingParam.u8Element_ID > 0)
	{ 	 /*Condition added to resolve issue NCG3D-64461*/
		 /* Tuner middleware responds with negative response if empty preset is recalled  */

		if(oStatusMixed.ListOfStations.at(oPresetHandlingParam.u8Element_ID - 1).Frequency == (tU32)0)
		{
				oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
				tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
				vSendMsg( u8OpCode,oMethodResult);
				ETG_TRACE_USR4(("PresetList::Request->PresetRecall error u32Frequency = %d ",oPresetHandlingParam.u32Frequency ));
				return;
		}
		 /*Condition added to resolve issue NCG3D-64461*/
	}

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(((u8TunState != (tU8)tuner::common::TUNERTOFG) && (u8TunState != (tU8)tuner::common::TAFG)) || ((u8Band != u8ActiveTunerBand) && (((tuner::common::enBand)u8Band != tuner::common::BANDMW) || (u8ActiveTunerBand != (tU8)tuner::common::BANDCB1))))
#else
	if((u8TunState!=(tU8)TUNMSTR_SRCCHG_FOREGROUND || m_u8CurrentBand != u8Band))
#endif
	{

		if(blIsmixedPreset==TRUE)
		{
			//Pack the data required for sending play for requested band to HMI
			ETG_TRACE_USR4(("PresetList::Request->PresetRecall Store the Preset recall request, send play request to HMI"));
			tU8 enBand = u8Band;
			oMethodResult.Source.enType=(midw_fi_tcl_e8_Source::tenType)enBand;
			oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_PLAY;
			//Store the Preset recall request
			/*m_poStoreRequest.blReguestPending=TRUE;
			m_poStoreRequest.eBand.enType=(midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
			m_poStoreRequest.eList.enType=(midw_fi_tcl_e8_List::tenType)oPresetHandlingParam.u8List;
			m_poStoreRequest.u8Element_ID=oPresetHandlingParam.u8Element_ID;
			m_poStoreRequest.ePresetAction.enType=midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT;*/

			midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart oMethodStart;
			oMethodStart.Option.enType = midw_fi_tcl_e8_StationSelectionOption::FI_EN_PRESET_INPUT;
			oMethodStart.u8Element_ID = oPresetHandlingParam.u8Element_ID;
			oMethodStart.e8ListID.enType = midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;
			m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
					oMethodStart,           // parameter&
					MIDW_TUNERFI_C_U16_FID_TUN_S_CHANGE_LSM, //FID
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
					0 );
		}
		else
		{
			oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
			oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
		}
	}
	else
	{
			midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
			oMethodStart.e8Action.enType= midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT;
			oMethodStart.u8ListElementID=oPresetHandlingParam.u8Element_ID;
			oMethodStart.e8ListID.enType=(midw_fi_tcl_e8_Tun_ListID::tenType)oPresetHandlingParam.u8List;
			ETG_TRACE_USR4(("PresetList::Request->PresetRecall Forward the request to AM/FM tuner ElementID=%d List=%d",
			oMethodStart.u8ListElementID,oMethodStart.e8ListID.enType));
			m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
					oMethodStart,           // parameter&
					MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, //FID
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
					0 );

			//Pack the data required for sending method result to HMI
			oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
			oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	}
	//Send method result to HMI
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);

}

/*************************************************************************
 * FUNCTION:    vHandleDABNormalPresetRecall
 *
 * DESCRIPTION:  Function to handle the DAB tuner Normal Preset recall request
 *
 * PARAMETER:    PresetHandlingParam stPresetHandlingParam
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABNormalPresetRecall(stPresetHandlingParam oPresetHandlingParam)
{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_SrcChgManager==NULL)||(m_potunmstr_DABClient_Handler==NULL) || (NULL == m_poclConfigInterface))
#else
	if((m_potunmstr_SrcChgManager==NULL)\
			||(m_potunmstr_AudioClientHandler==NULL)||(m_potunmstr_DABClient_Handler==NULL))
#endif
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
#else
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tU8 u8DABState = clSessionControl::getInstance()->getActiveTunerState(tuner::common::DABTUNER);
	/*DAB source doesn't have band, if DAB tuner is fg, then forward the preset recall request*/
#else
	tU8 u8DABState=m_potunmstr_SrcChgManager->u8GetDABState();
	m_u8CurrentBand = m_potunmstr_SrcChgManager->u8GetCurrentSource();
#endif
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	tU8 u8Band=u8ConvFiBandtoTunmstrBand((tU8)(midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band,oPresetHandlingParam.u8List);
	ETG_TRACE_USR4(("PresetList::Request->PresetRecall DAB State=%d Current Band=%d ConvBand=%d", u8DABState, m_u8CurrentBand, u8Band));

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(u8DABState !=(tU8)tuner::common::TUNERTOFG)
#else
		if((u8DABState ==(tU8)TUNMSTR_SRCCHG_BACKGROUND) || (u8DABState == TUNMSTR_SRCCHG_INPROGESS) || (m_u8CurrentBand != u8Band))
#endif

	{
        tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");

        if(TRUE == blIsmixedPreset)
        {
		    ETG_TRACE_USR4(("PresetList::Request->PresetRecall Store the DAB preset recall and send play request to HMI"));
		    oMethodResult.Source.enType=(midw_fi_tcl_e8_Source::tenType)(midw_fi_tcl_e8_Band::tenType)u8Band ;
		    oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_PLAY;
		    //Store the Preset recall request
		   /* m_poStoreRequest.blReguestPending=TRUE;
		    m_poStoreRequest.eBand.enType=(midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
		    m_poStoreRequest.eList.enType=(midw_fi_tcl_e8_List::tenType)oPresetHandlingParam.u8List;
		    m_poStoreRequest.u8Element_ID=oPresetHandlingParam.u8Element_ID;
		    m_poStoreRequest.ePresetAction.enType=midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT;*/
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart oMethodStart;
			oMethodStart.u8ActPresetElemID=oPresetHandlingParam.u8Element_ID;
			m_potunmstr_DABClient_Handler->vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
				oMethodStart,           // parameter&
				MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0,
				m_potunmstr_DABClient_Handler->u16GetDABServiceRegID() );

        }
        else
        {
		    oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
		    oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
        }

	}
	else
	{
			//Send preset recall method start to DAB
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart oMethodStart;
			oMethodStart.u8ActPresetElemID=oPresetHandlingParam.u8Element_ID;
			ETG_TRACE_USR4(("PresetList::Request->PresetRecall Forward the request to DAB tuner PresetElem=%d",oMethodStart.u8ActPresetElemID));
			m_potunmstr_DABClient_Handler->vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
					oMethodStart,           // parameter&
					MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM, //FID
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
					0 ,//CmdCntr
					m_potunmstr_DABClient_Handler->u16GetDABServiceRegID());


			//Pack the data required for sending method result to HMI
			oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
			oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;

	}
	//Send method result to HMI
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
			midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
/*************************************************************************
 * FUNCTION:    vHandleSXMNormalPresetRecall
 *
 * DESCRIPTION:  Function to handle SXM Preset recall request
 *
 * PARAMETER:    PresetHandlingParam stPresetHandlingParam
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleSXMNormalPresetRecall(stPresetHandlingParam oPresetHandlingParam)
{
	if((NULL == m_poclConfigInterface) || (m_potunmstr_MsgToHMI == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			|| (m_potunermaster_SXMClient==NULL)
#endif
			)
	{
		ETG_TRACE_USR4(("vHandleSXMNormalPresetRecall, null pointer"));
		return;
	}

	Update_tunmstr_bStartUpFlag(FALSE);

	tU8 u8TunState = clSessionControl::getInstance()->getActiveTunerState(tuner::common::AMFMTUNER);
	ETG_TRACE_USR4(("PresetList::Request->SXM PresetRecall Tuner State=%d", u8TunState));

    tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
    if(blIsmixedPreset)
    {
    	if(u8TunState ==(tU8)tuner::common::TUNERTOFG)
    	{
			ETG_TRACE_USR4(("PresetList::Request->SXM PresetRecall request and send play request to HMI"));
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
			oMethodResult.Source.enType = midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_SXM;
			oMethodResult.Action.enType = midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_PLAY;

			oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_PREV_REQ_INPROCESS;
			tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			vSendMsg( u8OpCode,oMethodResult);

      	}
    	else
    	{
    		// send method result once preset recall is successful
    	}
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
        midw_ext_sxm_audiofi_tclMsgRecallPresetMethodStart oMethodStart;
    	oMethodStart.PresetElement = oPresetHandlingParam.u8Element_ID;
    	m_potunermaster_SXMClient->vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
    		oMethodStart,           // parameter&
    		MIDW_EXT_SXM_AUDIOFI_C_U16_RECALLPRESET, //FID
    		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
    		0);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
    	// SXM360L Request
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
		oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL;
		oStatus.PresetIndex = oPresetHandlingParam.u8Element_ID;
		oStatus.Key = oPresetHandlingParam.sKey;
		oStatus.PresetType.enType = (midw_fi_tcl_e8_PresetType::tenType)oPresetHandlingParam.u8PresetType;
		m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
#endif
    }

}


/*************************************************************************
 * FUNCTION:    vHandleSXMNormalPresetSave
 *
 * DESCRIPTION:  Function to handle the SXM Preset save
 *
 * PARAMETER:   stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleSXMNormalPresetSave(stPresetHandlingParam oPresetHandlingParam)
{
	if((m_poclConfigInterface == nullptr) || (m_potunmstr_TunerClientHandler == nullptr)
			|| (m_potunmstr_MsgToHMI == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			|| (m_potunermaster_SXMClient==NULL)
#endif
			)
	{
		return;
	}

	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		Update_tunmstr_bStartUpFlag(FALSE);
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
		m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
		m_PresetSaveElemementID = oPresetHandlingParam.u8Element_ID;

		ETG_TRACE_USR4(("PresetList::Request->SXM PresetSave in Mixed PresetList"));
		if(m_PresetSaveElemementID != 0)
		{
			m_u8CurrentStoredBand = (tU8)oStatusMixed.ListOfStations.at(m_PresetSaveElemementID - 1).Band.enType;
		}
		else
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
			tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_ERROR;
			vSendMsg(u8OpCode,oMethodResult);
			ETG_TRACE_USR4(("PresetList::Request->PresetSave station error =%d Band=%d",
				oPresetHandlingParam.u8Element_ID,m_u8CurrentStoredBand));
			m_PresetSaveElemementID = 0;
			return;
		}

		if ((m_u8CurrentStoredBand != (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE) && (m_u8CurrentStoredBand != (tU8)oPresetHandlingParam.u8Band))
		{
			ETG_TRACE_USR4(("PresetList::Request->PresetSave Already at =%d Band=%d is stored",
					oPresetHandlingParam.u8Element_ID,m_u8CurrentStoredBand));

			midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
			oMethodStart.u8ListElementID=oPresetHandlingParam.u8Element_ID;
			oMethodStart.e8ListID.enType=(midw_fi_tcl_e8_Tun_ListID::tenType)oPresetHandlingParam.u8List;
			oMethodStart.e8Action.enType= (midw_fi_tcl_e8_Tun_PresetAction::tenType)midw_fi_tcl_e8_Tun_PresetAction::FI_EN_DELETE_ONE_ELEMENT;
			ETG_TRACE_USR4(("PresetList::Request->PresetSave delete FMAM preset stored at =%d ",oPresetHandlingParam.u8Element_ID));
			ETG_TRACE_USR4(("PresetList::Request->PresetSave delete m_PresetSaveElemementID =%d ",m_PresetSaveElemementID));
			m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
					oMethodStart,           // parameter&
					MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, //FID
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
					0 );
		}
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		midw_ext_sxm_audiofi_tclMsgStorePresetMethodStart oMethodStart;
		oMethodStart.PresetElement = oPresetHandlingParam.u8Element_ID;
		m_potunermaster_SXMClient->vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
				oMethodStart,           // parameter&
				MIDW_EXT_SXM_AUDIOFI_C_U16_STOREPRESET, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
				0);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
		// SXM360L Request
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
		oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE;
		oStatus.PresetIndex = oPresetHandlingParam.u8Element_ID;
		oStatus.Key = oPresetHandlingParam.sKey;
		oStatus.PresetType.enType = (midw_fi_tcl_e8_PresetType::tenType)oPresetHandlingParam.u8PresetType;
		m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
#endif
	}

}


/*************************************************************************
 * FUNCTION:    vHandleSXMNormalPresetDelete
 *
 * DESCRIPTION: Function to handle SXM preset delete
 *
 * PARAMETER:    stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleSXMNormalPresetDelete(stPresetHandlingParam oPresetHandlingParam)
{
	if((m_potunmstr_MsgToHMI==NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			|| (m_potunermaster_SXMClient==NULL)
#endif
			)
	{
		return;
	}

	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset)
	{
		ETG_TRACE_USR4(("PresetList::Request->SXM PresetDelete in Mixed PresetList"));
		Update_tunmstr_bStartUpFlag(FALSE);
		m_ePresetReguest = NormalPresetDelete;
		m_u8ElemID_Delete = oPresetHandlingParam.u8Element_ID;

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
					midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart oMethodStart;

					for(tU8 index=0; index < (m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands")); index++)
					{
						midw_ext_fi_tcl_PresetEntry oPresetEntry;
						oPresetEntry.SID = oStatusMixed.ListOfStations.at(index).SXMSMSlib_PresetListEntry.ServiceID;
						oPresetEntry.Index = index+1;
						if(index == (oPresetHandlingParam.u8Element_ID)-1)
							oPresetEntry.SID = 0;

						oMethodStart.PresetEntry.push_back(oPresetEntry);
					}
					m_potunermaster_SXMClient->vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
							oMethodStart,           // parameter&
							MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST, //FID
							AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
							0);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
					// SXM360L Request
					midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
					oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE;
					oStatus.PresetIndex = oPresetHandlingParam.u8Element_ID;
					m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
#endif

	}

}


/*************************************************************************
 * FUNCTION:    vHandleSXMNormalPresetDeleteAll
 *
 * DESCRIPTION: Function to handle SXM preset delete all
 *
 * PARAMETER:    stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleSXMNormalPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam)
{
	if((m_potunmstr_MsgToHMI==NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			|| (m_potunermaster_SXMClient==NULL)
#endif
			)
	{
		return;
	}

	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset)
	{
		Update_tunmstr_bStartUpFlag(FALSE);
		m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
		ETG_TRACE_USR4(("PresetList::Request->PresetDeleteAll request to SXM"));
		m_ePresetReguest=NormalPresetDeleteAll;

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
					midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart oMethodStart;

					for(tU8 index=0; index < (m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands")); index++)
					{
						midw_ext_fi_tcl_PresetEntry oPresetEntry;
						oPresetEntry.SID = 0;
						oPresetEntry.Index = index+1;
						oMethodStart.PresetEntry.push_back(oPresetEntry);
					}

					m_potunermaster_SXMClient->vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
							oMethodStart,           // parameter&
							MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST, //FID
							AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
							0);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
					// SXM360L Request
					midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
					oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL;
					oStatus.PresetIndex = oPresetHandlingParam.u8Element_ID;
					m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
#endif

	}

}


/*************************************************************************
 * FUNCTION:    vSendSXMGetPresetList
 *
 * DESCRIPTION: Function to request SXM preset list
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSendSXMGetPresetList()
{
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	if(m_potunermaster_SXMClient != NULL)
	{
		ETG_TRACE_USR4(("vSendSXMGetPresetList , SXM smslib request list"));
		m_potunermaster_SXMClient->vGetPresetList();
	}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	if(m_potunmstr_MsgToHMI != NULL)
	{
		ETG_TRACE_USR4(("vSendSXMGetPresetList , SXM 360L request list"));
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
		oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_GETPRESETLIST;
		oStatus.PresetIndex = 0x00;
		m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
	}
#endif
}


/*************************************************************************
 * FUNCTION:    vSendSXMPresetActionMethodResult
 *
 * DESCRIPTION:  Function to send SXM Preset operations result
 *
 * PARAMETER:    tU8 u8PresetAction , tBool bPresetActionStatus
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSendSXMPresetActionMethodResult(tU8 u8PresetAction , tBool bPresetActionStatus)
{
	if(m_potunmstr_MsgToHMI == nullptr)
	{
		return;
	}
	ETG_TRACE_USR4(("PresetList::vSendSXMPresetActionMethodResult , Action = %d , status = %d", u8PresetAction , bPresetActionStatus));

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;

	if(bPresetActionStatus)
	{
	    oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	}
	else
	{
	    oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
	}

	oMethodResult.Source.enType = midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType = midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	oMethodResult.Preset_Action.enType = (midw_fi_tcl_e8_Preset_Action::tenType)u8PresetAction;

	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	if((u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE) && (bPresetActionStatus))
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus oStatusMsg;
		midw_fi_tcl_SXMPresetListEntry oPresetListEntry;

		oPresetListEntry.ChannelActive = FALSE;
		oPresetListEntry.ChannelID = 0;
		oPresetListEntry.ChannelName = 0;
		oPresetListEntry.ServiceID = 0;
		oPresetListEntry.ChannelNameAvail = FALSE;
		oPresetListEntry.ChnGraphicAvail.enType = midw_fi_tcl_e8_Graphics::FI_EN_GRAPHICS_NEEDS_REFRESH;
		oPresetListEntry.IsSmartFavorite = FALSE;
		oPresetListEntry.IsAvailable = FALSE;
		oPresetListEntry.IsMature = FALSE;
		oPresetListEntry.IsSkipped = FALSE;
		oPresetListEntry.IsLocked = FALSE;

		oStatusMsg.PresetIndex = m_u8ElemID_Delete;
		oStatusMsg.ChannelInfo = oPresetListEntry;
		m_potunmstr_MsgToHMI->vSend_g_PresetChannelUpdate(oStatusMsg);
		m_ePresetReguest = None;
		m_u8ElemID_Delete = 0;
	}
#endif
}


#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
 * FUNCTION:    vUpdateSXMPresetActionMethodResult
 *
 * DESCRIPTION:  Function to update SXM Preset operations result
 *
 * PARAMETER:    amt_tclServiceData* poMessage , tU8 u8PresetAction
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateSXMPresetActionMethodResult(amt_tclServiceData* poMessage , tU8 u8PresetAction)
{
	if(m_potunmstr_MsgFromHMI == nullptr)
	{
		return;
	}

	tBool bPresetActionStatus = FALSE;
	switch(u8PresetAction)
	{
		case (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL:
		{
			midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult oResult;
			m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oResult);
			bPresetActionStatus = oResult.Status;
			vSendSXMPresetActionMethodResult(u8PresetAction, bPresetActionStatus);
			break;
		}

		case (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE:
		{
			midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult oResult;
			m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oResult);
			bPresetActionStatus = oResult.Status;
			vSendSXMPresetActionMethodResult(u8PresetAction, bPresetActionStatus);
			break;
		}
		case (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE:
		case (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL:
		{
			midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult oResult;
			m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oResult);
			bPresetActionStatus = oResult.Status;
			vSendSXMPresetActionMethodResult(u8PresetAction, bPresetActionStatus);
			break;
		}
		default:
		{
			break;
		}
	}

}


/*************************************************************************
 * FUNCTION:    vRequestChannelArtList
 *
 * DESCRIPTION:  Function to request channel art list
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vRequestChannelArtList(amt_tclServiceData* poMessage)
{
	if(m_potunmstr_MsgFromHMI == nullptr)
	{
		return;
	}

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodStart oMethodStart;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodStart);

	m_u16ChannelArtSourceAppID=poMessage->u16GetSourceAppID();
	m_u16ChannelArtCmdCounter=poMessage->u16GetCmdCounter();
	m_u16ChannelArtRegID=poMessage->u16GetRegisterID();

	midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodStart oMethod;
	oMethod.ChannelGraphicsType = oMethodStart.ChannelGraphicsType;
	oMethod.ListOfSID = oMethodStart.SIDList;
	m_potunermaster_SXMchannelartClient->vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
			oMethod,           // parameter&
			MIDW_EXT_SXM_CHANNELARTFI_C_U16_GETCHANNELARTLIST, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
			0
			);
}


/*************************************************************************
 * FUNCTION:    vHandleChannelArtListResult
 *
 * DESCRIPTION:  Function to handle channel art list
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleChannelArtListResult(amt_tclServiceData* poMessage)
{
	if(m_potunmstr_MsgFromHMI == nullptr)
	{
		return;
	}

	midw_ext_sxm_channelartfi_tclMsgGetChannelArtListMethodResult oMethodResult;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodResult);

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult oResult;

	oResult.ChannelGraphicsType = oMethodResult.ChannelGraphicsType;

    if (oMethodResult.ImageDataList.size() > 0)
    {
        for (auto it:oMethodResult.ImageDataList)
        {
        	midw_fi_tcl_SXMChannelImagedata oImageData;
        	oImageData.ImageData = it.ImageData;
        	oImageData.ImageDataSize  = it.ImageDataSize;
        	oImageData.SID = it.SID;
        	oResult.ImageDataList.push_back(oImageData);
        }
    }
    oResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
    						midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	stSendCCAMsg ostSendCCAMsg;
	ostSendCCAMsg.u16DestAppID=m_u16ChannelArtSourceAppID;
	ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_SXMCHANNELART_LIST;
	ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	ostSendCCAMsg.u16CmdCtr=m_u16ChannelArtCmdCounter;
	ostSendCCAMsg.u16RegID=m_u16ChannelArtRegID;
	m_potunmstr_MsgFromHMI->vSendMessage( ostSendCCAMsg,oResult);

}

#endif

#endif


/*************************************************************************
 * FUNCTION:    vHandleTunerNormalPresetSave
 *
 * DESCRIPTION:  Function to handle the AM/FM tuner Normal Preset save or Delete request
 *
 * PARAMETER:   stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleTunerNormalPresetSave(stPresetHandlingParam oPresetHandlingParam)
{
	if((m_potunmstr_TunerClientHandler==NULL)|| (m_poclConfigInterface==NULL) || (m_potunmstr_MsgToHMI == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			||(m_potunermaster_SXMClient == NULL)
#endif
	  )
	{
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI  != NULL );
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		NORMAL_M_ASSERT( m_potunermaster_SXMClient != NULL );
#endif
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	m_PresetSaveElemementID  = oPresetHandlingParam.u8Element_ID;
	if(oPresetHandlingParam.u8Element_ID == 0)
	{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
			oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
			oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
			oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
			midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
			tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			vSendMsg(u8OpCode,oMethodResult);
			ETG_TRACE_USR4(("PresetList::Request->PresetSave station error =%d Band=%d",
				oPresetHandlingParam.u8Element_ID,m_u8CurrentStoredBand));
			m_PresetSaveElemementID = 0;
			return;
	}
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		ETG_TRACE_USR4(("PresetList::Request->PresetSave in Mixed PresetList"));
		m_u8CurrentStoredBand = (tU8)oStatusMixed.ListOfStations.at(oPresetHandlingParam.u8Element_ID - 1).Band.enType;
		ETG_TRACE_USR4(("PresetList::Request->PresetSave Is station is already saved at =%d Band=%d",
				oPresetHandlingParam.u8Element_ID,m_u8CurrentStoredBand));
		if (m_u8CurrentStoredBand != (tU8)oPresetHandlingParam.u8Band)
		{
			if (m_u8CurrentStoredBand == (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
			{
				midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart oMethodStart;
				oMethodStart.u8DelPresetElemId=oPresetHandlingParam.u8Element_ID;
				oMethodStart.e8Action.enType=midw_ext_fi_tcl_e8_DAB_DeleteAction::FI_EN_PRESETLIST_DELACTION_ONE_ELEMENT;
				ETG_TRACE_USR4(("PresetList::Request->PresetSave delete DAB preset stored at =%d ",oPresetHandlingParam.u8Element_ID));
				m_potunmstr_DABClient_Handler->vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
							oMethodStart,           // parameter&
							MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DELETE_PRESET_LIST_ELEM, //FID
							AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
							0,
							m_potunmstr_DABClient_Handler->u16GetDABServiceRegID());
			}
			else if(m_u8CurrentStoredBand == (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_SXM)
			{
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
				midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart oMethodStart;
				for(tU8 index=0; index < (m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands")); index++)
				{
					midw_ext_fi_tcl_PresetEntry oPresetEntry;
					oPresetEntry.SID = oStatusMixed.ListOfStations.at(index).SXMSMSlib_PresetListEntry.ServiceID;
					oPresetEntry.Index = index+1;
					if(index == (oPresetHandlingParam.u8Element_ID)-1)
						oPresetEntry.SID = 0;

					oMethodStart.PresetEntry.push_back(oPresetEntry);
				}
				m_potunermaster_SXMClient->vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
						oMethodStart,           // parameter&
						MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST, //FID
						AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
						0);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
				// SXM360L Request
				midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
				oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE;
				oStatus.PresetIndex = oPresetHandlingParam.u8Element_ID;
				m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
#endif
			}
			else
			{

			}
		}
	}
	//Send preset Save method start to amfmtuner
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
	oMethodStart.u8ListElementID=oPresetHandlingParam.u8Element_ID;
	oMethodStart.e8ListID.enType=(midw_fi_tcl_e8_Tun_ListID::tenType)oPresetHandlingParam.u8List;
	oMethodStart.e8Action.enType= (midw_fi_tcl_e8_Tun_PresetAction::tenType)oPresetHandlingParam.u8PresetAction;
	if(oPresetHandlingParam.u8PresetAction == midw_fi_tcl_e8_Tun_PresetAction::FI_EN_SPECIAL_SAVE_ELEMENT)
	{
		m_u8PresetBandActionPerformed = enCovListToBand(oPresetHandlingParam.u8List, oPresetHandlingParam.u32Frequency);
		oMethodStart.u32Frequency = oPresetHandlingParam.u32Frequency;
		oMethodStart.u16PI = (tU16)oPresetHandlingParam.u32PI;
		oMethodStart.u16SecondaryPI  = oPresetHandlingParam.u16SecondaryPI;
	}
	m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMethodStart,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0 );
	//Pack the data required for sending method result to HMI
	oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	//Send method result to HMI
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

/*************************************************************************
 * FUNCTION:    vHandleTunerNormalPresetDelete
 *
 * DESCRIPTION:  Function to handle the AM/FM tuner Normal Preset save or Delete request
 *
 * PARAMETER:   stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleTunerNormalPresetDelete(stPresetHandlingParam oPresetHandlingParam)
{
	if(m_potunmstr_TunerClientHandler==NULL)
	{
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	ETG_TRACE_USR4(("PresetList::Request->PresetDelete Send preset Delete request to AMFM"));
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	m_ePresetReguest = NormalPresetDelete;
	m_u8ElemID_Delete = oPresetHandlingParam.u8Element_ID;
	//Send preset Save method start to amfmtuner
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
	oMethodStart.u8ListElementID=oPresetHandlingParam.u8Element_ID;
	oMethodStart.e8ListID.enType=(midw_fi_tcl_e8_Tun_ListID::tenType)oPresetHandlingParam.u8List;
	oMethodStart.e8Action.enType= (midw_fi_tcl_e8_Tun_PresetAction::tenType)oPresetHandlingParam.u8PresetAction;
	m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMethodStart,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0 );
	//Pack the data required for sending method result to HMI
	oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	//Send method result to HMI
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

/*************************************************************************
 *
 * FUNCTION:    vHandleDABNormalPresetSave
 *
 * DESCRIPTION: Function to handle DAB normal preset save request
 *
 * PARAMETER:    stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABNormalPresetSave(stPresetHandlingParam oPresetHandlingParam)
{
	if((m_potunmstr_DABClient_Handler==NULL)|| (m_poclConfigInterface==NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	m_PresetSaveElemementID = oPresetHandlingParam.u8Element_ID;
	if(blIsmixedPreset==TRUE)
	{
		ETG_TRACE_USR4(("PresetList::Request->PresetSave in Mixed PresetList"));
		if(oPresetHandlingParam.u8Element_ID != 0)
		m_u8CurrentStoredBand = (tU8)oStatusMixed.ListOfStations.at(oPresetHandlingParam.u8Element_ID - 1).Band.enType;
		else
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
			tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_ERROR;
			vSendMsg(u8OpCode,oMethodResult);
			ETG_TRACE_USR4(("PresetList::Request->PresetSave station error =%d Band=%d",
				oPresetHandlingParam.u8Element_ID,m_u8CurrentStoredBand));
			m_PresetSaveElemementID = 0;
			return;
		}
		ETG_TRACE_USR4(("PresetList::Request->PresetSave Already at =%d Band=%d is stored",
				oPresetHandlingParam.u8Element_ID,m_u8CurrentStoredBand));
		if (m_u8CurrentStoredBand != (tU8)oPresetHandlingParam.u8Band)
		{
			midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
			oMethodStart.u8ListElementID=oPresetHandlingParam.u8Element_ID;			
			oMethodStart.e8ListID.enType=(midw_fi_tcl_e8_Tun_ListID::tenType)oPresetHandlingParam.u8List;
			oMethodStart.e8Action.enType= (midw_fi_tcl_e8_Tun_PresetAction::tenType)midw_fi_tcl_e8_Tun_PresetAction::FI_EN_DELETE_ONE_ELEMENT;
			ETG_TRACE_USR4(("PresetList::Request->PresetSave delete FMAM preset stored at =%d ",oPresetHandlingParam.u8Element_ID));
			ETG_TRACE_USR4(("PresetList::Request->PresetSave delete m_PresetSaveElemementID =%d ",m_PresetSaveElemementID));
			m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
					oMethodStart,           // parameter&
					MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, //FID
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
					0 );
		}
	}
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LIST_ELEMMethodStart oMethodStart;
	oMethodStart.u8PresetElemId=oPresetHandlingParam.u8Element_ID;
	/*for secondary service storing*/
	oMethodStart.u8Scids=(tU8)oPresetHandlingParam.u16SecondaryPI;
	if(oPresetHandlingParam.u8PresetAction == (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_SPECIALPRESETSAVE)
	{
		oMethodStart.u32EnsFrequency  = oPresetHandlingParam.u32Frequency;
		oMethodStart.u32PSID = oPresetHandlingParam.u32PI;
	}
	m_potunmstr_DABClient_Handler->vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMethodStart,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST_ELEM, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,//CmdCntr
			m_potunmstr_DABClient_Handler->u16GetDABServiceRegID());

	//Pack the data required for sending method result to HMI
	oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

/*************************************************************************
 * FUNCTION:    vHandleDABNormalPresetDelete
 *
 * DESCRIPTION: Function to handle DAB normal preset recall
 *
 * PARAMETER:    stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABNormalPresetDelete(stPresetHandlingParam oPresetHandlingParam)
{
	if(m_potunmstr_DABClient_Handler==NULL)
	{
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	m_ePresetReguest = NormalPresetDelete;
	m_u8ElemID_Delete = oPresetHandlingParam.u8Element_ID;
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart oMethodStart;
	oMethodStart.e8Action.enType=midw_ext_fi_tcl_e8_DAB_DeleteAction::FI_EN_PRESETLIST_DELACTION_ONE_ELEMENT;
	oMethodStart.u8DelPresetElemId=oPresetHandlingParam.u8Element_ID;
	ETG_TRACE_USR4(("PresetList::Request->PresetDelete request to DAB"));
	m_potunmstr_DABClient_Handler->vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMethodStart,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DELETE_PRESET_LIST_ELEM, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,//CmdCntr
			m_potunmstr_DABClient_Handler->u16GetDABServiceRegID());
	oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

/*************************************************************************
 * FUNCTION:    vHandleTunerNormalPresetDeleteAll
 *
 * DESCRIPTION:  Function to handle the AM/FM tuner Normal Preset delete all request
 *
 * PARAMETER:    stPresetHandlingParam oPresetHandlingParam
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleTunerNormalPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam)
{
	if(m_potunmstr_TunerClientHandler==NULL)
	{
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	m_ePresetReguest=NormalPresetDeleteAll;
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
	oMethodStart.e8Action.enType= midw_fi_tcl_e8_Tun_PresetAction::FI_EN_DELETE_ALL_ELEMENTS;
	oMethodStart.u8ListElementID=oPresetHandlingParam.u8Element_ID;
	oMethodStart.e8ListID.enType=(midw_fi_tcl_e8_Tun_ListID::tenType)(midw_fi_tcl_e8_List::tenType)oPresetHandlingParam.u8List;
	ETG_TRACE_USR4(("PresetList::Request->PresetDelete request to AMFM"));
	m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMethodStart,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0 );
	//Pack the data required for sending method result to HMI
	oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	//Send method result to HMI
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

/*************************************************************************
 * FUNCTION:    vHandleDABNormalPresetDeleteAll
 *
 * DESCRIPTION: Function to handle DAB normal preset Delete All
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABNormalPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam)
{
	if(m_potunmstr_DABClient_Handler==NULL)
	{
		return;
	}
	Update_tunmstr_bStartUpFlag(FALSE);
	m_u8PresetBandActionPerformed.enType = (midw_fi_tcl_e8_Band::tenType)oPresetHandlingParam.u8Band;
	ETG_TRACE_USR4(("PresetList::Request->PresetDeleteAll request to DAB"));
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodResult oMethodResult;
	m_ePresetReguest=NormalPresetDeleteAll;
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_DELETE_PRESET_LIST_ELEMMethodStart oMethodStart;
	oMethodStart.e8Action.enType=midw_ext_fi_tcl_e8_DAB_DeleteAction::FI_EN_PRESETLIST_DELACTION_ALL_ELEMENTS;
	oMethodStart.u8DelPresetElemId=oPresetHandlingParam.u8Element_ID;
	m_potunmstr_DABClient_Handler->vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMethodStart,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DELETE_PRESET_LIST_ELEM, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,//CmdCntr
			m_potunmstr_DABClient_Handler->u16GetDABServiceRegID());
	//Pack the data required for sending method result to HMI
	oMethodResult.Source.enType=midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_NONE;
	oMethodResult.Action.enType=midw_fi_tcl_e8_Action::FI_EN_TUN_MSTR_NONE;
	oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType= \
	midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	tU8 u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMsg( u8OpCode,oMethodResult);
}

/*************************************************************************
 * FUNCTION:    vUpdateTunerPresetList
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_TUN_G_GET_STATIC_LIST status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateTunerPresetList(amt_tclServiceData* poMessage)
{
	if(m_poclConfigInterface == NULL)
	{
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		ETG_TRACE_USR4(("PresetList::Update->AMFM Mixed PresetList"));
		vUpdateTunerMixedPresetList(poMessage);
		vSendMixedPresetList();

	}
	else
	{
		ETG_TRACE_USR4(("PresetList::Update->AMFM  PresetList"));
		vUpdateTunerNormalPresetList(poMessage);
	}

}

/*************************************************************************
 * FUNCTION:    vUpdateTunerNormalPresetList
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_TUN_G_GET_STATIC_LIST status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateTunerNormalPresetList(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI == NULL) || (poMessage==NULL) || (m_potunmstr_MsgToHMI==NULL))
	{
		return;
	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus;
	midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus oStatusMsg;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);
	tU8 u8NoOfElemList=oStatusMsg.u8NumofElementsinList;
	for(tU8 i=0;i<u8NoOfElemList;i++)
	{
		midw_fi_tcl_PresetList oPresetList;
		midw_fi_tcl_TunerStaticListElementList oTunerStaticListElementList=oStatusMsg.Tun_StaticListElements;
		vTunerPresetListPopulate(oTunerStaticListElementList.TunerStaticListElement[i] , oPresetList,oStatusMsg.e8ListID.enType);
		oStatus.ListOfStations.push_back(oPresetList);
	}
	tU8 u8ListID = (tU8)oStatusMsg.e8ListID.enType;
	oStatus.List.enType = (midw_fi_tcl_e8_List::tenType)u8ListID;
	m_potunmstr_MsgToHMI->vSend_g_PresetListStatus(oStatus);
#ifdef INCLUDE_PROFILE_MANAGER
	if(NULL == m_poPMClient)
	{
			return;
	}
	m_poPMClient->vIndividualTunerPresetListUpdate(oStatus);
	if( 0 != m_PresetSaveElemementID )
	{
			if (oStatus.ListOfStations.at(m_PresetSaveElemementID -1).Frequency == m_potunmstr_TunerClientHandler->u32GetCurrentAtStationFreq())
			{
				std::vector<tU8> u8PresetID;
				u8PresetID.push_back(m_PresetSaveElemementID);
				m_poPMClient->vSendRadioSettingNotification(u8PresetID);
				m_PresetSaveElemementID = 0;
			}
	}
#endif
}


/*************************************************************************
 * FUNCTION:    vUpdateTunerMixedPresetList
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_TUN_G_GET_STATIC_LIST status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateTunerMixedPresetList(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI == NULL) || (poMessage==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		return;
	}
#ifdef INCLUDE_PROFILE_MANAGER
	tU8 u8DeletePresetElement =0;
#endif
	midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTStatus oStatusMsg;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);
	tU8 u8NoOfElemList=oStatusMsg.u8NumofElementsinList;
	midw_fi_tcl_TunerStaticListElementList oTunerStaticListElementList=oStatusMsg.Tun_StaticListElements;
	tU8 u8List=oStatusMsg.e8ListID.enType;
	ETG_TRACE_USR4(("PresetList::Update->Mixed AM/FM PresetList StartupFlag=%d",bStartUpFlag));
	if(bStartUpFlag)
	{
		if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
			Dec_m_u8TunerStartUp_HMI_Update();
		else
			Dec_m_u8StartUp_HMI_Update();
		
		for(tU8 i=0;i<u8NoOfElemList;i++)
		{
			midw_fi_tcl_TunerStaticListElement oTunerStaticListElem=oTunerStaticListElementList.TunerStaticListElement[i];
			ETG_TRACE_USR4(("PresetList::Update->Mixed AM/FM PresetList at element %d Frequency:%d",i,oTunerStaticListElem.u32Frequency));
			if(oTunerStaticListElem.u32Frequency != 0)
			{
				midw_fi_tcl_PresetList oPresetList;
				vTunerPresetListPopulate(oTunerStaticListElem , oPresetList, u8List);
				oStatusMixed.ListOfStations.at (oTunerStaticListElem.u8ElementID -1) = oPresetList;
			}
		}
	}
	else
	{
		if((m_ePresetReguest == NormalPresetDeleteAll) && (m_poclConfigInterface->u32GetConfigData("SXMSupported")))
		{
			ETG_TRACE_USR4(("PresetList::Update->Mixed AM/FM PresetList PresetReguest=%d",
				ETG_CENUM(enPresetReguest,m_ePresetReguest)));
			Dec_m_u8TunerStartUp_HMI_Update();
			return;
		}
		ETG_TRACE_USR4(("PresetList::Update->Mixed AM/FM PresetList PresetReguest=%d deleteElementID=%d",
				ETG_CENUM(enPresetReguest,m_ePresetReguest),m_u8ElemID_Delete));
		for(tU8 i=0;i<u8NoOfElemList;i++)
		{
			midw_fi_tcl_TunerStaticListElement oTunerStaticListElem=oTunerStaticListElementList.TunerStaticListElement[i];
			tU32 u32FRQ = oTunerStaticListElem.u32Frequency;
			tU8 u8Modulation= oStatusMsg.Tun_StaticListElements.TunerStaticListElement[i].e8Modulation.enType;
			enModulationType e8Modulation = (enModulationType)u8Modulation;


#ifndef INCLUDE_PROFILE_MANAGER
			if (((oTunerStaticListElem.u32Frequency != 0) && (m_u8PresetBandActionPerformed == enCovListToBand(u8List, u32FRQ, e8Modulation)))
					|| ((m_ePresetReguest == NormalPresetDelete) && (oTunerStaticListElem.u8ElementID == m_u8ElemID_Delete)))

#else
			if (((oTunerStaticListElem.u32Frequency != 0) && (((m_u8PresetBandActionPerformed == enCovListToBand(u8List, u32FRQ, e8Modulation)) || (m_bProfile_PresetOperation))))
									|| ((m_ePresetReguest == NormalPresetDelete) && (oTunerStaticListElem.u8ElementID == m_u8ElemID_Delete)))

#endif
				{
				midw_fi_tcl_PresetList oPresetList;
				vTunerPresetListPopulate(oTunerStaticListElem , oPresetList,u8List);
				oStatusMixed.ListOfStations.at (oTunerStaticListElem.u8ElementID -1) = oPresetList;
				if((m_ePresetReguest == NormalPresetDelete) && (oTunerStaticListElem.u8ElementID == m_u8ElemID_Delete))
				{
#ifdef INCLUDE_PROFILE_MANAGER
					u8DeletePresetElement = oTunerStaticListElem.u8ElementID;
#endif
					m_ePresetReguest = None;
					m_u8ElemID_Delete = 0;

				}
			}
		}

#ifdef INCLUDE_PROFILE_MANAGER
	if(NULL == m_poPMClient )
	{
		return;
	}
	std::vector<tU8> u8PresetID;
	if( 0 != m_PresetSaveElemementID    )
	{
		if( 0 != oStatusMixed.ListOfStations.at(m_PresetSaveElemementID-1).Frequency )
		{
			u8PresetID.push_back(m_PresetSaveElemementID);
			m_poPMClient->vSendRadioSettingNotification(u8PresetID);
			m_PresetSaveElemementID = 0;
		}
	}
	if(u8DeletePresetElement)
	{
		u8PresetID.push_back(u8DeletePresetElement);
		m_poPMClient->vSendRadioSettingNotification(u8PresetID);
	}
#endif

	}

}


/*************************************************************************
 * FUNCTION:    vUpdateDABMixedPresetListStatus
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_TUN_G_GET_STATIC_LIST status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateDABMixedPresetListStatus(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI==NULL)||(poMessage==NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}
#ifdef INCLUDE_PROFILE_MANAGER
	if(NULL == m_poPMClient )
	{
		return;
	}
	tU8 u8DeletedPresetNo =0;
#endif

	midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus oStatusMsg;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);

	tU8 u8NoOfElements=oStatusMsg.u8NumberOfElements;
	ETG_TRACE_USR4(("PresetList::Update->Mixed DAB PresetList StartupFlag:%d",bStartUpFlag));

	if(bStartUpFlag)
	{
		Dec_m_u8StartUp_HMI_Update();
		for(int i=0;i<u8NoOfElements;i++)
		{
			midw_fi_tcl_PresetList oPresetList;
			if((oStatusMsg.PresetList[i].u32Frequency != 0))
			{
				ETG_TRACE_USR4(("PresetList::Update->Mixed DAB PresetList at %d Frequency is %d",i,oStatusMsg.PresetList[i].u32Frequency));
				midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement  = oStatusMsg.PresetList[i];
				vDABPresetListPopulate(oDABPresetListElement , oPresetList);
				oStatusMixed.ListOfStations.at (oDABPresetListElement.u8PresetElementID -1) = oPresetList;
			}
		}
#ifdef INCLUDE_PROFILE_MANAGER
		if(NULL != m_poPMClient )
			m_poPMClient->vIndividualTunerPresetListUpdate(oStatusMsg);
#endif
	}
	else
	{
		ETG_TRACE_USR4(("PresetList::Update->Mixed DAB PresetList PresetReguest:%d deleteElementID=:%d",
							ETG_CENUM(enPresetReguest,m_ePresetReguest),m_u8ElemID_Delete));


		for(int i=0;i<u8NoOfElements;i++)
		{

#ifndef INCLUDE_PROFILE_MANAGER
			if(((oStatusMsg.PresetList[i].u32Frequency != 0) && m_u8PresetBandActionPerformed.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
				|| ((m_ePresetReguest == NormalPresetDelete) && (oStatusMsg.PresetList[i].u8PresetElementID == m_u8ElemID_Delete)))
#else
			if(((oStatusMsg.PresetList[i].u32Frequency != 0) && ((m_u8PresetBandActionPerformed.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB )|| (m_bProfile_PresetOperation)))
					|| ((m_ePresetReguest == NormalPresetDelete) && (oStatusMsg.PresetList[i].u8PresetElementID == m_u8ElemID_Delete)))
#endif
			{
				midw_fi_tcl_PresetList oPresetList;
				midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement  = oStatusMsg.PresetList[i];
				vDABPresetListPopulate(oDABPresetListElement , oPresetList);

				if((m_ePresetReguest == NormalPresetDelete) && (oStatusMsg.PresetList[i].u8PresetElementID == m_u8ElemID_Delete))
				{
					m_ePresetReguest = None;
#ifdef INCLUDE_PROFILE_MANAGER
					u8DeletedPresetNo = oStatusMsg.PresetList[i].u8PresetElementID;
#endif
					m_u8ElemID_Delete = 0;
					oPresetList.Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;

				}
				oStatusMixed.ListOfStations.at (oDABPresetListElement.u8PresetElementID -1) = oPresetList;
			}
		}
#ifdef INCLUDE_PROFILE_MANAGER
	if(NULL != m_poPMClient )
		m_poPMClient->vIndividualTunerPresetListUpdate(oStatusMsg);

	std::vector<tU8> u8PresetID;
	if( 0 != m_PresetSaveElemementID )
	{
		if( 0 != oStatusMsg.PresetList[m_PresetSaveElemementID-1].u32Frequency )
		{
			u8PresetID.push_back(m_PresetSaveElemementID);
			m_poPMClient->vSendRadioSettingNotification(u8PresetID);
			m_PresetSaveElemementID = 0;
		}
	}
	if(u8DeletedPresetNo)
	{
		u8PresetID.push_back(u8DeletedPresetNo);
		m_poPMClient->vSendRadioSettingNotification(u8PresetID);
	}
#endif
	}

	vSendMixedPresetList();
}


/*************************************************************************
 * FUNCTION:    vTunerPresetListPopulate
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_TUN_G_GET_STATIC_LIST status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vTunerPresetListPopulate(const midw_fi_tcl_TunerStaticListElement &oTunerStaticListElem , midw_fi_tcl_PresetList &oPresetList, tU8 u8List)
{
	tU32 u32FRQ = oTunerStaticListElem.u32Frequency;

	oPresetList.Frequency=u32FRQ;
	oPresetList.PSName=oTunerStaticListElem.sPSName;
	oPresetList.u8TpTmcInfo=oTunerStaticListElem.u8TpTmcInfo;
	oPresetList.PTY=oTunerStaticListElem.u32PTY;
	oPresetList.EnsembleName="";
	oPresetList.List.enType= (midw_fi_tcl_e8_List::tenType)u8List;
	tU8 u8Modulation = oTunerStaticListElem.e8Modulation.enType;
	enModulationType e8Modulation = (enModulationType)u8Modulation;
	oPresetList.Band=enCovListToBand(u8List, u32FRQ,e8Modulation);
	oPresetList.Element_ID=oTunerStaticListElem.u8ElementID;
	oPresetList.Frequency_Label="";
	oPresetList.e8Modulation.enType=(midw_fi_tcl_e8_ModulationType::tenType)oTunerStaticListElem.e8Modulation.enType;
	oPresetList.u32HDStationId_DRMServiceId=oTunerStaticListElem.u32HDStationId_DRMServiceId;
	oPresetList.sHDCallSign_DRMServiceLabel=oTunerStaticListElem.sHDCallSign_DRMServiceLabel;
	tU8 u8HDTextEncoding = oTunerStaticListElem.e8HDTextEncoding.enType;
	oPresetList.e8HDTextEncoding.enType=(midw_fi_tcl_e8_HDTextEncoding::tenType)u8HDTextEncoding;
	oPresetList.u8HDStationGenre_DRMPty=oTunerStaticListElem.u8HDStationGenre_DRMPty;
	oPresetList.u8HDAudioProgram_DRMShortID=oTunerStaticListElem.u8HDAudioProgram_DRMShortID;
	oPresetList.StationLogo=oTunerStaticListElem.StationLogo;
	ETG_TRACE_USR4(("PresetList::*************at Element%d ****************",oPresetList.Element_ID));
	ETG_TRACE_USR4(("PresetList::Update-> AMFM Frequency:%d",oPresetList.Frequency));
	ETG_TRACE_USR4(("PresetList::Update-> AMFM PSName:%s",oPresetList.PSName.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR4(("PresetList::Update-> AMFM HDCallSign/DRMServiceLabel:%s",oPresetList.sHDCallSign_DRMServiceLabel.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR4(("PresetList::Update-> AMFM HDStationId/DRMServiceId:%d, Modulation:%d, Band:%d List:%d"
			,oPresetList.u32HDStationId_DRMServiceId, oPresetList.e8Modulation.enType, oPresetList.Band.enType,u8List));
	ETG_TRACE_USR4(("PresetList::Update-> AMFM StationLogo:%s",oPresetList.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)));
}
/*************************************************************************
 * FUNCTION:    vDABPresetListPopulate
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_TUN_G_GET_STATIC_LIST status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vDABPresetListPopulate(midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement , midw_fi_tcl_PresetList &oPresetList)
{

	oPresetList.Element_ID=oDABPresetListElement.u8PresetElementID;
	oPresetList.Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
	oPresetList.Frequency = oDABPresetListElement.u32Frequency;
	oPresetList.PSName = oDABPresetListElement.ServiceLabel.sLabelShort.szValue;
	oPresetList.u8TpTmcInfo = 0x00;
	oPresetList.PTY = 0xffff;
	oPresetList.StationLogo = oDABPresetListElement.sLogoLink.szValue;
	ETG_TRACE_USR4(("PresetList::*************at Element%d ****************",oPresetList.Element_ID));
	ETG_TRACE_USR4(("PresetList::Update-> DAB Frequency:%d",oPresetList.Frequency));
	ETG_TRACE_USR4(("PresetList::Update-> DAB PSName:%s",oPresetList.PSName.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR4(("PresetList::Update-> DAB StationLogo:%s",oPresetList.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)));
}

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
 * FUNCTION:    vUpdateSXMPresetChannel
 *
 * DESCRIPTION: Sends status update for PresetChannelUpdate to client,
 * 				by extracting the PresetChannelUpdate status
 *
 * PARAMETER:    amt_tclServiceData* poMessage , tU8 u8PresetAction
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateSXMPresetChannel(amt_tclServiceData* poMessage , tU8 u8PresetAction)
{
	if((m_poclConfigInterface == nullptr) || (m_potunmstr_MsgFromHMI == nullptr) || (poMessage == nullptr))
	{
		return;
	}
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		ETG_TRACE_USR4(("PresetList::Update->SXM channel update"));

		midw_fi_tcl_SXMPresetListEntry oPresetListEntry;
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus oStatusMsg;

		switch(u8PresetAction)
		{
			case (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL:
			{
				midw_ext_sxm_audiofi_tclMsgRecallPresetMethodResult oMethodResult;
				m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodResult);
				vSXMPresetChannelPopulate(oMethodResult.PresetListElement, oPresetListEntry);
				oStatusMsg.PresetIndex = oMethodResult.PresetElement;
				break;
			}

			case (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE:
			{
				midw_ext_sxm_audiofi_tclMsgStorePresetMethodResult oMethodResult;
				m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodResult);
				vSXMPresetChannelPopulate(oMethodResult.PresetListElement, oPresetListEntry);
				oStatusMsg.PresetIndex = oMethodResult.PresetElement;
				break;
			}
			default:
			{
				midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus oStatus;
				m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatus);
				vSXMPresetChannelPopulate(oStatus.ChannelInfo, oPresetListEntry);
				oStatusMsg.PresetIndex = oStatus.LinearPresetIndex;
				break;
			}
		}

		oStatusMsg.ChannelInfo = oPresetListEntry;
		m_potunmstr_MsgToHMI->vSend_g_PresetChannelUpdate(oStatusMsg);
	}
}


/*************************************************************************
 * FUNCTION:    vSXMPresetChannelPopulate
 *
 * DESCRIPTION: update for PresetChannelUpdate to client,
 * 				by extracting the PresetChannelUpdate status
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSXMPresetChannelPopulate(midw_ext_fi_tcl_PresetListEntry oSXMPresetListEntry , midw_fi_tcl_SXMPresetListEntry &oPresetListEntry)
{
	oPresetListEntry.ChannelActive = oSXMPresetListEntry.ChannelActive;
	oPresetListEntry.ChannelID = oSXMPresetListEntry.ChannelID;
	oPresetListEntry.ChannelName = oSXMPresetListEntry.ChannelName;
	oPresetListEntry.ServiceID = oSXMPresetListEntry.ServiceID;
	oPresetListEntry.ChannelNameAvail  = oSXMPresetListEntry.ChannelNameAvail;
	oPresetListEntry.ChnGraphicAvail.enType = (midw_fi_tcl_e8_Graphics::tenType)oSXMPresetListEntry.ChnGraphicAvail.enType;
	oPresetListEntry.IsSmartFavorite = oSXMPresetListEntry.IsSmartFavorite;
	oPresetListEntry.IsAvailable = oSXMPresetListEntry.IsAvailable;
	oPresetListEntry.IsMature = oSXMPresetListEntry.IsMature;
	oPresetListEntry.IsSkipped = oSXMPresetListEntry.IsSkipped;
	oPresetListEntry.IsLocked = oSXMPresetListEntry.IsLocked;

	ETG_TRACE_USR4(("vSXMPresetChannelPopulate, ChannelID:%d",oPresetListEntry.ChannelID));
	ETG_TRACE_USR4(("vSXMPresetChannelPopulate, ServiceID:%d",oPresetListEntry.ServiceID));

}


/*************************************************************************
 * FUNCTION:    vUpdateSXMPresetList
 *
 * DESCRIPTION: Sends status update for GetPresetList to client,
 * 				by extracting the GetPresetList result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateSXMPresetList(amt_tclServiceData* poMessage)
{
	if((m_poclConfigInterface == nullptr) || (m_potunmstr_MsgFromHMI == nullptr) || (poMessage == nullptr))
	{
		return;
	}
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		if(bStartUpFlag)
		{
			Dec_m_u8SXMStartUp_HMI_Update();
		}
		ETG_TRACE_USR4(("PresetList::Update->SXM PresetList"));

		midw_ext_sxm_audiofi_tclMsgGetPresetListMethodResult oMsgResult;
		m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMsgResult);

	    if (oMsgResult.PresetChannels.ChannelList.size() > 0)
	    {
	    	tU8 u8index = 0;
	        for (auto it:oMsgResult.PresetChannels.ChannelList)
	        {
	            if (it.ServiceID != 0)
	            {
					midw_fi_tcl_PresetList oPresetListEntry;
					vSXMPresetListPopulate(it, oPresetListEntry);
					oPresetListEntry.Element_ID = u8index+1;
					oStatusMixed.ListOfStations.at(u8index) = oPresetListEntry;
	            }
				u8index++;
	        }
	    }

		vSendMixedPresetList();
	}
}


/*************************************************************************
 * FUNCTION:    vSXMPresetListPopulate
 *
 * DESCRIPTION: update for PresetListUpdate to client,
 * 				by extracting the GetPresetList result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSXMPresetListPopulate(midw_ext_fi_tcl_PresetListEntry oSXMPresetListEntry , midw_fi_tcl_PresetList &oPresetListEntry)
{
	oPresetListEntry.Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_SXM;
	oPresetListEntry.SXMSMSlib_PresetListEntry.ChannelActive = oSXMPresetListEntry.ChannelActive;
	oPresetListEntry.SXMSMSlib_PresetListEntry.ChannelID = oSXMPresetListEntry.ChannelID;
	oPresetListEntry.SXMSMSlib_PresetListEntry.ChannelName = oSXMPresetListEntry.ChannelName;
	oPresetListEntry.SXMSMSlib_PresetListEntry.ServiceID = oSXMPresetListEntry.ServiceID;
	oPresetListEntry.SXMSMSlib_PresetListEntry.ChannelNameAvail  = oSXMPresetListEntry.ChannelNameAvail;
	oPresetListEntry.SXMSMSlib_PresetListEntry.ChnGraphicAvail.enType = (midw_fi_tcl_e8_Graphics::tenType)oSXMPresetListEntry.ChnGraphicAvail.enType;
	oPresetListEntry.SXMSMSlib_PresetListEntry.IsSmartFavorite = oSXMPresetListEntry.IsSmartFavorite;
	oPresetListEntry.SXMSMSlib_PresetListEntry.IsAvailable = oSXMPresetListEntry.IsAvailable;
	oPresetListEntry.SXMSMSlib_PresetListEntry.IsMature = oSXMPresetListEntry.IsMature;
	oPresetListEntry.SXMSMSlib_PresetListEntry.IsSkipped = oSXMPresetListEntry.IsSkipped;
	oPresetListEntry.SXMSMSlib_PresetListEntry.IsLocked = oSXMPresetListEntry.IsLocked;
}

#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
/*************************************************************************
 * FUNCTION:    vUpdateSXM360LPresetList
 *
 * DESCRIPTION: Extracts the received preset list and forwards to client
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateSXM360LPresetList(amt_tclServiceData* poMessage)
{
	if((m_poclConfigInterface == NULL) || (m_potunmstr_MsgFromHMI == NULL) || (poMessage == NULL))
	{
		return;
	}
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart oMethodStart;
		m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodStart);

		switch(oMethodStart.Preset_Action.enType)
		{
			case midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL:
			case midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE:
			case midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_GETPRESETLIST:
			case midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE:
			case midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL:
			{
				vSendSXM360LPresetList(oMethodStart);

				if(oMethodStart.Preset_Action.enType != midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_GETPRESETLIST)
				{
					vSendSXMPresetActionMethodResult((tU8)oMethodStart.Preset_Action.enType , oMethodStart.Status);
				}
				break;
			}
			default:
			{
				ETG_TRACE_USR4(("vSendSXM360LPresetList, invalid option"));
				break;
			}

		}
	}
}


/*************************************************************************
 * FUNCTION:    vSendSXM360LPresetList
 *
 * DESCRIPTION: Extracts the received preset list and forwards to client
 *
 * PARAMETER:    midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart oMethodStart
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSendSXM360LPresetList(midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart oMethodStart)
{
    if (oMethodStart.PresetList.size() > 0)
    {
		if(bStartUpFlag)
		{
			Dec_m_u8SXMStartUp_HMI_Update();
		}
		ETG_TRACE_USR4(("vSendSXM360LPresetList::Update->SXM360L PresetList"));

		if(m_ePresetReguest == NormalPresetDeleteAll)
		{
			ETG_TRACE_USR4(("vSendSXM360LPresetList::Update->SXM360L PresetList PresetReguest=%d",
				ETG_CENUM(enPresetReguest,m_ePresetReguest)));
			Dec_m_u8SXMStartUp_HMI_Update();
			vSendMixedPresetList();
			return;
		}
		
    	tU8 u8index = 0;
        for (auto it:oMethodStart.PresetList)
        {
            if (it.PresetElemID != 0)
            {
				midw_fi_tcl_PresetList oPresetListEntry;
				vSXM360LPresetListPopulate(it, oPresetListEntry);
				oPresetListEntry.Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_SXM;
				oStatusMixed.ListOfStations.at(u8index) = oPresetListEntry;
            }
            else if((m_ePresetReguest == NormalPresetDelete) && (m_u8ElemID_Delete == (u8index + 1)))
            {
            	midw_fi_tcl_PresetList oPresetListEntry;
				m_ePresetReguest = None;
				m_u8ElemID_Delete = 0;
				vSXM360LPresetListPopulate(it, oPresetListEntry);
				oPresetListEntry.Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
				oStatusMixed.ListOfStations.at(u8index) = oPresetListEntry;
            }
            else
            {
            	// no operation
            }
			u8index++;
        }
		
		vSendMixedPresetList();
	}

}


/*************************************************************************
 * FUNCTION:    vSXM360LPresetListPopulate
 *
 * DESCRIPTION: Extracts the received preset list and forwards to client
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSXM360LPresetListPopulate(midw_fi_tcl_SXMPresetEntry &oSXMPresetListEntry , midw_fi_tcl_PresetList &oPresetListEntry)
{
	oPresetListEntry.Element_ID = (tU8)(oSXMPresetListEntry.PresetIndex+1);
	oPresetListEntry.Key = oSXMPresetListEntry.Key;
	oPresetListEntry.PresetType = oSXMPresetListEntry.PresetType;
	oPresetListEntry.SXM360L_PresetListEntry = oSXMPresetListEntry.ChannelAttributes;
}

#endif

/*************************************************************************
 * FUNCTION:    enCovListToBand
 *
 * DESCRIPTION: Converts List to midw_fi_tcl_e8_Band Type
 *
 * PARAMETER:    u8List
 *
 * RETURNVALUE:  enBand
 *************************************************************************/
midw_fi_tcl_e8_Band tunmstr_Preset_Handler::enCovListToBand(tU8 u8List, tU32 u32FRQ, enModulationType u8Modulation)const
{
	midw_fi_tcl_e8_Band enBand;
	enBand.enType=(midw_fi_tcl_e8_Band::tenType)TUNMSTR_SRCCHG_INVALID;
	switch(u8List)
	{
	case midw_fi_tcl_e8_List::FI_EN_BANK_FM1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_FM2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_FM3:
      case midw_fi_tcl_e8_List::FI_EN_BANK_FMAST:
	{
		enBand.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM;
		break;
	}
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW3:
    case midw_fi_tcl_e8_List::FI_EN_BANK_AM_AST:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MWAST:
	{
		enBand.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
		break;
	}
    case midw_fi_tcl_e8_List::FI_EN_BANK_DRM1:
    case midw_fi_tcl_e8_List::FI_EN_BANK_DRM_AST:
   {
      enBand.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1;
   }
   break;
	case midw_fi_tcl_e8_List::FI_EN_BANK_DAB1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DAB2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DAB3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DABAST:
	{
		enBand.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
		break;
	}
 	case midw_fi_tcl_e8_List::FI_EN_BANK_MIX1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_MIX2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_MIX3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_MIX_AST:
    {
      enBand.enType = (midw_fi_tcl_e8_Band::tenType)u8GetBandFrmFRQ(u32FRQ,(tU8)u8Modulation);
      break;
    }
	default:
	{
		break;
	}
	}
	//ETG_TRACE_USR4(("enCovListToBand()->enBand=%d u8List=%d",enBand.enType,u8List));
	//	ETG_TRACE_USR4(("enCovListToBand()->enBand=%02x",
	//		ETG_CENUM(midw_fi_tcl_e8_Band,enBand.enType)));
	return enBand;
}

/*************************************************************************
 * FUNCTION:    vHandleDABPresetListMethodResult
 *
 * DESCRIPTION: Handles the method result of FID_DAB_S_GET_PRESET_LIST
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABPresetListMethodResult(amt_tclServiceData* poMessage)
{
	if((poMessage==NULL)||(m_poclConfigInterface == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}

	ETG_TRACE_USR4(("PresetList::DAB Method Result"));
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		vUpdateDABMixedPresetListResult(poMessage);
	}
	else
	{
		vUpdateDABNormalPresetListResult(poMessage);
	}
}

/*************************************************************************
 * FUNCTION:    vHandleDABPresetListStatus
 *
 * DESCRIPTION: Handles the Status of FID_DAB_S_GET_PRESET_LIST
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABPresetListStatus(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI==NULL)||(poMessage==NULL)||(m_poclConfigInterface == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus oStatusMsg;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);
	tU8 u8NoOfElements=oStatusMsg.u8NumberOfElements;
	ETG_TRACE_USR4(("PresetList::Update-> DAB NoOfElements:%d",u8NoOfElements));
	if(u8NoOfElements == 0)
	{
		return;
	}
	tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
	if(blIsmixedPreset==TRUE)
	{
		vUpdateDABMixedPresetListStatus(poMessage);
	}
	else
	{
		vUpdateDABNormalPresetListStatus(poMessage);
	}
}


/*************************************************************************
 * FUNCTION:    vUpdateDABNormalPresetListStatus
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_DAB_S_GET_PRESET_LIST result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateDABNormalPresetListStatus(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI==NULL)||(m_potunmstr_MsgToHMI==NULL)||(poMessage==NULL))
	{
		ETG_TRACE_USR4(("tunmstr_Preset_Handler::vUpdateDABNormalPresetListStatus, NULL pointer"));
		return;
	}

	ETG_TRACE_USR4(("PresetList::Update-> Normal DAB PresetList"));
	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus;
	midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus oStatusMsg;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);
	tU8 u8NoOfElements=oStatusMsg.u8NumberOfElements;
	for(int i=0;i<u8NoOfElements;i++)
	{
		midw_fi_tcl_PresetList oPresetList;
		midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement  = oStatusMsg.PresetList[i];
		vDABPresetListPopulate(oDABPresetListElement , oPresetList);
		oStatus.ListOfStations.push_back(oPresetList);
	}
	oStatus.List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_DAB1;
	m_potunmstr_MsgToHMI->vSend_g_PresetListStatus(oStatus);
#ifdef INCLUDE_PROFILE_MANAGER
	if(NULL == m_poPMClient)
	{
		return;

	}
	m_poPMClient->vIndividualTunerPresetListUpdate(oStatusMsg);
	if( 0 != m_PresetSaveElemementID )
	{
			std::vector<tU8> u8PresetID;
			u8PresetID.push_back(m_PresetSaveElemementID);
			if(0 != oStatusMsg.PresetList[m_PresetSaveElemementID - 1].u32Frequency )
			{
					m_poPMClient->vSendRadioSettingNotification(u8PresetID);
					m_PresetSaveElemementID = 0;
			}

	}
#endif

}
/*************************************************************************
 * FUNCTION:    vUpdateDABNormalPresetListResult
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_DAB_S_GET_PRESET_LIST result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateDABNormalPresetListResult(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI==NULL)||(m_potunmstr_MsgToHMI==NULL)||(poMessage==NULL))
	{
		ETG_TRACE_USR4(("tunmstr_Preset_Handler::vUpdateDABNormalPresetListResult, NULL pointer"));
		return;
	}

	ETG_TRACE_USR4(("tunmstr_Preset_Handler::vHandleDABPresetListMethodResult : Entered Normal Preset Section"));
	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus;
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult oMethodResult;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodResult);

	tU8 u8NoOfElements=oMethodResult.u8NumberOfElements;

	for(int i=0;i<u8NoOfElements;i++)
	{
		midw_fi_tcl_PresetList oPresetList;
		midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement  = oMethodResult.PresetList[i];
		vDABPresetListPopulate(oDABPresetListElement , oPresetList);
		oStatus.ListOfStations.push_back(oPresetList);
	}
	oStatus.List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_DAB1;
	m_potunmstr_MsgToHMI->vSend_g_PresetListStatus(oStatus);
}


/*************************************************************************
 * FUNCTION:    vUpdateDABMixedPresetListResult
 *
 * DESCRIPTION: Sends status update for FID_TUNMSTR_G_PRESET_LIST to client,
 * 				by extracting the FID_DAB_S_GET_PRESET_LIST result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdateDABMixedPresetListResult(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgFromHMI==NULL) || (poMessage==NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		NORMAL_M_ASSERT( poMessage != NULL );
		ETG_TRACE_USR4(("tunmstr_Preset_Handler::vUpdateDABMixedPresetListResult, NULL pointer"));
		return;
	}
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodResult oMethodResult;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oMethodResult);

	tU8 u8NoOfElements=oMethodResult.u8NumberOfElements;

	ETG_TRACE_USR4(("vUpdateDABMixedPresetListResult()->bStartUpFlag=%d",bStartUpFlag));
	ETG_TRACE_USR4(("vUpdateDABMixedPresetListResult()->u8NoOfElements = %d , m_u8TunerStartUp_HMI_Update = %d",u8NoOfElements,m_u8TunerStartUp_HMI_Update));

	if(bStartUpFlag)
	{
		Dec_m_u8StartUp_HMI_Update();
		for(int i=0;i<u8NoOfElements;i++)
		{
			ETG_TRACE_USR4(("vUpdateDABMixedPresetListResult()->u32Frequency=%d i=%d", oMethodResult.PresetList[i].u32Frequency, i));
			if((oMethodResult.PresetList[i].u32Frequency != 0))
			{
				midw_fi_tcl_PresetList oPresetList;
				midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement  = oMethodResult.PresetList[i];
				vDABPresetListPopulate(oDABPresetListElement , oPresetList);
				oStatusMixed.ListOfStations.at (oDABPresetListElement.u8PresetElementID -1) = oPresetList;
			}
		}
	}
	else
	{
		for(int i=0;i<u8NoOfElements;i++)
		{
			if(((oMethodResult.PresetList[i].u32Frequency != 0) && m_u8PresetBandActionPerformed.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
				|| ((m_ePresetReguest == NormalPresetDelete) && (oMethodResult.PresetList[i].u8PresetElementID == m_u8ElemID_Delete)))
			{
				midw_fi_tcl_PresetList oPresetList;
				midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement  = oMethodResult.PresetList[i];
				vDABPresetListPopulate(oDABPresetListElement , oPresetList);

				if((m_ePresetReguest == NormalPresetDelete) && (oMethodResult.PresetList[i].u8PresetElementID == m_u8ElemID_Delete))
				{
					m_ePresetReguest = None;
					m_u8ElemID_Delete = 0;
					oPresetList.Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
				}
				oStatusMixed.ListOfStations.at (oDABPresetListElement.u8PresetElementID -1) = oPresetList;
			}
		}

	}

	vSendMixedPresetList();
}


/*************************************************************************
 * FUNCTION:    vSendMixedPresetList
 *
 * DESCRIPTION: Sends mixed preset list to client,
 *
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSendMixedPresetList()
{
	if((m_potunmstr_MsgToHMI==NULL) || (m_poclConfigInterface == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	
	tU8 u8TunerStartUp_HMI_Update = 0;
	tU8 u8SXMStartUp_HMI_Update = 0;
	
	if(NormalPresetDeleteAll == m_ePresetReguest)
	{
		Dec_m_u8StartUp_HMI_Update();

		oStatusMixed.ListOfStations.clear();
		vUpdateMixedPresetListBandAsNone();
	}
	
	if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	{
		u8TunerStartUp_HMI_Update = m_u8TunerStartUp_HMI_Update;
		u8SXMStartUp_HMI_Update = m_u8SXMStartUp_HMI_Update;
		ETG_TRACE_USR4(("PresetList::Update-> PresetReguest=%d StartUpTunerHMIUpdate=%d StartUpSXMHMIUpdate=%d",
			ETG_CENUM(enPresetReguest,m_ePresetReguest),u8TunerStartUp_HMI_Update,u8SXMStartUp_HMI_Update));
	}
	else
	{
		u8TunerStartUp_HMI_Update = m_u8StartUp_HMI_Update;
		ETG_TRACE_USR4(("PresetList::Update-> PresetReguest=%d StartUpHMIUpdate=%d",
			ETG_CENUM(enPresetReguest,m_ePresetReguest),u8TunerStartUp_HMI_Update));
	}
	
	if ((u8TunerStartUp_HMI_Update == 0) && (u8SXMStartUp_HMI_Update == 0))
	{
		oStatusMixed.List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
		m_potunmstr_MsgToHMI->vSend_g_PresetListStatus(oStatusMixed);
#ifdef INCLUDE_PROFILE_MANAGER
		if (NULL != m_poPMClient)
		{
			m_poPMClient->vIndividualTunerPresetListUpdate(oStatusMixed);
		}
		m_bProfile_PresetOperation = false;
#endif
		if(NormalPresetDeleteAll == m_ePresetReguest)
		{
			m_ePresetReguest = None;
		}
	}
}




/*************************************************************************
 *
 * FUNCTION:    stGetPresetHandleRequest()
 *
 * DESCRIPTION:  Return the member variable related to preset handling
 *
 * PARAMETER:    PresetHandlingParam stPresetHandlingParam
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
stPresetHandlingReguest tunmstr_Preset_Handler::stGetPresetHandleRequest()const
{
	stPresetHandlingReguest oPresetHandling;
	oPresetHandling.blReguestPending=m_poStoreRequest.blReguestPending;
	oPresetHandling.eBand.enType=m_poStoreRequest.eBand.enType;
	oPresetHandling.eList.enType=m_poStoreRequest.eList.enType;
	oPresetHandling.u8Element_ID=m_poStoreRequest.u8Element_ID;
	oPresetHandling.ePresetAction.enType=m_poStoreRequest.ePresetAction.enType;
	ETG_TRACE_USR4(("stGetPresetHandleRequest()->blReguestPending=%d eBand=%d",oPresetHandling.blReguestPending,oPresetHandling.eBand.enType));
	ETG_TRACE_USR4(("eList=%d u8Element_ID=%d ePresetAction=%d",oPresetHandling.eList.enType,oPresetHandling.u8Element_ID,oPresetHandling.ePresetAction.enType));
	return oPresetHandling;
}
/*************************************************************************
 * FUNCTION:    vClearPreserHandleRequest()
 *
 * DESCRIPTION: Updates the member variable related to preset handling to default value
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vClearPreserHandleRequest()
{
	ETG_TRACE_USR4(("vClearPreserHandleRequest()"));
	m_poStoreRequest.blReguestPending=FALSE;
	m_poStoreRequest.eBand.enType=(midw_fi_tcl_e8_Band::tenType)TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.eList.enType=(midw_fi_tcl_e8_List::tenType)TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.u8Element_ID=TUNMSTR_SRCCHG_INVALID;
	m_poStoreRequest.ePresetAction.enType=(midw_fi_tcl_e8_Tun_PresetAction::tenType)TUNMSTR_SRCCHG_INVALID;
}
/*************************************************************************
 * FUNCTION:    vSendDemuteRequest()
 *
 * DESCRIPTION: Send De-mute request to ARL
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSendDemuteRequest()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(m_potunmstr_AudioClientHandler==NULL)
	{
		return;
	}
	//Once the fc_amfm tuner defines the mute interface the check will be removed.
	if(m_ePresetReguest==NormalPresetRecall)
	{
		m_potunmstr_AudioClientHandler->vSendDemuteRequest();
	}
#endif
}
/*************************************************************************
 * FUNCTION:    enGetPreserRequest()
 *
 * DESCRIPTION: returns the member variable m_ePresetReguest
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  m_ePresetReguest
 *************************************************************************/
enPresetReguest tunmstr_Preset_Handler::enGetPreserRequest()
{
	ETG_TRACE_USR4(("enGetPreserRequest()->m_ePresetReguest=%d",m_ePresetReguest));
	return m_ePresetReguest;
}
/*************************************************************************
 * FUNCTION:    vUpdatePresetRequestVar()
 *
 * DESCRIPTION: Updates the member variable m_ePresetReguest
 *
 * PARAMETER:    enPresetReguest oenPresetReguest)
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vUpdatePresetRequestVar(enPresetReguest oenPresetReguest)
{
	ETG_TRACE_USR4(("vUpdatePresetRequestVar()->oenPresetReguest=%d",oenPresetReguest));
	m_ePresetReguest=oenPresetReguest;
}
/*************************************************************************
 * FUNCTION:    vHandleDABpresetMethodResult()
 *
 * DESCRIPTION: Function to handle the DAB Preset handling FID's method result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vHandleDABpresetMethodResult(amt_tclServiceData* poMessage)
{
	if((poMessage ==NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		||(m_potunmstr_AudioClientHandler==NULL)
#endif
		)
	{
		NORMAL_M_ASSERT( poMessage != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		return;
	}
	tU16 u16FID=poMessage->u16GetFunctionID();
	ETG_TRACE_USR4(("vHandleDABpresetMethodResult()->u16FID=%d",u16FID));
	switch(u16FID)
	{
	case MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM:
		{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_AudioClientHandler->vSendDemuteRequest();
#endif
			break;
		}
	default:
		{
			break;
		}
	}
}

/*************************************************************************
 * FUNCTION:		vSendMsg()
 *
 * PARAMETER:		tU8 u8OpCode, fi_tclTypeBase&  oOutData
 *
 * RETURNVALUE:		tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler::vSendMsg(tU8 u8OpCode, fi_tclTypeBase&  oOutData)const
{
	if(m_potunmstr_MsgFromHMI==NULL)
	{
		return;
	}
	stSendCCAMsg ostSendCCAMsg;
	ostSendCCAMsg.u16DestAppID=m_u16SourceAppID;
	ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING;
	ostSendCCAMsg.u8OpCode=u8OpCode;
	ostSendCCAMsg.u16CmdCtr=m_u16CmdCounter;
	ostSendCCAMsg.u16RegID=m_u16RegID;
	m_potunmstr_MsgFromHMI->vSendMessage( ostSendCCAMsg,oOutData);
}

tVoid tunmstr_Preset_Handler::Update_tunmstr_bStartUpFlag(tBool Update)
{
	ETG_TRACE_USR4(("tunmstr_Preset_Handler::Update_tunmstr_bStartUpFlag()->StartUpFlag=%d",Update));
	bStartUpFlag = Update;
}

tVoid tunmstr_Preset_Handler::Conv_Mix_To_BandType (stPresetHandlingParam *oPresetHandlingParam)
{
	ETG_TRACE_USR4(("tunmstr_Preset_Handler::Conv_Mix_To_BandType"));
	switch(oPresetHandlingParam->u8Band)
		{
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
		{
			oPresetHandlingParam->u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM1;
			break;
		}
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
		{
			oPresetHandlingParam->u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1;
			break;
		}
		case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB:
		{
			oPresetHandlingParam->u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_DAB1;
			break;
		}
		default:
			break;
		}
}


tVoid tunmstr_Preset_Handler::Inc_m_u8StartUp_HMI_Update()
{
	if(m_u8StartUp_HMI_Update>=2)
	{
		m_u8StartUp_HMI_Update=0;
	}
	m_u8StartUp_HMI_Update++;
	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Inc_m_u8StartUp_HMI_Update : %d", m_u8StartUp_HMI_Update));
}


tVoid tunmstr_Preset_Handler::Dec_m_u8StartUp_HMI_Update()
{
	if(m_u8StartUp_HMI_Update==0)
	{
		return;
	}
	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Dec_m_u8StartUp_HMI_Update : %d", m_u8StartUp_HMI_Update));
	m_u8StartUp_HMI_Update--;
}


tVoid tunmstr_Preset_Handler::Inc_m_u8TunerStartUp_HMI_Update()
{
	m_u8TunerStartUp_HMI_Update = 1;
	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Inc_m_u8TunerStartUp_HMI_Update : %d", m_u8TunerStartUp_HMI_Update));
}


tVoid tunmstr_Preset_Handler::Dec_m_u8TunerStartUp_HMI_Update(tBool bResetStartUp_HMI_Update)
{
	if(bResetStartUp_HMI_Update == true)
	{
		m_u8TunerStartUp_HMI_Update = 0xFF;
		ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Dec_m_u8TunerStartUp_HMI_Update, reset startup update : %d", m_u8TunerStartUp_HMI_Update));
		return;
	}
		
	m_u8TunerStartUp_HMI_Update = 0;
	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Dec_m_u8TunerStartUp_HMI_Update : %d", m_u8TunerStartUp_HMI_Update));
}


tVoid tunmstr_Preset_Handler::Inc_m_u8SXMStartUp_HMI_Update()
{
	m_u8SXMStartUp_HMI_Update = 1;
	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Inc_m_u8SXMStartUp_HMI_Update : %d", m_u8SXMStartUp_HMI_Update));
}


tVoid tunmstr_Preset_Handler::Dec_m_u8SXMStartUp_HMI_Update(tBool bResetStartUp_HMI_Update)
{
	if(bResetStartUp_HMI_Update == true)
	{
		m_u8SXMStartUp_HMI_Update = 0xFF;
		ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Dec_m_u8SXMStartUp_HMI_Update, reset startup update : %d", m_u8SXMStartUp_HMI_Update));
		return;
	}
		
	m_u8SXMStartUp_HMI_Update = 0;
	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: Dec_m_u8SXMStartUp_HMI_Update : %d", m_u8SXMStartUp_HMI_Update));
}


//tVoid tunmstr_Preset_Handler::Send_HMIUpdate_Flag()
//{
//	bHMI_Update_Flag = TRUE;
//}

/*************************************************************************
 * FUNCTION:		u8GetBandFrmFRQ()
 *
 * PARAMETER:		Get Band value from FRQ
 *
 * RETURNVALUE:		tVoid
 *************************************************************************/
tU8 tunmstr_Preset_Handler:: u8GetBandFrmFRQ(tU32 u32Frequency, tU8 u8Modulation)const
{
  tU8 u8Band=0xFF;
	if(m_poclConfigInterface == NULL)
	{
			ETG_TRACE_USR4((" tunmstr_Preset_Handler:: u8GetBandFrmFRQ, Null pointer"));
			NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
			return TUNMSTR_SRCCHG_INVALID;
	}

     if(u32Frequency == 0)
     {
	return u8Band;
     }
     if (u32Frequency>=(unsigned int)(m_poclConfigInterface->u32GetConfigData("LowFM")) && u32Frequency<=(unsigned int)(m_poclConfigInterface->u32GetConfigData("HighFM")))
       {
       u8Band=(tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM;
       }

	 else if (u32Frequency>=(unsigned int)(m_poclConfigInterface->u32GetConfigData("LowMW")) && u32Frequency<=(unsigned int)(m_poclConfigInterface->u32GetConfigData("HighMW")))
		{
			 if(u8Modulation == DRM_MODULATION_TYPE)
			 {
				 u8Band=(tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1;
			 }
			 else
			 {
				 u8Band=(tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
			 }
		}
   else  if (u32Frequency>=(unsigned int)(m_poclConfigInterface->u32GetConfigData("LowLW")) && u32Frequency<=(unsigned int)(m_poclConfigInterface->u32GetConfigData("HighLW")))
        {
        u8Band=(tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW;
        } 
   else 
     {
	   ETG_TRACE_USR4(("tunmstr_Preset_Handler::u8GetBandFrmFRQ , invalid"));
     }
   

 return(u8Band);
}


/*************************************************************************
 * FUNCTION:		vUpdateMixedPresetList()
 *
 * PARAMETER:		None
 *
 * RETURNVALUE:		tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler:: vUpdateMixedPresetListBandAsNone()
{
	if(m_poclConfigInterface == NULL)
	{
		NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
		return;
	}

	ETG_TRACE_USR4((" tunmstr_Preset_Handler:: vUpdateMixedPresetList"));
	oStatusMixed.ListOfStations.clear();

	for(tU8 i=0; i< (m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands")); i++)
	{
		midw_fi_tcl_PresetList cObj;
		cObj.Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
    	oStatusMixed.ListOfStations.push_back(cObj);
	}
}


/*************************************************************************
 * FUNCTION:		vClearPresetList()
 *
 * PARAMETER:		None
 *
 * RETURNVALUE:		tVoid
 *************************************************************************/
tVoid tunmstr_Preset_Handler:: vClearPresetList()
{
	ETG_TRACE_USR4(("PresetList::Clear PresetList"));
	oStatusMixed.ListOfStations.clear();
}

tVoid tunmstr_Preset_Handler::vHandleSystemSetForPresetList(tBool bSendPresetList)
{
	if ((NULL == m_poclConfigInterface) || (NULL == m_potunmstr_MsgToHMI))
	{
		return;
	}
	ETG_TRACE_USR4((" vHandleSystemSetForPresetList()"));
	if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
	{
		oStatusMixed.ListOfStations.clear();
		for(tU8 i=0; i< (m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands")); i++)
		{
			midw_fi_tcl_PresetList cObj;
			cObj.Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
			oStatusMixed.ListOfStations.push_back(cObj);
		}
		oStatusMixed.List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
		if(bSendPresetList)
		{
			//THis condition is only executed for personalization 
			//We will clear the list and wait till the final list we get from Individual clients.
			m_potunmstr_MsgToHMI->vSend_g_PresetListStatus(oStatusMixed);
		}
		
		if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
		{
			Dec_m_u8TunerStartUp_HMI_Update(true);
			Dec_m_u8SXMStartUp_HMI_Update(true);
			Update_tunmstr_bStartUpFlag(true);
		}
	}
}

tVoid tunmstr_Preset_Handler::vHandleSystemSetFinishForPresetList()
{
	ETG_TRACE_USR4((" vHandleSystemSetFinishForPresetList() StartUpHMIUpdate = %d",m_u8StartUp_HMI_Update));
	m_u8StartUp_HMI_Update = 0;
	/*During system set, don't request for the AMFM/DAB presetlist.
	 *After the switch user/default setting, the respective component will send the status msg.
	 */
	Update_tunmstr_bStartUpFlag(true);
}


tVoid tunmstr_Preset_Handler::vSendEmptyPresetlistUpdate()
{
	if((NULL==m_poclConfigInterface) || (NULL==m_potunmstr_MsgToHMI))
	{
		return;
	}
	if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
	{
		ETG_TRACE_USR4((" vSendPresetlistUpdate() size=%d",(int)oStatusMixed.ListOfStations.size()));
		for(tU8 u8index = 0 ; u8index < oStatusMixed.ListOfStations.size() ; u8index++)
		{
			if(((oStatusMixed.ListOfStations.at(u8index).Frequency>=m_poclConfigInterface->u32GetConfigData("LowLW")) && (oStatusMixed.ListOfStations.at(u8index).Frequency<=m_poclConfigInterface->u32GetConfigData("HighLW")) )||
				(((oStatusMixed.ListOfStations.at(u8index).Frequency>=m_poclConfigInterface->u32GetConfigData("LowMW"))) && (oStatusMixed.ListOfStations.at(u8index).Frequency<=m_poclConfigInterface->u32GetConfigData("HighMW"))))
			{
				oStatusMixed.ListOfStations.at(u8index).Frequency =0;
				midw_fi_tclString emptystring ="";
				oStatusMixed.ListOfStations.at(u8index).PSName=emptystring;
				oStatusMixed.ListOfStations.at(u8index).u32HDStationId=0;
				oStatusMixed.ListOfStations.at(u8index).sHDCallSign=emptystring;
				oStatusMixed.ListOfStations.at(u8index).e8HDAudioProgram.enType=midw_fi_tcl_e8_HDAudioProgram::FI_EN_TUN_MSTR_AUDIO_PROGRAM_ONE;
				oStatusMixed.ListOfStations.at(u8index).Band.enType=midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE; 
			}
		}
		m_potunmstr_MsgToHMI->vSend_g_PresetListStatus(oStatusMixed);
	}
}
tVoid tunmstr_Preset_Handler::vClearPresetDeleteElementID()
{
	m_u8ElemID_Delete = 0;
}


/*************************************************************************
 * FUNCTION:		e8GetPresetBand()
 *
 * PARAMETER:		tU8 u8PresetElemID
 *
 * RETURNVALUE:		midw_fi_tcl_e8_Band
 *************************************************************************/
midw_fi_tcl_e8_Band tunmstr_Preset_Handler::e8GetPresetBand(tU8 u8PresetElemID)
{
	midw_fi_tcl_e8_Band e8Band;
	e8Band.enType = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
	if((u8PresetElemID > 0) && (u8PresetElemID < oStatusMixed.ListOfStations.size()))
	{
		e8Band = oStatusMixed.ListOfStations.at(u8PresetElemID-1).Band;
	}
	ETG_TRACE_USR4((" e8GetPresetBand() band = %d", e8Band.enType));
	return e8Band;

}

/*************************************************************************
 * FUNCTION:		u8GetTunerStartUp_HMI_Update()
 *
 * PARAMETER:		
 *
 * RETURNVALUE:		tU8
 *************************************************************************/
tU8 tunmstr_Preset_Handler::u8GetTunerStartUp_HMI_Update()
{
	ETG_TRACE_USR4((" u8GetTunerStartUp_HMI_Update() m_u8TunerStartUp_HMI_Update = %d", m_u8TunerStartUp_HMI_Update));
	return m_u8TunerStartUp_HMI_Update;

}

/*************************************************************************
 * FUNCTION:		u8GetSXMStartUp_HMI_Update()
 *
 * PARAMETER:		
 *
 * RETURNVALUE:		tU8
 *************************************************************************/
tU8 tunmstr_Preset_Handler::u8GetSXMStartUp_HMI_Update()
{
	ETG_TRACE_USR4((" u8GetSXMStartUp_HMI_Update() m_u8SXMStartUp_HMI_Update = %d", m_u8SXMStartUp_HMI_Update));
	return m_u8SXMStartUp_HMI_Update;
}

#ifdef INCLUDE_PROFILE_MANAGER
tVoid tunmstr_Preset_Handler::vSetProfile_PresetOperation()
{
	m_bProfile_PresetOperation = true;
	ETG_TRACE_USR4((" vSetProfile_PresetOperation() m_bProfile_PresetOperation=%d",m_bProfile_PresetOperation));
}
#endif
