/************************************************************************
 * FILE:           tunmstr_MuteHandler.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    CCA messages sent to HMI are implemented in this file.
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date     		 | Author                       | Modification
 *  Jan 2, 2014      | auj1kor					  	| initial version

 *************************************************************************/

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"


#include "tunmstr_MuteHandler.h"
#include "tunermaster_main.h"
#include "tunmstr_AudioClientHandler.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChg_Defines.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#include "tunmstr_TunerClientHandler.h"
#include "tunmstr_Preset_Handler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_MuteHandler.cpp.trc.h"
#endif



/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::tunmstr_MuteHandler( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_MuteHandler::tunmstr_MuteHandler()
{
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_AudioClientHandler = NULL;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_ptunmstr_Preset_Handler = NULL;
	m_u8MuteStatus = 0xFF;
	m_u8DABMuteStatus = 0xFF;
	m_bMuteReq = FALSE;
	m_bDABMuteReq = FALSE;
	bMute_Interrupt = FALSE;
	bDABMute_Interrupt = FALSE;
}//End of constructor


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::~tunmstr_MuteHandler( )
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_MuteHandler::~tunmstr_MuteHandler( )
{
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_AudioClientHandler = NULL;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_ptunmstr_Preset_Handler = NULL;
	m_u8MuteStatus = 0xFF;
	m_u8DABMuteStatus = 0xFF;
	m_bMuteReq = FALSE;
	m_bDABMuteReq = FALSE;
	bMute_Interrupt = FALSE;
	bDABMute_Interrupt = FALSE;
}//End of Destructor


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_TunerClientHandler
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MuteHandler::vSet_tunmstr_TunerClientHandler( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler)
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler= ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_TunerClientHandler != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::vSet_tunmstr_AudioClientHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_AudioClientHandler
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_MuteHandler::vSet_tunmstr_AudioClientHandler_Ptr( tunmstr_AudioClientHandler* potunmstr_AudioClientHandler )
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = potunmstr_AudioClientHandler;
	}
	else
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT ( potunmstr_AudioClientHandler != NULL );
#endif
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_SrcChgManager
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_MuteHandler::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = potunmstr_SrcChgManager;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_SrcChgManager != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_MsgFromHMI
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MuteHandler::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI= ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgFromHMI != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MuteHandler::vSet_tunmaster_DABClient_Handler( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_DABClient_Handler
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MuteHandler::vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler )
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler= ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_DABClient_Handler != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_Preset_Handler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer m_ptunmstr_Preset_Handler
 *
 * PARAMETER:   tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_MuteHandler::vSet_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_ptunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MuteHandler::vSend_TunerMuteRequest
 *
 *DESCRIPTION: Funtion to handle property FID_TUN_G_MUTE_REQUEST
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vHandle_TunerMuteRequest(amt_tclServiceData* poMessage )
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_MsgFromHMI == NULL) || (m_potunmstr_AudioClientHandler == NULL)
			|| (m_potunmstr_SrcChgManager == NULL) || (m_potunmstr_TunerClientHandler == NULL)
			||(poMessage == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}

	midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus oStatusMsg;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);

	tBool bMute = oStatusMsg.bMute;
	tU8 u8Attenuation = oStatusMsg.u8Attenuation;
	tBool bMuteInterupt = oStatusMsg.bMute_Interrupt;

	ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), MuteState: %d ,Attenuation: %d",
						bMute,u8Attenuation));

	if(bMute == true)
	{
		if(m_potunmstr_SrcChgManager->u8GetTunerState() != TUNMSTR_SRCCHG_INPROGESS)
		{
			/*if(bMute_Interrupt == true)
			{
				ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), Load Request"));
				m_potunmstr_SrcChgManager->vSetTunerState(TUNMSTR_SRCCHG_INPROGESS);
			}*/
			if(bMuteInterupt)
			{
				ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), Mute requested for preset load or stationlist elem load"));
				m_potunmstr_SrcChgManager->vSetTunerState(TUNMSTR_SRCCHG_INPROGESS);
			}
			vSend_TunerMuteRequest();
		}
		else
		{
			ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), src change request on going"));
			if(bMuteInterupt)
			{
				m_potunmstr_TunerClientHandler->vSend_s_MuteState();
			}
		}
	}
	else
	{
		if(bMuteInterupt)
		{
			ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), De-mute request obtained for preset recall/Station List elem load complete, \
			                      but handle the next stored request"));
		}
		else
		{
			if(m_bMuteReq == false)
			{
				ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), Audio already de-muted"));
			}
			else
			{
				ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), send de-mute request to audio"));
				m_u8MuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE;
                m_potunmstr_AudioClientHandler->vSendMuteState(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(m_potunmstr_SrcChgManager->u8GetCurrentSource()),\
						ARL_EN_MUTEACTION_DEMUTE,ARL_EN_MUTE_REASON_TRACK_START);
			}
		}

	}
#endif
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MuteHandler::vSend_TunerMuteRequest
 *
 *DESCRIPTION: Send Mute request to Audio
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vSend_TunerMuteRequest()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_AudioClientHandler == NULL) || (m_potunmstr_SrcChgManager == NULL)
			|| (m_potunmstr_TunerClientHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		return;
	}

	if(m_u8MuteStatus == TUNMSTR_SRCCHG_MUTESTATUS_MUTE)  // Mute request already sent to Audio
	{
		if(m_bMuteReq == true)                            // Mute response obtained from audio for Mute
		{
			ETG_TRACE_USR4((" vSend_MuteRequest(), send audio muted status"));
			m_potunmstr_TunerClientHandler->vSend_s_MuteState();
		}
		else
		{
			ETG_TRACE_USR4((" vSend_MuteRequest(), mute request already sent to audio and waiting for response"));
		}
	}
	else
	{
		ETG_TRACE_USR4((" vSend_MuteRequest(), send mute request to audio"));
		m_u8MuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_MUTE;
        m_potunmstr_AudioClientHandler->vSendMuteState(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(m_potunmstr_SrcChgManager->u8GetCurrentSource()),\
				ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_TRACK_START);
	}
#endif
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MuteHandler::vSend_DABMuteRequest
 *
 *DESCRIPTION: Funtion to handle Mute/De-Mute request
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vHandle_DABMuteRequest(amt_tclServiceData* poMessage )
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_MsgFromHMI == NULL) || (m_potunmstr_AudioClientHandler == NULL)
			|| (m_potunmstr_DABClient_Handler == NULL) ||(poMessage == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}

	midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus oStatus;
	m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatus);

	tBool blSource = oStatus.bTa;          // DAB or DABTA
	tBool blState = oStatus.bRequestMute; // Mute or De-Mute
	tBool bMuteInterupt = oStatus.bMute_Interrupt;

	switch(blSource)
	{
		case SRC_DABTA:
		{
			if(blState == true) //Mute
			{
				if(m_potunmstr_SrcChgManager->u8GetDABState() != TUNMSTR_SRCCHG_INPROGESS)
				{
					if(bMuteInterupt)
					{
						ETG_TRACE_USR4((" vHandle_DABMuteRequest(), Mute requested for preset load or stationlist elem load"));
						m_potunmstr_SrcChgManager->vSetDABState(TUNMSTR_SRCCHG_INPROGESS);
					}

					vSend_DABMuteRequest(SRC_DABTA);
				}
				else
				{
					ETG_TRACE_USR4((" vHandle_DABMuteRequest(), src change request on going"));
				}
			}
			else  // De-Mute
			{
				if(bMuteInterupt)
				{
					ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), De-mute request obtained for preset recall/Station List elem load complete, \
					                      but handle the next stored request"));
				}
				else
				{
					if(m_bDABMuteReq == false)
					{
						ETG_TRACE_USR4((" vHandle_DABMuteRequest(), Audio already de-muted"));
					}
					else
					{
						ETG_TRACE_USR4((" vHandle_DABMuteRequest(), send de-mute request to audio"));
						m_u8DABMuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE;
						m_potunmstr_AudioClientHandler->vSendMuteState(ARL_SRC_DABTA
								  ,ARL_EN_MUTEACTION_DEMUTE,ARL_EN_MUTE_REASON_TRACK_START);
					}
				}
			}
			break;
		}
		case SRC_DAB:
		{
			if(blState == true)
			{
				if(m_potunmstr_SrcChgManager->u8GetDABState() != TUNMSTR_SRCCHG_INPROGESS)
				{
					if(bMuteInterupt)
					{
						ETG_TRACE_USR4((" vHandle_DABMuteRequest(), Mute requested for preset load or stationlist elem load"));
						m_potunmstr_SrcChgManager->vSetDABState(TUNMSTR_SRCCHG_INPROGESS);
					}

					vSend_DABMuteRequest(SRC_DAB);
				}
				else
				{
					ETG_TRACE_USR4((" vHandle_DABMuteRequest(), src change request on going"));
				}
			}
			else
			{
				if(bMuteInterupt)
				{
					ETG_TRACE_USR4((" vHandle_TunerMuteRequest(), De-mute request obtained for preset recall/Station List elem load complete, \
					                      but handle the next stored request"));
				}
				else
				{
					if(m_bDABMuteReq == false)
					{
						ETG_TRACE_USR4((" vHandle_DABMuteRequest(), Audio already de-muted"));
					}
					else
					{
						ETG_TRACE_USR4((" vHandle_DABMuteRequest(), send de-mute request to audio"));
						m_u8DABMuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE;
						m_potunmstr_AudioClientHandler->vSendMuteState(ARL_SRC_DAB
								  ,ARL_EN_MUTEACTION_DEMUTE,ARL_EN_MUTE_REASON_TRACK_START);
					}
				}
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4(("tunmstr_SrcChgManager::vSend_DABMuteRequest, invalid"));
			break;
		}
	}
#endif
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_DABMuteRequest
 *
 *DESCRIPTION: Function to send Mute request to Audio
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vSend_DABMuteRequest(tU8 u8Source)
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_AudioClientHandler == NULL) || (m_potunmstr_DABClient_Handler == NULL)
			|| (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}

	if(m_u8DABMuteStatus == TUNMSTR_SRCCHG_MUTESTATUS_MUTE)  // Mute request already sent to Audio
	{
		if(m_bDABMuteReq == true)                            // Mute response obtained from audio for Mute
		{
			ETG_TRACE_USR4((" vSend_DABMuteRequest(), send audio muted state"));
			m_potunmstr_DABClient_Handler->vSend_s_Set_Mute_State(u8Source, TUNMSTR_SRCCHG_MUTESTATUS_MUTE);
		}
		else
		{
			ETG_TRACE_USR4((" vSend_DABMuteRequest(), mute request already sent to audio but waiting for response"));
		}
	}
	else
	{
		ETG_TRACE_USR4((" vSend_DABMuteRequest(), send mute request to audio"));
		m_u8DABMuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_MUTE;
		if(u8Source == SRC_DABTA)
		{
			m_potunmstr_AudioClientHandler->vSendMuteState(ARL_SRC_DABTA
					,ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_TRACK_START);
		}
		else
		{
			m_potunmstr_AudioClientHandler->vSendMuteState(ARL_SRC_DAB
					,ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_TRACK_START);
		}
	}
#endif
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_TunerMuteState
 *
 *DESCRIPTION: Function to Handle Mute/De-Mute response from Audio
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vSend_TunerMuteState(tBool blMuteState)
{
	if((m_potunmstr_SrcChgManager == NULL) || (m_potunmstr_TunerClientHandler == NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
		)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		return;
	}

    ETG_TRACE_USR4(("tunmstr_MuteHandler::vSend_TunerMuteState, blMuteState=%d m_u8MuteStatus=%d",
                        blMuteState, m_u8MuteStatus));

	if((blMuteState == TUNMSTR_SRCCHG_MUTESTATUS_MUTE) && (blMuteState == m_u8MuteStatus))
	{
		ETG_TRACE_USR4((" vSend_TunerMuteState(), send mute response"));
		m_bMuteReq = true;
		m_potunmstr_TunerClientHandler->vSend_s_MuteState();
	}
	else if((blMuteState == TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE) && (blMuteState == m_u8MuteStatus)
			&& (m_bMuteReq == true))
	{
		ETG_TRACE_USR4((" vSend_TunerMuteState(), handle De-Mute response"));
		m_bMuteReq = false;
		vHandle_TunerStoredRequests();
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vSend_TunerMuteState, invalid"));
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vHandle_TunerStoredRequests
 *
 *DESCRIPTION: Function to handle stored src change requests
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vHandle_TunerStoredRequests()
{
	if(m_potunmstr_SrcChgManager == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}

	if(m_potunmstr_SrcChgManager->u8GetTunerState() == TUNMSTR_SRCCHG_INPROGESS)
	{
		m_potunmstr_SrcChgManager->vSetTunerState(TUNMSTR_SRCCHG_FOREGROUND);

		if(m_potunmstr_SrcChgManager->m_u8InProgSrcActivity != TUNMSTR_SRCCHG_INVALID)
		{
			ETG_TRACE_USR4(("tunmstr_MuteHandler::vHandle_TunerStoredRequests"));

			m_potunmstr_SrcChgManager->vHandleTunerStateInProgress(m_potunmstr_SrcChgManager->m_u8InProgSource,
											m_potunmstr_SrcChgManager->m_u8InProgSrcActivity);

			m_potunmstr_SrcChgManager->m_u8InProgSource = TUNMSTR_SRCCHG_INVALID;
			m_potunmstr_SrcChgManager->m_u8InProgSrcActivity = TUNMSTR_SRCCHG_INVALID;

		}
	}

}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_DABMuteState
 *
 *DESCRIPTION: Function to Handle Mute/De-Mute response from Audio
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vSend_DABMuteState(tBool blSource,tBool blMuteState)
{
	if((m_potunmstr_DABClient_Handler == NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			|| (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}

	ETG_TRACE_USR4(("tunmstr_MuteHandler::vSend_DABMuteState"
			"blMuteState=%d blSource=%d",
			blMuteState, blSource));
	if((blMuteState == TUNMSTR_SRCCHG_MUTESTATUS_MUTE) && (blMuteState == m_u8DABMuteStatus))
	{
		ETG_TRACE_USR4((" vSend_DABMuteState(), send mute response"));
		m_bDABMuteReq = true;
		m_potunmstr_DABClient_Handler->vSend_s_Set_Mute_State(blSource,blMuteState);
	}
	else if((blMuteState == TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE) && (blMuteState == m_u8DABMuteStatus)
			&& (m_bDABMuteReq == true))
	{
		ETG_TRACE_USR4((" vSend_DABMuteState(), handle De-Mute response"));
		m_bDABMuteReq = false;
		vHandle_DABStoredRequests();
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vSend_DABMuteState, invalid"));
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vHandle_DABStoredRequests
 *
 *DESCRIPTION: Function to send Mute State
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vHandle_DABStoredRequests()
{
	if(m_potunmstr_SrcChgManager == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}

	if(m_potunmstr_SrcChgManager->u8GetDABState() == TUNMSTR_SRCCHG_INPROGESS)
	{
		m_potunmstr_SrcChgManager->vSetDABState(TUNMSTR_SRCCHG_FOREGROUND);

		if(m_potunmstr_SrcChgManager->m_u8InProgDABSrcActivity != TUNMSTR_SRCCHG_INVALID)
		{
			ETG_TRACE_USR4(("tunmstr_MuteHandler::vHandle_DABStoredRequests"));

			m_potunmstr_SrcChgManager->vHandleDABStateInProgress(m_potunmstr_SrcChgManager->m_u8InProgDABSource,
											m_potunmstr_SrcChgManager->m_u8InProgDABSrcActivity);

			m_potunmstr_SrcChgManager->m_u8InProgDABSource = TUNMSTR_SRCCHG_INVALID;
			m_potunmstr_SrcChgManager->m_u8InProgDABSrcActivity = TUNMSTR_SRCCHG_INVALID;

		}
	}

}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSendTunerDeMute_srcChange
 *
 *DESCRIPTION: Function to send DeMute if Audio Muted and a src change is done
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vSendTunerDeMute_srcChange()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_AudioClientHandler == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}
	if(m_bMuteReq == true)  // Mute response from Audio recieved
	{
		ETG_TRACE_USR4(("tunmstr_MuteHandler::vSendTunerDeMute_srcChange"));
		m_u8MuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE;
        m_potunmstr_AudioClientHandler->vSendMuteState(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(m_potunmstr_SrcChgManager->u8GetCurrentSource()),\
				ARL_EN_MUTEACTION_DEMUTE,ARL_EN_MUTE_REASON_TRACK_START);
	}
#endif
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSendDABDeMute_srcChange
 *
 *DESCRIPTION: Function to send DeMute if Audio Muted and a src change is done
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MuteHandler::vSendDABDeMute_srcChange()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_AudioClientHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		return;
	}

	ETG_TRACE_USR4(("tunmstr_MuteHandler::vSendDABDeMute_srcChange"));
	if(m_bDABMuteReq == true)   // Mute response from Audio recieved
	{
		ETG_TRACE_USR4(("tunmstr_MuteHandler::vSendDABDeMute_srcChange"));
		m_u8DABMuteStatus = TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE;
		m_potunmstr_AudioClientHandler->vSendMuteState(ARL_SRC_DAB
				,ARL_EN_MUTEACTION_DEMUTE,ARL_EN_MUTE_REASON_TRACK_START);
	}
#endif
}

