/************************************************************************
 * FILE:           tunmstr_AutoStoreHandler.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    Class to handle Auto store functionalities
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	 | Author                       | Modification
 * 02-05-2013	 | RBEI/ECV3Pallavi HN   	    | initial version
 *
 *************************************************************************/



//------------
// includes
//------------
#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


//---------------------------------------

//-------------------
// Internal includes
//-------------------

#include "fc_tunermaster_featureControl.h"

#include "tunermaster_main.h"
#include "tunermaster_Config.h"

#include "tunmstr_TunerClientHandler.h"
#include "tunmstr_AutoStorehandler.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunermaster_defines.h"
#include "tunmstr_MsgToHMI.h"
#include "kdsconfig/clConfigInterface.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_AutoStorehandler.cpp.trc.h"
#endif



/*************************************************************************
 *
 * FUNCTION: tunmstr_AutoStoreHandler::tunmstr_AutoStoreHandler(ccademo_tclApp* poGWMainApp)
 *
 * DESCRIPTION: constructor, creates object tunmstr_AutoStoreHandler - object
 *
 * PARAMETER: ccademo_tclApp* poGWMainApp: main - object of this application
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunmstr_AutoStoreHandler::tunmstr_AutoStoreHandler(tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl):
#else
tunmstr_AutoStoreHandler::tunmstr_AutoStoreHandler():
#endif
m_potunmstr_SrcChgManager(NULL),\
m_potunmstr_MsgFromHMI(NULL),\
m_potunmstr_DABClient_Handler(NULL),\
m_potunmstr_TunerClientHandler(NULL),\
m_potunmaster_Config(NULL),\
m_potunmstr_MsgToHMI(NULL),\
m_potunmstr_Preset_Handler(NULL),\
m_poclConfigInterface(NULL)
				{
	 	 	 	 /* Assign Tuner main Application pointer */
				m_u16Cmd_Cntr = 0x00;
				m_blNormalAST_Request = FALSE;
				m_blInitialAST_Request = FALSE;
				m_u8ASTReq_ListID = 0xff;
				m_blAst_Status = FALSE;
				m_enInitiaAST_ProgressStatus = TunMstr_InitialAST_Invalid;
				m_u8Band_BeforeAST = 0xff;
				m_u16ASTRegId=AMT_C_U16_REGID_INVALID;

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				m_poArlImpl = poArlImpl;
#endif

				}

/*************************************************************************
 *
 * FUNCTION: tunmstr_AutoStoreHandler::~tunmstr_AutoStoreHandler( )
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tunmstr_AutoStoreHandler::~tunmstr_AutoStoreHandler( )
{  
	m_u16Cmd_Cntr = 0x00;
	m_blNormalAST_Request = FALSE;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmaster_Config = NULL;
	m_blAst_Status = FALSE;
	m_enInitiaAST_ProgressStatus = TunMstr_InitialAST_Invalid;
	m_u8Band_BeforeAST = 0xff;
	m_u16ASTRegId=AMT_C_U16_REGID_INVALID;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_Preset_Handler=NULL;
	m_poclConfigInterface = NULL;

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlImpl = NULL;
#endif

}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_SrcChgManager*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI= ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgFromHMI != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_SrcChgManager*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager= ( tunmstr_SrcChgManager* )potunmstr_SrcChgManager;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChgManager != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmaster_DABClient_Handler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_DABClient_Handler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler )
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler= ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_DABClient_Handler != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_TunerClientHandler( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler)
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler= ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_TunerClientHandler != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmaster_Config_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmaster_Config*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config= ( tunmaster_Config* )potunmaster_Config;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmaster_Config != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_MsgToHMI_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = potunmstr_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgToHMI != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * PARAMETER:    tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_Preset_Handler != NULL );
	}
}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSetNormalAST_Status(tBool blStatus)
{
	m_blNormalAST_Request = blStatus;
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSetInitialAST_Status( )
 *
 * DESCRIPTION:  
 * PARAMETER:    
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSetInitialAST_Status(tBool blStatus)
{
	m_blInitialAST_Request = blStatus;
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSetAST_ListID( )
 *
 * DESCRIPTION:  
 *
 * PARAMETER:    
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSetAST_ListID(tU8 u8ListID)
{
	 m_u8ASTReq_ListID = u8ListID;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tU8 tunmstr_AutoStoreHandler::u8GetAST_ListID() const
{
	return m_u8ASTReq_ListID;
}
 /*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::enGetInitialAST_ProgressStatus( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
enInitial_AutoStore_Status tunmstr_AutoStoreHandler::enGetInitialAST_ProgressStatus() const
{
	return m_enInitiaAST_ProgressStatus;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tBool tunmstr_AutoStoreHandler::blGetNormalAST_Request() const
{
	return m_blNormalAST_Request;
}
 
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::blGetAST_Status( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tBool tunmstr_AutoStoreHandler::blGetAST_Status() const
{
	return m_blAst_Status;
} 
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSetAST_Status( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:   blStatus
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSetAST_Status(tBool blStatus)
{
    m_blAst_Status = blStatus;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSet_tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Set pointer to pointer potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tBool tunmstr_AutoStoreHandler::m_blGetInitalAST_Request() const
{
	return m_blInitialAST_Request;
} 
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vSetCmd_Cntr( )
 *
 * DESCRIPTION: 
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSetCmd_Cntr(tU16 u16Cmd_Cntr)
{
	m_u16Cmd_Cntr=u16Cmd_Cntr;
}
/*************************************************************************
 * FUNCTION:     vSetAstRegID
 *
 * DESCRIPTION:  Update varaibel m_u16ASTRegId reg ID rx on method start for Auto store
 *
 * PARAMETER:    u16RegId
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_AutoStoreHandler::vSetAstRegID(tU16 u16RegId)
{
	m_u16ASTRegId=u16RegId;
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::u16GetCMd_Cntr( )
 *
 * DESCRIPTION: 
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 **************************************************************************/
tU16 tunmstr_AutoStoreHandler::u16GetCMd_Cntr()const
{
	return m_u16Cmd_Cntr;
}
/*************************************************************************
 * FUNCTION:     u16GetASTRegId()
 *
 * DESCRIPTION: retruns on the varaibel m_u16ASTRegId 
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  tU16
 **************************************************************************/
tU16 tunmstr_AutoStoreHandler::u16GetASTRegId()const
{
	return m_u16ASTRegId;
}
/*************************************************************************
 * FUNCTION:     u8GetAST_Type()
 *
 * DESCRIPTION: returns on the varaible u8AST_Type
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  tU8
 **************************************************************************/
tU8 tunmstr_AutoStoreHandler::u8GetAST_Type() const
{
    ETG_TRACE_USR4(("tunmstr_MsgFromHMI::u8GetAST_Type() NormalAST flag - %d InitialAST flag - %d", \
                    tU8(m_blNormalAST_Request), tU8(m_blInitialAST_Request)));

    tU8 u8AST_Type = 0;
    //check which type of autostore is active and return the type.
    if(blGetNormalAST_Request())
    {
        u8AST_Type = TUNMSTR_AST_NORMAL;
    }
    else if(m_blGetInitalAST_Request())
    {
        u8AST_Type = TUNMSTR_AST_INITAL;
    }
    else
    {
        ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::u8GetAST_Type-> no autostore is active"));
    }
    return u8AST_Type;
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vHandle_ASTRequest( )
 *
 * DESCRIPTION:  Handler for Auto store handling
 *
 * PARAMETER:    tBool blAST_Start, tU8 u8ListID, tU8 u8Type
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AutoStoreHandler::vHandle_ASTRequest(tBool blAST_Start, tU8 u8ListID, tU8 u8Type)
{
	ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandle_ASTRequest->  Status -> %d, Type ->%d",blAST_Start, u8Type));
	switch (u8Type)
	{
		case TUNMSTR_AST_NORMAL:
		{
			vHandleNormal_AST(blAST_Start,u8ListID);
			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandle_ASTRequest, Normal Auto store"));
		}break;
		case TUNMSTR_AST_INITAL:
		{
        vHandleInitial_AST(blAST_Start);
		ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandle_ASTRequest, Inital Auto store"));
		}break;
		default:
		break;
	}//end of switch
	
}//end of function

/*************************************************************************
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::vHandleNormal_AST( )
 *
 * DESCRIPTION:  Handler for Normal Auto store 
 *
 * PARAMETER:    tBool blAST_Start, tU8 u8ListID
 *
 * RETURNVALUE:  void
 *
***************************************************************************/
tVoid tunmstr_AutoStoreHandler::vHandleNormal_AST(tBool blAST_Start, tU8 u8ListID)
{

	if((m_potunmstr_DABClient_Handler == NULL) ||(m_potunmstr_SrcChgManager == NULL) || (m_potunmstr_MsgFromHMI == NULL) || (m_potunmstr_TunerClientHandler == NULL))
	{
			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandle_ASTRequest, Null pointer"));
			NORMAL_M_ASSERT (NULL != m_potunmstr_DABClient_Handler);
			NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
			NORMAL_M_ASSERT (NULL != m_potunmstr_MsgFromHMI);
			NORMAL_M_ASSERT (NULL != m_potunmstr_TunerClientHandler);
			return;
	}
	tU8 u8TunerState = 0xff;

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tU8 u8ActiveSource = m_poArlImpl->getActiveSource();
#else
	u8TunerState = m_potunmstr_SrcChgManager->u8GetTunerState();
	tU8 u8DABState = m_potunmstr_SrcChgManager->u8GetDABState();

	//tU8 u8Action = TUNMSTR_SRCCHG_INVALID;
	tU8 u8ActiveSource = m_potunmstr_SrcChgManager->u8GetCurrentSource();
#endif

	tU8 u8Source = u8ConvertList2Source(u8ListID);
	ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, u8TunerState = %d", u8TunerState));
	ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, u8ActiveSource = %d", u8ActiveSource));
    /**save the Autostore state (Normal Autostore flag is set to true)*/
    m_blNormalAST_Request = TRUE;
    m_blInitialAST_Request = FALSE;
    m_u8ASTReq_ListID = u8ListID;
    //set variable m_blAst_Status
    vSetAST_Status(blAST_Start);

	switch (u8ListID)
	{
	case (tU8) midw_fi_tcl_e8_List::FI_EN_BANK_FM1:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM2:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM3:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FMAST:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW2:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW3:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_AST:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW1:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW2:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DRM_AST:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DRM1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MWAST:
	{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		u8TunerState = clSessionControl::getInstance()->getActiveTunerState(tuner::common::AMFMTUNER);
		if(u8TunerState !=(tU8)tuner::common::TUNERTOFG) // If tuner is not in FG, 1st send tuner to FG
#else
		if(u8TunerState !=(tU8)TUNMSTR_SRCCHG_FOREGROUND)
#endif
		{
		
			//u8Action = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
    		// if current active band
			
			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, Tuner not in FG, AST request stored"));
		}
		else if(u8Source != u8ActiveSource)
		{
			// if tuner is in FG, and not tuned to requested band, then 1st request for band change then AST 

							//u8Action = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
							ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, Tuner is in FG, but band change required"));

		}// end of else if
			else
			{
			    /**send autostore status update to clients.*/
			    m_potunmstr_MsgToHMI->vSend_g_GetAutostoreStatus( blGetAST_Status(), u8GetAST_Type() );

				m_potunmstr_TunerClientHandler->vSend_s_AutoStore(u8ListID, blAST_Start);
				//u8Source = TUNMSTR_SRCCHG_INVALID;
				ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, Tuner in FG, AST request forwared"));
								// else just send AST message and clear source value.
			}// end of else
			
		}
	break;
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_DAB1:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_DAB2:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_DAB3:
	case (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_DABAST:
	
	{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		u8TunerState = clSessionControl::getInstance()->getActiveTunerState(tuner::common::DABTUNER);
		if((u8TunerState !=(tU8)tuner::common::TUNERTOFG) && (u8TunerState !=(tU8)tuner::common::SRCPAUSE)) // If tuner is not in FG, 1st send tuner to FG
#else
		if((u8DABState !=(tU8)TUNMSTR_SRCCHG_FOREGROUND) && (u8DABState !=(tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE))
#endif
				{

					//u8Action = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
		    		// if current active band

					ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, DAB not in FG, AST request stored"));
				}
		else if(u8Source != u8ActiveSource)
				{
					// if tuner is in FG, and not tuned to requested band, then 1st request for band change then AST

									//u8Action = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
									ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleNormal_AST, DAB is in FG, but Source change required"));

				}// end of else if
		else
				{

					/**send autostore status update to clients.*/
		    		m_potunmstr_MsgToHMI->vSend_g_GetAutostoreStatus( blGetAST_Status(), u8GetAST_Type() );

					m_potunmstr_DABClient_Handler->vSend_s_AutoStore(blAST_Start);
					//u8Source = TUNMSTR_SRCCHG_INVALID;
				}// end of else
		}break;
		default:
		break;
	}//end of switch

	/** Commented out as autostore method result is to be sent after preset list update */
//m_potunmstr_MsgFromHMI->vSendAST_MethodResult(u8Source,u8Action,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT );	
	
}//end of function

/************************************************************************* *
 *
 * FUNCTION:     tunmstr_AutoStoreHandler::u8ConvertList2Source( )
 *
 * DESCRIPTION:  Handler for Normal Auto store 
 *
 * PARAMETER:    tBool blAST_Start, tU8 u8ListID
 *
 * RETURNVALUE:  void
 *
***************************************************************************/

tU8 tunmstr_AutoStoreHandler::u8ConvertList2Source(tU8 u8ListID)const
{
	tU8 u8Source = TUNMSTR_SRCCHG_INVALID;
	
	switch (u8ListID)
	{
	case midw_fi_tcl_e8_List::FI_EN_BANK_FM1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_FM2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_FM3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_FMAST:
	{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		u8Source = (tU8)tuner::common::FM1;
#else
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM;
#endif

	}break;
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_AST:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MWAST:
	{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		u8Source = (tU8)tuner::common::AM;
#else
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM;
#endif

	
	}break;
	case midw_fi_tcl_e8_List::FI_EN_BANK_DAB1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DAB2:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DAB3:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DABAST: 
	{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		u8Source = (tU8)tuner::common::DAB;
#else
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
#endif

	
	}break;
	case midw_fi_tcl_e8_List::FI_EN_BANK_DRM1:
	case midw_fi_tcl_e8_List::FI_EN_BANK_DRM_AST:
	{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		u8Source = (tU8)tuner::common::DRM;
#else
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DRM;
#endif

	}break;
	//
	default:
	break;
	}//end of switch

	ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::u8ConvertList2Source, Source = %d", u8Source));
	return u8Source;
	
}//end of function

 /*************************************************************************
  *
  * FUNCTION:     tunmstr_AutoStoreHandler::vHandleInitialAST( )
  *
  * DESCRIPTION:  Handler for Normal Auto store 
  *
  * PARAMETER:    tBool blAST_Start, tU8 u8ListID
  *
  * RETURNVALUE:  void
  *
 ***************************************************************************/
 tVoid tunmstr_AutoStoreHandler::vHandleInitial_AST(tBool blAST_Start)
 {
	 if((m_potunmstr_SrcChgManager == NULL) ||(m_potunmstr_TunerClientHandler == NULL) || (m_poclConfigInterface == NULL))
 	{
 			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandle_ASTRequest, Null pointer"));
 			NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
 			NORMAL_M_ASSERT (NULL != m_potunmstr_TunerClientHandler);
 			NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
 			return;
 	}
	/* "InitialAutoStoreListId" parameter has been replaced by "PresetListMapping" in generic parameter set. Function has to be relooked into when a project uses initial AST*/
 	tU32 u32ASTLists = m_poclConfigInterface->u32GetConfigData("PresetListMapping");
    m_u8Band_BeforeAST = m_potunmstr_SrcChgManager->u8GetCurrentSource();
    m_blInitialAST_Request =  TRUE;
    m_blNormalAST_Request = FALSE;
    //set variable m_blAst_Status
    vSetAST_Status(blAST_Start);

	enAutostoreBank oenAutostoreBank=AST_NONE;
    // Get AST list IDS, Save active band before AST and set Initial AST status to TRUE
 	switch(u32ASTLists)
	{
		case TUNMSTR_INITIAL_AST_MIB_FMAMDAB:
 		{
 			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleInitial_AST, AST is required for 3 bands."));
 			if(m_u8Band_BeforeAST == (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM )
 			{
 				oenAutostoreBank=AST_AM_MW1;
 			}
 			else
 			{
				oenAutostoreBank=AST_FM1_DAB;
 			}
			break;
 		}// end of if(m_u8Band_BeforeAST == TUNMSTR_SRCCHG_SOURCE_TUN1FM )
		case TUNMSTR_INITIAL_AST_MIB_FMAM:
 		{
 				ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleInitial_AST, AST is required for 2 bands. "));
				if(m_u8Band_BeforeAST ==(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM)
 		 		{
					oenAutostoreBank=AST_AM_MW1;
 		 		}
	 			else
	 			{
					oenAutostoreBank=AST_FM1;	
	 			}
				break;
		}
		case TUNMSTR_INITIAL_AST_MIB_FM:
 		{
 		    /**send autostore status update to clients.*/
 		    m_potunmstr_MsgToHMI->vSend_g_GetAutostoreStatus(blGetAST_Status(), u8GetAST_Type());

 			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleInitial_AST, AST is required for 1 band only "));
 			m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM1, TRUE);
 			ETG_TRACE_USR4((" tunmstr_AutoStoreHandler::vHandleInitial_AST, AST request for FM  sent "));
 			 m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_Complete;
			 break;
 		}
		default:
		{
			break;
		}
	}
	if(oenAutostoreBank!=AST_NONE)
	{
	    /**send autostore status update to clients.*/
	    m_potunmstr_MsgToHMI->vSend_g_GetAutostoreStatus(blGetAST_Status(), u8GetAST_Type());
		vSendAutoStoreReq(oenAutostoreBank);
	}
}//end of function

 /*************************************************************************************
  *FUNCTION:    vHandleResult_ForInitialAST
  *
  *DESCRIPTION: Handler to hanle method result of Auto store. Actions performed is as mentioned below
  *							1) Check if Auto store request is complet; if completed then checked for band change requesed flag and act accordingly.
  *							2) If Auto store request is in Progress, send AST message for remaining bands and complete the AST.
  *
  *PARAMETER:    amt_tclServiceData *poMessage
  *
  *RETURNVALUE: None
  ************************************************************************************/
 tVoid tunmstr_AutoStoreHandler::vHandleResult_ForInitialAST()
 {
	 if((m_potunmstr_MsgToHMI == NULL) || (m_poclConfigInterface == NULL) || (m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_MsgFromHMI == NULL))
	 {
		 ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleResult_ForInitialAST,Null Pointer!!!"));
		 NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
			NORMAL_M_ASSERT (NULL != m_potunmstr_MsgToHMI);
			NORMAL_M_ASSERT (NULL != m_potunmstr_TunerClientHandler);
			NORMAL_M_ASSERT(NULL!= m_potunmstr_MsgFromHMI);
			return;
	 }
 	 	if(m_enInitiaAST_ProgressStatus == TunMstr_InitialAST_Complete)
 	{
 	 	tBool bBandChgRequired = (m_poclConfigInterface->u32GetConfigData("BandToTuneAfterInitialAutostore")) & 0x01;
 		//Update the variable with Band change required after initial AST
 		//And with 0x70(0111 0000)to extract Bits from 4 to 6 and shift Right 4 times to get the MSB to LSB
 	 	tU8   u8BandToTuneAfterInitialAutostore = (tU8)(((m_poclConfigInterface->u32GetConfigData("BandToTuneAfterInitialAutostore")) & 0x70)>>4);

 	 	if(!bBandChgRequired)
 		{
 			m_potunmstr_MsgToHMI->vSend_g_SourceChange(u8BandToTuneAfterInitialAutostore, TUNMSTR_SRCCHG_ACTION_ON);
 			ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForInitialAST:AST complete, Band change request sent"));
 			// If Band change after AST is true, then Request for Band change.
 		}
 		else
 		{
 			ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForInitialAST:AST complete no further action required!!!"));
 			// No action required
 		}
 		m_potunmstr_MsgFromHMI->vSendAST_MethodResult(TUNMSTR_SRCCHG_INVALID, TUNMSTR_SRCCHG_INVALID,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
 		m_blInitialAST_Request = FALSE;
 		m_u8Band_BeforeAST = 0xff;
 		// Update Initial AST staus as False and Band as Invalid.

 	}//if(m_enInitiaAST_ProgressStatus == TunMstr_InitialAST_Complete)
 	else
 	{
 		switch(m_u8Band_BeforeAST)
 		{
 		case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
 		{
 			m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1, TRUE);
 			 m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_Complete;

 			ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForInitialAST,Send AST request to AM !!!"));
 		}break;
		case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
 		{
 			m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM1, TRUE);
 			m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_Complete;
 			ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForInitialAST,Send AST request to FM !!!"));

 		}break;

		case TUNMSTR_SRCCHG_SOURCE_DAB:
 		{
 			m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1, TRUE);
 			 m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_Complete;
 			ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForInitialAST,Send AST request to AM !!!"));
 		}break;
		default:
			break;
 		}//end of switch
 	}
 }// end of Function

 /*************************************************************************************
  *FUNCTION:    vHandleResult_ForNormalAST
  *
  *DESCRIPTION: Handler to hanle method result of Auto store. Actions performed is as mentioned below
  *							Check if Auto store request is complet; if completed then recall the first preset.
  *
  *
  *PARAMETER:    amt_tclServiceData *poMessage
  *
  *RETURNVALUE: None
  ************************************************************************************/
 tVoid tunmstr_AutoStoreHandler::vHandleResult_ForNormalAST()
 {
	 if((m_poclConfigInterface == NULL) || (m_potunmstr_SrcChgManager == NULL)
			 || (m_potunmstr_MsgFromHMI == NULL) ||(NULL==m_potunmstr_Preset_Handler))
	 {
		ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForNormalAST,Null Pointer!!!"));
		NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
		NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
		NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
		NORMAL_M_ASSERT(NULL!= m_potunmstr_MsgFromHMI);
		NORMAL_M_ASSERT(NULL!= m_potunmstr_Preset_Handler);
		return;
	 }

	 tBool bPresetRecall = (m_poclConfigInterface->u32GetConfigData("BandToTuneAfterUserAutostore")) & 0x01;
     ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForNormalAST, source :%d , bPresetRecall : %d ",m_potunmstr_SrcChgManager->u8GetCurrentSource(), bPresetRecall));
	 	if(!bPresetRecall)
		{
	 		ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForNormalAST, send preset recall"));
	 		stPresetHandlingParam oPresetHandlingParam;
			oPresetHandlingParam.u8Element_ID = 0x01;


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForNormalAST, Current active src : %d", m_poArlImpl->getActiveSource()));
			oPresetHandlingParam.u8Band = m_poArlImpl->getActiveSource();
            switch(m_poArlImpl->getActiveSource())
#else
            oPresetHandlingParam.u8Band = m_potunmstr_SrcChgManager->u8GetCurrentSource();
            switch(m_potunmstr_SrcChgManager->u8GetCurrentSource())
#endif

            {
//pmn3kor : this change made to fix SUZUKI-19777 and ADR is taking care of doing preset recall after autostore.

//				case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
//				{
//					oPresetHandlingParam.u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FMAST;
//					m_potunmstr_Preset_Handler->vHandleTunerNormalPresetRecall(oPresetHandlingParam);
//					break;
//				}
//				case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
//				{
//					oPresetHandlingParam.u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_AST;
//					m_potunmstr_Preset_Handler->vHandleTunerNormalPresetRecall(oPresetHandlingParam);
//					break;
//				}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				case tuner::common::DAB:
#else
				case TUNMSTR_SRCCHG_SOURCE_DAB:
#endif
				{
					oPresetHandlingParam.u8Element_ID = TUNMSTR_DABAST_PRESET1;
					oPresetHandlingParam.u8Band = (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
					oPresetHandlingParam.u8List = (tU8)midw_fi_tcl_e8_List::FI_EN_BANK_DABAST;
					m_potunmstr_Preset_Handler->vHandleDABNormalPresetRecall(oPresetHandlingParam);
					break;
				}
				default:
				{
					ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vHandleResult_ForNormalAST, invalid source"));
					break;
				}
	 		}
		}
	 	m_potunmstr_MsgFromHMI->vSendAST_MethodResult(TUNMSTR_SRCCHG_INVALID, TUNMSTR_SRCCHG_INVALID,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
	 	m_blNormalAST_Request = FALSE;
}


 /*******************************************************************************
 *FUNCTION:    vSendAutoStoreReq
 *
 *DESCRIPTION: Function to send the request of Autostore to client based on Autostore bank
 *
 *PARAMETER:  enAutostoreBank oenAutostoreBank
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
 tVoid tunmstr_AutoStoreHandler::vSendAutoStoreReq(enAutostoreBank oenAutostoreBank)
{
	if((NULL==m_potunmstr_TunerClientHandler)||(NULL==m_potunmstr_DABClient_Handler))
	{
		return;
	}
	switch(oenAutostoreBank)
	{
	case AST_AM_MW1:
	{
		m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1, TRUE);
		m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_InPrg;
		break;
	}
	case AST_FM1:
	{
		m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM1, TRUE);
		m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_InPrg;
		break;
	}
	case AST_DAB:
	{
		m_potunmstr_DABClient_Handler->vSend_s_AutoStore(TRUE);
		m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_InPrg;
		break;
	}
	case AST_AM_MW1_DAB:
	{
		m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1, TRUE);
		m_potunmstr_DABClient_Handler->vSend_s_AutoStore(TRUE);
		m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_InPrg;
		break;
	}
	case AST_FM1_DAB:
	{
		m_potunmstr_TunerClientHandler->vSend_s_AutoStore((tU8)midw_fi_tcl_e8_List::FI_EN_BANK_FM1, TRUE);
		m_potunmstr_DABClient_Handler->vSend_s_AutoStore(TRUE);
		m_enInitiaAST_ProgressStatus =TunMstr_InitialAST_InPrg;
		break;
	}
	default:
	{
		break;
	}
	}
}
