/************************************************************************
* FILE:           tunmstr_Tmc_Trace.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    Trace defines are done in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date         | Author                          | Modification
* 04/10/2010   | CM-AI/PJ-VW36 ( RBEI )Pallavi   | initial version
* 25.04.13     | NGP1KOR  					     | First version of the G3g after porting from NISSAN LCN2Kai
				
*************************************************************************/
#ifndef TUNMSTR_SRCCHG_TRACE_H
#define TUNMSTR_SRCCHG_TRACE_H



#include "trace_if.h"

/*-------------------------*/
/* Trace for each class    */
/*-------------------------*/

/*----------------------------------------------------------------------------------*/
/* Tuner Componenet ->  TR_COMP_TUNER ( tri_types.h )  (256 * 82) = 20,992 (0x5200)  */

/* A class definition describes a 16 bit value, which has two parts                 */

/*   [  Component - ID   ][   Trace-Class-ID  ]                                     */
/*   15                  10                   0                                     */

/*----------------------------------------------------------------------------------*/





#define TUNMSTR_TRACE_CLASS_SRCCHG		(TR_COMP_TUNERMASTER + 23)
#define TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER		(TR_COMP_TUNERMASTER + 22)
/*----------------------*/
/* class tunmstr_MsgToAudio  */
/*----------------------*/

#define TUNMSTR_TRACE_MSG_TO_AUDIO_ADD_TO_NOTIF_FAIL   0x7000
#define TUNMSTR_TRACE_MSG_TO_AUDIO_ADD_TO_NOTIF_OK	    0x7001
#define TUNMSTR_TRACE_MSG_TO_AUDIO_REM_NOTIF		       0x7002
#define TUNMSTR_TRACE_MSG_TO_AUDIO_REMALL_NOTIF		    0x7003
#define TUNMSTR_TRACE_MSG_TO_AUDIO_SEND_MR_SRCCHG	    0x7004

// for the class tunmstr_MsgFromAudio
#define TUNMSTR_TRACE_MSG_FROM_AUDIO_NEW_CCA_MSG       0x7100
#define TUNMSTR_TRACE_MSG_FROM_AUDIO_SEND_ERROR_MSG	 0x7101
#define TUNMSTR_TRACE_MSG_FROM_AUDIO_AMD_CNTR          0x7102

// for the class tunmstr_MsgToHMI
#define TUNMSTR_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_FAIL	     0x7200
#define TUNMSTR_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_OK        0x7201
#define TUNMSTR_TRACE_MSG_TO_HMI_REM_NOTIF              0x7202
#define TUNMSTR_TRACE_MSG_TO_HMI_REMALL_NOTIF		     0x7203
#define TUNMSTR_TRACE_MSG_TO_HMI_SEND_SRCCHG_STATUS     0x7204
#define TUNMSTR_TRACE_MSG_TO_HMI_SEND_TA_ANNO_STATUS    0x7205
#define TUNMSTR_TRACE_MSG_TO_HMI_SEND_TP_STATUS         0x7206
#define TUNMSTR_TRACE_MSG_TO_HMI_ASSTER                 0x7207
#define TUNMSTR_TRACE_MSG_TO_HMI_SEND_TA_STATUS         0x7208
#define TUNMSTR_TRACE_MSG_TO_HMI_SEND_BAND_INFO         0x7209

//for the class tunmstr_MsgFromHMI

#define TUNMSTR_TRACE_MSG_FROM_HMI_NEW_CCA_MSG         0x7300
#define TUNMSTR_TRACE_MSG_FROM_NULL_POINTER            0x7301
#define TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE          0x7302
#define TUNMSTR_TRACE_MSGFROMHMI_FID_HANDLER           0x7303
#define TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL  0x7304
#define TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC  0x7305
#define TUNMSTR_TRACE_MSG_FROM_HMI_UNKNOWN_MESS        0x7306


// for the class tunmstr_DABClientHandler

#define TUNMSTR_TRACE_DABCLT_SERVICE_STATE			   0x7400
#define TUNMSTR_TRACE_DABCLT_INVALID_APPID             0x7401
#define TUNMSTR_TRACE_DABCLT_UNREG_SUCCESS             0x7402
#define TUNMSTR_TRACE_DABCLT_FID_REG_OK                0x7403
#define TUNMSTR_TRACE_DABCLT_FID_REG_NOK               0x7404
#define TUNMSTR_TRACE_DABCLT_SERVICE_REG_OK            0x7405
#define TUNMSTR_TRACE_DABCLT_SERVICE_REG_NOK           0x7406
#define TUNMSTR_TRACE_DABCLT_HANDLER_NULL_POINTER      0x7407
#define TUNMSTR_TRACE_DABCLT_HANDLE_S_SOURCE_STATE     0x7408
#define TUNMSTR_TRACE_DABCLT_HANDLE_SEND_SRC_STATE     0x7409
#define TUNMSTR_TRACE_DABCLT_HANDLE_SEND_PRESET_RECALL 0x7410
#define TUNMSTR_TRACE_DABCLT_HANDLE_G_CHANNEL_INFO     0x7411
#define TUNMSTR_TRACE_DABCLT_HANDLE_G_ANNO_STATUS      0x7412
#define TUNMSTR_TRACE_DABCLT_HANDLER_RDBID_LIST_SIZE    0x7413
#define TUNMSTR_TRACE_DABCLT_HANDLER_ARRAY_ELEMENTS     0x7414
#define TUNMSTR_TRACE_DABCLT_HANDLER_SET_RDBID          0x7415
#define TUNMSTR_TRACE_DABCLT_HANDLER_S_RDBID_WISH_LIST  0x7416
#define TUNMSTR_TRACE_DABCLT_HANDLER_FAST_TMC           0x7418
#define TUNMSTR_TRACE_DABCLT_HANDLER_G_TMC_AVAIL        0x7419
#define TUNMSTR_TRACE_DABCLT_TRIGGER_BG_SELECTION       0x7420
#define TUNMSTR_TRACE_DABCLT_TMC_DATA_SENT_MSGEXTRACTOR 0x7421
#define TUNMSTR_TRACE_DABCLT_SELECT_TMC                 0x7422
#define TUNMSTR_TRACE_DABCLT_HANDLER_LIST_SIZE         0x7413


// For the class tunmstr_SrcChgManager

#define TUNMSTR_TRACE_SRCCHG_MANGR_COMPARE_BAND		                  0x7500
#define TUNMSTR_TRACE_SRCCHG_MANGR_BANDINFO			                  0x7501
#define TUNMSTR_TRACE_SRCCHG_MANGR_CHK_SRCCHG	                     0x7502
#define TUNMSTR_TRACE_SRCCHG_MANGR_TUNSRCCHG_STOP	                  0x7503
#define TUNMSTR_TRACE_SRCCHG_MANGR_DABSRCCHG_STOP	                  0x7504
#define TUNMSTR_TRACE_SRCCHG_MANGR_OTHER_STOP		                  0x7505
#define TUNMSTR_TRACE_SRCCHG_MANGR_TUNSRCCHG_PLAY	                  0x7506
#define TUNMSTR_TRACE_SRCCHG_MANGR_DABSRCCHG_PLAY	                  0x7507
#define TUNMSTR_TRACE_SRCCHG_TUNSTOP_SENT_TUNBG		                  0x7508
#define TUNMSTR_TRACE_SRCCHG_TUNSTOP_TUNINBG		                     0x7509
#define TUNMSTR_TRACE_SRCCHG_TUNSTOP_TUNINFG		                     0x750A
#define TUNMSTR_TRACE_SRCCHG_TUNPLAY_TUNINFG		                     0x750B
#define TUNMSTR_TRACE_SRCCHG_TUNPLAY_SENT_TUNFG		                  0x750C
#define TUNMSTR_TRACE_SRCCHG_DABSTOP    			                     0x750D
#define TUNMSTR_TRACE_SRCCHG_DABSTOP_VISIBLE		                     0x750E
#define TUNMSTR_TRACE_SRCCHG_DABSTOP_DABBG			                  0x750F
#define TUNMSTR_TRACE_SRCCHG_DABSTOP_SENT_DABBG		                  0x7510
#define TUNMSTR_TRACE_SRCCHG_MANGR_OTHER_PLAY		                  0x7511
#define TUNMSTR_TRACE_SRCCHG_DABPLAY_DABFG			                  0x7512
#define TUNMSTR_TRACE_SRCCHG_DABPLAY_SENT_DABFG		                  0x7513
#define TUNMSTR_TRACE_SRCCHG_DABPLAY_VISIBLE		                     0x7514
#define TUNMSTR_TRACE_SRCCHG_TUN_PRESET_RECALL		                  0x7515
#define TUNMSTR_TRACE_SRCCHG_TUN_BANDCHG			                     0x7516
#define TUNMSTR_TRACE_BAND_CHANGE_NOTREQUIRED		                  0x7517
#define TUNMSTR_TRACE_BAND_CHANGE_REQUIRED  		                     0x7518
#define TUNMSTR_TRACE_SRCCHG_MANGR_BAND_CHANGE		                  0x7519
#define TUNMSTR_TRACE_MIXED_PRESET_RECALL   		                     0x751A
#define TUNMSTR_TRACE_SRCCHG_DABVISIBLE_SENT_DABFG	                  0x751B
#define TUNMSTR_TRACE_SRCCHG_TUNVISIBLE_SENT_TUNFG	                  0x751C
#define TUNMSTR_TRACE_DAB_INVISIBLE         		                     0x751D
#define TUNMSTR_TRACE_DAB_VISIBLE           		                     0x751E
#define TUNMSTR_TRACE_TUNER_INVISIBLE       		                     0x7525
#define TUNMSTR_TRACE_TUNER_VISIBLE         		                     0x751F
#define TUNMSTR_TRACE_SRCCHG_ZERO_VOL				                     0x7523
#define TUNMSTR_TRACE_SRCCHG_TUNSTOP_VISIBLE		                     0x7524
#define TUNMSTR_TRACE_SRCCHG_DAB_PRESET_RECALL                       0x7521
#define TUNMSTR_TRACE_SRCCHG_TUNVISIBLE_WAIT_FOR_PLAY_BANDCHG        0x7526
#define TUNMSTR_TRACE_SRCCHG_TUNVISIBLE_WAIT_FOR_PLAY_PRESET_RECALL  0x7527
#define TUNMSTR_TRACE_SRCCHG_DABISIBLE_WAIT_FOR_PLAY_BANDCHG         0x7528
#define TUNMSTR_TRACE_SRCCHG_DABVISIBLE_WAIT_FOR_PLAY_PRESET_RECALL  0x7529
#define TUNMSTR_TRACE_SRCCHG_METHODRESULT_FAIL                       0x752A
#define TUNMSTR_TRACE_SRCCHG_TP_STATE                                0x752B
#define TUNMSTR_TRACE_SRCCHG_TA_ANNO_IN_TUN_HANDLER                  0x752C
#define TUNMSTR_TRACE_SRCCHG_TA_ANNO_IN_DAB_HANDLER                  0x752D
#define TUNMSTR_TRACE_SRCCHG_TA_ANNO_DAB_TA_ON                       0x752E
#define TUNMSTR_TRACE_SRCCHG_TA_ANNO_DAB_TA_OFF                      0x752F
#define TUNMSTR_TRACE_SRCCHG_TA_ANNO_DAB_TA_UNKNOW                   0x7530
#define TUNMSTR_TRACE_SRCCHG_FMTA_ANNO_IGNORE_TA                     0x7531
#define TUNMSTR_TRACE_SRCCHG_FMTA_SENT_PLAY                          0x7532
#define TUNMSTR_TRACE_SRCCHG_FMTA_PLAY_UNKNOW                        0x7533
#define TUNMSTR_TRACE_SRCCHG_FMTA_STOP_USER                          0x7534
#define TUNMSTR_TRACE_SRCCHG_FMTA_STOP_AUTOMATIC                     0x7535
#define TUNMSTR_TRACE_SRCCHG_STOPSRC_FMTA                            0x7536
#define TUNMSTR_TRACE_SRCCHG_STOPSRC_DAB_TA                          0x7537
#define TUNMSTR_TRACE_SRCCHG_OTHERSRCPLAY_FMTA                       0x7538
#define TUNMSTR_TRACE_SRCCHG_OTHERSRCPLAY_DABTA                      0x7539
#define TUNMSTR_TRACE_SRCCHG_TP_STATE_2                              0x7540
#define TUNMSTR_TRACE_SRCCHG_TP_STATE_3                              0x7541
#define TUNMSTR_TRACE_SRCCHG_TP_STATE_TP_DISABLE                     0x7542
#define TUNMSTR_TRACE_SRCCHG_METHODRESULT_NOTREQUIRED                0x7543
#define TUNMSTR_TRACE_SRCCHG_STOP_NEXTSOURCE_SRCCHG                  0x7544
#define TUNMSTR_TRACE_SRCCHG_STOP_NEXTSOURCE_BANDCHG                 0x7545
#define TUNMSTR_TRACE_SRCCHG_SEND_DAB_SF_OFF                         0x7546
#define TUNMSTR_TRACE_SRCCHG_SEND_DAB_SF_ON                          0x7547
#define TUNMSTR_TRACE_SRCCHG_SWITCH_FALSE                            0x7548
#define TUNMSTR_TRACE_SRCCHG_DAB_SF_PLAY                             0x7549
#define TUNMSTR_TRACE_SRCCHG_DAB_SF_STOP                             0x7550
#define TUNMSTR_TRACE_SRCCHG_DAB_TP_OFF                              0x7551

#define TUNMSTR_TRACE_TUNCLT_SERVICE_STATE						  0x0303
#define TUNMSTR_TRACE_TUNCLT_INVALID_APPID						  0x0304
#define TUNMSTR_TRACE_TUNCLT_UNREG_SUCCESS						  0x0305
#define TUNMSTR_TRACE_TUNCLT_UNREG_FAIL  						  0x0306
#define TUNMSTR_TRACE_TUNCLT_FID_REG_OK 						  0x0307
#define TUNMSTR_TRACE_TUNCLT_FID_REG_NOK						  0x0308
#define TUNMSTR_TRACE_TUNCLT_SERVICE_REG_OK 					  0x0309
#define TUNMSTR_TRACE_TUNCLT_SERVICE_REG_NOK					  0x030A
#define TUNMSTR_TRACE_TUNCLT_SEND_S_SETFEATURE					  0x030B
#define TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER				  0x0300
#define TUNMSTR_TRACE_TUNCLT_HANDLE_S_AUDIOFGBG				      0x0325
#define TUNMSTR_TRACE_TUNCLT_HANDLE_S_BANDCANGE					  0x0326
#define TUNMSTR_TRACE_TUNCLT_HANDLE_S_PRESET_RECALL			      0x0327

#define TUNMSTR_TRACE_TUNCLT_SEND_S_AUDIOFGBG					  0x0328
#define TUNMSTR_TRACE_TUNCLT_SEND_S_BANDCHANGE					  0x0329
#define TUNMSTR_TRACE_TUNCLT_SEND_S_PRESET_LIST					  0x0330
#define TUNMSTR_TRACE_TUNCLT_SEND_S_SETFEATURE_TA				 0x0331 
#define TUNMSTR_TRACE_TUNCLT_SEND_S_STOP_ANNO					 0x0332
#define TUNMSTR_TRACE_TUNCLT_HANDLER_SET_FEATURE				  0x0333
#define TUNMSTR_TRACE_TUNCLT_HANDLER_COMP_STATUS				  0x0334
#endif  
