/************************************************************************
 * FILE:           tunmstr_SrcChg_AnnoHandler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    header contents of tunmstr_SrcChg_AnnoHandler
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY: 
* Date			 | Author					| Modification
 
 *************************************************************************/

#ifndef tunmstr_SrcChg_AnnoHandler_H
#define tunmstr_SrcChg_AnnoHandler_H
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "midw_fi_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#include <vector>


#include "tunermaster_Class_ForwardDecl.h"

enum enActiveAnnoSource
{
	TunMstr_AnnoActive_FMPTY=0,
	TunMstr_AnnoActive_DABPTY,
	TunMstr_AnnoActive_DABTA,
	TunMstr_AnnoActive_FMTA,
	TunMstr_AnnoActive_DABTransport,
	TunMstr_AnnoActive_FMOther,
	TunMstr_AnnoActive_DABWarning = 8,
	TunMstr_AnnoActive_DABNews = 16,
	TunMstr_AnnoActive_DABWeather = 32,
	TunMstr_AnnoActive_DABEvent = 64,
	TunMstr_AnnoActive_DABSplEvent = 128,
	TunMstr_AnnoActive_DABPI = 256,
	TunMstr_AnnoActive_DABSports = 512,
	TunMstr_AnnoActive_DABFinance = 1024,
	TunMstr_AnnoActive_None = 0xffff
};

class clConfigInterface;

class tunmstr_SrcChg_AnnoHandler
{
private:

	// Member variables
	tU16 m_u16Cmd_Cntr;
	tBool m_blAnno_Active;
	tBool m_blTPState_DAB;
	tBool m_blTPState_TUN;
	tBool m_blLast_TASource_FMTA;
	tBool m_blDABTAEnded;

	tU32 m_u32AnnoButtonState_FM;
	tU32 m_u32AnnoButtonState_DAB;

	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	tunmstr_DABClient_Handler *m_potunmstr_DABClient_Handler;
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	tunmaster_Config*      m_potunmaster_Config;
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;
	tunmstr_AudioClientHandler * m_potunmstr_AudioClientHandler;
	clConfigInterface* m_poclConfigInterface;

	tVoid vSetCmd_Cntr(tU16 u16Cmd_Cntr);
	tU16 u16GetCMd_Cntr()const;

	tVoid vSetPty31Button_FM(tBool blAnno_Status);
	tU8 u8ConvertAnnoSrcValues(tU8 u8Source)const;
	tBool blCheckARLUpdate_Required(tU16 u16SourceTA);
	tVoid vHandleDABTA(tBool blStatus);
	tVoid vHandle_FMTA(tBool blTA_Anno);
	tVoid vEndAnnoSrc(tU16 u16AnnoType ,tU8 u8Source, tBool bCheckARLUpdate);
	tBool blCheckPTYAnnoActive()const;
	tBool blCheckTAAnnoActive()const;

public:
	/*-------------*/
	/* Constructor */
	/*-------------*/
	tunmstr_SrcChg_AnnoHandler();

	//Distructor
	~tunmstr_SrcChg_AnnoHandler();

	enActiveAnnoSource  m_ActiveAnnoSrc;

	stAnnoHandlingRequest m_AnnoSrcChgRequest;

	//Helper Functions for Anno Logic
	tVoid vHandle_AnnoMSG(tU16 u16AnnoType, tU8 u8Source, tBool AnnoState);

	//Helper Function TA Logic

	tVoid vHandleTPState_FM(tU8 u8Status);
	tVoid vHandleTPState_DAB(tU8 u8Status);
	tBool blGetTPState()const;
	tVoid vCheckForTPStatus(tU8 u8TPStatus, tU8 u8Source);
	tBool blGetTPState_DAB()const;
	tBool blGetTPState_FM()const;

	tVoid vCheckForTA_Anno(tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoType);
	tVoid vCheckForPTY31_Anno(tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoType);
	tVoid vCheckForOther_Anno(tBool blTA_Anno,tU8 u8Source, tU16 u16AnnoOtherType);

	//Helper Functions for TA Logic
	tVoid vCheckFor_TAButton(amt_tclServiceData* poMessage);
	tVoid vSetTA_Anno_State(const tU8 u8TA_Anno);
	tBool u8GetTPSource()const;
	tVoid vSend_Src_Chg_Request(tU8 u8Source, tU8 u8Action);
	tVoid vSetActiveAnnoSrc(enActiveAnnoSource u16ActiveAnnoSrc);

	tVoid vHandleAnnoConfig(  tU32 u32AnnoConfig);
	tBool blGetTA_Anno_Status()const;
	tVoid vSetDABTA_Ended(const tBool blStatus);
	tBool blGetDABTA_Ended()const;
	tVoid vSetLastFMTA_ActiveStatus(const tBool blStatus);
	tBool blGetLastFMTA_ActiveStatus()const;
	tVoid vCheckForStop_Anno(amt_tclServiceData* poMessage);
	tVoid vSetANNOFeature_FM(tU8 u8Type, tBool blStatus);

	tVoid vStartAnnoSrc(tU16 u8AnnoType);
	tVoid vHandlerForTA_Anno(tBool blTA_Anno, tU16 u16AnnoType);

	// Pointer creation
	tVoid vSet_tunmstr_SrcChgManager_Ptr(tunmstr_SrcChgManager* potunmstr_SrcChgManager);
	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	tVoid vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler );
	tVoid vSet_tunmstr_TunerClientHandler( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler);
	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );
	tVoid vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI );
	tVoid vSet_tunmstr_AudioClientHandler_Ptr( tunmstr_AudioClientHandler* potunmstr_AudioClientHandler );
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

	// Helper function to handle Activation of Anno buttons
	tVoid vHandleAnnoStatusInfo(tU32 u32AnnoType,tU8 u8Source);
	tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg,
			fi_tclTypeBase&     oFIData )const;
	tU8 u8GetTunmst_AnnoTypes(tU16 u16AnnoType)const;
	tU8 u8ConvertCurrentAnnoSource(tU16 u16AnnoType);
	tU8 u8ConvertCurrentAnnoARLSource(tU16 u16AnnoType);
	tVoid vUpdateAnnoSrcChgRequest(tU8 u8Source , tU8 u8AnnoState);
	tVoid vSetAnnoButtonState_FM(tU32 u32FMAnnoState);
	tU32  u32GetAnnoButtonState_FM() const;
	tVoid vSetButtonState_DAB(tU32 u32DABAnnoState);
	tU32  u32GetAnnoButtonState_DAB() const;
	tVoid vHandleAnnoSwitchState(tBool bTAState , tBool bPTYState,tBool bWeatherAlertState);
};
#endif
