/************************************************************************
 * FILE:           tunmstr_Preset_Handler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    Header file to handle Preset feature
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY: 
 * Date			 | Author										| Modification
 * 01-05-2013	 | RBEI/ECV3 Priya Prabhuswamy(rrb1kor)			| initial version
 *************************************************************************/
 
#ifndef tunmstr_Preset_Handler_H
#define tunmstr_Preset_Handler_H

#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
//#include "../../utest/Mocks/tunmstr_DABClient_Handler.h"
#else
#include "tunmstr_DABClient_Handler.h"
#ifndef SYSTEM_S_IMPORT_INTERFACE_VECTOR
#include <vector>

#endif
using namespace std;
#ifndef tunmstr_MsgToHMI_H
#include "tunmstr_MsgToHMI.h" 
#endif
#ifndef TUNMASTER_MSGFROMHMI_H
#include "tunmstr_MsgFromHMI.h"
#endif
#include "tunmstr_AudioClientHandler.h"
#endif

#ifdef INCLUDE_PROFILE_MANAGER
#ifndef TUNERMASTER_PM_CLIENT_H
#include "tunermaster_PMClient.h"
#endif
#endif

#include <map>
#include <vector>


using namespace std;
using namespace std;

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/clArlSourceImpl.h"
#include "datatypes/tunerDatatypes.h"
using namespace tuner::sessionManagement::audio;
#endif

struct stPresetHandlingReguest
{
	tBool blReguestPending;
	midw_fi_tcl_e8_List eList;
	midw_fi_tcl_e8_Band eBand;
	tU8 u8Element_ID;
	midw_fi_tcl_e8_Tun_PresetAction ePresetAction;
};

#define TUNMSTR_MAX_MIXED_PRESET_LIST_SIZE 15

struct stPresetList
{
	tU8 u8Element_ID;
	tU32 u32Frequency;
	tString s16PSName;
	tU8 u8TpTmcInfo;
	tU32 u32PTY;
	tString s16Ensemble_Name;
	tString s16Frequency_Label;
	midw_fi_tcl_e8_Band enBand;
};
struct stPresetHandlingParam
{
	tU8 u8Band;
	tU8 u8List;
	tU8 u8Element_ID;
	tU8 u8PresetAction;
	tU32 u32Frequency;
	tU32 u32PI;
	tU16 u16SecondaryPI;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	tString sKey;
	tU8 u8PresetType;
#endif
};
struct stPresetSaveParam
{
	tU8 u8Band;
	tU32 u32Frequency;
	tU8 u8Element_ID;
};

enum enPresetReguest
{
	NormalPresetSave=0,
	NormalPresetRecall,
	NormalPresetDelete,
	NormalPresetDeleteAll,
	MixedPresetSave,
	MixedPresetRecall,
	MixedPresetDelete,
	MixedPresetDeleteAll,
	None=0xff
};
enum enModulationType
{
	AMFM=0,
	HD,
	DRM
};

class clConfigInterface;

class tunmstr_Preset_Handler
{
private:

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
#endif

	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	tunmaster_Config*      m_potunmaster_Config;
	tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;
	// Pointer to class tunmstr_TunerClientHandler.
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	//Pointer to class tunmstr_DABClientHandler
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;
	//Pointer to class tunmstr_MsgToHMI
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;
	tunmstr_MuteHandler* m_potunmstr_MuteHandler;
	clConfigInterface* m_poclConfigInterface;
#ifdef INCLUDE_PROFILE_MANAGER
	tunermaster_PMClient* m_poPMClient;
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tunermaster_SXMClient* m_potunermaster_SXMClient;
	tunermaster_SXMchannelartClient* m_potunermaster_SXMchannelartClient;
	tU16 m_u16ChannelArtCmdCounter;
	tU16 m_u16ChannelArtRegID;
	tU16 m_u16ChannelArtSourceAppID;
#endif


	stPresetHandlingReguest m_poStoreRequest;
	enPresetReguest m_ePresetReguest;
	tU16 m_u16CmdCounter;
	tU16 m_u16RegID;
	tU16 m_u16SourceAppID;
	//struct stMixedPresetList m_stMixedPresetListHandler;
	//tU8 m_u8PresetBandActionPerformed;

	midw_fi_tcl_e8_Band m_u8PresetBandActionPerformed;
	tU8 m_u8CurrentBand;
	tU8 m_u8CurrentStoredBand;
	tU32 m_PresetSaveElemementID;
	tBool bStartUpFlag;
	tU8 m_u8StartUp_HMI_Update; 
	tU8 m_u8TunerStartUp_HMI_Update;
	tU8 m_u8SXMStartUp_HMI_Update;
	tU8 m_u8ElemID_Delete;
#ifdef INCLUDE_PROFILE_MANAGER
	tBool m_bProfile_PresetOperation;
#endif
	//tBool bHMI_Update_Flag;
	tVoid vHandleSkipPreset(tU8 u8PresetDirection);
	tVoid vRecallAvailablePreset(tU8 u8Index , tBool &bCheckPresetList);
public:
	/*-------------*/
	/* Constructor */
	/*-------------*/
	stPresetHandlingParam m_poPresetHandling;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tunmstr_Preset_Handler(tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl);
#else
	tunmstr_Preset_Handler();
#endif
	//tunmstr_Preset_Handler(const tunmstr_Preset_Handler& c);
	~tunmstr_Preset_Handler();
	tVoid vHandlePresetConfig()const;
	tVoid vHandlePreset(amt_tclServiceData* poMessage);
	tVoid vSet_tunmstr_SrcChgManager_Ptr(tunmstr_SrcChgManager* potunmstr_SrcChgManager);
	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );
	tVoid vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler);
	tVoid vSet_tunmstr_TunerClientHandler_Ptr(tunmstr_TunerClientHandler* potunmstr_TunerClientHandler);
#ifdef INCLUDE_PROFILE_MANAGER
	tVoid vSet_tunmstr_PMClient_Ptr(tunermaster_PMClient* poPMClientPtr);
	tVoid vSetProfile_PresetOperation();
#endif


#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)

	tVoid vHandleSXMNormalPresetRecall(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleSXMNormalPresetSave(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleSXMNormalPresetDelete(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleSXMNormalPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
	tVoid vSendSXMPresetActionMethodResult(tU8 u8PresetAction , tBool bPresetActionStatus);
	tVoid vSendSXMGetPresetList();

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tVoid vSet_tunmstr_SXMClient_Ptr(tunermaster_SXMClient* potunermaster_SXMClient);
	tVoid vSet_tunmstr_SXMChannelArtClient_Ptr(tunermaster_SXMchannelartClient* potunermaster_SXMchannelartClient);

	tVoid vUpdateSXMPresetChannel(amt_tclServiceData* poMessage , tU8 u8PresetAction = 0xFF);
	tVoid vSXMPresetChannelPopulate(midw_ext_fi_tcl_PresetListEntry oSXMPresetListEntry , midw_fi_tcl_SXMPresetListEntry &oPresetListEntry);
	tVoid vUpdateSXMPresetList(amt_tclServiceData* poMessage);
	tVoid vSXMPresetListPopulate(midw_ext_fi_tcl_PresetListEntry oSXMPresetListEntry , midw_fi_tcl_PresetList &oPresetListEntry);
	tVoid vUpdateSXMPresetActionMethodResult(amt_tclServiceData* poMessage , tU8 u8PresetAction);

	tVoid vRequestChannelArtList(amt_tclServiceData* poMessage);
	tVoid vHandleChannelArtListResult(amt_tclServiceData* poMessage);
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	tVoid vUpdateSXM360LPresetList(amt_tclServiceData* poMessage);
	tVoid vSendSXM360LPresetList(midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESET_RESPONSEMethodStart oMethodStart);
	tVoid vSXM360LPresetListPopulate(midw_fi_tcl_SXMPresetEntry &oSXMPresetListEntry , midw_fi_tcl_PresetList &oPresetListEntry);
#endif

#endif


	tVoid vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI);
	tVoid vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler);
	tVoid Update_tunmstr_bStartUpFlag(tBool);
	//Set Pointer to tunmstr_DABClient_Handler
	tVoid vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tU8 u8ConvFiBandtoTunmstrBand(tU8 u8RequestBand,tU8 u8RequestedList)const;
	stPresetHandlingReguest stGetPresetHandleRequest()const;
	tVoid vClearPreserHandleRequest();
	tVoid vSendDemuteRequest();
	enPresetReguest enGetPreserRequest();
	tVoid vUpdatePresetRequestVar(enPresetReguest oenPresetReguest);
	tVoid vUpdateTunerPresetList(amt_tclServiceData* poMessage);
	tVoid vUpdateTunerMixedPresetList(amt_tclServiceData* poMessage);
	tVoid vUpdateTunerNormalPresetList(amt_tclServiceData* poMessage);
	tVoid vTunerPresetListPopulate(const midw_fi_tcl_TunerStaticListElement &oTunerStaticListElem , midw_fi_tcl_PresetList &oPresetList, tU8 u8List);
	tVoid vUpdatePresetList(stPresetList ostPresetList,tU8 u8Index);
	midw_fi_tcl_e8_Band enCovListToBand(tU8 u8List , tU32 u32Frq, enModulationType oenModulationType = AMFM)const;

	tVoid vHandleDABpresetMethodResult(amt_tclServiceData* poMessage);
	tVoid vHandleDABActivatePresetElem();
	tVoid vHandleDABPresetListMethodResult(amt_tclServiceData* poMessage);
	tVoid vHandleDABPresetListStatus(amt_tclServiceData* poMessage);
	tVoid vUpdateDABMixedPresetListStatus(amt_tclServiceData* poMessage);
	tVoid vUpdateDABMixedPresetListResult(amt_tclServiceData* poMessage);
	tVoid vUpdateDABNormalPresetListResult(amt_tclServiceData* poMessage);
	tVoid vUpdateDABNormalPresetListStatus(amt_tclServiceData* poMessage);
	tVoid vDABPresetListPopulate(midw_ext_fi_tcl_DAB_PresetListElement oDABPresetListElement , midw_fi_tcl_PresetList &oPresetList);

	tVoid vSendMixedPresetList();

	tVoid vHandleTunerNormalPresetRecall(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABNormalPresetRecall(stPresetHandlingParam oPresetHandlingParam);

	tVoid vHandleTunerNormalPresetSave(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABNormalPresetSave(stPresetHandlingParam oPresetHandlingParam);


	tVoid vHandleTunerNormalPresetDelete(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABNormalPresetDelete(stPresetHandlingParam oPresetHandlingParam);


	tVoid vHandleTunerNormalPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABNormalPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);

	tVoid vSendMsg(tU8 u8OpCode, fi_tclTypeBase&  oOutData)const;
	tVoid Conv_Mix_To_BandType (stPresetHandlingParam *);
	tVoid Inc_m_u8StartUp_HMI_Update();
	tVoid Dec_m_u8StartUp_HMI_Update();
	tVoid Inc_m_u8TunerStartUp_HMI_Update();
	tVoid Dec_m_u8TunerStartUp_HMI_Update(tBool bResetStartUp_HMI_Update = false);
	tVoid Inc_m_u8SXMStartUp_HMI_Update();
	tVoid Dec_m_u8SXMStartUp_HMI_Update(tBool bResetStartUp_HMI_Update = false);
	//virtual tVoid Send_HMIUpdate_Flag();
	tU8 u8GetBandFrmFRQ(tU32 u32Frequency, tU8 u8Modulation)const;
	tVoid vUpdateMixedPresetListBandAsNone();
	tVoid vClearPresetList();
	tVoid vHandleSystemSetForPresetList(tBool bSendPresetList =true);
	tVoid vHandleSystemSetFinishForPresetList();
	tVoid vSendEmptyPresetlistUpdate();
	tVoid vClearPresetDeleteElementID();

	midw_fi_tcl_e8_Band e8GetPresetBand(tU8 u8PresetElemID);
	tU8 u8GetTunerStartUp_HMI_Update();
	tU8 u8GetSXMStartUp_HMI_Update();

#if 0
	tVoid vHandlePresetRecall(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerPresetRecall(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerMixedPresetRecall(stPresetHandlingParam oPresetHandlingParam)const;
	tVoid vHandleDABPresetRecall(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABMixedPresetRecall(stPresetHandlingParam oPresetHandlingParam)const;
	tVoid vHandleDABPresetSave(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerMixedPresetSave(stPresetHandlingParam oPresetHandlingParam)const;
	tVoid vHandleDABMixedPresetSave(stPresetHandlingParam oPresetHandlingParam)const;
	tVoid vHandlePresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandlePresetSave(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerPresetSave(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandlePresetDelete(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerPresetDelete(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABPresetDelete(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleTunerMixedPresetDelete(stPresetHandlingParam oPresetHandlingParam)const;
	tVoid vHandleDABMixedPresetDelete(stPresetHandlingParam oPresetHandlingParam)const;
	tVoid vHandleTunerMixedPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
	tVoid vHandleDABMixedPresetDeleteAll(stPresetHandlingParam oPresetHandlingParam);
#endif
};
#endif
