/************************************************************************
* FILE:           tunmstr_MsgToHMI.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    CCA messages sent to HMI are implemented in this file.
*              
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                         | Modification
* 15-04-11  | CM-AI/PJ-VW36 Pallavi HN       | initial version
* 25.04.13  | NGP1KOR    					 | First version of the G3g after porting from NISSAN LCN2Kai
				
*************************************************************************/


#ifndef tunmstr_MsgToHMI_H
#define tunmstr_MsgToHMI_H

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"  // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
//Amt Ahl mocks already included
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "tunmstr_MsgFromHMI.h"
#endif
//-------------------------- FI includes

/*  Interface for Visitor Message */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES

#include "midw_fi_if.h" // Include tmctuner_fi in VOB:di_fi using "fi_if_gen.h"
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clArlSourceImpl.h"
using namespace tuner::sessionManagement::audio;
#endif

#ifdef INCLUDE_PROFILE_MANAGER
#ifndef TUNERMASTER_PM_CLIENT_H
#include "tunermaster_PMClient.h"
#endif
#endif

#include "tunmstr_SrcChg_Defines.h"

struct StSendCCAMsg
{
	tU16   u16DestAppID;
	tU16	u16Fid;
	tU8     u8OpCode;	
	tU16    u16CmdCtr;
	tU16	u16RegID;
};
//---------------------------------

class clConfigInterface;

//using namespace std;


/*--------------------------------*/
/* class tunmstr_MsgToHMI definition */
/*--------------------------------*/
class tunmstr_MsgToHMI :public ahl_tclBaseWork
{

  template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
  /* this function must not be used, therefore it is private */
   tunmstr_MsgToHMI& operator=(const tunmstr_MsgToHMI& c);

public:
  /*-------------*/
  /* Constructor */
  /*-------------*/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
  tunmstr_MsgToHMI( tunmaster_tclApp* poMain, tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl);
#else
  tunmstr_MsgToHMI( tunmaster_tclApp* poMain);
#endif
  tunmstr_MsgToHMI(); //default constructor added to remove lint warning
  /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
  tunmstr_MsgToHMI(const tunmstr_MsgToHMI& c);


 /*-------------*/
 /* Destructors */
 /*-------------*/
 virtual  ~tunmstr_MsgToHMI( ); 


  // Set pointer to Tmc manager.
  tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );


  // Get pointer to class tunmstr_TMCConfig
   tVoid vSet_tunmstr_TunerClientHandler_Ptr(
                        tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
                               );

   tVoid vSet_tunmstr_SrcChgManager_Ptr(
                    tunmstr_SrcChgManager* potunmstr_SrcChgManager
                           );
   // Set pointer tunmstr_MsgFromHMI
   	tVoid vSet_tunmstr_MsgFromHMI_Ptr(
   			tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
   	);

    // Set pointer tunmstr_SrcChg_AnnoHandler
	tVoid vSet_tunmstr_SrcChg_AnnoHandler_Ptr(
			tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler
			);
			
			
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	
	
  /* Method Result FID_TUNMSTR_S_SOURCE_CHANGE */
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16 
  tVoid vSend_g_SourceChange( tU8 u8Source, tU8 u8Action );
 
  tVoid vSend_g_Band_Info( tU8 u8SourceId, tBool bSetBandNone );
 
  tVoid vSend_g_TunerDomainAvailabilityStatus();

  tVoid vSend_g_AnnoButton_Status( tU8 u8Source, tU32 u32AnnoType);
 #endif
  tVoid vSend_g_Announcement_Status( tBool blAnno_Status, tU8 u8Source, tU8 u8AnnoType);
  tVoid vUpdateAnnouncementStatusValues(tBool blAnno_Status, tU8 u8Source, tU8 u8AnnoType);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
  tVoid vSend_g_Announcement_Status();
#endif

  tVoid vSend_g_TP_Status( tBool blTP_Status ,tU8 u8Source);
  tVoid vSend_g_Tuner_Source_Availability_status(tBool bIsUpreg = false);
  
  

  tVoid vSend_g_RFAntennaTest(tU8 u8WhichAntenna,tU8 u8antennastatus,tFloat fconnectioncurrent);
  /* Add clients(different AppIds), During UPREG  */
  tBool bAddNotificationTable ( const amt_tclServiceData* poMessage );

  /* Remove clients from notification table */
  tBool bRemoveNotification( const amt_tclServiceData* poMessage );

  /* Remove all the entries in Not table with Reg ID */
  tVoid vRemoveAllEntriesWithRegID( tU16 u16ServiceID,tU16 u16RegisterID );
  
  tVoid vSend_s_TunerInfo(tU8 u8TunerIndex);
  tVoid vSend_g_PresetListStatus(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus);
  
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
  tVoid vSend_g_PresetChannelUpdate(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus oStatus);
  tVoid vSend_g_SystemMessage(tU8 u8SystemErrorType , tU16 u16ChannelNumber);
#endif

  tVoid vSend_g_GetAutostoreStatus(tBool bAST_State, tU8 u8AST_Type);
  tVoid vSendMTC_SetMode_status(tU8 u8Mode);
  tVoid vSendMTC_Surveilance_StationStatus(\
	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus oMTCSurveilanceStatus);
  tVoid vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler);

#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
  tVoid vHandleSXM360LPresetRequest(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus);
  tVoid vSend_SXM360LUserProfileActions(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus oStatus);
#endif

	tVoid vSend_g_PresetAutoCompare(tU8 u8PresetAutoCompare, tBool bUserPresetAction);
	tU8 u8GetActivePreset();

	/*OnlinerPersonalization*/
#ifdef INCLUDE_PROFILE_MANAGER
	//tVoid vSend_g_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus oStatus);
	tVoid vSend_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus oStatus);
	tVoid vSet_tunmstr_PMClient_Ptr(tunermaster_PMClient* poPMClientPtr);
#endif

	tU8 u8GetTunerTPStatus();
	tU8 u8GetDABTPStatus();
private:

   // Pointer to main fc_Tmctuner application class.
   tunmaster_tclApp*   poGWMain;

  // Pointer to class tunmaster_TMCManager.
   tunmaster_Config*      m_potunmaster_Config;

   // Pointer to class tunmstr_TMCConfig.
   tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;

   // Pointer to class tunmstr_TMCConfig.
   tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;

   //Pointer to classtunmstr_MsgFromHMI
   	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;

	 tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;
	 
	 clConfigInterface* m_poclConfigInterface;
   /*--------------------------------------*/
  /* Notification table : Tuner Master Client client     */
  /*--------------------------------------*/
  
  ahl_tclNotificationTable*  m_hNotTable_TunerMaster;  

  tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;

  static OSAL_tSemHandle     m_hNotTable_SemHandle;

  tBool bAnnouncementStatus;
  tU8 u8AnnouncementMainSource;
  tU8 u8AnnouncementType;
  tU8 m_u8ActivePreset;
  
  tU8 m_u8TunerTPStatus;
  tU8 m_u8DABTPStatus;
   //---------------------------------------------
   // Generic functions for managing CCA messages.
   //---------------------------------------------

   // Get message in amt_tclServiceData* format convert to fi_tclTypeBase 
   tVoid vGetDatafromAMT(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData)const;

   // Send messsage to client (FC_TIMA)
  tVoid vSendMessage( StSendCCAMsg OStSendCCAMsg,const fi_tclTypeBase&  oOutData);

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
  tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
#endif
#ifdef INCLUDE_PROFILE_MANAGER
  tunermaster_PMClient* m_poPMClient;
#endif
};


#endif // tunmstr_MsgToHMI_H
