/************************************************************************
 * FILE:           tunmstr_MsgFromHMI.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    CCA messages received from HMI are handled in this file.
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                       | Modification
 * 15-04-11  | CM-AI/PJ-VW36 Pallavi HN     | initial version
 *
 *************************************************************************/




#ifndef TUNMASTER_MSGFROMHMI_H
#define TUNMASTER_MSGFROMHMI_H


#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16

#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
//#include "../../utest/Mocks/tunmstr_Preset_Handler.h"
#else
#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#endif
#endif

#ifdef INCLUDE_PROFILE_MANAGER
#include "tunermaster_PMClient.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/clArlSourceImpl.h"
using namespace tuner::sessionManagement::audio;
#endif

//-------------------------- FI includes

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS // not sure
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO

#include "midw_fi_if.h" // Include tmctuner_fi in VOB:di_fi using "fi_if_gen.h"


#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif
struct stSendCCAMsg
{
	tU16   u16DestAppID;
	tU16	u16Fid;
	tU8     u8OpCode;
	tU16    u16CmdCtr;
	tU16	u16RegID;
	stSendCCAMsg()
	{
		u16DestAppID=0xff;
		u16Fid=0x00;
		u8OpCode=CCA_C_U8_OPCODE_ERROR;
		u16CmdCtr=0x00;
		u16RegID=AMT_C_U16_REGID_INVALID;
	};
};
#include "tunmstr_SrcChg_Defines.h"

class clConfigInterface;

class tunmstr_MsgFromHMI : public ahl_tclBaseWork
{

private:

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
	tuner::sessionManagement::audio::clSessionControl* m_poSessionControl;
#endif

	/* Pointer to main FC_TmcTuner Application */
	tunmaster_tclApp*          poGWMain;

	static OSAL_tSemHandle     m_hNotTable_SemHandle;

	tU16 m_u16RegID;
	tU16 m_16CmdCntr;
	tU16 m_AST_APPID;
	tU16 m_u16ActiveTuner_AppID;
	tU16 m_u16RfAntennaTest_AppID;
	tU16 m_u16RfAntennaTest_Cmdcntr;
	tU16 m_u16RfAntennaTest_RegID;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	tBool m_bSXM360LClientAvail;
#endif
	stSendCCAMsg m_stSendCCAMsgSourceSetupOpt;

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
	tBool m_bSXMSrcState;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	tU8 m_u8SXMPresetAutocompare;
	tBool m_bSXMUserPresetAction;
#endif
#endif

	// Pointer to class tunmaster_Config
	tunmaster_Config*          m_ptunmaster_Config;

	// Pointer to class tunmstr_SrcChgManager
	tunmstr_SrcChgManager*	  m_potunmstr_SrcChgManager;

	// Pointer to class tunmstr_MsgToHMI
		tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;

	// Pointer to class tunmstr_SrcChgManager
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;
   tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;
	// Pointer to class tunmstr_antdiag_Manager
	tunmstr_antdiag_Manager* m_potunmstr_antdiag_Manager;

	tunmstr_AutoStoreHandler* m_ptunmstr_AutoStoreHandler;

	tunmaster_Utility* m_potunmstr_Utility;

	tunmstr_SDSHandler* m_potunmstr_SDSHandler;


	clConfigInterface* m_poclConfigInterface;

#ifdef INCLUDE_PROFILE_MANAGER
	tunermaster_PMClient* m_potunmstr_PMClient_Handler;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tunermaster_SXMClient* m_potunermaster_SXMClient;
	tunermaster_SXMchannelartClient* m_potunermaster_SXMchannelartClient;
#endif
	//--------------------------
	// Generic functions
	//--------------------------

	// Get message in amt_tclServiceData* format convert to fi_tclTypeBase



	//--------------------------------------
	// Helper functions to get CCA messages
	//--------------------------------------


protected:

	virtual tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage);

public:   

	/*-------------*/
	/* constructor */
	/*-------------*/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tunmstr_MsgFromHMI(tunmaster_tclApp* poMain , tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl);
	tVoid vHandle_s_Source_Setup_Option(amt_tclServiceData* poMessage);
#else
	tunmstr_MsgFromHMI(tunmaster_tclApp* poMain);
#endif

	//default constructor added to remove lint warning
	tunmstr_MsgFromHMI();
	tVoid vSendTunerDomainAvailability(amt_tclServiceData* poMessage);
	/* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */


	/*------------*/
	/* destructor */
	/*------------*/
	virtual ~tunmstr_MsgFromHMI( );


	// Get pointer to class tunmstr_TMCConfig

	// Get pointer to class tunmstr_SrcChgManager
	tVoid vSet_tunmstr_SrcChgManager_Ptr(
			tunmstr_SrcChgManager* potunmstr_SrcChgManager
	);

	// Get pointer to class tunmstr_TunerClientHandler
	tVoid vSet_tunmstr_TunerClientHandler_Ptr(
			tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
	);
	tVoid vSet_tunmstr_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	// Get pointer to class tunmstr_MsgToHMI
	tVoid vSet_tunmstr_MsgToHMI_Ptr(
			tunmstr_MsgToHMI* potunmstr_MsgToHMI
	);
	tVoid vSet_tunmstr_AutoStoreHandler_Ptr(tunmstr_AutoStoreHandler* potunmstr_AutoStoreHandler);
	tVoid vSet_tunmstr_DABClient_Handler_Ptr(
			tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
	);

	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );
	tVoid vSet_tunmstr_SrcChg_AnnoHandler_Ptr( tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler );
	//Set Pointer to tunmstr_antdiag_Manager
	tVoid vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager );
	tVoid vSet_tunmstr_Utility_Ptr( tunmaster_Utility* potunmstr_Utility  );

	tVoid vSet_tunmstr_SDSHandler_Ptr( tunmstr_SDSHandler* potunmstr_SDSHandler  );

	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	/* Method  OperationMode */
	// Testmode handlers
	tVoid vHandle_s_BandChange_TM( amt_tclServiceData* poMessage );
	tVoid vHandle_s_TestMode( amt_tclServiceData* poMessage );
	tVoid vHandle_s_SrcChg_testmode( amt_tclServiceData* poMessage );

	//Antenna diagnosis handlers
	tVoid vHandle_s_Rf_Antenna_Test( amt_tclServiceData* poMessage );
	tVoid vSendRfAntenna_TestMethodResult(tU8 u8Client,tU8 u8AntennaState, tFloat fCurrent);
	tVoid vHandle_g_Rf_Antenna_Test( amt_tclServiceData* poMessage )const;

	// General Features
	tVoid vHandle_g_PresetList(amt_tclServiceData* poMessage);
	tVoid vHandle_s_GetActiveTuner_Info(amt_tclServiceData* poMessage);
	tVoid vHandle_s_DirectFrequency_Input(amt_tclServiceData* poMessage);
	tVoid vHandle_s_PresetHandling(amt_tclServiceData* poMessage);
	tVoid vHandle_s_AutoStore( amt_tclServiceData* poMessage );
    tVoid vHandle_g_Get_Autostore_Status( amt_tclServiceData* poMessage );
	tVoid vHandle_g_Band_Info( amt_tclServiceData* poMessage );
	tVoid vHandle_s_Visibility( amt_tclServiceData* poMessage );
	tVoid vHandle_g_SourceChange( amt_tclServiceData* poMessage );
	tVoid vHandle_g_Tuner_Source_Availability( amt_tclServiceData* poMessage );

#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	tVoid vHandle_s_HandleSXMPreset(amt_tclServiceData* poMessage);
	tVoid vHandle_g_SXM_PresetHandling(amt_tclServiceData* poMessage);
	tVoid vHandle_s_SXM_PresetAutoCompare(amt_tclServiceData* poMessage);
#endif

	// Announcement related handlers
	tVoid vHandle_s_ActivateAnno(amt_tclServiceData* poMessage);
	tVoid vHandle_g_Anno_Status(amt_tclServiceData* poMessage);
	tVoid vHandle_s_StopAnnouncement( amt_tclServiceData* poMessage );
	tVoid vHandle_g_TP_Status( amt_tclServiceData* poMessage );
	tVoid vHandle_g_AnnoButton_Status(amt_tclServiceData* poMessage)const;
	/**vnd4kor: to solve prio2 lint warning*/
	tVoid vHandle_g_Tuner_Domain_Availability(amt_tclServiceData* poMessage);
	
	tVoid vHandle_s_Set_MTC_SetMode(amt_tclServiceData* poMessage);
	tVoid vHandle_g_MTC_SurveilanceStationStatus(amt_tclServiceData* poMessage);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tVoid vHandle_s_StationSelection(amt_tclServiceData* poMessage);
#endif

#ifdef INCLUDE_PROFILE_MANAGER
	/*OnlinerPersonalization*/
	tVoid vHandle_Tunmstr_s_RadioProfile_Setting(amt_tclServiceData* poMessage);
	tVoid vHandle_s_Radio_Profile_Setting_Request(amt_tclServiceData* poMessage);
	tVoid vSet_tunmstr_PMClient_Handler_Ptr(tunermaster_PMClient* potunmstr_PMClient_Handler);
	tVoid vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status(amt_tclServiceData* poMessage);
	tVoid vHandleUserProfileResponse(amt_tclServiceData* poMessage);
	tVoid vHandle_g_SXM_UserProfile(amt_tclServiceData* poMessage);
#endif

	tVoid vHandle_s_Set_PSFreeze(amt_tclServiceData* poMessage);

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tVoid vSet_tunmstr_SXMClient_Handler_Ptr(tunermaster_SXMClient* potunermaster_SXMClient);
	tVoid vSet_tunmstr_SXMChannelArtClient_Handler_Ptr(tunermaster_SXMchannelartClient* potunermaster_SXMchannelartClient);
	tVoid vHandle_g_Preset_ChannelUpdate(amt_tclServiceData* poMessage);
	tVoid vHandle_s_get_ChannelArtList(amt_tclServiceData* poMessage);
	tVoid vHandle_g_System_Message(amt_tclServiceData* poMessage);
#endif

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
	tVoid vHandle_s_SXM_SrcState(amt_tclServiceData* poMessage);
	tBool bGetSXMSrcState();
#endif

	tVoid vHandle_g_Preset_AutoCompare(amt_tclServiceData* poMessage);

	tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);

#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	tBool bGetSXM360LServiceStatus();
#endif

	tVoid vGetDatafromAMT(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData)const;

	tVoid vSendMessage( stSendCCAMsg OstSendCCAMsg,const fi_tclTypeBase&  oOutData);

	tVoid vSetRegID(tU16 u16RegID);
	tU16 u16GetRegID()const;
	tVoid vSetCmdCntr(tU16 u16CmdCntr);
	tU16 u16GetCmdCntr()const;
	tVoid vSendAST_MethodResult(tU8 u8Source, tU8 u8Action, tU8 u8Opcode);
	tVoid vSetAppID_ActiveTuner(tU16 u16AppID);
	tU16 u16GetActiveTuner_APPID()const;
	tVoid vSend_s_Source_Setup_Option_MethodResult(midw_fi_tcl_e8_TunMstr_ResponseStatus::tenType oStatus);
	tVoid vUpdateAMSourceDp();
	tVoid vHandle_g_Set_DTVAntennaTRegister(amt_tclServiceData* poMessage);
	DECLARE_MSG_MAP( tunmstr_MsgFromHMI )

};






#endif /* tunmstr_MsgFromHMI_H */
