/************************************************************************
 * FILE:           tunmstr_DABClient_Handler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    This class will handle source change logic functionalty.
 *
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date        | Author                       | Modification
 * 11-04-11    | CM-AI/PJ-VW36 Pallavi HN     | initial version
 *
 *************************************************************************/
 
 

#ifndef tunmstr_DABClient_Handler_H
#define tunmstr_DABClient_Handler_H

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h" 

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 


//To include the declaration of STD::Stl
#include <list>


using namespace std; 


#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/clArlSourceImpl.h"
using namespace tuner::sessionManagement::audio;
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#include "announcements/clAnnouncementControl.h"
#endif

//---------------------------------

class clConfigInterface;
//using namespace std;

//using namespace std;

/*--------------------------------*/
/* class tunmstr_DABClient_Handler definition */
/*--------------------------------*/
class tunmstr_DABClient_Handler : public ahl_tclBaseWork
{

private:

	// Pointer to main fc_TunerMaster application class.
	tunmaster_tclApp*   poGWMain;

	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;


	tunmaster_Config*       m_potunmaster_Config;
	// Pointer to class tunmstr_TunerClientHandler.
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	//Pointer to class tunmstr_DABClientHandler
	tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;

	tunmstr_AutoStoreHandler* m_ptunmstr_AutoStoreHandler;


	tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;

	tunmstr_MuteHandler* m_potunmstr_MuteHandler;

	//pointer to class tunmstr_MsgToHMI
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;

	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;

	clConfigInterface* m_poclConfigInterface;

	tVoid vHandleAnnoInfo(tU8 u8Length);
	tU8 u8ConvertDABAnnoTyp_TunMstrAnnoTyp(tU16 u16Type) const;
	tVoid vHandle_s_UnUsedMessages();

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	tunermaster_PMClient* m_ptunmaster_PMClient;
#endif
	//Variables


	tU16 m_u16RegID;
	tU8 m_u8ServiceAvailable_DAB;
	tBool m_bFmServiceFollowActive;

	tU8 m_u8PresetAutocompare;


	midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus m_eAnnoElement ;
	/**Vnd4kor: To solve prio2 lint warning*/
	tVoid vHandlePendingSrcChgReq_DAB();
	tVoid vHandlePendingDABTAReqFromARL(tU8 u8Action);

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
    tuner::sessionManagement::audio::clSessionControl* m_poSessionControl;
    tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
	tBool bIsRequestedSourceDAB();
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
    tuner::announcements::clAnnouncementControl oAnnouncementControl;
#endif


public:
	/*-------------*/
	/* Constructor */
	/*-------------*/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tunmstr_DABClient_Handler( tunmaster_tclApp* poMain, tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl );
#else
	tunmstr_DABClient_Handler( tunmaster_tclApp* poMain);
#endif
	tunmstr_DABClient_Handler(); //default constructor added to remove lint warning
	/* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
	//tunmstr_DABClient_Handler(const tunmstr_DABClient_Handler& c);

	/* RDBID data */

	/*-------------*/
	/* Destructors */
	/*-------------*/
	virtual ~tunmstr_DABClient_Handler( );


	// Set pointer to Msg to Audio
	tVoid vSet_tunmstr_SrcChgManager_Ptr(
			tunmstr_SrcChgManager* potunmstr_SrcChgManager
	);

	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );
	tVoid vSet_tunmstr_SrcChg_AnnoHandler_Ptr( tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler );
	tVoid vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler);
	//Set Pointer to tunmstr_AudioClientHandler
	tVoid vSet_tunmstr_AudioClientHandler_Ptr(
			tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
	);
	tVoid vSet_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vSet_tunmstr_AutoStoreHandler_Ptr(tunmstr_AutoStoreHandler* potunmstr_AutoStoreHandler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tVoid vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler );
	tVoid vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI );
	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	//handler functions for CCA messages
	tVoid vSetDABRegID(tU16 u16RegID);
	tVoid vHandle_s_MethodResult_SrcChg(amt_tclServiceData* poMessage);
	tVoid vHandle_g_Channel_Info(amt_tclServiceData* poMessage);
	tVoid vHandle_g_Anno_Status(amt_tclServiceData* poMessage);
	tVoid vHandle_s_Set_Mute_Status(amt_tclServiceData* poMessage)const;
	tVoid vHandle_g_Mute_Request(amt_tclServiceData* poMessage)const;
	tVoid vHandleDABPresetHandlingMethodResult(amt_tclServiceData* poMessage)const;
	tVoid vHandleDABPresetListMethodResult(amt_tclServiceData* poMessage)const;
	tVoid vHandle_s_AutoStore(amt_tclServiceData* poMessage)const;
	virtual tVoid vSendMessage( tU16             u16DestAppID,
			const fi_tclTypeBase&  oOutData,
			tU16             u16Fid,
			tU8              u8OpCode,
			tU16             u16CmdCtr,
			tU16             u16RegId);
	// CCA messages to be sent to fc_DABtuner
	tVoid vSend_s_Source_State(tU8 u8DAB_State);
	tVoid vSendSourceState(tU8 u8DAB_State);
	tVoid vSend_s_Activate_Preset_List_Elem(tU8 u8Elem_ID);
	tVoid vSend_s_RDBID_Wish_List(amt_tclServiceData* poMessage);
	tVoid vSend_s_Set_Mute_State(tBool blSource , tBool blState);
	tVoid vSend_s_AutoStore(tBool blStatus);
	tVoid vSend_s_Anno_Config(tU16 u16Type);
	tVoid vSend_s_SlectAnno(tU16 u16Type, tBool blStatus);
	//Handles the state changes of the service we use
	tVoid vOnServiceState(   tU16  u16ServiceId ,
			tU16  u16ServerId ,
			tU16  u16RegisterId,
			tU8   u8ServiceState,
			tU16  u16SubId      );

	//Function to handle change in power state
	tVoid vOnNewAppState(   tU32 u32OldAppState,  tU32 u32AppState  );
	tBool fUnregisterForService();

	tVoid vSend_s_StopAnno();
	
	tVoid vSet_MTC_Mode(tU8 u8Mode);
	tVoid vGet_MTC_Mode();
	tVoid vHandleDAB_MTCSetModeMethodResult(amt_tclServiceData* poMessage) const;
	tVoid vHandleDAB_MTCSetModeStatus(amt_tclServiceData* poMessage)const;
	tVoid vHandleDAB_MTC_Surveillance_Monitor(amt_tclServiceData* poMessage);
	tVoid vGet_Surveillance_Mode_Status();
	// Register for FI ID's

	tBool fregisterForFID(tU16 u16FID);
	//Register for fc_amfmtuner service
	tVoid vRegisterForService(void);
	// Function to handle handle DAB service available
	tVoid vHandleDABService_available();

	tU8 u8GetDABServiceState()const;
	tU16 u16GetDABServiceRegID()const;
	tVoid vSendPresetListReq();
	tVoid vHandleDABPresetListStatus(amt_tclServiceData* poMessage)const;
	tU16 u8ConvertTunMstrAnnoTyp_DABAnnoTyp(tU8 u8Type)const;
	tBool blGetFmServiceFollowActive();

	tU8 u8GetPresetAutoCompare();

	tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);


		tVoid vHandleProfileUpdate(tU8 u8UserID,tU8 u8UserIDDest , tU8 u8Action );
#ifdef INCLUDE_PROFILE_MANAGER
		tVoid vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler);
		tVoid vSendDABListonlinePersonalization(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& DABList );
		tVoid vHandle_s_UserProfileUpdateResult(amt_tclServiceData* poMessage);
		tVoid vHandle_S_FID_DAB_S_SAVE_PRESET_LIST_MethodeResult(amt_tclServiceData* poMessage);
#endif
		virtual tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData )const;
	DECLARE_MSG_MAP( tunmstr_DABClient_Handler )


   /*MTC tuner Surveillance status  message*/
   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus oMTCSurveilanceStatus;


};


#endif // tunmstr_DABClient_Handler_H
