/************************************************************************
* FILE:         tunermaster_servce.cpp
* PROJECT:      G3g
* SW-COMPONENT: TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION: TunerMaster Server
*              
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      	| Author                       	| Modification
* 08/09/10      | ECV4, PallaviHN          		| initial version
* 25.04.13 	    | NGP1KOR                       | First version of the G3g after porting from NISSAN LCN2Kai
				
*************************************************************************/



//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"   



#include "tunermaster_utility.h"
#include "tunermaster_main.h"
#include "tunermaster_service.h"
#include "tunermaster_trace.h"


/* +++
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
+++ */

/*************************************************************************
*
* FUNCTION: tunermaster_tclservice::tunermaster_tclservice(tunmaster_tclApp* poGWMainApp)
* 
* DESCRIPTION: constructor, creates object tunermaster_tclservice - object
*
* PARAMETER: tunmaster_tclApp* poGWMainApp: main - object of this application 
*
* RETURNVALUE: none
*
*************************************************************************/
tunermaster_tclservice::tunermaster_tclservice(tunmaster_tclApp* potunerMainApp)
{
 /* ---
   this constructor calls ( impicit ) the constructor of the upper class ( framework )
   so it registers the combinations of FID and message handler with the framework
   --- */
   poGWMain     = potunerMainApp;
   poNotTable   = potunerMainApp->_poNotTable;
   hNotTableSem = tunmaster_tclApp::_hNotTableSem;

   _oActivityLock.bInit();
}


/*************************************************************************
*
* FUNCTION: tunermaster_tclservice::~tunermaster_tclservice()
* 
* DESCRIPTION: Destructor
*
* PARAMETER: tnone 
*
* RETURNVALUE: none
*
*************************************************************************/
tunermaster_tclservice::~tunermaster_tclservice() 
{
   _oActivityLock.bDestroy();

   poGWMain = NULL;

   poNotTable = NULL;

 
}



/*************************************************************************
*
* FUNCTION:tVoid tunermaster_tclservice::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
* 
* DESCRIPTION: handle unkown message
*
* PARAMETER:  unkown message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tunermaster_tclservice::vOnUnknownMessage(amt_tclBaseMessage* /*poMessage*/)
{
  /* +++
   the frame work call this function when it receives a message with a unknown 
   FID. You can use it for error handling.
  +++ */

  /* Delete the message */
  /*if( poMessage != NULL )
  {
    poMessage->bDelete();
  }*/
  
}




/*************************************************************************
*
* FUNCTION: tVoid tunermaster_tclservice::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
* 
* DESCRIPTION: handles state - change messages form the spm
*
* PARAMETER: old state, new state
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tunermaster_tclservice::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)const
{
   switch(u32AppState)
   {
   case AMT_C_U32_STATE_NORMAL:
      {
         if(u32OldAppState == AMT_C_U32_STATE_NORMAL) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tunmaster_tclApp )
         +++ */
         
         break;
      }
   case AMT_C_U32_STATE_DIAGNOSIS:
      {
         if(u32OldAppState == AMT_C_U32_STATE_DIAGNOSIS) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tunmaster_tclApp )
         +++ */
         
         break;
      }
   case AMT_C_U32_STATE_PAUSE:
      {
         if(u32OldAppState == AMT_C_U32_STATE_PAUSE) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tunmaster_tclApp )
         +++ */
         
         break;
      }
   case AMT_C_U32_STATE_OFF:
      {
         if(u32OldAppState == AMT_C_U32_STATE_OFF) 
         { 
            break; //switching to the same state
         } 

         /* +++
         here you can react on changes of the power state 
         ( if not already done in tunmaster_tclApp )
         +++ */
         
         break;
      }
   default:
      {
         /* +++
         unkown power state:
         enter error handling here ( trace or assert )
         +++ */
         break;
      }
   }
}






/*************************************************************************
*
* FUNCTION: tVoid tunermaster_tclservice::bSendStatus(tU16 u16FID ,tU8 Value)
* 
* DESCRIPTION: sends an status - message
*
* PARAMETER: Function - ID and data to send
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tunermaster_tclservice::bSendStatus(tU16 u16FID ,tU8 u8Value)const
{


  ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV, ET_EN_T16 _ u16FID _
                                                ET_EN_T8  _ u8Value _ ET_EN_DONE);
}





/*************************************************************************
*
* FUNCTION: tVoid tunermaster_tclservice::bSendAnswer
* 
* DESCRIPTION: sends an answer message
*
* PARAMETER: message to be answered, data, opcode of the answer
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tunermaster_tclservice::bSendAnswer
(
 const amt_tclServiceData* poMessage, 
 tU8 u8Value, 
 tU8 u8Opcode
 )const
{
  /* Code kept for future use. */

  if( poMessage == NULL )
  {
    ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV, ET_EN_T16 _\
                       TUNMSTR_TRACE_TCLSERVICE_INVALID_PARA _ ET_EN_DONE);

  }
  
 
  ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV, ET_EN_T8 _  u8Value _
                                                ET_EN_T8  _ u8Opcode _ ET_EN_DONE);

}

/*************************************************************************
*
* FUNCTION: tVoid tunermaster_tclservice::vSendError
* 
* DESCRIPTION: sends an error - message
*
* PARAMETER: data for addressing the message
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tunermaster_tclservice::vSendError
( 
 tU16 u16AMTErrorCode,
 tU16 u16TMCErrorCode,
 tU16 u16FID,
 tU16 u16RegisterID
 ) const
{
   /* Code kept for future use. */
 
  ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV, ET_EN_T16 _  u16AMTErrorCode _
                                                ET_EN_T16 _  u16TMCErrorCode _
                                                ET_EN_T16 _  u16FID _
                                                ET_EN_T16 _  u16RegisterID _
                                                ET_EN_DONE);
   

   
}



/*************************************************************************
*
* FUNCTION: tBool tunermaster_tclservice::bUpreg
* 
* DESCRIPTION: insert the sender of the message to the NotifcationTable
*              (i.e. register this client)
*
* PARAMETER: amt_tclServiceData* poMessage: upreg request message
*
* RETURNVALUE: void
*
*************************************************************************/
tBool tunermaster_tclservice::bUpreg( const amt_tclServiceData* poMessage )const
{
   tBool bRegOpStatus = FALSE; 

  if( poMessage == NULL )
  {
    ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV, ET_EN_T16 _\
                       TUNMSTR_TRACE_TCLSERVICE_INVALID_PARA _ ET_EN_DONE);

  }   
   

  /* Code kept for future use. */
      
   return bRegOpStatus;
}

/*************************************************************************
*
* FUNCTION: tBool tunermaster_tclservice::bRelUpreg
* 
* DESCRIPTION: remove the sender of the message from the NotifcationTable
*              (i.e. unregister this client)
*
* PARAMETER: amt_tclServiceData* poMessage: relupreg request message
*
* RETURNVALUE: void
*
*************************************************************************/
tBool tunermaster_tclservice::bRelUpreg( const amt_tclServiceData* poMessage )const
{
   tBool bRegOpStatus = false;      
   
   if( poMessage == NULL )
   {
     ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV, ET_EN_T16 _\
                        TUNMSTR_TRACE_TCLSERVICE_INVALID_PARA _ ET_EN_DONE);

   }  

  /* Code kept for future use. */   

   return bRegOpStatus;
}


/* *****************************************************************************

   FUNCTION:      vDeleteNoThrow

   DESCRIPTION:   Deletes memory without throwing an exception.

   PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

   RETURN TYPE:   void

   HINT:          Why this function? If delete is called inside the destructor,
                  Lint complains with warning 1551 that delete might throw an
                  execption, which is not caught.

                  But try / catch must not be used, and delete does not throw
                  an exception, anyway. To prevent a Lint warning deactivation,
                  this function guarantees that no exception is thrown.
                  Furthermore, it sets the given pointer to 0, and Lint is
                  happy.

                  It is a template, because two different memory types have to
                  be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tunermaster_tclservice::vDeleteNoThrow( T*& rfpArg ) throw()
{
   OSAL_DELETE rfpArg;
   rfpArg = 0;
}
