/************************************************************************
 * FILE:           tunermaster_main.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    TunerMaster Server
 *
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:
* Date     		 | Author                        | Modification
* 17.08.10  	 | ECV4-Pallavi HN           	 | initial version
* 25.04.13   	 | NGP1KOR 					     | First version of the G3g after porting from NISSAN LCN2Kai.
				
 *************************************************************************/


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"       

//------------------------------------------------------------------------------
//includes for SessionManagement and Announcement libs
//------------------------------------------------------------------------------
#include "fc_tunermaster_featureControl.h"

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_AMT_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
//AHL AMT mocks already included
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 



#include "tunermaster_Class_ForwardDecl.h"

#include "tunermaster_defines.h"
#include "tunermaster_SPM_Client.h"

#ifdef INCLUDE_PROFILE_MANAGER
   #include "tunermaster_PMClient.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
  #include "tunermaster_SXMClient.h"
  #include "tunermaster_SXMchannelartClient.h"
#endif

#include "tunermaster_Config.h"
#include "kdsconfig/clConfigMain.h"
#include "tunermaster_utility.h"
#include "tunermaster_service.h"
#include "tunermaster_main.h"
#include "tunermaster_trace.h"
#include "tunermaster_PrjConfig.h"
#include "tunmstr_SrcChg_Defines.h"
#include "tunermaster_cfcVehicleClientHandler.h"
#include "tunmstr_MsgFromHMI.h"
#include "tunmstr_MsgToHMI.h"
#include "convTables/midwTunerMap.h"

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16

#define ARL_S_IMPORT_INTERFACE_GENERIC_AIL
#include "audio_routing_lib.h"


#include "tunmstr_TunerClientHandler.h"
#include "tunmstr_AudioClientHandler.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_DABClient_Handler.h"

#include "tunmstr_Preset_Handler.h"
#include "tunmstr_AutoStorehandler.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#include "tunmstr_MuteHandler.h"
#include "tunmstr_SDSHandler.h"
#endif
#ifndef tunmstr_antdiag_Manager_H
#include "tunmstr_antdiag_Manager.h"
#endif
#ifndef tunmstr_antdiag_Debounce_H
#include "tunmstr_antdiag_Debounce.h"
#endif
#ifndef tunmstr_DiaglibListner_H
#include "tunmstr_DiaglibListner.h"
#endif
#ifndef tunmstr_antdiag_Measure_H
#include "tunmstr_antdiag_Measure.h"
#endif
#ifndef tunmstr_DiagLogClientHandler_H
#include "tunmstr_DiagLogClientHandler.h"
#endif
#ifndef tunmstr_antdiag_i2cHandler_H
#include "tunmstr_antdiag_i2cHandler.h"
#endif
#include "tunermaster_main.h"

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#include "announcements/clAudioImpl.h"
#include "announcements/clAMFMAnnouncementsImpl.h"
#include "announcements/clDABAnnouncementsImpl.h"
#include "announcements/clAudioControl.h"
#include "announcements/clTunerControl.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clArlSourceImpl.h"
#include "sessionManagement/clAMFMTunerImpl.h"
#include "sessionManagement/clDABTunerImpl.h"
#include "sessionManagement/audio/clAudioControl.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "sessionManagement/audio/clAudioSession.h"
#endif
#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_tuner_if.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_TUNMASTERAPP 
#include "trcGenProj/Header/tunermaster_main.cpp.trc.h"
#endif

/**vnd4kor : to solve prio 2 lint warning*/
//lint -"esym(793,external identifiers)"

OSAL_tSemHandle tunmaster_tclApp::_hNotTableSem  = OSAL_C_INVALID_HANDLE;
tBool           tunmaster_tclApp::_bAppClosed    = FALSE;
tunmaster_tclApp* tunmaster_tclApp::_poExemplar      = NULL;

tunmaster_tclApp* tunmaster_tclApp::_theServer = NULL;

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::theServer
 *
 *DESCRIPTION:  create new server object
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tunmaster_tclApp* _theServer
 *
 *HISTORY:
 *27.01.07 kol2hi
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tunmaster_tclApp*
tunmaster_tclApp::theServer()
{
	if (_theServer == NULL)
	{
		_theServer = new tunmaster_tclApp();
	}
	return _theServer;
}
/*************************************************************************
 *
 * FUNCTION: tunmaster_tclApp::tunmaster_tclApp()
 *
 * DESCRIPTION:
 *
 *  Constructor: - Initialize AMT, create Sem, create notification table
 *
 *
 * PARAMETER: void
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tunmaster_tclApp::tunmaster_tclApp() :fInitializationComplete( FALSE ),cleoSBRVariant(0x2A),aivi2SBRVariant(0x2B)
{
	/* ---
   initialize the AMT/CCA framework for this component
   --- */
	ET_TRACE_OPEN;

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_CONSTRUCTOR _ ET_EN_DONE);

	/** Initialize all pointer variables to NULL **/
	vInitializeToDefault();

	amt_bInit();

	m_blStartup_Trigger = FALSE;
	u16m_RegID = 0x00;
	m_u8StreamRouterServiceState=TUNMSTR_SRCCHG_INVALID;
	m_u16TunerControlRegID=AMT_C_U16_REGID_INVALID;
	m_u16DabRegID=AMT_C_U16_REGID_INVALID;
	/* ---
   create semaphore for protecting NotificationTable
   --- */
	tS32 s32RetFlag = OSAL_s32SemaphoreCreate(TUNERMASTER_NOTTABLE_SEM_NAME, &_hNotTableSem, 1);
	//Added to remove lint warning.
	ETG_TRACE_USR1(( " tunmaster_tclApp::tunmaster_tclApp()->s32RetFlag=%u", s32RetFlag));



	/* ---
   create NotificationTable.
   Here we store information about all registered clients
   --- */
	_poNotTable = new ahl_tclNotificationTable(TUNERMASTER_FUNCARRAY_SIZE);

	/* ---
   create the cca service handler. 
   It analyses the received cca messages and calls the corresponding handler function
   --- */
	_tunermaster_poCCAService = new tunermaster_tclservice(this);

	/* +++
   HERE YOU CAN INITIALIZE YOUR APPLICATION 
   - start your threads
   - register your call backs
   - create anything you need
   +++ */

	/* class tunmaster_tclApp* can be accessed from static functions */
	_poExemplar = this;

	/*-----------------------------------*/
	/* Register with the trace component */
	/*-----------------------------------*/
	vRegisterInTraceCmdService();

	/*--------------------------------------*/
	/* Initialize the tuner component here  */
	/*--------------------------------------*/
	if( !fInitializationComplete )
	{
		//vInitializeTunMasterComponent( );

		fInitializationComplete = TRUE;

	}

	m_poPortMngr = new ahl_tclServerPortMngr(this);

}

/*************************************************************************
 *
 * FUNCTION: tunmaster_tclApp::~tunmaster_tclApp()
 *
 * DESCRIPTION: destructor, frees all ressources
 *             ( if not done by vOnApplicationClose before )
 *
 * PARAMETER: void
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tunmaster_tclApp::~tunmaster_tclApp()
{
	/* ---
   Normally the SPM calls vOnApplicationClose before this application - object is
   destroyed. Here we check if the ressources are already freed by vOnApplicationClose else 
   we free the ressources
   --- */ 

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_DESTRUCTOR _ ET_EN_DONE);

	vDeleteClassInstances();
	/*-----------------------*/
	/* Delete CCAService  */
	/*-----------------------*/
	if( _tunermaster_poCCAService != NULL )
	{
		vDeleteNoThrow(_tunermaster_poCCAService);

		_tunermaster_poCCAService = NULL;
	}
	/*-----------------------*/
	/* Delete NotTable  */
	/*-----------------------*/
	if( _poNotTable != NULL )
	{
		vDeleteNoThrow(_poNotTable);

		_poNotTable = NULL;
	}


	_poExemplar = NULL;
	//   m_ptunmstr_RUMessage = NULL;

	/*---------------------------------*/


	/*--------------------------------------*/
	/* Unregister with the trace component  */
	/*--------------------------------------*/
	vUnregisterInTraceCmdService( );



	if(!_bAppClosed)
	{
		tunmaster_tclApp :: vOnApplicationClose();
	}

	ET_TRACE_CLOSE;
	m_u8StreamRouterServiceState=TUNMSTR_SRCCHG_INVALID;
	m_u16TunerControlRegID=AMT_C_U16_REGID_INVALID;
	m_u16DabRegID=AMT_C_U16_REGID_INVALID;
	m_potunmstr_antdiag_i2cHandler=NULL;
}

/*************************************************************************
 *
 **************************************************************************/
tVoid tunmaster_tclApp::vInitializeToDefault()
{
	m_ptunmstr_Utility = NULL;
	m_ptunmaster_Config = NULL;
	m_poclConfigMain = NULL;
	m_ptunmaster_tclSPMClient = NULL;
#ifdef INCLUDE_PROFILE_MANAGER
	m_ptunmaster_PMClient = NULL;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_ptunmaster_SXMClient = NULL;
	m_ptunermaster_SXMchannelartClient = NULL;
#endif
	m_potunermaster_cfcVehicleClientHandler = NULL;
	m_potunmstr_DiaglibListner = NULL;
	m_potunmstr_antdiag_Debounce = NULL;
	m_potunmstr_antdiag_Manager = NULL;
	m_potunmstr_antdiag_Measure = NULL;
	m_potunmstr_DiagLogClientHandler = NULL;
	m_potunmstr_antdiag_i2cHandler = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_MsgToHMI = NULL;

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlSourceImpl = NULL;
	m_poAMFMTunerImpl = NULL;
	m_poDABTunerImpl = NULL;
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	m_pAudioImpl = NULL;
	m_poAMFMAnnouncementImpl = NULL;
	m_poDABAnnouncementImpl = NULL;
	m_poAnnouncementControl = NULL;
#endif

#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_potunmstr_AudioClientHandler = NULL;
#endif

	m_potunmstr_TunClnt_Handlr = NULL;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_Preset_Handler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_AutoStoreHandler = NULL;
	m_potunmstr_MuteHandler = NULL;
	m_potunmstr_SDSHandler = NULL;

#endif
	
}

/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vInitializeTunMasterComponent ()
 *
 * DESCRIPTION:
 *
 * PARAMETER: void
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vInitializeTunMasterComponent ()
{

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_INIT_TUNER _ ET_EN_DONE);
	vCreateClassInstances();
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
      (NULL == m_potunmstr_SrcChgManager )||
#endif
      (NULL == m_potunmstr_Preset_Handler)||(NULL == m_potunmstr_AutoStoreHandler)|| (NULL == m_potunmstr_MsgToHMI) ||
      (NULL == m_potunmstr_SrcChg_AnnoHandler) || (NULL == m_potunmstr_MuteHandler) || (NULL == m_ptunmaster_Config) ||
	  (NULL == m_potunmstr_SDSHandler) || (NULL == m_poclConfigMain))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_AutoStoreHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_ptunmaster_Config != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MuteHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SDSHandler != NULL );
		NORMAL_M_ASSERT( m_poclConfigMain != NULL );
		return;
	}

	//Update Pointer variables in tunmstr_SrcChgManager class
		m_potunmstr_SrcChgManager->vSet_tunmaster_Config_Ptr( m_ptunmaster_Config );
		m_potunmstr_SrcChgManager->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
		m_potunmstr_SrcChgManager->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
		m_potunmstr_SrcChgManager->vSet_tunmstr_SrcChg_AnnoHandler_Ptr(m_potunmstr_SrcChg_AnnoHandler);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_potunmstr_SrcChgManager->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif
	m_potunmstr_SrcChgManager->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
	m_potunmstr_SrcChgManager->vSet_tunmaster_tclSPMClient(m_ptunmaster_tclSPMClient);
	m_potunmstr_SrcChgManager->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
	m_potunmstr_SrcChgManager->vSet_tunmstr_MuteHandler_Ptr(m_potunmstr_MuteHandler);



	//Update Pointer variables in tunmstr_Preset_Handler class
	m_potunmstr_Preset_Handler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
	m_potunmstr_Preset_Handler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
	m_potunmstr_Preset_Handler ->vSet_tunmaster_Config_Ptr( m_ptunmaster_Config );
	m_potunmstr_Preset_Handler ->vSet_tunmstr_ConfigInterface_Ptr( m_poclConfigMain );

#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_potunmstr_Preset_Handler ->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif
	m_potunmstr_Preset_Handler ->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
	m_potunmstr_Preset_Handler ->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
	m_potunmstr_Preset_Handler ->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
	m_potunmstr_Preset_Handler ->vSet_tunmstr_MuteHandler_Ptr(m_potunmstr_MuteHandler);

	m_potunmstr_SDSHandler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
	m_potunmstr_SDSHandler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
	m_potunmstr_SDSHandler->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
	m_potunmstr_SDSHandler->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
	m_potunmstr_SDSHandler->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
	m_potunmstr_SDSHandler->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_potunmstr_SDSHandler->vSet_tunmstr_SXMClient_Handler_Ptr(m_ptunmaster_SXMClient);
#endif
	m_potunmstr_SDSHandler->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);

	//Update Pointer variables in tunmstr_AutoStoreHandler class
	m_potunmstr_AutoStoreHandler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
	m_potunmstr_AutoStoreHandler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
	m_potunmstr_AutoStoreHandler ->vSet_tunmaster_Config_Ptr( m_ptunmaster_Config );
	m_potunmstr_AutoStoreHandler ->vSet_tunmstr_ConfigInterface_Ptr( m_poclConfigMain );
	m_potunmstr_AutoStoreHandler->vSet_tunmstr_TunerClientHandler(m_potunmstr_TunClnt_Handlr);
	m_potunmstr_AutoStoreHandler ->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
	m_potunmstr_AutoStoreHandler ->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
	m_potunmstr_AutoStoreHandler ->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);

	//Update Pointer variables in tunmstr_SrcChg_AnnoHandler class
	m_potunmstr_SrcChg_AnnoHandler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
	m_potunmstr_SrcChg_AnnoHandler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
	m_potunmstr_SrcChg_AnnoHandler->vSet_tunmstr_TunerClientHandler(m_potunmstr_TunClnt_Handlr);
	m_potunmstr_SrcChg_AnnoHandler ->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
	m_potunmstr_SrcChg_AnnoHandler ->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
	m_potunmstr_SrcChg_AnnoHandler ->vSet_tunmaster_Config_Ptr( m_ptunmaster_Config );
	m_potunmstr_SrcChg_AnnoHandler ->vSet_tunmstr_ConfigInterface_Ptr( m_poclConfigMain );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_potunmstr_SrcChg_AnnoHandler ->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif

	//Update Pointer variables in tunmaster_Config class
	m_ptunmaster_Config->vSet_tunmstr_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
	#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_ptunmaster_Config->vSet_tunmstr__ArlSourceImplPtr((tuner::sessionManagement::audio::clArlSourceImpl*)m_poArlSourceImpl);
	#endif
#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	m_ptunmaster_Config->vSet_tunmstr__AnnouncementControlImplPtr((tuner::announcements::clAnnouncementControl*) m_poAnnouncementControl);
#endif
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_ptunmaster_Config->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif
	m_potunmstr_MuteHandler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
	m_potunmstr_MuteHandler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
	m_potunmstr_MuteHandler->vSet_tunmstr_TunerClientHandler(m_potunmstr_TunClnt_Handlr);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_potunmstr_MuteHandler ->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif
	m_potunmstr_MuteHandler ->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
	m_potunmstr_MuteHandler ->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);

#else
    if(NULL == m_ptunmaster_Config || NULL == m_potunmstr_MsgToHMI)
	{
		NORMAL_M_ASSERT( m_ptunmaster_Config != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
        return;
	}
#endif

	m_ptunmaster_Config->vSettunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);

	//Update Pointer variables in tunmstr_MsgToHMI class
	m_potunmstr_MsgToHMI->vSet_tunmaster_Config_Ptr(m_ptunmaster_Config);
	m_potunmstr_MsgToHMI ->vSet_tunmstr_ConfigInterface_Ptr( m_poclConfigMain );
	m_potunmstr_MsgToHMI->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	m_potunmstr_MsgToHMI->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
#endif
#ifdef INCLUDE_PROFILE_MANAGER
	m_potunmstr_MsgToHMI->vSet_tunmstr_PMClient_Ptr(m_ptunmaster_PMClient);
#endif
	m_ptunmaster_Config->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);

#ifdef INCLUDE_PROFILE_MANAGER
	if (NULL != m_ptunmaster_PMClient)
		m_potunmstr_Preset_Handler ->vSet_tunmstr_PMClient_Ptr( m_ptunmaster_PMClient );

    if(NULL == m_ptunmaster_PMClient )
	{
		NORMAL_M_ASSERT( m_ptunmaster_PMClient != NULL );
        return;
	}
    else
    {
    	m_ptunmaster_PMClient->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
    	m_ptunmaster_PMClient->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
    	m_ptunmaster_PMClient->vSet_tunmstr_ArlSourceImplPtr((tuner::sessionManagement::audio::clArlSourceImpl*)m_poArlSourceImpl);
    	m_ptunmaster_PMClient->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
    	m_ptunmaster_PMClient->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
    }
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		m_potunmstr_Preset_Handler->vSet_tunmstr_SXMClient_Ptr( m_ptunmaster_SXMClient );
		m_potunmstr_Preset_Handler-> vSet_tunmstr_SXMChannelArtClient_Ptr(m_ptunermaster_SXMchannelartClient);
#endif

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	m_potunmstr_MsgToHMI->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
	m_potunmstr_MsgToHMI->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
	m_potunmstr_MsgToHMI->vSet_tunmstr_SrcChg_AnnoHandler_Ptr(m_potunmstr_SrcChg_AnnoHandler);
#endif

	m_poclConfigMain->vSetTunerInterfacePtr(m_ptunmaster_Config);

	vReadProjectConfiguration();
	if(m_poclConfigMain->u32GetConfigData("SBR"))
	{
		clSessionControl::getInstance()->vSetSBRVariant(true);
	}
	vUpdateClientsPointer();

#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::FMTA, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioFMTA"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::PTY31FM, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioFMPTY31"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABALARM, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABAlarm"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABTA, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABRoadTrafficFlash"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABTRANSPORT, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABTransportFlash"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABWARNING, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABWarningService"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABNEWS, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABNewsFlash"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABWEATHER, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABAreaWeatherFlash"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABEVENT, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABEventAnnouncement"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABSPECIALEVENT, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABSpecialEvent"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABPROGRAMME, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABProgramInformation"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABSPORTS, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABSportReport"));
      m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::DABFINANCE, (tU8)m_poclConfigMain->u32GetConfigData("AnnouncementPrioDABFinantialReport"));
      tU32 u32Available_band = m_poclConfigMain->u32GetConfigData("AvailableBands");
      if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL))
      {
         m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::WEATHERALERT, ALWAYS_ALLOW_ANNOUNCEMENTS);
      }
      else
      {
         m_poAnnouncementControl->vSetAnnouncementPriority(tuner::common::WEATHERALERT, IGNORE_ANNOUNCEMENTS);
      }
#endif
#ifdef INCLUDE_PROFILE_MANAGER
    if(NULL != m_ptunmaster_PMClient)
      m_ptunmaster_PMClient->vPersonalizationMasterListCreation();
#endif
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	  m_potunmstr_TunClnt_Handlr->vRegisterForService();
	  m_potunmstr_DABClient_Handler->vRegisterForService();
	  //m_ptunmaster_PMClient->fRegisterForService();
#endif

}
/*************************************************************************
 *
 * FUNCTION: tBool tunmaster_tclApp::vReadProjectConfiguration ()
 *
 * DESCRIPTION: is called after the initialisation of the framework is finished
 *
 * PARAMETER: void
 *
 * RETURNVALUE: TRUE
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vReadProjectConfiguration()
{
	if( NULL== m_ptunmaster_Config)
	{
		return;
	}
	if( NULL== m_poclConfigMain)
	{
		return;
	}
//	/*Read configuration from KDS (for Nissan) or from registry (other projects)*/
//	m_ptunmaster_Config->vReadKDSConfig_AMFMParamters();
//	m_ptunmaster_Config->vReadKDSGenericTunerParameterSet();
//	m_ptunmaster_Config->vReadKDSCMVariantCoding();
//	/**Reading of the ECU HW version data for Antenna diagnosis*/
//	m_ptunmaster_Config->vReadECUHWVer();
//#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
//	m_ptunmaster_Config->vReadKDSEOLParameters();
//#endif

	#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
   if(NULL!= m_poArlSourceImpl)
	{
		m_poArlSourceImpl->vInit();
	}
#else
	if(NULL!= m_potunmstr_AudioClientHandler)
	{
		m_potunmstr_AudioClientHandler->vCheckTunerSourceavailability();
	}
#endif
	#endif

	m_ptunmaster_Config->vUpdateAnnoPrio();
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(m_potunmstr_Preset_Handler != NULL)
	{
		m_potunmstr_Preset_Handler->vUpdateMixedPresetListBandAsNone();
	}
#endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   vSetMidwTunerBand(m_poclConfigMain->u32GetConfigData("CombiBands"),m_poclConfigMain->u32GetConfigData("AvailableBands"));
#endif
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	vSetMidwTunerSource(m_poclConfigMain->u32GetConfigData("CombiBands"),m_poclConfigMain->u32GetConfigData("AvailableBands"));
	/*This is added to remove hard coding of ANNO Surveillance state instead it written based on KDS config*/
   clSessionControl::getInstance()->vTunerSetFGBGLearnForever(tuner::common::FM1,m_poclConfigMain->u32GetConfigData("FMLearnForever"));
   clSessionControl::getInstance()->vTunerSetFGBGLearnForever(tuner::common::AM,m_poclConfigMain->u32GetConfigData("AMLearnForever"));
   clSessionControl::getInstance()->vTunerSetFGBGLearnForever(tuner::common::DAB,m_poclConfigMain->u32GetConfigData("DABLearnForever"));
   clSessionControl::getInstance()->vLearnForever(m_poclConfigMain->u32GetConfigData("NonRadioLearnForever"));
#endif
}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
/*Source Availability must be sent only after the tunermaster service becomes available */
tVoid tunmaster_tclApp::vCheckSourceAvailabilityfromKDS()
{
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	ETG_TRACE_USR4(( "m_poclConfigMain=%p",m_poclConfigMain));
	if((NULL==m_poclConfigMain) || (NULL==m_poArlSourceImpl) || (NULL == m_poclConfigMain))
	{
		return;
	}
	stSourceAvailabilty aTunerSourceAvailability;
	tU32 u32Available_band =m_poclConfigMain->u32GetConfigData("AvailableBands");
	tBool blDABAvail= (tBool)m_poclConfigMain->u32GetConfigData("DABSupported");
    for(tU8 u8Source=(tU8)ARL_SRC_FM;u8Source<=(tU8)ARL_SRC_DABTA;u8Source++)
	{
    	ETG_TRACE_USR4(( "u8Source=%d",u8Source));
    	aTunerSourceAvailability.oSource= u8Source;
    	aTunerSourceAvailability.oSrcAvail =	ARL_EN_SRC_NOT_AVAILABLE;
    	aTunerSourceAvailability.oAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
    	switch(u8Source)
		{
			case ARL_SRC_FM:
			case ARL_SRC_FMTA:
			{
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_FM_MASKVAL))
				{
					aTunerSourceAvailability.oSource= (arl_tenSource)u8Source;
					aTunerSourceAvailability.oSrcAvail =	ARL_EN_SRC_PLAYABLE_UNKNOWN;
					aTunerSourceAvailability.oAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
				}
				break;
			}
			case ARL_SRC_AM:
			{
			    #ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
				dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
				tBool bTmcTunerDPAMAvailStatus = true;
				oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
				ETG_TRACE_USR4(( "AMAvailability=%d",bTmcTunerDPAMAvailStatus));

				if(  (m_poclConfigMain->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigMain->u32GetConfigData("CFGAM")))
				{
					if (bTmcTunerDPAMAvailStatus)
					{
						aTunerSourceAvailability.oSource= (arl_tenSource)u8Source;
						aTunerSourceAvailability.oSrcAvail =	ARL_EN_SRC_PLAYABLE_UNKNOWN;
						aTunerSourceAvailability.oAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
					}
				}
				#else
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_AM_MASKVAL))
				{
					aTunerSourceAvailability.oSource= (arl_tenSource)u8Source;
					aTunerSourceAvailability.oSrcAvail =	ARL_EN_SRC_PLAYABLE_UNKNOWN;
					aTunerSourceAvailability.oAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
				}
			    #endif
				break;
			}
			case ARL_SRC_DAB:
			case ARL_SRC_DABTA:
			{
				if(blDABAvail)
				{
					aTunerSourceAvailability.oSource= (arl_tenSource)u8Source;
					aTunerSourceAvailability.oSrcAvail =	ARL_EN_SRC_PLAYABLE_UNKNOWN;
					aTunerSourceAvailability.oAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
				}
				break;
			}
		}
    	ETG_TRACE_USR4(( " vUpdateAudioSourceAvailabelStatus() source =%d availability =%d reason=%d",aTunerSourceAvailability.oSource, aTunerSourceAvailability.oSrcAvail,aTunerSourceAvailability.oAvailabilityReason));
    	m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)aTunerSourceAvailability.oSource,(arl_tenSrcAvailability)aTunerSourceAvailability.oSrcAvail,(arl_tenAvailabilityReason)aTunerSourceAvailability.oAvailabilityReason);
	}
    //Send source availability for DRM
    arl_tenSrcAvailability arlSrcAvailability = ARL_EN_SRC_NOT_AVAILABLE;
    arl_tenAvailabilityReason arlAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
    if (m_poclConfigMain->u32GetConfigData("DRMSupported"))
	{
    	arlSrcAvailability = ARL_EN_SRC_PLAYABLE_UNKNOWN;
    }
    m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus(ARL_SRC_DRM,arlSrcAvailability,arlAvailabilityReason);
 #endif
}
#endif
/*************************************************************************
 *
 * FUNCTION: tBool tunmaster_tclApp::bOnInit ()
 *
 * DESCRIPTION: is called after the initialisation of the framework is finished
 *
 * PARAMETER: void
 *
 * RETURNVALUE: TRUE
 *
 *************************************************************************/
tBool tunmaster_tclApp::bOnInit ()
{
	vInitializeTunMasterComponent( );
	//Initialize all classes
	/* +++
   here you can start your application
   +++ */
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_ONINIT _ ET_EN_DONE);

	//   m_pPortMngr->vClearAll();

	return  TRUE;
}

/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vOnServiceState
 *
 * DESCRIPTION: FC_TunerMaster is client to the components, the
 *              Service state responses will be handled here.
 *
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vOnServiceState
( 
		tU16  u16ServiceId   ,
		tU16  u16ServerId    ,
		tU16  u16RegisterId  ,
		tU8   u8ServiceState ,
		tU16  u16SubId
)
{
	ETG_TRACE_USR1(( " tunmaster_tclApp::	vOnServiceState::"
				"u16ServiceId=%d u16ServerId=%d u16RegisterId=%d u8ServiceState=%d u16SubId=%d",
				u16ServiceId,u16ServerId,u16RegisterId,u8ServiceState,u16SubId));
	stOnServiceStateParm OnServiceStateParm;
	OnServiceStateParm.u16ServiceId=u16ServiceId;
	OnServiceStateParm.u16RegisterId=u16RegisterId;
	OnServiceStateParm.u8ServiceState=u8ServiceState;

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if( 
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB      
      (m_potunmstr_AudioClientHandler == NULL)||
#endif
      (m_potunmstr_TunClnt_Handlr==NULL)\
			||(m_potunmstr_DABClient_Handler==NULL))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT (NULL != m_potunmstr_TunClnt_Handlr);
		NORMAL_M_ASSERT (NULL != m_potunmstr_DABClient_Handler);
		return;
	}
	switch ( u16ServiceId )
	{

	case CCA_C_U16_SRV_TUNERCONTROL:
		{
			// Inform the SPM CCA client handler
			ETG_TRACE_USR1(( " vOnServiceState()->entered into Tuner control service"));
			m_potunmstr_TunClnt_Handlr->vOnServiceState ( u16ServiceId,
				u16ServerId,
				u16RegisterId,
				u8ServiceState,
				u16SubId );
			break;
		}
	case CCA_C_U16_SRV_DAB_TUNER:
	{
		// Inform the DAB CCA client handler
		m_potunmstr_DABClient_Handler->vOnServiceState ( u16ServiceId,
				u16ServerId,
				u16RegisterId, 
				u8ServiceState,
				u16SubId );
		break;
	}
	case CCA_C_U16_SRV_STREAMROUTER:
	{

		m_u8StreamRouterServiceState=u8ServiceState;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if( (m_poArlSourceImpl != 0) && (m_poAnnouncementControl != 0))
		{
			/*Dont change the order. As soon as the service status unavailabel info is forwared to ARL,
			  ARL might send the source activty off before the session management stack info is cleared*/		
			m_poArlSourceImpl->vUpdateStreamRouterServiceState(static_cast<tuner::common::enTunerClientAvailability>(u8ServiceState));
			m_poAnnouncementControl->vUpdateStreamRouterServiceState(static_cast<tuner::common::enTunerClientAvailability>(u8ServiceState));
			m_poArlSourceImpl->vOnServiceState ( u16ServiceId,
				u16ServerId,
				u16RegisterId,
				u8ServiceState,
				u16SubId );

		}
#else
		m_potunmstr_AudioClientHandler->vOnServiceState ( u16ServiceId,
				u16ServerId,
				u16RegisterId,
				u8ServiceState,
				u16SubId );
#endif
		//Send Service state to Lib
		ETG_TRACE_USR1(( " tunmaster_tclApp::vOnServiceState() -> Service state sent to lib." ));
	}break;
	default:
		{
			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ u16ServiceId _ \
				ET_EN_T16 _ u16ServerId _ ET_EN_T16 _ u16RegisterId _ \
				ET_EN_T8 _ u8ServiceState _ ET_EN_T16 _ u16SubId _ \
				ET_EN_DONE );
		}
		break;
	}
#endif
	if((m_ptunmaster_tclSPMClient==NULL)||(m_potunermaster_cfcVehicleClientHandler==NULL)
	||(m_potunmstr_DiagLogClientHandler==NULL) )
	{
		NORMAL_M_ASSERT (NULL != m_potunmstr_DiagLogClientHandler);
		NORMAL_M_ASSERT (NULL != m_potunermaster_cfcVehicleClientHandler);
		return;
	}
#ifdef INCLUDE_PROFILE_MANAGER
		if(m_ptunmaster_PMClient == NULL)
		{
		NORMAL_M_ASSERT (NULL != m_ptunmaster_PMClient);
		return;
	}
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT

		if(m_ptunmaster_SXMClient == NULL || m_ptunermaster_SXMchannelartClient == NULL)
		{
			NORMAL_M_ASSERT (NULL != m_ptunmaster_SXMClient);
			NORMAL_M_ASSERT (NULL != m_ptunermaster_SXMchannelartClient);
			return;
		}
#endif
		switch ( u16ServiceId )
		{
		case CCA_C_U16_SRV_SPM:
			{
				// Inform the SPM CCA client handler
				m_ptunmaster_tclSPMClient->vOnServiceState ( u16ServiceId,
					u16ServerId,
					u16RegisterId, 
					u8ServiceState,
					u16SubId );
				break;
			}
		case CCA_C_U16_SRV_VEHICLE_DATA:
			{
				m_potunermaster_cfcVehicleClientHandler->vOnServiceState (OnServiceStateParm);	
				break;
			}
		case CCA_C_U16_SRV_DIAGLOG:
		{
			m_potunmstr_DiagLogClientHandler->vOnServiceState ( u16ServiceId,
				u16ServerId,
				u16RegisterId,
				u8ServiceState,
				u16SubId );
				break;
			}
#ifdef INCLUDE_PROFILE_MANAGER
		case CCA_C_U16_SRV_USERMANAGER:
		{
			ETG_TRACE_USR1(( " vOnServiceState()->service State  Profile Manager"));

			m_ptunmaster_PMClient->vOnServiceState ( u16ServiceId,
								u16ServerId,
								u16RegisterId,
								u8ServiceState,
								u16SubId );

			break;
			}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		case CCA_C_U16_SRV_SXM_AUDIO:
		{
			ETG_TRACE_USR1(( " vOnServiceState()->service State SXM audio "));
			m_ptunmaster_SXMClient->vOnServiceState ( u16ServiceId,
								u16RegisterId,
								u8ServiceState,
								u16SubId );
			break;
		}
		case CCA_C_U16_SRV_SXM_CHANNEL_ART:
		{
			ETG_TRACE_USR1(( " vOnServiceState()->service State SXM channel art "));
			m_ptunermaster_SXMchannelartClient->vOnServiceState ( u16ServiceId,
								u16RegisterId,
								u8ServiceState,
								u16SubId );
			break;
		}
#endif
		default:
			{
				ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ u16ServiceId _ \
					ET_EN_T16 _ u16ServerId _ ET_EN_T16 _ u16RegisterId _ \
					ET_EN_T8 _ u8ServiceState _ ET_EN_T16 _ u16SubId _ \
					ET_EN_DONE );
			}
			break;
	}
}
/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vOnUnregister
 *
 * DESCRIPTION: This is oveeloaded function of AIL, to handle "Do service unregister" requests from clients.
 *
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *************************************************************************/
tVoid tunmaster_tclApp:: vOnUnregister(tU16 u16ServiceId,  tU16 u16RegisterId)
{
	ETG_TRACE_USR1(( " tunmaster_tclApp::vOnUnregister() u16ServiceID=%d ,u16RegisterId=%d ",u16ServiceId , u16RegisterId ));
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(m_potunmstr_MsgToHMI == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		ETG_TRACE_USR1(( " tunmaster_tclApp::vUnregisterService() ->NULL Pointer." ));
		return;
	}
	switch ( u16ServiceId )
	{
	case CCA_C_U16_SRV_TUNERMASTERCONTROL:
	{
		m_potunmstr_MsgToHMI ->vRemoveAllEntriesWithRegID(u16ServiceId,u16RegisterId);
		ETG_TRACE_USR1(( " tunmaster_tclApp::vUnregisterService() -> Unreg Tunermaster service request from Client." ));
	}break;
	default:
	{
		ETG_TRACE_USR1(( " tunmaster_tclApp::vUnregisterService() -> Default case ->"
				"Service iD =%d",
				u16ServiceId));
	}
	break;
	}
#endif
}

/************************************************************************
 *
 * FUNCTION: tBool vOnAsyncRegisterConf()
 *
 * DESCRIPTION: only used for one thread applications
 *
 * PARAMETER:
 *              tU16 u16RegisterId,
 *              tU16 u16ServerAppId
 *              tU16 u16ServiceId,
 *              tU16 u16SourceSubID
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vOnAsyncRegisterConf (  tU16 u16RegisterId, 
		tU16 u16ServerAppId,
		tU16 u16ServiceId,
		tU16 u16SourceSubID )
{
	ETG_TRACE_USR1(( " tunmaster_tclApp::vOnAsyncRegisterConf() u16ServiceID=%d ,u16RegisterId=%d ",u16ServiceId , u16RegisterId ));
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
      (m_potunmstr_AudioClientHandler == NULL)|| 
#endif
      (m_potunmstr_TunClnt_Handlr==NULL)||(m_potunmstr_DABClient_Handler==NULL))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_TunClnt_Handlr != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		return;
	}
	switch ( u16ServiceId )
	{
		case CCA_C_U16_SRV_DAB_TUNER:
		{
			m_potunmstr_DABClient_Handler->vSetDABRegID(u16RegisterId);
			break;
		}
	case CCA_C_U16_SRV_STREAMROUTER:
	{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if (m_poArlSourceImpl != 0)
		{
		m_poArlSourceImpl->vOnAsyncRegisterConf (
				u16RegisterId,
				u16ServerAppId,
				u16ServiceId,
				u16SourceSubID);
		}
#else

		m_potunmstr_AudioClientHandler->vOnAsyncRegisterConf (
				u16RegisterId,
				u16ServerAppId,
				u16ServiceId,
				u16SourceSubID);
#endif
		ETG_TRACE_USR1(( " tunmaster_tclApp::vOnAsyncRegisterConf() -> Service state sent to lib." ));
		}break;
		case CCA_C_U16_SRV_TUNERCONTROL:
		{
			m_potunmstr_TunClnt_Handlr->vSetTunerRegID(u16RegisterId);
			break;
		}
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		case CCA_C_U16_SRV_SXM_AUDIO:
		{
			if(m_ptunmaster_SXMClient != NULL)
			{
				m_ptunmaster_SXMClient->vOnAsyncRegisterConf(u16RegisterId,u16ServerAppId,u16ServiceId,u16SourceSubID);
			}
			break;
		}
#endif
		default:
		{
			break;
		}
	}
#endif

	if(NULL == m_potunermaster_cfcVehicleClientHandler)
	{
		return;
	}
	if((u16ServiceId == CCA_C_U16_SRV_VEHICLE_DATA))
		{
			m_potunermaster_cfcVehicleClientHandler->vOnAsyncRegisterConf(u16RegisterId,
				u16ServerAppId,
				u16ServiceId,
				u16SourceSubID);
		}
}
/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
 *
 * DESCRIPTION: * is call from SPM to inform this application about new power states
 *              * changes the state of the application
 *              * sends ServiceAvailability state to all notified clients
 *              * changes state of downloadservice(-object)
 *
 * PARAMETER: tU32 u32OldAppState (actual state),
 *            tU32 u32AppState (state to change to)
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
{
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
      (m_potunmstr_AudioClientHandler == NULL)|| 
#endif
      (_tunermaster_poCCAService==NULL)||\
			(m_potunmstr_TunClnt_Handlr == NULL) ||(m_potunmstr_DABClient_Handler == NULL) || (nullptr ==m_potunmstr_antdiag_Manager))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( _tunermaster_poCCAService != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunClnt_Handlr != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		return;
	}
	/* ---
	analyse the state we have to go to 
	--- */   
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if (m_poArlSourceImpl != 0)
	{
		m_poArlSourceImpl->vOnNewAppState(u32OldAppState,u32AppState );
	}
#else
	m_potunmstr_AudioClientHandler->vOnNewAppState(u32OldAppState,u32AppState );
#endif
	ETG_TRACE_USR1(( " tunmaster_tclApp::vOnNewAppState() -> Application state sent to lib." ));

	switch(u32AppState)
	{

	case AMT_C_U32_STATE_NORMAL:
	{
		vHandleNormState( u32OldAppState);
		m_potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_NORMAL);
		break;
	}
	case AMT_C_U32_STATE_DIAGNOSIS:
	{
		vHandleDiagState( u32OldAppState);

		break;
	}
	case AMT_C_U32_STATE_PAUSE:
	{
		vHandlePauseState( u32OldAppState);
		break;
	}
	case AMT_C_U32_STATE_OFF:
	{

		vHandleOffState( u32OldAppState);
		m_potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_OFF);

		break;
	}
	default:
	{
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_INVALID _ ET_EN_DONE);
		/* +++
         this should never happen, you can call a trace or assert here
         +++ */  
	}
	}

	// handler for handling for change SPM state for tuner client service 
	m_potunmstr_TunClnt_Handlr->vOnNewAppState ( u32OldAppState, 
			u32AppState );
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_TUN_CLT_HNDLR_PASS _ ET_EN_DONE);

	// Inform the status to SPM client handler
	m_potunmstr_DABClient_Handler->vOnNewAppState ( u32OldAppState, 
			u32AppState );
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_DAB_CLT_HNDLR_PASS _ ET_EN_DONE);

	
#endif


		// Inform the status to SPM client handler
	if(( m_ptunmaster_tclSPMClient == NULL) || (m_potunmstr_DiagLogClientHandler == NULL)||\
			(m_potunermaster_cfcVehicleClientHandler==NULL)||(m_potunmstr_DiaglibListner==NULL))
	{
		return;
	}
#ifdef INCLUDE_PROFILE_MANAGER
	if(m_ptunmaster_PMClient == NULL)
		{
			return;
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	if(m_ptunmaster_SXMClient == NULL || m_ptunermaster_SXMchannelartClient == NULL)
	{
			return;
	}
#endif
		m_ptunmaster_tclSPMClient->vOnNewAppState ( u32OldAppState, 
			u32AppState );

		_tunermaster_poCCAService->vOnNewAppState(u32OldAppState, u32AppState);
		m_potunmstr_DiagLogClientHandler->vOnNewAppState(u32OldAppState, u32AppState);
		ETG_TRACE_USR1(( " tunmaster_tclApp::	vOnServiceState::->DiagLogClientHandler::Pass"));

		m_potunermaster_cfcVehicleClientHandler->vOnNewAppState(u32OldAppState, u32AppState);
	m_potunmstr_DiaglibListner->vOnNewAppState(u32OldAppState, u32AppState);
#ifdef INCLUDE_PROFILE_MANAGER
	m_ptunmaster_PMClient->vOnNewAppState(u32OldAppState, u32AppState);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_ptunmaster_SXMClient->vOnNewAppState(u32OldAppState, u32AppState);
	m_ptunermaster_SXMchannelartClient->vOnNewAppState(u32OldAppState, u32AppState);
#endif
	/* ---
	create and send an acknowledge message so the SPM knows you have reached the new state
	--- */
	vAppStateChanged (u32AppState, 0);

} 
/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vOnNewMessage (amt_tclBaseMessage* poMessage)
 *
 * DESCRIPTION: * casts Message to amt_tclServiceData (if legal)
 *              * gives amt_tclServiceData - Message to service for analyzing
 *              * ignores all unexpected messsages
 *
 * PARAMETER: amt_tclBaseMessage* poMessage ( Message to analyse)
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vOnNewMessage (amt_tclBaseMessage* poMessage) 
{
	if (poMessage == NULL)
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}		
	amt_tclServiceData oServiceData(poMessage);
	tU16 u16ServiceID = oServiceData.u16GetServiceID();
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
    if(  (m_poPortMngr==NULL) \
		||(m_potunmstr_TunClnt_Handlr==NULL)\
		||(m_potunmstr_DABClient_Handler==NULL))
	{
		NORMAL_M_ASSERT( m_poPortMngr != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunClnt_Handlr != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		return;
	}
#endif
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB     
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16 
	if(m_potunmstr_AudioClientHandler == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );		 
		return ;
	}
#endif
#endif
	/* ---
	check if the received message is a AMT Service data message
	--- */
	if(poMessage->u8GetType() == AMT_C_U8_CCAMSGTYPE_SVCDATA)
	{

		/* ---
		cast the received message to a AMT Service data message so we 
		can access the standard members
		--- */

		m_poPortMngr->enUpdate(&oServiceData);


		/* ---
		one server can offer more than one service. So we analyse the ServiceID
		to know which service handler we have to call. 
		99% of all Servers only offer one service ( with a different function ID for each feature ). 
      --- */
		switch(u16ServiceID)
		{
			/* +++
			enter your Service ID here*/ 
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16 
		case CCA_C_U16_SRV_TUNERCONTROL:
			{
				ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_SRV_TUNERCONTROL _ ET_EN_DONE);
				m_potunmstr_TunClnt_Handlr->vDispatchMessage(&oServiceData);
				break;
			}
		

		case CCA_C_U16_SRV_DAB_TUNER:
			{
				ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_SRV_DAB_TUNER _ ET_EN_DONE);
				m_potunmstr_DABClient_Handler->vDispatchMessage(&oServiceData);
				break;
			}
		case CCA_C_U16_SRV_STREAMROUTER:
		case CCA_C_U16_SRV_AUD_SRC_ROUTE:    // Added by Karsten Geier
			{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				if (m_poArlSourceImpl != 0)
				{
					m_poArlSourceImpl->vOnNewMessage(poMessage);
				}
#else
			m_potunmstr_AudioClientHandler->vOnNewMessage(poMessage);
#endif
				ETG_TRACE_USR1(( " tunmaster_tclApp::vOnNewMessage() -> New Message sent to lib." ));

				break;
			}
#endif
		default:
			break;

		}
	}
	else
	{
		/* +++
		we have received a message with an unkown format.
		this is an error so make a trace or assert here
		+++ */

		/* ---
		we can't do anything with this message so free the ressources
		--- */
	}

	switch (u16ServiceID)
	{
	case CCA_C_U16_SRV_DIAGLOG:
		{
			ETG_TRACE_USR4(("tunmaster_tclApp:: vOnNewMessage->vDispatchMessage"));
			if(NULL != m_potunmstr_DiagLogClientHandler)
			{
				m_potunmstr_DiagLogClientHandler->vDispatchMessage(&oServiceData);
			}
			break;
		}
	case  CCA_C_U16_SRV_VEHICLE_DATA:
		{
			if(NULL != m_potunermaster_cfcVehicleClientHandler)
			{
				m_potunermaster_cfcVehicleClientHandler->vDispatchMessage(&oServiceData);
			}
			break;
		}
	case CCA_C_U16_SRV_SPM:
		{
			// Give the message to cca service handler for analysing.
			// vDispatchMessage is a framework function. it will compare
			// the function ID with the message map and call the corresponding
			// function
			if(NULL != m_ptunmaster_tclSPMClient)
			{
				m_ptunmaster_tclSPMClient->vDispatchMessage(&oServiceData);
			}
			break;
		}
	case CCA_C_U16_SRV_TUNERMASTERCONTROL:
		{
			if(NULL != m_potunmstr_MsgFromHMI)
			{
				u16m_RegID = oServiceData.u16GetRegisterID();
				m_potunmstr_MsgFromHMI ->vDispatchMessage(&oServiceData);		
				ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _\
					TUNMSTR_TRACE_TUNMASTERAPP_SRV_TUNERMASTERCONTROL _ \
					ET_EN_DONE );
			}
			break;
		}
#ifdef INCLUDE_PROFILE_MANAGER
	case CCA_C_U16_SRV_USERMANAGER:
			{

				if (NULL != m_ptunmaster_PMClient )
				{
					m_ptunmaster_PMClient->vDispatchMessage(&oServiceData);
				}
				break;
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	case CCA_C_U16_SRV_SXM_AUDIO:
	{
		if (NULL != m_ptunmaster_SXMClient )
		{
			m_ptunmaster_SXMClient->vDispatchMessage(&oServiceData);
		}
		break;
	}
	case CCA_C_U16_SRV_SXM_CHANNEL_ART:
	{
		if (NULL != m_ptunermaster_SXMchannelartClient )
		{
			m_ptunermaster_SXMchannelartClient->vDispatchMessage(&oServiceData);
		}
		break;
	}
#endif
	default:
		{
			ETG_TRACE_USR4(("tunmaster_tclApp:: vOnNewMessage->CCA_C_U16_SRV_DIAGLIB"));
			if( (NULL!= m_potunmstr_DiaglibListner) && (u16ServiceID == m_potunmstr_DiaglibListner->u16GetServiceId()) )
			{
				m_potunmstr_DiaglibListner->vDiagLibDispatchMessage(&oServiceData);
			}
			break;
		}
	}
	if((u16ServiceID != CCA_C_U16_SRV_STREAMROUTER) && (poMessage->bIsValid() == TRUE))
	{
		if(poMessage->bDelete() == FALSE)
		{
			ETG_TRACE_USR1(("tunmaster_tclApp:: vOnNewMessage Message Not deleted from Serive Id = %d", u16ServiceID));
		}
	}
}


/*************************************************************************
 *
 * FUNCTION: tBool tunmaster_tclApp::bGetServiceVersion (tU16 u16ServiceID, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion)
 *
 * DESCRIPTION: stores data about the version of this service (magics)
 *
 * PARAMETER: * u16ServiceID: the service we should describe
 *            * rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion: targets for storing the data
 *
 * RETURNVALUE: success: TRUE / FALSE
 *
 *************************************************************************/
tBool tunmaster_tclApp::bGetServiceVersion (tU16 u16ServiceID, tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion)
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _\
			TUNMSTR_TRACE_TUNMASTERAPP_GET_SRV_VERSION _ ET_EN_DONE);
	ETG_TRACE_USR1(( " tunmaster_tclApp::bGetServiceVersion()->u16ServiceID=%d",u16ServiceID ));

	tBool bRetVal = FALSE;
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(m_potunmstr_AudioClientHandler == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		return bRetVal;
	}
#endif
#endif
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(u16ServiceID == CCA_C_U16_SRV_TUNERCONTROL )
	{
		/* +++
      Enter the version of this service you offer
      +++ */

		rfu16MajorVersion =MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION;
		rfu16MinorVersion = MIDW_TUNERFI_C_U16_SERVICE_MINORVERSION;
		rfu16PatchVersion = 0;

		bRetVal = TRUE;
	}
	else if( u16ServiceID == CCA_C_U16_SRV_DAB_TUNER )
	{
		// Major ver
		rfu16MajorVersion = 2;
		// Minor ver
		rfu16MinorVersion = 0;
		// Patch ver
		rfu16PatchVersion = 0;

		bRetVal = TRUE;

	}
	else
	{

	}
#endif
	if( u16ServiceID == CCA_C_U16_SRV_DIAGLOG )
	{
		// Major ver
		rfu16MajorVersion = MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION;
		// Minor ver
		rfu16MinorVersion = 0;
		// Patch ver
		rfu16PatchVersion = 0;

		bRetVal = TRUE;

	}
	else if( u16ServiceID == CCA_C_U16_SRV_TUNERMASTERCONTROL )
	{
		// Major ver
		rfu16MajorVersion = MIDW_TUNERMASTERFI_C_U16_SERVICE_MAJORVERSION;
		// Minor ver
		rfu16MinorVersion = MIDW_TUNERMASTERFI_C_U16_SERVICE_MINORVERSION;
		// Patch ver
		rfu16PatchVersion = 0;

		bRetVal = TRUE;

	}
	else if ((NULL != m_potunmstr_DiaglibListner) && (u16ServiceID == m_potunmstr_DiaglibListner->u16GetServiceId()))
	{
		bRetVal= m_potunmstr_DiaglibListner->bGetServiceVersion(rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion);	
	}
	else
	{
		/* +++
      we have received a request with an unkown service ID.
      this is an error so make a trace or assert here
      +++ */
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if (m_poArlSourceImpl != 0)
		{
			bRetVal = m_poArlSourceImpl->bGetServiceVersion (u16ServiceID, rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion);
		}
#else
      bRetVal = m_potunmstr_AudioClientHandler->bGetServiceVersion (u16ServiceID, rfu16MajorVersion, rfu16MinorVersion, rfu16PatchVersion);
#endif
#endif
	}

	return bRetVal;
}

/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vSendError
 *
 * DESCRIPTION: sends an error - message
 *
 * PARAMETER: data for addressing the message
 *
 * RETURNVALUE: void
 *

 **************************************************************************/
tVoid tunmaster_tclApp::vSendError(tU16 /* u16SourceID    */, 
		tU16 /* u16TargetID    */,
		tU16 /* u16RegisterID  */,
		tU16 /* u16CmdCounter  */,
		tU16 /* u16Sid         */,
		tU16 /* u16Fid         */)const
{

}

/************************************************************************
 *
 * FUNCTION: tBool tunmaster_tclApp::bOnWatchdog()
 *
 * DESCRIPTION: ????
 *
 * PARAMETER: void
 *
 * RETURNVALUE: TRUE
 *
 *************************************************************************/
tBool tunmaster_tclApp::bOnWatchdog()
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_ONWATCHDOG _ ET_EN_DONE);
	return TRUE;
}

/*************************************************************************
 *
 * FUNCTION: tVoid tunmaster_tclApp::vOnApplicationClose()
 *
 * DESCRIPTION: releases all resources and sends close - message
 *
 * PARAMETER: void
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
tVoid tunmaster_tclApp::vOnApplicationClose()
{ 


	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_APPLICATION_CLOSE _ ET_EN_DONE);
	_bAppClosed = TRUE;

	//    m_pPortMngr->vClearAll();

	/* +++
   free all allocated ressources
   +++ */


	tS32 s32RetFlag = OSAL_s32SemaphoreClose( _hNotTableSem );
	s32RetFlag = OSAL_s32SemaphoreDelete( TUNERMASTER_NOTTABLE_SEM_NAME );
	//Added to remove lint warning.
	ETG_TRACE_USR1(( " tunmaster_tclApp::vOnApplicationClose() -> s32RetFlag=%x.",  s32RetFlag));


	if( _poNotTable != NULL )
	{
		vDeleteNoThrow( _poNotTable);

		_poNotTable = NULL;
	}

	if( _tunermaster_poCCAService != NULL )
	{
		vDeleteNoThrow( _tunermaster_poCCAService);

		_tunermaster_poCCAService = NULL;
	}


	/* ---
   inform SPM about successful shut down
   --- */
	vApplicationCloseAcknowledge(AIL_C_U8_APP_END_SUCCESSFUL);
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vRegisterInTraceCmdService
 *
 *DESCRIPTION:  Registers trace channel to send commands from TTFis
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vRegisterInTraceCmdService ()
{
	tS32                        s32Error;
	OSAL_trIOCtrlLaunchChannel  oTraceChannel;

	ETG_TRACE_USR1(( " tunmaster_tclApp::vRegisterInTraceCmdService() -> Register trace interface." ));

	_fdTrace = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);

	oTraceChannel.enTraceChannel = TR_TTFIS_TUNERMASTER;

	oTraceChannel.pCallback = (OSAL_tpfCallback)vTraceTunerMasterChannelMgr;

	s32Error = OSAL_s32IOControl (_fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &oTraceChannel);

	if (OSAL_OK != s32Error)
	{
		ETG_TRACE_ERR(( " tunmaster_tclApp::vRegisterInTraceCmdService() -> ERROR: Registration of call back function failed, s32Error=%x."
				,s32Error));
		return;
	}
	else
	{
		ETG_TRACE_ERR(( " tunmaster_tclApp::vRegisterInTraceCmdService() -> Registration of call back function is successful." ));
	}
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vUnregisterInTraceCmdService
 *
 *DESCRIPTION:  De-registers trace channel used to send commands from TTFis
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vUnregisterInTraceCmdService () throw()
										{
	tS32 s32Error;
	OSAL_trIOCtrlLaunchChannel oTraceChannel;

	ETG_TRACE_USR1(( " tunmaster_tclApp::vUnregisterInTraceCmdService() -> UnRegister trace interface." ));

	oTraceChannel.enTraceChannel = TR_TTFIS_TUNERMASTER;

	oTraceChannel.pCallback = (OSAL_tpfCallback)vTraceTunerMasterChannelMgr;


	s32Error = OSAL_s32IOControl (_fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &oTraceChannel);

	if (OSAL_OK != s32Error)
	{
		ETG_TRACE_ERR(( " tunmaster_tclApp::vUnregisterInTraceCmdService() -> ERROR: UnRegistration of call back function failed, s32Error=%x."
				,s32Error));
		return;
	}
	else
	{
		ETG_TRACE_ERR(( " tunmaster_tclApp::vUnregisterInTraceCmdService() -> UnRegistration of call back function is successful :)" ));

	}

	tS32 s32RetFlag = OSAL_s32IOClose (_fdTrace);
	//to solve lint warning
	ETG_TRACE_USR1(( " tunmaster_tclApp::vUnregisterInTraceCmdService() -> s32RetFlag=%x" , s32RetFlag));



										}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vTunerMasterStartUpProcess
 *
 *DESCRIPTION:  Tuner activities during startup, After Radio unit communication is
 *              established. Inform all the clients of service availablility.
 *
 *PARAMETER:    tVoid
 *
 *RETURNVALUE:  tVoid
 *
 *
 *HISTORY:
 *15.09.06 dip2kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vTunerMasterStartUpProcess ()
{
	ETG_TRACE_USR1(( "vTunerMasterStartUpProcess"));
	vServiceAvailabilityChanged
	(
			CCA_C_U16_SRV_TUNERMASTERCONTROL,
			AMT_C_U8_SVCSTATE_AVAILABLE
	);

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if( m_ptunmaster_Config != NULL && m_potunmstr_SrcChgManager != NULL)
	{
		m_potunmstr_SrcChgManager->vSetTunerState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
	}
#endif
	vSetStratUpTriggerSent_Info(TRUE);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	/*Source Availability must be sent only after the tunermaster service becomes available */
	/*Source availability will be sent only when the amfm/dab service becomes available*/
	//vCheckSourceAvailabilityfromKDS();
#endif
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vTunerMasterShutDownProcess
 *
 *DESCRIPTION:  All Tuner shut down process after PAUSE, OFF state received from
 *              SPM. Inform all the CCA clients, SERVICE NOT AVAILABLE.
 *
 *PARAMETER:    tVoid
 *
 *RETURNVALUE:  tVoid
 *
 *
 *HISTORY:
 *15.09.06 dip2kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vTunerMasterShutDownProcess ()
{
		ETG_TRACE_USR1(( " vTunerMasterShutDownProcess()->Send tuner master service un availabel"));
		vSetStratUpTriggerSent_Info(FALSE);
		vServiceAvailabilityChanged
		(
				CCA_C_U16_SRV_TUNERMASTERCONTROL,
				AMT_C_U8_SVCSTATE_NOT_AVAILABLE
		);
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vTraceTunerMasterChannelMgr
 *
 *DESCRIPTION:  React on TTFis commands
 *
 *PARAMETER:    const tUChar* puchData
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vTraceTunerMasterChannelMgr (const tUChar* puchData)
{    

	if (puchData == NULL)
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_NULL_POINTER _ ET_EN_DONE);

		return;
	}

	/*------------------*/
	/* Message length   */
	/*------------------*/
	tU8 u8Messagelen = puchData[ 0 ];
	//Message Code
	tU8 u8MessageCode= puchData [ 1 ];
	tU8 u8Data[0x14] = {0};
	for( tU8 u8Index=0;u8Index<0x14;u8Index++)
	{
		u8Data[u8Index] = (tU8)puchData[u8Index+2];
	}
	if(( u8Messagelen >= 1) &&(_poExemplar!=NULL))
	{
		switch(u8MessageCode)
		{
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		case TUNMSTR_SERVICE_STATUS:
			{
				ETG_TRACE_USR4(("TUNMSTR_SERVICE_STATUS()u8Data[0]=%d u8Data[1]=%d",u8Data[0],u8Data[1]));
				if(u8Data[0]==0x1)
				{
					_poExemplar->m_potunmstr_TunClnt_Handlr->vOnServiceState(CCA_C_U16_SRV_TUNERCONTROL,CCA_C_U16_SRV_TUNERCONTROL,0,u8Data[1],0);
				}
				else
				{
					_poExemplar->m_potunmstr_DABClient_Handler->vOnServiceState(CCA_C_U16_SRV_DAB_TUNER,CCA_C_U16_SRV_DAB_TUNER,0,u8Data[1],0);
				}
				break;
			}
#endif
		case TUNMSTR_MSG_TO_HMI:
		{
			ETG_TRACE_FATAL(( " tunmaster_tclApp::vTraceTunerMasterChannelMgr () -> TTFis command: TUNMSTR_MSG_TO_HMI. length:%d"
					,u8Messagelen));
			_poExemplar ->m_potunmstr_MsgFromHMI->vHandleTTFiS_CMD( u8Data );
			break;
		}
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		case TUNMSTR_MSG_FROM_TUNER:
		{
			ETG_TRACE_FATAL(( " tunmaster_tclApp::vTraceTunerMasterChannelMgr () -> TTFis command: TUNMSTR_MSG_FROM_TUNER. length:%d"
					,u8Messagelen));
			_poExemplar ->m_potunmstr_TunClnt_Handlr->vHandleTTFiS_CMD( u8Data );
			break;
		}
		case TUNMSTR_MSG_FROM_DAB:
		{
			// to be extended later
			break;
		}
		case TUNMSTR_S_MTC_SETMODE:
		case TUNMSTR_S_PRESET_HANDLING:
		case TUNMSTR_S_ACTIVATEANNO:
		case TUNMSTR_S_AUTOSTORE:
		case TUNMSTR_S_STATION_SELECTION:
		case TUNMSTR_S_RADIOPROFILE_SETTING:
			{

				_poExemplar ->m_potunmstr_MsgFromHMI->vHandleTTFiS_CMD( u8Data );
				break;
			}
		case DRMDUMMYSOURCE_ENABLE:
		{
			u8Data[0]=u8MessageCode;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			_poExemplar->m_potunmstr_AudioClientHandler->vHandleTTFiS_CMD(u8Data);
#endif
			break;
		}
		case DRMDUMMYSOURCE_DISABLE:
		{
			u8Data[0]=u8MessageCode;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			_poExemplar->m_potunmstr_AudioClientHandler->vHandleTTFiS_CMD(u8Data);
#endif
			break;
		}
#endif
		case TUNMSTR_MSG_FROM_SPM:
		{
			ETG_TRACE_FATAL(( " tunmaster_tclApp::vTraceTunerMasterChannelMgr () -> TTFis command: TUNMSTR_MSG_FROM_SPM. length:%d"
					,u8Messagelen));
			_poExemplar ->m_ptunmaster_tclSPMClient->vHandleTTFiS_CMD( u8Data );
			break;
		}
		case TUNMSTR_MSG_FROM_DIAGLOG:
		{
			ETG_TRACE_FATAL(( " tunmaster_tclApp::vTraceTunerMasterChannelMgr () -> TTFis command: TUNMSTR_MSG_FROM_DIAGLOG. length:%d"
					,u8Messagelen   ));
			_poExemplar ->m_potunmstr_DiagLogClientHandler->vHandleTTFiS_CMD( u8Data );
			break;
		}
		case TUNMSTR_I2C:
		{
			u8Data[0]=puchData [2];
			u8Data[1]=puchData [3];
			u8Data[2]=puchData [4];
			_poExemplar ->m_potunmstr_antdiag_i2cHandler->vHandleTTFiS_CMD(u8Data);
			break;
		}
		case (tU8)TUNMSTR_MSG_FROM_DIAGLIB:
		case TUNMSTR_vStartAntennaDiag:
		case TUNMSTR_vStopAntennaDiag:
		{
			ETG_TRACE_FATAL(( " tunmaster_tclApp::vTraceTunerMasterChannelMgr ()length:%d"
					,u8Messagelen));
			u8Data[0]=u8MessageCode;
			_poExemplar ->m_potunmstr_antdiag_Manager->vHandleTTFiS_CMD( u8Data );
			break;
		}
		case TUNMSTR_IgnitionState:
		case TUNMSTR_BatteryVg:
		{
			u8Data[0]=u8MessageCode;
			u8Data[1]=(tU8)puchData [2];
			_poExemplar->m_potunermaster_cfcVehicleClientHandler->vHandleTTFiS_CMD(u8Data);
			break;
		}
		case TUNMSTR_FM1ConsiderBatVg:
		case TUNMSTR_FM2ConsiderBatVg:
		case TUNMSTR_DAB1ConsiderBatVg:
		case TUNMSTR_FM1ConsiderIgn:
		case TUNMSTR_FM2ConsiderIgn:
		case TUNMSTR_DAB1ConsiderIgn:
		{
			u8Data[0]=u8MessageCode;
			u8Data[1]=(tU8)puchData [2];
			u8Data[2]=(tU8)puchData [3];
			u8Data[3]=(tU8)puchData [4];
			_poExemplar->m_potunmstr_DiagLogClientHandler->vHandleTTFiS_CMD( u8Data );
			break;
		}
		case TUNMSTR_SystemSetTypeCoding:
			{
			u8Data[0]=u8MessageCode;
			u8Data[1]=(tU8)puchData [2];
			u8Data[2]=(tU8)puchData [3];
			u8Data[3]=(tU8)puchData [4];	
			ETG_TRACE_USR4(("TUNMSTR_SystemSetTypeCoding()"));
			_poExemplar->m_potunmstr_DiaglibListner->vHandleTTFiS_CMD();
			break;
			}
		case FID_TUNMSTR_S_SOURCE_SETUP_OPTION:
			{
				u8Data[0]=u8MessageCode;
				u8Data[1]=(tU8)puchData [2];
				u8Data[2]=(tU8)puchData [3];
				ETG_TRACE_USR4(("FID_TUNMSTR_S_SOURCE_SETUP_OPTION () 0=%d 1=%d 2=%d",u8MessageCode,puchData [2],puchData [3]));
				_poExemplar ->m_potunmstr_MsgFromHMI->vHandleTTFiS_CMD(u8Data);
				break;
			}
		case TUNMSTR_ReadAntennaStatus:
		{
			u8Data[0]=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST;
			u8Data[1]=(tU8)puchData [2];
			_poExemplar ->m_potunmstr_MsgFromHMI->vHandleTTFiS_CMD(u8Data);
			break;
		}
		case TUNMSTR_SetDTVAntennaRegister:
		{
			u8Data[0]=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SET_DTVANTENNAREGISTER;
			_poExemplar ->m_potunmstr_MsgFromHMI->vHandleTTFiS_CMD(u8Data);
			break;
		}
		default:
		{
			break;
		}
		} /* switch(u8MessageCode) */
	}//End of if( _poExemplar != NULL )

}



/* *****************************************************************************

FUNCTION:      vDeleteNoThrow

DESCRIPTION:   Deletes memory without throwing an exception.

PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

RETURN TYPE:   void

HINT:          Why this function? If delete is called inside the destructor,
Lint complains with warning 1551 that delete might throw an
execption, which is not caught.

But try / catch must not be used, and delete does not throw
an exception, anyway. To prevent a Lint warning deactivation,
this function guarantees that no exception is thrown.
Furthermore, it sets the given pointer to 0, and Lint is
happy.

It is a template, because two different memory types have to
be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tunmaster_tclApp::vDeleteNoThrow( T*& rfpArg ) throw()
										{
	OSAL_DELETE rfpArg;
	rfpArg = 0;
										}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vCreateClassInstances
 *
 *DESCRIPTION:  Creates instances of Classes
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vCreateClassInstances()
{
	//Create tuner Utility
	m_ptunmstr_Utility = new tunmaster_Utility;

	//Create tunmaster_Config
	m_ptunmaster_Config = new tunmaster_Config( );

	m_poclConfigMain = clConfigMain::instance();
		//Create tunmaster_tclSPMClient
	m_ptunmaster_tclSPMClient = new tunmaster_tclSPMClient(this);

#ifdef INCLUDE_PROFILE_MANAGER
	m_ptunmaster_PMClient = new tunermaster_PMClient(this);
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_ptunmaster_SXMClient = new tunermaster_SXMClient(this);
	m_ptunermaster_SXMchannelartClient = new tunermaster_SXMchannelartClient(this);
#endif

	m_potunermaster_cfcVehicleClientHandler=new tunermaster_cfcVehicleClientHandler(this);

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	//Create tunmstr_SrcChgManager
	m_potunmstr_SrcChgManager = new tunmstr_SrcChgManager(this);

	//Create tunmstr_AutoStoreHandler
	//m_potunmstr_AutoStoreHandler=new tunmstr_AutoStoreHandler();

	//Create tunmstr_SrcChg_AnnoHandler
	m_potunmstr_SrcChg_AnnoHandler=new tunmstr_SrcChg_AnnoHandler();


	//Create tunmstr_AudioClientHandler
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	   m_poArlSourceImpl = new tuner::sessionManagement::audio::clArlSourceImpl((ail_tclAppInterface*)(this),m_poclConfigMain);
	   tuner::sessionManagement::audio::clAudioControl audioControl;
	   audioControl.vSetAudioImpl(m_poArlSourceImpl);

		//Create tunmstr_MsgToHMI
	m_potunmstr_MsgToHMI = new tunmstr_MsgToHMI(this, m_poArlSourceImpl);
	//Create tunmstr_TunerClientHandler
	m_potunmstr_TunClnt_Handlr = new tunmstr_TunerClientHandler( this, m_poArlSourceImpl);
		//Create tunmstr_Preset_Handler
	m_potunmstr_Preset_Handler=new tunmstr_Preset_Handler(m_poArlSourceImpl);

		//Create tunmstr_Autostore_Handler
	m_potunmstr_AutoStoreHandler=new tunmstr_AutoStoreHandler(m_poArlSourceImpl);

	m_potunmstr_MsgFromHMI = new tunmstr_MsgFromHMI(this , m_poArlSourceImpl);

	//Create tunmstr_DABClient_Handler
	m_potunmstr_DABClient_Handler = new tunmstr_DABClient_Handler(this, m_poArlSourceImpl);

	m_potunmstr_SDSHandler = new tunmstr_SDSHandler(m_poArlSourceImpl);

#else
	m_potunmstr_AudioClientHandler = new tunmstr_AudioClientHandler(this);

		//Create tunmstr_MsgToHMI
	m_potunmstr_MsgToHMI = new tunmstr_MsgToHMI(this);
	//Create tunmstr_TunerClientHandler
	m_potunmstr_TunClnt_Handlr = new tunmstr_TunerClientHandler( this);
		//Create tunmstr_Preset_Handler
	m_potunmstr_Preset_Handler=new tunmstr_Preset_Handler();

		//Create tunmstr_Autostore_Handler
	m_potunmstr_AutoStoreHandler=new tunmstr_AutoStoreHandler();

	//Create tunmstr_MsgFromHMI
	m_potunmstr_MsgFromHMI = new tunmstr_MsgFromHMI(this);

	//Create tunmstr_DABClient_Handler
		m_potunmstr_DABClient_Handler = new tunmstr_DABClient_Handler(this);

	m_potunmstr_SDSHandler = new tunmstr_SDSHandler();

#endif


	//Create tunmstr_MuteHandler
	m_potunmstr_MuteHandler=new tunmstr_MuteHandler();
#endif
	
	vCreateAntDiagClassInstances();
	vUpdateAntDiagPointers();

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poAMFMTunerImpl = new tuner::sessionManagement::audio::clAMFMTunerImpl(m_potunmstr_TunClnt_Handlr , m_potunmstr_MsgToHMI,m_poclConfigMain);
	m_poDABTunerImpl  = new tuner::sessionManagement::audio::clDABTunerImpl(m_potunmstr_DABClient_Handler , m_potunmstr_MsgToHMI, m_potunmstr_TunClnt_Handlr,m_poclConfigMain);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAMFMTunerImpl, tuner::common::AM);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAMFMTunerImpl, tuner::common::FM1);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAMFMTunerImpl, tuner::common::FM2);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAMFMTunerImpl, tuner::common::AMTI);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAMFMTunerImpl, tuner::common::DRM);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAMFMTunerImpl, tuner::common::WB);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poDABTunerImpl,  tuner::common::DAB);

#endif


#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	m_poAMFMAnnouncementImpl = new tuner::announcements::clAMFMAnnouncementsImpl(m_potunmstr_TunClnt_Handlr, m_potunmstr_MsgToHMI,m_poclConfigMain);
	m_poDABAnnouncementImpl  = new tuner::announcements::clDABAnnouncementsImpl(m_potunmstr_DABClient_Handler, m_potunmstr_MsgToHMI, m_potunmstr_TunClnt_Handlr,m_poclConfigMain);
    m_pAudioImpl = new tuner::announcements::clAudioImpl(m_poArlSourceImpl);
    m_poAnnouncementControl = new tuner::announcements::clAnnouncementControl();

    tuner::announcements::clAudioControl announcementAudioControl;
    announcementAudioControl.vSetAudioImpl(m_pAudioImpl);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAnnouncementControl, tuner::common::DABANNOUNCEMENTS);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAnnouncementControl, tuner::common::FMANNOUNCEMENTS);
	tuner::sessionManagement::audio::clTunerControl::instance()->vSetTunerImpl(m_poAnnouncementControl, tuner::common::WEATHERANNOUNCEMENTS);


	tuner::announcements::clTunerControl::instance()->vSetTunerImpl(m_poAMFMAnnouncementImpl, tuner::common::FMANNOUNCEMENTS);
	tuner::announcements::clTunerControl::instance()->vSetTunerImpl(m_poDABAnnouncementImpl, tuner::common::DABANNOUNCEMENTS);
	tuner::announcements::clTunerControl::instance()->vSetTunerImpl(m_poAMFMAnnouncementImpl, tuner::common::WEATHERANNOUNCEMENTS);

#endif

	
}
/******************************************************************+FUNCHEADER**
 *FUNCTION:     tunmaster_tclApp::vUpdateAntDiagPointers
 *
 *DESCRIPTION:  
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vUpdateAntDiagPointers()
{

	// Pointers for Class tunmstr_antdiag_Manager
	if( m_potunmstr_antdiag_Manager != NULL )
	{
		m_potunmstr_antdiag_Manager->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_antdiag_Measure_Ptr(m_potunmstr_antdiag_Measure);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_antdiag_i2cHandler(m_potunmstr_antdiag_i2cHandler);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_antdiag_Debounce_Ptr(m_potunmstr_antdiag_Debounce);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_DiagLogClientHandler_Ptr(m_potunmstr_DiagLogClientHandler);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
		m_potunmstr_antdiag_Manager->vSet_tunmstr_DiaglibListner_Ptr(m_potunmstr_DiaglibListner);
	}
	// Pointers for Class tunmstr_antdiag_Debounce
	if( m_potunmstr_antdiag_Debounce != NULL )
	{
		m_potunmstr_antdiag_Debounce->vSet_tunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);
		m_potunmstr_antdiag_Debounce->vSet_tunmstr_DiagLogClientHandler_Ptr(m_potunmstr_DiagLogClientHandler);
		m_potunmstr_antdiag_Debounce->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
		m_potunmstr_antdiag_Debounce->vSet_tunmstr_antdiag_i2cHandler(m_potunmstr_antdiag_i2cHandler);
		m_potunmstr_antdiag_Debounce->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
		m_potunmstr_antdiag_Debounce->vSet_tunmstr_antdiag_Measure_Ptr(m_potunmstr_antdiag_Measure);

	}
	// Pointers for Class tunmstr_antdiag_Debounce
	if( m_potunmstr_antdiag_Measure != NULL )
	{
		m_potunmstr_antdiag_Measure->vSet_tunmstr_antdiag_Debounce_Ptr(m_potunmstr_antdiag_Debounce);
		m_potunmstr_antdiag_Measure->vSet_tunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);
		m_potunmstr_antdiag_Measure->vSet_tunmstr_DiagLogClientHandler_Ptr(m_potunmstr_DiagLogClientHandler);
	}
	// Pointers for Class tunmstr_DiagLogClientHandler
	if( m_potunmstr_DiagLogClientHandler != NULL )
	{
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_cfcVehicleClientHand_Ptr(m_potunermaster_cfcVehicleClientHandler);
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_antdiag_Debounce(m_potunmstr_antdiag_Debounce);
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_antdiag_Measure_Ptr(m_potunmstr_antdiag_Measure);
		m_potunmstr_DiagLogClientHandler->vSet_tunmstr_antdiag_i2cHandler(m_potunmstr_antdiag_i2cHandler);
		m_potunmstr_DiagLogClientHandler->vSet_tunermaster_SPM_Client_Ptr(m_ptunmaster_tclSPMClient);
	}
	if(m_potunmstr_antdiag_i2cHandler!=NULL)
	{
		m_potunmstr_antdiag_i2cHandler->vSet_tunmstr_antdiag_Measure_Ptr(m_potunmstr_antdiag_Measure);
		m_potunmstr_antdiag_i2cHandler->vSet_tunmstr_antdiag_Manager_Ptr(m_potunmstr_antdiag_Manager);
		m_potunmstr_antdiag_i2cHandler->vSet_tunmstr_antdiag_Debounce_Ptr(m_potunmstr_antdiag_Debounce);
		m_potunmstr_antdiag_i2cHandler->vSet_tunmstr_DiagLogClientHandler_Ptr(m_potunmstr_DiagLogClientHandler);
		m_potunmstr_antdiag_i2cHandler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
	}
	if(m_potunmstr_DiaglibListner!=NULL)
	{
		m_potunmstr_DiaglibListner->vSet_tunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);
		m_potunmstr_DiaglibListner->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_potunmstr_DiaglibListner->vSet_tunmstr_DiagLogClientHandler_Ptr(m_potunmstr_DiagLogClientHandler);
		m_potunmstr_DiaglibListner->vSet_tunmstr_antdiag_i2cHandler(m_potunmstr_antdiag_i2cHandler);
		m_potunmstr_DiaglibListner->vSet_tunmstr_antdiag_Debounce_Ptr(m_potunmstr_antdiag_Debounce);
		m_potunmstr_DiaglibListner->vSet_tunmstr_antdiag_Measure_Ptr(m_potunmstr_antdiag_Measure);
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		m_potunmstr_DiaglibListner->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_DiaglibListner->vSet_tunmstr_ArlSourceImpl_Ptr((tuner::sessionManagement::audio::clArlSourceImpl*)m_poArlSourceImpl);
#endif
		if(NULL!=m_ptunmaster_Config)
		{
			m_ptunmaster_Config->vSet_tunmstr_DiaglibListner_Ptr(m_potunmstr_DiaglibListner);
		}
		#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		m_potunmstr_DiaglibListner ->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
		#endif
	}
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vDeleteClassInstances
 *
 *DESCRIPTION:  Delete all the tuner internal classes
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunmaster_tclApp::vDeleteClassInstances()
{
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16

	if((NULL == m_ptunmstr_Utility )||(NULL==m_ptunmaster_Config)||(NULL==m_poPortMngr)||\
		(NULL==m_potunmstr_SrcChgManager)||(NULL==m_potunmstr_AutoStoreHandler)||\
		(NULL==m_potunmstr_SrcChg_AnnoHandler)||(NULL==m_potunmstr_Preset_Handler) || (NULL==m_potunmstr_MuteHandler) || (NULL == m_potunmstr_SDSHandler))
	{
		NORMAL_M_ASSERT( m_poPortMngr != NULL );

		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_AutoStoreHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MuteHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SDSHandler != NULL );
		return;
	}

		//Delete m_poPortMngr
		vDeleteNoThrow(m_poPortMngr);
		m_poPortMngr = NULL;



		//Delete m_potunmstr_SrcChgManager
		vDeleteNoThrow(m_potunmstr_SrcChgManager);
		m_potunmstr_SrcChgManager = NULL;

		//Delete m_potunmstr_AutoStoreHandler
		vDeleteNoThrow(m_potunmstr_AutoStoreHandler);
		m_potunmstr_AutoStoreHandler = NULL;

		//Delete m_potunmstr_Preset_Handler
		vDeleteNoThrow(m_potunmstr_Preset_Handler);
		m_potunmstr_Preset_Handler = NULL;

		//Delete m_potunmstr_MuteHandler
		vDeleteNoThrow(m_potunmstr_MuteHandler);
		m_potunmstr_MuteHandler = NULL;

		//Delete m_potunmstr_SDSHandler
		vDeleteNoThrow(m_potunmstr_SDSHandler);
		m_potunmstr_SDSHandler = NULL;


		vDeleteTunMstrClientClassInstances();
#endif
if((NULL == m_ptunmaster_tclSPMClient) || (NULL == m_ptunmstr_Utility) || (NULL == m_ptunmaster_Config) ||
   (NULL==m_potunmstr_MsgToHMI)||(NULL==m_potunmstr_MsgFromHMI) || (NULL==m_poclConfigMain) )
{
	NORMAL_M_ASSERT( m_ptunmaster_tclSPMClient != NULL );
	NORMAL_M_ASSERT( m_ptunmstr_Utility != NULL );
	NORMAL_M_ASSERT( m_ptunmaster_Config != NULL );
			NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
			NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
			NORMAL_M_ASSERT( m_poclConfigMain != NULL );
	return;
}
#ifdef INCLUDE_PROFILE_MANAGER
if(NULL==m_ptunmaster_PMClient)
{
			NORMAL_M_ASSERT( m_ptunmaster_PMClient != NULL );
	return;
}
#endif

		vDeleteNoThrow( m_ptunmaster_tclSPMClient);
		m_ptunmaster_tclSPMClient = NULL;

		//Delete tunmstr_Utility
		vDeleteNoThrow( m_ptunmstr_Utility);
		m_ptunmstr_Utility = NULL;

		//Delete m_ptunmaster_Config
		vDeleteNoThrow(m_ptunmaster_Config);
		m_ptunmaster_Config = NULL;

				//Delete m_potunmstr_MsgToHMI
		vDeleteNoThrow(m_potunmstr_MsgToHMI);
		m_potunmstr_MsgToHMI = NULL;
		
						//Delete m_poclConfigMain
		vDeleteNoThrow(m_poclConfigMain);
		m_poclConfigMain = NULL;
#ifdef INCLUDE_PROFILE_MANAGER
		vDeleteNoThrow(m_ptunmaster_PMClient);
			m_ptunmaster_PMClient = NULL;
#endif

			//Delete m_potunmstr_MsgFromHMI
	vDeleteNoThrow( m_potunmstr_MsgFromHMI);
	m_potunmstr_MsgFromHMI = NULL;

		vDeleteTunMstrAntDiagClassInstances();
}
/******************************************************************
 *FUNCTION:     vDeleteTunMstrClientClassInstances
 *
 *DESCRIPTION:  Delete tunermaster client classes
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *******************************************************************/
tVoid tunmaster_tclApp::vDeleteTunMstrClientClassInstances()
{
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if((NULL == m_ptunmaster_tclSPMClient )||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	   (NULL==m_potunmstr_AudioClientHandler)||
#endif
      (NULL==m_potunmstr_DABClient_Handler)||\
	(NULL==m_potunmstr_TunClnt_Handlr))
	{
		NORMAL_M_ASSERT( m_ptunmaster_tclSPMClient != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunClnt_Handlr != NULL );
		return;
	}

#ifdef INCLUDE_PROFILE_MANAGER
		if(NULL==m_ptunmaster_PMClient)
		{
			NORMAL_M_ASSERT( m_ptunmaster_PMClient != NULL );
			return;
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		if(NULL==m_ptunmaster_SXMClient)
		{
				NORMAL_M_ASSERT( m_ptunmaster_SXMClient != NULL );
				return;
		}
		if(NULL==m_ptunermaster_SXMchannelartClient)
		{
				NORMAL_M_ASSERT( m_ptunermaster_SXMchannelartClient != NULL );
				return;
		}
#endif

	//Delete m_ptunmaster_tclSPMClient
	vDeleteNoThrow( m_ptunmaster_tclSPMClient);
	m_ptunmaster_tclSPMClient = NULL;
#ifdef INCLUDE_PROFILE_MANAGER
	vDeleteNoThrow( m_ptunmaster_PMClient);
	m_ptunmaster_PMClient = NULL;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	vDeleteNoThrow( m_ptunmaster_SXMClient);
	m_ptunmaster_SXMClient = NULL;
	vDeleteNoThrow( m_ptunermaster_SXMchannelartClient);
	m_ptunermaster_SXMchannelartClient = NULL;
#endif

#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	//Delete m_potunmstr_AudioClientHandler
	vDeleteNoThrow( m_potunmstr_AudioClientHandler);
	m_potunmstr_AudioClientHandler = NULL;
#endif

	//Delete m_potunmstr_DABClient_Handler
	vDeleteNoThrow( m_potunmstr_DABClient_Handler);
	m_potunmstr_DABClient_Handler = NULL;

	//Delete m_potunmstr_TunClnt_Handlr
	vDeleteNoThrow( m_potunmstr_TunClnt_Handlr);
	m_potunmstr_TunClnt_Handlr = NULL;
#endif
}
/******************************************************************
 *FUNCTION:     vDeleteTunMstrAntDiagClassInstances
 *
 *DESCRIPTION:  Delete tunermaster antenna diagnosis classes
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *******************************************************************/
tVoid tunmaster_tclApp::vDeleteTunMstrAntDiagClassInstances()
{
	if((NULL == m_potunmstr_antdiag_Debounce )||(NULL==m_potunmstr_antdiag_Manager)||\
	(NULL==m_potunmstr_antdiag_Measure)||(NULL==m_potunmstr_DiagLogClientHandler))
	{
		NORMAL_M_ASSERT( m_potunmstr_antdiag_Debounce != NULL );
		NORMAL_M_ASSERT( m_potunmstr_antdiag_Manager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_antdiag_Measure != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DiagLogClientHandler != NULL );
		return;
	}
	//Delete m_potunmstr_antdiag_Debounce
	vDeleteNoThrow( m_potunmstr_antdiag_Debounce);
	m_potunmstr_antdiag_Debounce = NULL;

	//Delete m_potunmstr_antdiag_Manager
	vDeleteNoThrow( m_potunmstr_antdiag_Manager);
	m_potunmstr_antdiag_Manager = NULL;

	//Delete m_potunmstr_antdiag_Measure
	vDeleteNoThrow( m_potunmstr_antdiag_Measure);
	m_potunmstr_antdiag_Measure = NULL;

	//Delete m_potunmstr_DiagLogClientHandler
	vDeleteNoThrow( m_potunmstr_DiagLogClientHandler);
	m_potunmstr_DiagLogClientHandler = NULL;
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vHandleNormState
 *
 *DESCRIPTION:  To Handle Normal State
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunmaster_tclApp::vHandleNormState( tU32 u32OldAppState)const
{

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_NORMAL _ ET_EN_DONE);
	/* ---
   the server has already entered this state, so it has nothing to do 
   --- */
	if(u32OldAppState == AMT_C_U32_STATE_NORMAL)
	{
		return; //switching to same state
	}
	/* +++
   do everything you have to do to enter the state NORMAL

   the state NORMAL is enter on system start and when the system leaves the states PAUSE and DIAG
   so if you want to do something only once, don't do it here!!!!

   +++ */


	/* ---
   inform the framework that the we are ready to receive and send messages
   --- */

}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vHandleDiagState
 *
 *DESCRIPTION:  To Handle Normal State
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunmaster_tclApp::vHandleDiagState(tU32 u32OldAppState)const
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_DIAG _ ET_EN_DONE);
	/* ---
   the server has already entered this state, so it has nothing to do 
   --- */

	/*-------------------------------------------------------*/
	/* antdiag_Manager is informed of the new tuner state.     */
	/*-------------------------------------------------------*/
	if( m_potunmstr_antdiag_Manager != NULL )
	{

		//m_potunmstr_antdiag_Manager ->vSetTunerSystemState(AMT_C_U32_STATE_DIAGNOSIS);
	}
	if (u32OldAppState == AMT_C_U32_STATE_DIAGNOSIS)
	{
		return; //switching to same state
	}


	/* +++
   do everything you have to do to enter the state DIAGNOSIS
   +++ */         


	/* ---
   inform the framework that the we are ready to receive and send messages
   --- */

}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vHandlePauseState
 *
 *DESCRIPTION:  To Handle Normal State
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunmaster_tclApp::vHandlePauseState(tU32 u32OldAppState)const
{

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_PAUSE _ ET_EN_DONE);
	/* ---
   the server has already entered this state, so it has nothing to do 
   --- */
	/*-------------------------------------------------------*/
	/* antdiag_Manager is informed of the new tuner state.     */
	/*-------------------------------------------------------*/
	if( m_potunmstr_antdiag_Manager != NULL )
	{

		//m_potunmstr_antdiag_Manager ->vSetTunerSystemState(AMT_C_U32_STATE_PAUSE);
	}
	if (u32OldAppState == AMT_C_U32_STATE_PAUSE)
	{
		return; //switching to same state
	}

	/* +++
   do everything you have to do to enter the state PAUSE
   +++ */

	/* +++
   inform the framework if you are ready to receive and send messages 
   in this state
   +++ */      

}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vHandleOffState
 *
 *DESCRIPTION:  To Handle Normal State
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunmaster_tclApp::vHandleOffState(tU32 u32OldAppState)const
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_OFF _ ET_EN_DONE);

	// m_pPortMngr->vClearAll();
	/* ---
   the server has already entered this state, so it has nothing to do 
   --- */
	/*-------------------------------------------------------*/
	/* antdiag_Manager is informed of the new tuner state.     */
	/*-------------------------------------------------------*/
	//if( m_potunmstr_antdiag_Manager != NULL )
	//{
	//	m_potunmstr_antdiag_Manager ->vSetTunerSystemState(AMT_C_U32_STATE_OFF);

	//}

	if (u32OldAppState == AMT_C_U32_STATE_OFF)
	{
		return; //switching to same state
	}

	/* +++
   do everything you have to do to enter the state OFF
   +++ */

	/* ---
   inform the framework that we are not ready to received or send messages
   --- */   
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if (m_poPortMngr != NULL)
	{
		m_poPortMngr->vClearAll( FALSE );
	}
#endif

}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::vSetStratUpTriggerSent_Info
 *
 *DESCRIPTION:  Set status about tuner start up processing handling
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunmaster_tclApp::vSetStratUpTriggerSent_Info(tBool blTrigger_Status)
{
	m_blStartup_Trigger = blTrigger_Status;
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::blGetStratUpTriggerSent_Info
 *
 *DESCRIPTION:  Get status about tuner start up processing handling
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tBool tunmaster_tclApp::blGetStratUpTriggerSent_Info()const
{
	return m_blStartup_Trigger;
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::u16GetRegID
 *
 *DESCRIPTION:  Retruns register ID of tunermaster service
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  u16
 *
 *HISTORY:
 *
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tU16 tunmaster_tclApp::u16GetRegID() const
{
	return u16m_RegID;
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunmaster_tclApp::u8GetStreamRoutreServiceState
 *
 *DESCRIPTION:  Retruns service state of stream router
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tu8
 ******************************************************************-FUNCHEADER*/

tU8 tunmaster_tclApp::u8GetStreamRoutreServiceState()const
{
	return m_u8StreamRouterServiceState;
}
/*******************************************************************
 *FUNCTION:     vCreateAntDiagClassInstances()
 *
 *DESCRIPTION:  function to create antenna diagnosis class instances
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *******************************************************************/
tVoid tunmaster_tclApp::vCreateAntDiagClassInstances()
{
	// Create tunmstr_antdiag_Debounce
	m_potunmstr_antdiag_Debounce = new tunmstr_antdiag_Debounce();
	if( m_potunmstr_antdiag_Debounce == NULL )
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_ERR_NEW_FAIL _ ET_EN_DONE);
	}
	// Create tunmstr_antdiag_Manager
	m_potunmstr_antdiag_Manager = new tunmstr_antdiag_Manager();
	if( m_potunmstr_antdiag_Manager == NULL )
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_ERR_NEW_FAIL _ ET_EN_DONE);
	}
	// Create tunmstr_antdiag_Measure
	m_potunmstr_antdiag_Measure = new tunmstr_antdiag_Measure();

	if( m_potunmstr_antdiag_Measure == NULL )
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_ERR_NEW_FAIL _ ET_EN_DONE);
	}
	// Create tunmstr_DiagLogClientHandler
	m_potunmstr_DiagLogClientHandler = new tunmstr_DiagLogClientHandler(this);
	if( m_potunmstr_DiagLogClientHandler == NULL )
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNMASTERAPP, ET_EN_T16 _ TUNMSTR_TRACE_TUNMASTERAPP_ERR_NEW_FAIL _ ET_EN_DONE);
	}
m_potunmstr_antdiag_i2cHandler=new tunmstr_antdiag_i2cHandler();
m_potunmstr_DiaglibListner=new tunmstr_DiaglibListner(this);

}
/*******************************************************************
 *FUNCTION:     vUpdateClientsPointer()
 *
 *DESCRIPTION:  function to update tunermaster clients  pointer  memeber variable
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *******************************************************************/
tVoid tunmaster_tclApp::vUpdateClientsPointer()
{
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	// Pointers for tunmstr_TunClnt_Handlr class
	if( m_potunmstr_TunClnt_Handlr != NULL )
	{
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_Utility_Ptr( m_ptunmstr_Utility );
		m_potunmstr_TunClnt_Handlr->vSet_tunmaster_Config_Ptr( m_ptunmaster_Config );
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_SrcChgManager_Ptr( m_potunmstr_SrcChgManager );
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI );
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_AutoStoreHandler_Ptr(m_potunmstr_AutoStoreHandler);
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_SrcChg_AnnoHandler_Ptr(m_potunmstr_SrcChg_AnnoHandler);
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_SDSHandler_Ptr( m_potunmstr_SDSHandler );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_MuteHandler_Ptr(m_potunmstr_MuteHandler);
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		m_potunmstr_TunClnt_Handlr->vSet_tunmstr_SXMClient_Handler_Ptr( m_ptunmaster_SXMClient );
#endif
	}
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if( m_potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
		m_potunmstr_AudioClientHandler->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
		m_potunmstr_AudioClientHandler->vSet_tunmstr_TunerClient_Handler_Ptr(m_potunmstr_TunClnt_Handlr);
		m_potunmstr_AudioClientHandler->vSet_tunmaster_tclApp_Handler_Ptr(this);
		m_potunmstr_AudioClientHandler->vSet_tunmstr_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
		m_potunmstr_AudioClientHandler->vSet_tunmstr_SrcChg_AnnoHandler_Ptr(m_potunmstr_SrcChg_AnnoHandler);
		m_potunmstr_AudioClientHandler->vSet_tunmstr_MuteHandler_Ptr(m_potunmstr_MuteHandler);
		m_potunmstr_AudioClientHandler->vSet_tunmaster_Config_Ptr(m_ptunmaster_Config);
		m_potunmstr_AudioClientHandler->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
	}
#endif

	if(m_potunmstr_DABClient_Handler !=NULL)
	{
		m_potunmstr_DABClient_Handler->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
		m_potunmstr_DABClient_Handler->vSet_tunmaster_Config_Ptr(m_ptunmaster_Config);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_AutoStoreHandler_Ptr(m_potunmstr_AutoStoreHandler);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_SrcChg_AnnoHandler_Ptr(m_potunmstr_SrcChg_AnnoHandler);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_DABClient_Handler->vSet_tunmstr_AudioClientHandler_Ptr(m_potunmstr_AudioClientHandler);
#endif
		m_potunmstr_DABClient_Handler->vSet_tunmstr_MuteHandler_Ptr(m_potunmstr_MuteHandler);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_MsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
		m_potunmstr_DABClient_Handler->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
#ifdef INCLUDE_PROFILE_MANAGER
		m_potunmstr_DABClient_Handler->vSet_PMClient_Handler_Ptr(m_ptunmaster_PMClient);
#endif
	}
#endif

		if( m_potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_potunmstr_MsgFromHMI->vSet_tunmaster_Config_Ptr(m_ptunmaster_Config);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16

		m_potunmstr_MsgFromHMI->vSet_tunmstr_SrcChgManager_Ptr(m_potunmstr_SrcChgManager);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);

		m_potunmstr_MsgFromHMI->vSet_tunmstr_SrcChg_AnnoHandler_Ptr(m_potunmstr_SrcChg_AnnoHandler);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_tunmstr_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_AutoStoreHandler_Ptr(m_potunmstr_AutoStoreHandler);
		m_potunmstr_MsgFromHMI->vSet_tunmstr_Utility_Ptr( m_ptunmstr_Utility );
		m_potunmstr_MsgFromHMI->vSet_tunmstr_SDSHandler_Ptr( m_potunmstr_SDSHandler );
#ifdef INCLUDE_PROFILE_MANAGER
		if( NULL != m_ptunmaster_PMClient)
		{
			m_potunmstr_MsgFromHMI->vSet_tunmstr_PMClient_Handler_Ptr( m_ptunmaster_PMClient );
		}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		m_potunmstr_MsgFromHMI->vSet_tunmstr_SXMClient_Handler_Ptr( m_ptunmaster_SXMClient );
		m_potunmstr_MsgFromHMI->vSet_tunmstr_SXMChannelArtClient_Handler_Ptr( m_ptunermaster_SXMchannelartClient );
#endif
#endif
		
	}
	// Pointers for Class tunmaster_tclSPMClient
	if( m_ptunmaster_tclSPMClient != NULL )
	{
		m_ptunmaster_tclSPMClient ->vSet_tunmaster_Config_Ptr( m_ptunmaster_Config );
		m_ptunmaster_tclSPMClient->vSet_tunmstr_antdiag_Manager(m_potunmstr_antdiag_Manager);
		m_ptunmaster_tclSPMClient->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_ptunmaster_tclSPMClient->vSet_tunmstr_DiagLogClientHandler_Ptr(m_potunmstr_DiagLogClientHandler);
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		m_ptunmaster_tclSPMClient ->vSet_tunmaster_SrcChgManager_Ptr( m_potunmstr_SrcChgManager );
		m_ptunmaster_tclSPMClient ->vSet_tunmaster_ClientHandler_Ptr( m_potunmstr_TunClnt_Handlr );		
#endif
	}
#ifdef INCLUDE_PROFILE_MANAGER
	if( NULL != m_ptunmaster_PMClient  )
	{
		m_ptunmaster_PMClient ->vSet_tunmaster_ClientHandler_Ptr( m_potunmstr_TunClnt_Handlr );
		m_ptunmaster_PMClient ->vSet_tunmstr_DABClient_Handler_Ptr(m_potunmstr_DABClient_Handler);
		m_ptunmaster_PMClient ->vSet_tunmstr_MsgToHMI_Ptr(m_potunmstr_MsgToHMI);
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		m_ptunmaster_PMClient ->vSet_tunmstr_SXMClient_Ptr(m_ptunmaster_SXMClient);
#endif
	}
	if( (NULL != m_potunmstr_TunClnt_Handlr)  && (NULL != m_potunmstr_DABClient_Handler))
	{
		m_potunmstr_TunClnt_Handlr->vSet_PMClient_Handler_Ptr(m_ptunmaster_PMClient);
	}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	if (NULL != m_ptunmaster_SXMClient)
	{
#ifdef INCLUDE_PROFILE_MANAGER
		m_ptunmaster_SXMClient->vSet_PMClient_Handler_Ptr(m_ptunmaster_PMClient);
#endif
		m_ptunmaster_SXMClient->vSet_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
		m_ptunmaster_SXMClient->vSet_tunmstr_ConfigInterface_Ptr(m_poclConfigMain);
		m_ptunmaster_SXMClient->vSet_tunmstrMsgToHMI_Ptr(m_potunmstr_MsgToHMI);
		m_ptunmaster_SXMClient->vSet_tunmstrMsgFromHMI_Ptr(m_potunmstr_MsgFromHMI);
		m_ptunmaster_SXMClient->vSet_tunmstr_TunerClientHandler_Ptr(m_potunmstr_TunClnt_Handlr);
	}

	if(NULL != m_ptunermaster_SXMchannelartClient)
	{
		m_ptunermaster_SXMchannelartClient->vSet_Preset_Handler_Ptr(m_potunmstr_Preset_Handler);
	}

#endif
}
