/************************************************************************
* FILE:           tunermaster_cfcVehicleClientHandler.cpp
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Cleint Header file for Vehicle Data Service
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date			 | Author										| Modification
 * 13-12-2013	 | RBEI/ECV3 Priya Prabhuswamy(rrb1kor)			| initial version

																			
*************************************************************************/

#ifndef tunermaster_cfcVehicleClientHandler_H
#include "tunermaster_cfcVehicleClientHandler.h"
#endif
//include hearder files

#include  "tunmstr_antdiag_Defines.h"
#include  "tunermaster_defines.h"


// Include VehicleData interface
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
	#include "spm_fi_if.h"
#else
	#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_DBGVISITORS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_STDVISITORS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_FUNCTIONIDS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_SERVICEINFO
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_VEHICLEFI_TYPES
	#define CFC_FI_S_IMPORT_INTERFACE_FI_TYPES
	#include "cfc_fi_if.h"
#endif

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fi_gen_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

//Include for ETG trace

#include  "tunermaster_trace.h"
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_CFCVEHICLECLIENTHANDLER
#include "trcGenProj/Header/tunermaster_cfcVehicleClientHandler.cpp.trc.h"
#endif


//message Mapping
BEGIN_MSG_MAP(tunermaster_cfcVehicleClientHandler, ahl_tclBaseWork)
#ifndef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
ON_MESSAGE( CFC_VEHICLEFI_C_U16_IGNITION,         vHandleIgnitionStatus)
ON_MESSAGE( CFC_VEHICLEFI_C_U16_PQ_BATTERY_VOLTAGE,   vHandleBatteryVgStatus)
#endif
END_MSG_MAP()


OSAL_tSemHandle tunermaster_cfcVehicleClientHandler::m_hNotTable_SemHandle  = OSAL_C_INVALID_HANDLE;
/*************************************************************************
 * FUNCTION:     tunermaster_cfcVehicleClientHandler
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tunermaster_cfcVehicleClientHandler::tunermaster_cfcVehicleClientHandler(tunmaster_tclApp* poMainApp )
{
	ETG_TRACE_USR1(("tunermaster_cfcVehicleClientHandler()"));
	poMain=poMainApp;
	m_u16RegisterId=AMT_C_U16_REGID_INVALID;
	m_blIgnitionStatus=FALSE;
	m_f32BatteryVg=0;
}
/*************************************************************************
 * FUNCTION:     tunermaster_cfcVehicleClientHandler
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tunermaster_cfcVehicleClientHandler::~tunermaster_cfcVehicleClientHandler()
{
	ETG_TRACE_USR1(("~tunermaster_cfcVehicleClientHandler()"));
	poMain=NULL;
	m_u16RegisterId=AMT_C_U16_REGID_INVALID;
	m_blIgnitionStatus=FALSE;
	m_f32BatteryVg=0;
}
/*************************************************************************
 * FUNCTION:     tunermaster_cfcVehicleClientHandler
 *
 * DESCRIPTION:  Defualt Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tunermaster_cfcVehicleClientHandler::tunermaster_cfcVehicleClientHandler()
{
	ETG_TRACE_USR1(("tunermaster_cfcVehicleClientHandler()"));
	poMain=NULL;
	m_u16RegisterId=AMT_C_U16_REGID_INVALID;
	m_blIgnitionStatus=FALSE;
	m_f32BatteryVg=0;
}
/*************************************************************************
 * FUNCTION:     vRegisterForVehicleDataService
 *
 * DESCRIPTION:  Function to register for Vechicle Data service 
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vRegisterForVehicleDataService()
{
	if(poMain==NULL)
	{
		return;
	}
	if(m_u16RegisterId==AMT_C_U16_REGID_INVALID)
	{
#ifndef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
		tBool bRetVal = poMain->bRegisterAsync(CCA_C_U16_SRV_VEHICLE_DATA,
					CFC_VEHICLEFI_C_U16_SERVICE_MAJORVERSION                      /* Major version */,
					CFC_VEHICLEFI_C_U16_SERVICE_MINORVERSION                     /* Minor version */,
					0x0,
					CCA_C_U16_APP_VD_VEHICLE_DATA);	
		ETG_TRACE_USR1(("vRegisterForVehicleDataService() bRetVal=%d",bRetVal));
#endif
	}
}
/*************************************************************************
 * FUNCTION:     vOnAsyncRegisterConf
 *
 * DESCRIPTION:  Vechicle Data service registeration confirmation function
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId,
				tU16 u16ServiceId,
				tU16 u16SourceSubID)
{
	m_u16RegisterId=u16RegisterId;
	ETG_TRACE_USR1(("vRegisterForVehicleDataService() m_u16RegisterId=%d u16ServiceId=%d,u16SourceSubID=%d u16ServerAppId=%d"\
		,m_u16RegisterId,u16ServiceId,u16SourceSubID,u16ServerAppId));
}
//tVoid tunermaster_cfcVehicleClientHandler::vUnregisterForService()
//{
//	if(NULL ==poMain )
//	{
//		NORMAL_M_ASSERT (NULL != poMain);
//	}
//	 Unregister only if Reg ID not invalid
//	if ( AMT_C_U16_REGID_INVALID != m_u16RegisterId )
//	{
//			poGWMain->vUnregisterService(CCA_C_U16_SRV_VEHICLE_DATA);
//	}
//
//		 Make register-ID invalid:
//		m_u16RegisterId = AMT_C_U16_REGID_INVALID;
//}
/*************************************************************************
 * FUNCTION:     vOnServiceState
 *
 * DESCRIPTION:  Function to handle Vechicle Data service state
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vOnServiceState (stOnServiceStateParm OnServiceStateParm)
{
	ETG_TRACE_USR1(("vOnServiceState() ServiceState=%d",OnServiceStateParm.u8ServiceState));
	switch(OnServiceStateParm.u8ServiceState)
	{
	case AMT_C_U8_SVCSTATE_AVAILABLE :
		{
			//Fix for jira issue NCG3D-2562
			/*These properties were introduced during MIB project and removed in A-IVI project
			  In A-IVI,Battery volatge is not supported by cfc_vechicle and ignition we have to use VEHICLE_MAINFI_C_U16_IGNITION
			vRegisterForProperty(CFC_VEHICLEFI_C_U16_IGNITION);
			vRegisterForProperty(CFC_VEHICLEFI_C_U16_PQ_BATTERY_VOLTAGE);*/
			break;
		}
	case AMT_C_U8_SVCSTATE_NOT_AVAILABLE:
		{
			break;
		}
	case AMT_C_U8_SVCSTATE_REG_INVALID:
		{
			break;
		}
	default:
		{
			break;
		}
	}

}
/*************************************************************************
 * FUNCTION:     vRegisterForProperty
 *
 * DESCRIPTION:  Function to register for Vechicle Data service Property
 *
 * PARAMETER:    tU16 u16FID
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vRegisterForProperty(tU16 u16FID)
{
	if((poMain==NULL) || (m_u16RegisterId == AMT_C_U16_REGID_INVALID))
	{
		return;
	}
	gm_tclEmptyMessage oUpRegMessage( CCA_C_U16_APP_TUNERMASTER,  // AppID of this application
		CCA_C_U16_APP_VD_VEHICLE_DATA,      // AppID of the Server
		m_u16RegisterId,                // RegId for the service (see bRegisterForService )
		0,                        // always 0
		CCA_C_U16_SRV_VEHICLE_DATA,  // SID of the service
		u16FID,                   // FID to register for
		AMT_C_U8_CCAMSG_OPCODE_UPREG);
if (poMain->enPostMessage(&oUpRegMessage, TRUE) == AIL_EN_N_NO_ERROR)
{
	// message send success - set the return value to TRUE
	ETG_TRACE_USR1(("vRegisterForProperty()->Reg for FID=%d is Success",u16FID));
}
else
{
	ETG_TRACE_ERR(("vRegisterForProperty()->Reg for FID=%d is failed",u16FID));
}
}
/*************************************************************************
 * FUNCTION:     vGetDataFromAmt
 *
 * DESCRIPTION:  Function to convert poMessage to AMT message
 *
 * PARAMETER:   amt_tclServiceData* poFIMsg,fi_tclTypeBase&     oFIData
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vGetDataFromAmt(amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		ETG_TRACE_ERR(("vGetDataFromAmt()-Error in converting to AMT tyep"));
		NORMAL_M_ASSERT_ALWAYS ();
	}
	ETG_TRACE_USR4(("vGetDataFromAmt()"));
}
/*************************************************************************
 * FUNCTION:     vHandleIgnitionStatus
 *
 * DESCRIPTION:  Function to Handle FID CFC_VEHICLEFI_C_U16_IGNITION  status msg
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vHandleIgnitionStatus(amt_tclServiceData* poMessage)
{
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
#ifndef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
			cfc_vehiclefi_tclMsgIgnitionStatus oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);
			tU8 u8IgnitionSignalState=oMsgStatus.SignalState;
			tBool blIgnitionStatus=oMsgStatus.IgnitionStatus;
			tS32 s32ViewOptions_state=oMsgStatus.ViewOptions.state;
			tS32 s32ViewOptions_reason=oMsgStatus.ViewOptions.reason;
			m_blIgnitionStatus=(TRUE==blIgnitionStatus)&&(VEHICLE_CSM_C_SIGNALSTATE_VALID==u8IgnitionSignalState)&&\
			(VEHICLE_CSM_C_VIEWOPTION_STATE_NORMAL==s32ViewOptions_state)&&(VEHICLE_CSM_C_VIEWOPTION_REASON_NORMAL==s32ViewOptions_reason);
			ETG_TRACE_USR4(("vHandleIgnitionStatus()IgnitionStatus=%d",m_blIgnitionStatus));
#endif
			break;
		}
		default:
		{
			break;
		}

}
}
/*************************************************************************
 * FUNCTION:     vHandleBatteryVgStatus
 *
 * DESCRIPTION:  Function to Handle FID CFC_VEHICLEFI_C_U16_PQ_BATTERY_VOLTAGE  status msg
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vHandleBatteryVgStatus(amt_tclServiceData* poMessage)
{
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
#ifndef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
			cfc_vehiclefi_tclMsgPQ_Battery_VoltageStatus oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);
			tU8 u8BatterySignalState=oMsgStatus.SignalState;
			tS32 s32ViewOptions_state=oMsgStatus.ViewOptions.state;
			tS32 s32ViewOptions_reason=oMsgStatus.ViewOptions.reason;
			if((VEHICLE_CSM_C_SIGNALSTATE_VALID==u8BatterySignalState)&&(VEHICLE_CSM_C_VIEWOPTION_STATE_NORMAL==s32ViewOptions_state)&&\
				(VEHICLE_CSM_C_VIEWOPTION_REASON_NORMAL==s32ViewOptions_reason))
			{
				m_f32BatteryVg=oMsgStatus.Value;
				ETG_TRACE_USR4(("vHandleBatteryVgStatus()->BatteryVg=%f",m_f32BatteryVg));
			}
			else
			{
				m_f32BatteryVg=0.0;
			}
#endif
			break;
		}
		default:
		{
			break;
		}
}
}
tVoid tunermaster_cfcVehicleClientHandler::vOnNewAppState(tU32 u32OldAppState,tU32 u32NewAppState)
{
	if(poMain==NULL)
	{
		return;
	}
	if(u32OldAppState!=u32NewAppState)
	{
	switch(u32NewAppState)
	{
		case AMT_C_U32_STATE_NORMAL:
		{
			vRegisterForVehicleDataService();
			break;
		}
		case AMT_C_U32_STATE_OFF:
		{
			m_u16RegisterId=AMT_C_U16_REGID_INVALID;
			poMain->vUnregisterService(CCA_C_U16_SRV_VEHICLE_DATA);
			break;
		}
		default:
		{
			break;
		}
		}
	}
}
tBool tunermaster_cfcVehicleClientHandler::blGetIgnitionstate()const
{
	return m_blIgnitionStatus;
}
tF32 tunermaster_cfcVehicleClientHandler::f32GetBatteryVg()const
{
	return m_f32BatteryVg;
}
/*************************************************************************
 * FUNCTION:     vHandleTTFiS_CMD
 *
 * DESCRIPTION:  Fucntion to Handle the TTFI's Command
 *
 * PARAMETER:    const tU8* u8DataSpecial
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_cfcVehicleClientHandler::vHandleTTFiS_CMD(const tU8* u8DataSpecial)
{
	tU8 u8FunctionID = u8DataSpecial[0];
	switch(u8FunctionID)
	{
	case TUNMSTR_IgnitionState:
		{
			m_blIgnitionStatus=(tBool)u8DataSpecial[1];
			ETG_TRACE_USR4(("vHandleTTFiS_CMD()->m_blIgnitionStatus=%d",m_blIgnitionStatus));
			break;
		}
	case TUNMSTR_BatteryVg:
		{
			m_f32BatteryVg=u8DataSpecial[1];
			m_f32BatteryVg=m_f32BatteryVg/10;
			ETG_TRACE_USR4(("vHandleTTFiS_CMD()->BatteryVg=%f",m_f32BatteryVg));
			break;
		}
	default:
		{
			break;
		}
	}
}
