/************************************************************************
* FILE:           tunermaster_utility.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner Master Utility tasks are done .
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 06/10/10  	 | CM-AI/PJ-VW36 ( RBEI ) Pallavi       | Initial version.
* 25.04.13 	     | NGP1KOR    						    | First version of the G3g after porting from NISSAN LCN2Kai 
				
																
*************************************************************************/

#ifndef TUNERMASTER_UTILITY_H
#define TUNERMASTER_UTILITY_H

#define TUNERMASTER_INVALID_UTF8_CHAR          0xffff
#define TUNERMASTER_INVALID_UNICODE_CHARACTER  0xffff
#define TUNERMASTER_INVALID_EBUCODE_CHARACTER  0xff
#define TUNERMASTER_CHAR_SPACE                 0x20


class tunmaster_Utility
{
public:

  tVoid vConvert16BitTo2SeparateBytes( tU8* pu8Message, tU16 u16Frequency )const;

  tU16 u16Convert2SeparateBytesTo16Bit( const tU8* pu8NewData )const;

  tVoid vConvert32BitTo4SeparateBytes( tU8* pu8Message, tU32 u32Frequency )const;

  tU32 u32Convert4SeparateBytesTo32Bit( const tU8* pu8NewData )const;




  // Converts the Unicode character to UTF8 equivalent:
  tU32 u32ConvertFromUnicode2UTF8( tU16 u16UnicodeChar )const;

  tU16 u16ConvertFromUTF82Unicode( tU8 u8UTF8CharMSB, tU8 u8UTF8CharLSB )const;

  tU16 u16ConvertFromUTF82Unicode( tU8 u8UTF8Char1, tU8 u8UTF8Char2, tU8 u8UTF8Char3 )const;
};


#endif /* TUNERMASTER_UTILITY_H */
