/************************************************************************
* FILE:           tunermaster_trace.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    TunerMaster Server, trace defines.
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 01/09/2010  	 | ECV4 ( RBEI ) Pallavi HN  		    | Initial version.
* 25.04.13  	 | NGP1KOR    						    | First version of the G3g after porting from NISSAN LCN2Kai 
				
				
												
*************************************************************************/

#ifndef TUNERMASTER_TRACE_H
#define TUNERMASTER_TRACE_H



#include "trace_if.h"

/*-------------------------*/
/* Trace for each class    */
/*-------------------------*/

/*----------------------------------------------------------------------------------*/
/* Tuner Componenet ->  TR_COMP_TUNER ( tri_types.h )  (256 * 82) = 20,992 (0x5200)  */

/* A class definition describes a 16 bit value, which has two parts                 */

/*   [  Component - ID   ][   Trace-Class-ID  ]                                     */
/*   15                  10                   0                                     */

/*----------------------------------------------------------------------------------*/




#define TUNMSTR_TRACE_CLASS_TUNMASTERAPP   (TR_COMP_TUNERMASTER + 1)
#define TUNMSTR_TRACE_CLASS_TUNMASTERTCLSRV      (TR_COMP_TUNERMASTER + 16) // Temperorily done 
 

#define TUNMSTR_TRACE_CLASS_ANTDIAG		   (TR_COMP_TUNERMASTER + 24)
#define TUNMSTR_TRACE_CLASS_WTHREAD        (TR_COMP_TUNERMASTER + 3)  
#define TUNMSTR_TRACE_CLASS_MSGQUE         (TR_COMP_TUNERMASTER + 6)
#define TUNMSTR_TRACE_CLASS_MGR            (TR_COMP_TUNERMASTER + 8)
#define TUNMSTR_TRACE_CLASS_ACTDATA        (TR_COMP_TUNERMASTER + 9)   
#define TUNMSTR_TRACE_CLASS_DISPATCHER     (TR_COMP_TUNERMASTER + 10) 
#define TUNMSTR_TRACE_CLASS_FLASH_ACCESS   (TR_COMP_TUNERMASTER + 2) 

#define TUNMSTR_TRACE_CLASS_DEBUG          (TR_COMP_TUNERMASTER + 17) //11
#define TUNMSTR_TRACE_CLASS_SPM_CLIENT     (TR_COMP_TUNERMASTER + 18) //12
#define TUNMSTR_TRACE_CLASS_HMI_MGR        (TR_COMP_TUNERMASTER + 19) 
#define TUNMSTR_TRACE_CLASS_KDSCONFIG       (TR_COMP_TUNERMASTER + 22)//0x16
#define TUNMSTR_TRACE_CLASS_CFCVEHICLECLIENTHANDLER		   (TR_COMP_TUNERMASTER + 25)
#define TUNMSTR_TRACE_CLASS_DIAGLIBHANDLER		   (TR_COMP_TUNERMASTER + 26)
#define TUNMSTR_TRACE_CLASS_PM_CLIENT   (TR_COMP_TUNERMASTER + 27)
#define TUNMSTR_TRACE_CLASS_SXM_CLIENT   (TR_COMP_TUNERMASTER + 28)
/*---------------------*/
/* class tunmaster_tclApp  */
/*---------------------*/
#define TUNMSTR_TRACE_TUNMASTERAPP_CONSTRUCTOR        0x0101  
#define TUNMSTR_TRACE_TUNMASTERAPP_DESTRUCTOR         0x0102
#define TUNMSTR_TRACE_TUNMASTERAPP_ONINIT             0x0103
#define TUNMSTR_TRACE_TUNMASTERAPP_SERVICE_STATE      0x0104
#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE      0x0105
#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_MESSAGE        0x0106
#define TUNMSTR_TRACE_TUNMASTERAPP_GET_SRV_VERSION    0x0107
#define TUNMSTR_TRACE_TUNMASTERAPP_ONWATCHDOG         0x0108
#define TUNMSTR_TRACE_TUNMASTERAPP_APPLICATION_CLOSE  0x0109
#define TUNMSTR_TRACE_TUNMASTERAPP_SEND_ERROR         0x010a
#define TUNMSTR_TRACE_TUNMASTERAPP_INIT_TUNER         0x010b

#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_NORMAL     0x010c
#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_DIAG       0x010d
#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_PAUSE      0x010e
#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_OFF        0x010f
#define TUNMSTR_TRACE_TUNMASTERAPP_NEW_APP_STATE_INVALID    0x0110

#define TUNMSTR_TRACE_TUNMASTERAPP_REGISTER_WITH_TTFIS      0x0113
#define TUNMSTR_TRACE_TUNMASTERAPP_UNREGISTER_WITH_TTFIS    0x0114

#define TUNMSTR_TRACE_TUNMASTETAPP_TRACE_CALLBACK_REG_SUCC  0x0115
#define TUNMSTR_TRACE_TUNMASTERAPP_TRACE_CALLBACK_REG_FAIL  0x0116

#define TUNMSTR_TRACE_TUNMASTERAPP_TRACE_CALLBACK_UNREG_SUCC  0x0115
#define TUNMSTR_TRACE_TUNMASTERAPP_TRACE_CALLBACK_UNREG_FAIL  0x0116

#define TUNMSTR_TRACE_TUNMASTERAPP_TRACE_VALUES               0x0117

#define TUNMSTR_TRACE_TUNMASTERAPP_DABTUNER_SERVICE		      0x0118
#define TUNMSTR_TRACE_TUNMASTERAPP_DAB_CLT_HNDLR_FAIL         0x0119
#define TUNMSTR_TRACE_TUNMASTERAPP_DAB_CLT_HNDLR_PASS         0x0120
#define TUNMSTR_TRACE_TUNMASTERAPP_SRV_DAB_TUNER              0x0121

/* Error messages */
#define TUNMSTR_TRACE_TUNMASTERAPP_ERR_NEW_FAIL             0x011a
#define TUNMSTR_TRACE_TUNMASTERAPP_NULL_POINTER             0x011b

/* Which service has sent in OnNewMessage */
#define  TUNMSTR_TRACE_TUNMASTERAPP_SRV_TUNERCONTROL        0x013a
#define TUNMSTR_TRACE_TUNMASTERAPP_SRV_TUNERMASTERCONTROL   0x013b
#define TUNMSTR_TRACE_TUNMASTERAPP_SRV_FROMHMI              0x031c
#define TUNMSTR_TRACE_TUNMASTERAPP_SRV_FROMAUDIO            0x031d

#define  TUNMSTR_TRACE_TUNMASTERAPP_FLASH_FILE_READ_SUCC      0x0201
#define  TUNMSTR_TRACE_TUNMASTERAPP_FLASH_FILE_READ_FAIL      0x0202

#define  TUNMSTR_TRACE_TUNMASTERAPP_FLASH_FILE_WRITE_SUCC     0x0203
#define  TUNMSTR_TRACE_TUNMASTERAPP_FLASH_FILE_WRITE_FAIL     0x0204

#define  TUNMSTR_TRACE_TUNMASTERAPP_FLASH_FILE_SAVE           0x0205


#define  TUNMSTR_TRACE_TUNMASTERAPP_SPM_CLIENT_SERVICE   0x0211
#define  TUNMSTR_TRACE_TUNMASTERAPP_TUNERCONTROL_SERVICE   0x0212

#define  TUNMSTR_TRACE_TUNMASTERAPP_BG_TUNER_ACTIVE            0x0316
#define  TUNMSTR_TRACE_TUNMASTERAPP_BG_TUNER_NOTACTIVE         0x0318

#define  TUNMSTR_TRACE_TUNMASTERAPP_PROJ_CONFIGURATION   0x0319

#define  TUNMSTR_TRACE_TUNMASTERAPP_TUN_CLT_HNDLR_FAIL	0x0320
#define  TUNMSTR_TRACE_TUNMASTERAPP_TUN_CLT_HNDLR_PASS	0x0321


          
/*----------------------*/
/* class tun_KDSConfiguration */
/*----------------------*/

#define TUNMSTR_TRACE_KDSCONFIG_CONSTRUCTOR          0x0101
#define TUNMSTR_TRACE_KDSCONFIG_DESTRUCTOR           0x0102
#define TUNMSTR_TRACE_KDSCONFIG_KDS_OPEN_ERROR       0x0103
#define TUNMSTR_TRACE_KDSCONFIG_KDS_OPEN_SUCCESS     0x0104
#define TUNMSTR_TRACE_KDSCONFIG_KDS_CLOSE_ERROR      0x0105
#define TUNMSTR_TRACE_KDSCONFIG_KDS_CLOSE_SUCCESS    0x0106
#define TUNMSTR_TRACE_KDSCONFIG_KDS_READ_ERROR       0x0107
#define TUNMSTR_TRACE_KDSCONFIG_KDS_READ_SUCCESS     0x0108
#define TUNMSTR_TRACE_KDSCONFIG_KDS_NO_OF_ANTENNA    0X0109
#define TUNMSTR_TRACE_KDSCONFIG_KDS_AREA             0X010a


/*-------------------------*/
/* class tuner_tclservice  */
/*-------------------------*/

#define TUNMSTR_TRACE_TCLSERVICE_HANDLE_COMP_STATUS   0x023a
#define TUNMSTR_TRACE_TCLSERVICE_HANDLE_FG_BG         0x023b
#define TUNMSTR_TRACE_TCLSERVICE_INVALID_PARA         0x023c


/*------------------------------*/
/* class tunmstr_RUIF_WaitingThread */
/*------------------------------*/

#define TUNMSTR_TRACE_WTHREAD_THREAD_STARTED             0x0120
#define TUNMSTR_TRACE_WTHREAD_LOOP_RUNNING               0x0121
#define TUNMSTR_TRACE_WTHREAD_EVENT_MASK                 0x0122
#define TUNMSTR_TRACE_RX_EVENT_RECEIVED                  0x0123
#define TUNMSTR_TRACE_SYSLAYER_LOOP_NOEVENT              0x0124
#define TUNMSTR_TRACE_SYSLAYER_LOOP_END                  0x0125
#define TUNMSTR_TRACE_WTHREAD_HANDLE_RX_MSG              0x0135
#define TUNMSTR_TRACE_WTHREAD_RX_MSG_CONFIRMATION        0x0136
#define TUNMSTR_TRACE_WTHREAD_RX_MSG_INDICATION          0x0137
#define TUNMSTR_TRACE_WTHREAD_TIMER_EVENT                0x0138

#define TUNMSTR_TRACE_WTHREAD_SELF_POSE_EVENT            0x0200
#define TUNMSTR_TRACE_WTHREAD_SELF_POSE_EVENT_SUCC       0x0202
#define TUNMSTR_TRACE_WTHREAD_SELF_POSE_EVENT_FAIL       0x0203
#define TUNMSTR_TRACE_WTHREAD_THREAD_TERMINATE           0x0206


/* Error */
#define TUNMSTR_TRACE_WTHREAD_THREAD_CREATION_FAIL       0x013a
#define TUNMSTR_TRACE_WTHREAD_THREAD_SPAWN_FAIL          0x013b
#define TUNMSTR_TRACE_WTHREAD_INVALID_IPNET_INTF_PTR     0x013c
#define TUNMSTR_TRACE_WTHREAD_INVALID_MESSAGE            0x013d
#define TUNMSTR_TRACE_WTHREAD_EVENT_CREATIONFAIL         0x013e

/*----------------------------*/
/* Tuner Message Q interface  */
/*----------------------------*/
#define TUNMSTR_TRACE_MESSAGEQUE_CONSTRUCTOR             0x0101
#define TUNMSTR_TRACE_MESSAGEQUE_DESTRUCTOR              0x0102

#define TUNMSTR_TRACE_MESSAGEQUE_GETNEXTMSG_OK           0x0105
#define TUNMSTR_TRACE_MESSAGEQUE_GETNEXTMSG_FAIL         0x0106

#define TUNMSTR_TRACE_MESSAGEQUE_INSERTNEXTMSG_OK        0x0109
#define TUNMSTR_TRACE_MESSAGEQUE_INSERTNEXTMSG_FAIL      0x010a

#define TUNMSTR_TRACE_MESSAGEQUE_ADDNEWMSG               0x010d
#define TUNMSTR_TRACE_MESSAGEQUE_ADDTOHEAD               0x010e

#define TUNMSTR_TRACE_MESSAGEQUE_ADDTOTAIL               0x0111
#define TUNMSTR_TRACE_MESSAGEQUE_REMOVEFROMHEAD          0x0112

#define TUNMSTR_TRACE_MESSAGEQUE_REMOVEFROMTAIL          0x0115


#define TUNMSTR_TRACE_MESSAGEQUE_PUTINQUE_OK             0x0119
#define TUNMSTR_TRACE_MESSAGEQUE_PUTINQUE_FAIL           0x011a

#define TUNMSTR_TRACE_MESSAGEQUE_MSGSENTSUCCESS          0x011d
#define TUNMSTR_TRACE_MESSAGEQUE_INCRHEADER              0x011e

#define TUNMSTR_TRACE_MESSAGEQUE_CLRMSG                  0x0121
#define TUNMSTR_TRACE_MESSAGEQUE_MSGOVERFLOW             0x0122

#define TUNMSTR_TRACE_MESSAGEQUE_WAITINGFORCONF          0x0124
#define TUNMSTR_TRACE_MESSAGEQUE_NOT_WAITINGFORCONF      0x0125

#define TUNMSTR_TRACE_MESSAGEQUE_NEXTVALIDMSG_AVAI       0x0128
#define TUNMSTR_TRACE_MESSAGEQUE_NEXTVALIDMSG_NOT_AVAI   0x0129


#define TUNMSTR_TRACE_MESSAGEQUE_MSGHEADER               0x0150
#define TUNMSTR_TRACE_MESSAGEQUE_MSGTAIL                 0x0151


/*----------------*/
/* Tuner Manager  */
/*----------------*/
#define TUNMSTR_TRACE_UPDATE_TUNER_STATE                0x0101
#define TUNMSTR_TRACE_TUNER_STATE_READY                 0x0102
#define TUNMSTR_TRACE_TUNER_STATE_NOT_READY             0x0103
#define TUNMSTR_TRACE_CHANGE_COMP_STATUS                0x0104




/*----------------------*/
/* class tunmstr_MsgFromHMI */
/*----------------------*/

#define TUNMSTR_TRACE_MSGFROMHMI_NULL_POINTER          0x0101
#define TUNMSTR_TRACE_MSGFROMHMI_SEND_REPLY_TO_CLIENT  0x0104
#define TUNMSTR_TRACE_MSGFROMHMI_SEND_ERROR_TO_CLIENT  0x0105
//#define TUNMSTR_TRACE_MSGFROMHMI_FID_HANDLER           0x0109
//#define TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE          0x0501
#define TUNMSTR_TRACE_MSGFROMHMI_WRONG_PARA            0x0502
#define TUNMSTR_TRACE_MSGFROMHMI_POST_MSG_FAIL         0x0701
#define TUNMSTR_TRACE_MSGFROMHMI_POST_MSG_OK           0x0702
#define TUNMSTR_TRACE_MSGFROMHMI_MSG_DEL_FAIL          0x0703


//#define TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC  0x0705
//#define TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL  0x0706

#define TUNMSTR_TRACE_MSGFROMHMI_NEW_CREATION_FAIL     0x0801
#define TUNMSTR_TRACE_MSGFROMHMI_UPREG_REG             0x5555
#define TUNMSTR_TRACE_MSGFROMHMI_MS                    0x6666





/*----------------------*/
/* class tunmstr_MsgToHMI   */
/*----------------------*/

#define TUNMSTR_TRACE_MSG_TO_HMI_STATUS_MSG             0x7777


#define TUNMSTR_TRACE_MSG_POST_FAIL_ERR                 0x0501


/*----------------------*/
/* class tunmstr_ActualData */
/*----------------------*/


/* class tunmstr_Data_MainStatus */

#define TUN_ACT_DATA_TUNER_MAIN_STATUS             0x0001
#define TUN_ACT_DATA_TUNER_STATION                 0x0002



/*-----------------------------*/
/* class tunmaster_Flash_File_Access */
/*-----------------------------*/
#define TUNMSTR_TRACE_FLASH_CREATE_FILE_FAIL            0x0101
#define TUNMSTR_TRACE_FLASH_CREATE_FILE_SUCC            0x0102

#define TUNMSTR_TRACE_FLASH_OPEN_FILE_FAIL              0x0106
#define TUNMSTR_TRACE_FLASH_OPEN_FILE_SUCC              0x0107

#define TUNMSTR_TRACE_FLASH_READ_FILE_FAIL              0x0108
#define TUNMSTR_TRACE_FLASH_READ_FILE_SUCC              0x0109
#define TUNMSTR_TRACE_FLASH_READ_FILE                   0x010a

#define TUNMSTR_TRACE_FLASH_WRITE_FILE_FAIL             0x010b
#define TUNMSTR_TRACE_FLASH_WRITE_FILE_SUCC             0x010c
#define TUNMSTR_TRACE_FLASH_WRITE_FILE                  0x010d



#define TUNMSTR_TRACE_FLASH_READ_DATA                   0x0201
#define TUNMSTR_TRACE_FLASH_WRITE_DATA                  0x0202
#define TUNMSTR_TRACE_FLASH_ACCESS_LIST_EMPTY           0x0203
#define TUNMSTR_TRACE_FLASH_ACCESS_INVALID_LIST_LEN     0x0204

#define TUNMSTR_TRACE_FLASH_READ_FILE_VER_WRONG         0x0205



#define TUNMSTR_TRACE_FLASH_ACCESS_INVALID_PARA         0x0301


// Macro for ordinary trace
/*#define TUNMSTR_TRACE(Trace_Val)                            \
  do {                                                  \
         ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_DEBUG,     \
          ET_EN_T8 _ TUN_DEBUG _                        \
            ET_EN_T32 _ __LINE__ _                      \
              ET_EN_T8 _ Trace_Val _                    \
                ET_EN_STRING _ __FILE__ _               \
                  ET_EN_DONE);                          \
      }while(0);*/

#define TUNMSTR_DEBUG 0x01
#define TUNMSTR_TRACE(Trace_Val)                           \
           ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_DEBUG,     \
					          ET_EN_T8 _ TUNMSTR_DEBUG _     \
							  ET_EN_T32 _ __LINE__ _     \
                              ET_EN_T8 _ Trace_Val _     \
                              ET_EN_STRING _ __FILE__ _  \
                              ET_EN_DONE);
 

/*------------------------------------*/
/* class tunmaster_tclSPMClient definition  */
/*------------------------------------*/

#define TUNMSTR_TRACE_COPRO_STATE_CHANGE                 0x0101
#define TUNMSTR_TRACE_SYSTEM_STATE_CHANGE                0x0102

#define TUNMSTR_TRACE_REGISTER_FOR_SERVICE_SUCC          0x0105
#define TUNMSTR_TRACE_REGISTER_FOR_SERVICE_FAIL          0x0107
#define TUNMSTR_TRACE_UNREGISTER_FOR_SERVICE             0x0108

#define TUNMSTR_TRACE_REGISTER_FOR_FID_INVALID_SRVID     0x0109
#define TUNMSTR_TRACE_REGISTER_FOR_FID                   0x010a
#define TUNMSTR_TRACE_UNREGISTER_FOR_FID                 0x010b

#define TUNMSTR_TRACE_SET_COPRO_STATE                    0x010c

#define TUNMSTR_TRACE_LOW_VOLTAGE_EVENT                  0x010e

#define TUNMSTR_TRACE_SPM_SYSTEM_STATE                   0x010d

#define TUNMSTR_TRACE_ON_SERVICE_STATE                   0x0110
#define TUNMSTR_TRACE_ON_SERVICE_STATE_AVAILABLE         0x0112
#define TUNMSTR_TRACE_ON_SERVICE_STATE_UNAVAILABLE       0x0113

#define TUNMSTR_TRACE_ON_INVALID_REGID                   0x0114

#define TUNMSTR_TRACE_ON_REG_FOR_COPRO_SUCC              0x0116

#define TUNMSTR_TRACE_ON_REG_FOR_SYSSTATE_SUCC           0x0117

#define TUNMSTR_TRACE_SPM_INFO_COPRO_STANDBY             0x0120
#define TUNMSTR_TRACE_SPM_INFO_COPRO_DOWN                0x0122
#define TUNMSTR_TRACE_SPM_INFO_COPRO_NORMAL              0x0124

#define TUNMSTR_TRACE_PROJECT_ID					     0x0301
#define TUNMSTR_TRACE_KDS_LANDSCAPE_ENABLE			     0x0302
#define TUNMSTR_TRACE_TUNERSTATE					     0x0303
#define TUNMSTR_TRACE_LANDSCAPE_FGBG					 0x0304

/*------------------------------------*/
/* class tunmstr_HMIManager definition    */
/*------------------------------------*/

#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_DIR_TICS            0x0401
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_NEW_DIR_TICS        0x0403
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_NEW_CTR             0x0405
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_STEPS        0x0407
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_STEPS_RES    0x0408
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_P_STEPS      0x0409
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_FRQ_ON_P_STEPS_RES  0x040a

#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_WITH_ONE_STEP       0x040b
#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_WITH_STEPS          0x040d

#define TUNMSTR_TRACE_HMI_MGR_MAN_TUN_TO_NEW_FRQ          0x040f

/*************************************************************************************/
//These are use by Learn Mem Flash File Read and write operation Class tun_Flash_File_Access
/*************************************************************************************/ 
#define TUNMSTR_TRACE_LEARNMEM_TRACE_DEF                  0xdddd
#define TUNMSTR_TRACE_LEARNMEM_READ_FILE_UNSUCC           0x0001
#define TUNMSTR_TRACE_FLASH_GET_FILE_SIZE_ERROR           0x0002
#define TUNMSTR_TRACE_FLASH_FILE_SIZE_LESS                0x0003
#define TUNMSTR_TRACE_FLASH_FILE_SIZE_WRONG               0x0004
#define TUNMSTR_TRACE_LEARNMEM_READ_FILE_SUCC             0x0005
#define TUNMSTR_TRACE_LEARNMEM_READ_FILE_FAIL             0x0006
#define TUNMSTR_TRACE_LEARNMEM_READ_DATA                  0x0007
#define TUNMSTR_TRACE_LEARNMEM_FILE_CREATED               0x0008
#define TUNMSTR_TRACE_LEARNMEM_WRITE_HEADERINFO           0x0009
#define TUNMSTR_TRACE_LEARNMEM_WRITE_DATA_SUCC            0x000a
#define TUNMSTR_TRACE_LEARNMEM_WRITE_DATA_FAIL            0x000b
#define TUNMSTR_TRACE_LEARNMEM_CREATE_FILE_FAIL           0x000c
#define TUNMSTR_TRACE_LEARNMEM_CREATE_FILE_SUCC           0x000d
#define TUNMSTR_TRACE_LEARNMEM_WRITE_DATA                 0x000e


#endif /* TUNERMASTER_TRACE_H */
