/************************************************************************
* FILE:           tunermaster_service.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    TunerMaster Server
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 08/09/10  	 | Pallavi HN                   		| initial version
* 25.04.13  	 | NGP1KOR   						    | First version of the G3g after porting from NISSAN LCN2Kai
												
*************************************************************************/

#ifndef TUNERMASTER_SERVICE_H
#define TUNERMASTER_SERVICE_H

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif



//class tunmaster_tclApp;



//--------------------
// class definition
//--------------------
class tunermaster_tclservice : public ahl_tclBaseWork
{
private:
   tunmaster_tclApp*              poGWMain;
   OSAL_tSemHandle            hNotTableSem;
   ahl_tclNotificationTable*  poNotTable;  //gets NotifactionTable from parent
   template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
   

   /* +++
   Enter your private Data and functions here
   +++ */
   
protected:
     
  virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );

   
public:
   
   /* +++
   Enter your public Data and functions here
   +++ */

   ahl_tclLock _oActivityLock;

   

   /*---------------------------------------------------------------------*/
      
   /*-- constructor --*/
   tunermaster_tclservice( tunmaster_tclApp* poMain ); 
   tunermaster_tclservice();//default constructor added to remove lint warning
   
   /*---------------------------------------------------------------------*/
   /*-- Destructor --*/
   virtual ~tunermaster_tclservice(); 

    /*---------------------------------------------------------------------*/
   
   tVoid bSendStatus( tU16 u16FID, tU8 Value )const;
   
   /*---------------------------------------------------------------------*/
   
   tVoid bSendAnswer( const amt_tclServiceData* poMessage, tU8 Value, tU8 u8Opcode )const;
   
   /*---------------------------------------------------------------------*/
   
   tBool bRelUpreg( const amt_tclServiceData* poMessage )const ;
   
   /*---------------------------------------------------------------------*/
   
   
   /*---------------------------------------------------------------------*/
   
   tVoid vOnNewAppState( tU32 u32OldAppState, tU32 u32AppState )const;

   /*---------------------------------------------------------------------*/
   
   tVoid vSendError( tU16 u16AMTErrorCode, tU16 u16TMCErrorCode, tU16 u16FID, tU16 u16RegisterID )const ;
   
   /*---------------------------------------------------------------------*/
   
   tBool bUpreg(const amt_tclServiceData* poMessage )const ;
   
   /*---------------------------------------------------------------------*/

   /*-- Handler for HMI messages --*/

   tVoid vHandleMessageFromHMI( amt_tclServiceData* poMessage ) const;

   /*---------------------------------------------------------------------*/
   
   //DECLARE_MSG_MAP( tunmaster_tclApp )

};

#endif //_tunermaster_service
