 /************************************************************************
* FILE:           tunermaster_main.h
* PROJECT:        G3g
* SW-COMPONENT:   
*----------------------------------------------------------------------
*
* DESCRIPTION:    Demo Server
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 17.08.10  	 | ECV Pallavi HN 					    | initial version
* 25.04.13  	 | NGP1KOR   					        | First version of the G3g after porting from NISSAN LCN2Kai
				
							
*************************************************************************/

#ifndef _TUNERMASTER_MAIN_H_
#define _TUNERMASTER_MAIN_H_

#define TUNERMASTER_FUNCARRAY_SIZE 10 // count of function-IDs of all services 
//#define TUNERMASTER_NOTARRAY_SIZE  20 // count of registered clients * different FIDs of all services
//#define TUNERMASTER_NOTARRAY_ENLARGE  20 // count of registered clients * different FIDs of all services
//#define ARRAY_COUNT(arrayName, arrayType) (sizeof(arrayName)/sizeof(arrayType))

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#ifdef VARIANT_S_FTR_ENABLE_AMT_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"
#endif
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif
struct stSourceAvailabilty
{
	tU8 oSource;
	tU8 oSrcAvail;
	tU8 oAvailabilityReason;
};
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clArlSourceImpl;
         class clAMFMTunerImpl;
         class clDABTunerImpl;
      }
   }
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
namespace tuner
{
   namespace announcements
   {
      class clAudioImpl;
      class clAMFMAnnouncementsImpl;
      class clDABAnnouncementsImpl;
      class clAnnouncementControl;
   }
}
#endif


// name of semaphore for notification table access

#define TUNERMASTER_NOTTABLE_SEM_NAME "TUNERMASTER_NOTTABLESEM"  

#define PM_USERS 6 /*Guest + 5 users*/
/*-------------------------------*/
/* class tunmaster_tclApp definition */
/*-------------------------------*/
#ifndef GTEST_x86LINUX_BUILD
struct stOnServiceStateParm
{
	tU16 u16ServiceId;
	tU16 u16RegisterId;
	tU16 u8ServiceState;
};
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_VDFMAM_AUD_CCACOMM
class tunmaster_tclApp : public ail_tclAppInterface
#else
class tunmaster_tclApp : public ail_tclOneThreadAppInterface 
#endif
{
private:
   
   //ahl_tFunction            _aFuncArray[TUNER_FUNCARRAY_SIZE];     // for notification storage
   //ahl_tNotification        _aNotArray[TUNER_NOTARRAY_SIZE];       // for notification storage
   
   static tBool _bAppClosed;

   /* Variable required for incomming trace */ 
   OSAL_tIODescriptor   _fdTrace;


   /* this function must not be used, therefore it is private */
   tunmaster_tclApp& operator=(const tunmaster_tclApp& c);
   tBool m_blStartup_Trigger;
   tU16 u16m_RegID;
   tU8 m_u8StreamRouterServiceState;
   tU16 m_u16TunerControlRegID;
   tU16 m_u16DabRegID;
   
   /* +++
   Enter your private Data and functions here   
   +++ */ 

   tVoid vInitializeToDefault();
   tVoid vInitializeTunMasterComponent( );

      //To read project configuration


   tBool fInitializationComplete;
   const tU8 cleoSBRVariant;
   const tU8 aivi2SBRVariant;
   tVoid vCreateClassInstances();

   tVoid vCreateClassPointers();

    tVoid vDeleteClassInstances();
	tVoid vUpdateClientsPointer();
	tVoid vDeleteTunMstrClientClassInstances();
	tVoid vDeleteTunMstrAntDiagClassInstances();
	tVoid vCreateAntDiagClassInstances();
	tVoid vUpdateAntDiagPointers();
    tVoid vHandleNormState(tU32 u32OldAppState)const;
    tVoid vHandleDiagState(tU32 u32OldAppState)const;
    tVoid vHandlePauseState( tU32 u32OldAppState)const;
    tVoid vHandleOffState( tU32 u32OldAppState)const;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
    tVoid vCheckSourceAvailabilityfromKDS();
#endif



//   ahl_tclServerPortMngr* m_pPortMngr;


   static tunmaster_tclApp* _theServer;
   
   template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
  
protected:
    virtual tBool bGetServiceVersion( tU16 u16ServiceID,         tU16& rfu16MajorVersion, 
                                      tU16& rfu16MinorVersion,   tU16& rfu16PatchVersion );

public:

   /* +++
   Enter your public Data and functions here
   +++ */
   
   tunermaster_tclservice*          _tunermaster_poCCAService;
   
   static OSAL_tSemHandle     _hNotTableSem;

   ahl_tclNotificationTable*  _poNotTable;

   /*------------------------------------*/
   /* Tuner utility tasks are done here  */
   /*------------------------------------*/
   tunmaster_Utility* m_ptunmstr_Utility;

   /*--------------------------------------*/
   /* Tuner config settings are done here  */
   /*--------------------------------------*/
   tunmaster_Config* m_ptunmaster_Config;

   clConfigMain* m_poclConfigMain;
      /*--------------------------------------------------------*/
   /* Class SPM client to handle COPRO, LOW VOLTAGE states   */
   /*--------------------------------------------------------*/
   tunmaster_tclSPMClient* m_ptunmaster_tclSPMClient;

#ifdef INCLUDE_PROFILE_MANAGER
   tunermaster_PMClient* m_ptunmaster_PMClient;
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
  tunermaster_SXMClient* m_ptunmaster_SXMClient;
  tunermaster_SXMchannelartClient* m_ptunermaster_SXMchannelartClient;
#endif
   
   tunermaster_cfcVehicleClientHandler*  m_potunermaster_cfcVehicleClientHandler;
   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_antdiag_Debounce  */
   /*--------------------------------------------------------*/
   tunmstr_DiaglibListner* m_potunmstr_DiaglibListner;
   tunmstr_antdiag_Debounce* m_potunmstr_antdiag_Debounce;

   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_antdiag_Manager  */
   /*--------------------------------------------------------*/

   tunmstr_antdiag_Manager* m_potunmstr_antdiag_Manager;

	/*--------------------------------------------------------*/
   /* Pointer to class tunmstr_antdiag_Measure */
   /*--------------------------------------------------------*/

   tunmstr_antdiag_Measure* m_potunmstr_antdiag_Measure;


	/*--------------------------------------------------------*/
   /* Pointer to class tunmstr_DiagLogClientHandler  */
   /*--------------------------------------------------------*/

   tunmstr_DiagLogClientHandler* m_potunmstr_DiagLogClientHandler;
   tunmstr_antdiag_i2cHandler* m_potunmstr_antdiag_i2cHandler;

      tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	     /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_MsgToHMI  */
   /*--------------------------------------------------------*/
   tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
   tuner::sessionManagement::audio::clArlSourceImpl* m_poArlSourceImpl;
   tuner::sessionManagement::audio::clAMFMTunerImpl* m_poAMFMTunerImpl;
   tuner::sessionManagement::audio::clDABTunerImpl* m_poDABTunerImpl;
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
   tuner::announcements::clAudioImpl* m_pAudioImpl;
   tuner::announcements::clAMFMAnnouncementsImpl* m_poAMFMAnnouncementImpl;
   tuner::announcements::clDABAnnouncementsImpl* m_poDABAnnouncementImpl;
   tuner::announcements::clAnnouncementControl* m_poAnnouncementControl;
#endif

#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
   tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;
#endif

	
   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_TunerClientHandler  */
   /*--------------------------------------------------------*/

   tunmstr_TunerClientHandler* m_potunmstr_TunClnt_Handlr;

   /**************************************************************************/
   /*Classes required for handling Source change, TA_logic and DAB concelment*/
   /**************************************************************************/
   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_SrcChgManager.cpp  */
   /*--------------------------------------------------------*/
   tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;

   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_DABClient_Handler  */
   /*--------------------------------------------------------*/
   tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;



   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_Preset_Handler  */
   /*--------------------------------------------------------*/
   tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;

   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_SrcChg_AnnoHandler  */
   /*--------------------------------------------------------*/
   tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;

   /*--------------------------------------------------------*/
   /* Pointer to class tunmstr_AutoStoreHandler  */
   /*--------------------------------------------------------*/
   tunmstr_AutoStoreHandler* m_potunmstr_AutoStoreHandler;

   tunmstr_MuteHandler* m_potunmstr_MuteHandler;

   tunmstr_SDSHandler* m_potunmstr_SDSHandler;

#endif
   ahl_tclServerPortMngr* m_poPortMngr;

   /* Needed for access from static functions */
   static tunmaster_tclApp* _poExemplar;

   // method to create server object - called by SPM
   static tunmaster_tclApp* theServer();
   
   /*-------------*/
   /* constructor */
   /*-------------*/
   tunmaster_tclApp(); 

   /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
   tunmaster_tclApp(const tunmaster_tclApp& c);
   /*overloading constructor*/

   /*------------*/
   /* destructor */
   /*------------*/
   virtual ~tunmaster_tclApp(); 

   tVoid vReadProjectConfiguration( );
   
    virtual tBool bOnInit();

    /* To be used by client */
    virtual tVoid vOnServiceState( tU16 u16ServiceId,  tU16 u16ServerId, 
                                   tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId );
   
    virtual tVoid vOnAsyncRegisterConf (  tU16 u16RegisterId, tU16 u16ServerAppId,
                                          tU16 u16ServiceId,  tU16 u16SourceSubID );

    virtual tVoid vOnNewAppState( tU32 u32OldAppState, tU32 u32AppState );  
 
    virtual tVoid vOnNewMessage ( amt_tclBaseMessage* poMessage );
   
    virtual tBool bOnWatchdog( );
   
    virtual tVoid vOnApplicationClose( );
    virtual tVoid vOnUnregister(tU16 u16ServiceId,  tU16 u16RegisterId);
   
    /*--------------------------------------*/
    /* help function to send error messages */
    /*--------------------------------------*/
    tVoid vSendError( tU16 u16SourceID,   tU16 u16TargetID,
                      tU16 u16RegisterID, tU16 u16CmdCounter,
                      tU16 u16Sid,        tU16 u16Fid  )const;
   

    /*-------------------------*/
    /* TTfis command functions */
    /*-------------------------*/
    tVoid vRegisterInTraceCmdService ();

    tVoid vUnregisterInTraceCmdService()throw();

    static tVoid vTraceTunerMasterChannelMgr (const tUChar* puchData);


    /*-----------------------------------------*/
    /* Tuner shut down after PAUSE, OFF state. */
    /*-----------------------------------------*/
    tVoid vTunerMasterShutDownProcess( );

    /*-------------------------------------*/
    /* Tuner activities during start up    */
    /*-------------------------------------*/
    tVoid vTunerMasterStartUpProcess( );
    /*-------------------------------------------*/
    /*To Check if Start up process is handelled  */
    /*-------------------------------------------*/
    tBool blGetStratUpTriggerSent_Info( )const;
    tVoid vSetStratUpTriggerSent_Info(tBool blTrigger_Status);
    tU16	u16GetRegID() const;
	tU8 u8GetStreamRoutreServiceState()const;
   
}; 

#endif //_TUNERMASTER_MAIN_H_
