///////////////////////////////////////////////////////////
//  tunermaster_SXMClient.h
//  Implementation of the Class tunermaster_SXMClient
//  Created on:      18-Apr-2018 11:35:14 AM
//  Original author: MHV6KOR
///////////////////////////////////////////////////////////

#ifndef TUNERMASTER_SXM_CLIENT_H
#define TUNERMASTER_SXM_CLIENT_H

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_ERRORCODES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h"

#ifdef INCLUDE_PROFILE_MANAGER
#ifndef TUNERMASTER_PM_CLIENT_H
#include "tunermaster_PMClient.h"
#endif
#endif

#include "datatypes/tVector.h"

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
class clConfigInterface;
class tunmaster_tclApp;
class tunmstr_Preset_Handler;
class tunmstr_MsgToHMI;
class tunmstr_MsgFromHMI;
class tunmstr_TunerClientHandler;

class tunermaster_SXMClient : public ahl_tclBaseWork
{

private:
	tunmaster_tclApp* poGWMain;
	tU16 m_u16SrvRegID;
#ifdef INCLUDE_PROFILE_MANAGER
	tunermaster_PMClient* m_ptunmaster_PMClient;
#endif
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	clConfigInterface* m_poclConfigInterface;
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;

	tBool m_bServiceAvailable;
	tU8 m_u8PresetAutocompare;

public:
	tunermaster_SXMClient(tunmaster_tclApp* poMain);
	virtual ~tunermaster_SXMClient();

	tBool bRegisterForFID(tU16 u16FID);
	tVoid vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16SourceSubID);
	tVoid vUnregisterForService();
	tVoid vOnServiceState(tU16 u16ServiceId, tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId);
	tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);
	virtual tVoid vRegisterForService();
	virtual tVoid vSendMessage(tU16 u16DestAppID, const fi_tclTypeBase& oOutData, tU16 u16Fid, tU8 u8OpCode, tU16 u16CmdCtr);
	virtual tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData )const;

	/*Online and Offline Personalization */
	tVoid vSendSXMListonlinePersonalization(midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& SXMList);
	tVoid vSendUserProfileAction(midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& UserProfileAction);

	tVoid vHandlePresetChannelUpdate(amt_tclServiceData* poMessage);
	tVoid vHandleSystemMessageUpdate(amt_tclServiceData* poMessage);
#ifdef INCLUDE_PROFILE_MANAGER
	tVoid vHandleUserProfileResult(amt_tclServiceData* poMessage);

	tVoid vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler);
	/*End Online and Offline Personalization */
#endif
	tVoid vHandle_SetPresetListResult(amt_tclServiceData* poMessage);
	tVoid vHandlePresetListResult(amt_tclServiceData* poMessage);
	tVoid vHandleRecallPresetResult(amt_tclServiceData* poMessage);
	tVoid vHandleStorePresetResult(amt_tclServiceData* poMessage);
	tVoid vHandlePresetAutoCompare(amt_tclServiceData* poMessage);
	tVoid vGetPresetList();
	tBool bGetServiceStatus();
	tU8 u8GetPresetAutoCompare();
	tVoid vSet_Preset_Handler_Ptr(tunmstr_Preset_Handler* po_tunmstr_PresetHandler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tVoid vSet_tunmstrMsgToHMI_Ptr(tunmstr_MsgToHMI* po_tunmstr_MsgToHMI);
	tVoid vSet_tunmstrMsgFromHMI_Ptr(tunmstr_MsgFromHMI* po_tunmstr_MsgFromHMI);
	tVoid vSet_tunmstr_TunerClientHandler_Ptr(tunmstr_TunerClientHandler* potunmstr_TunerClientHandler);

	DECLARE_MSG_MAP( tunermaster_SXMClient )

};
#endif
#endif // !defined(TUNERMASTER_SXM_CLIENT_H)
