/************************************************************************
* FILE:           Tunerermaster_PrjConfig.h
* PROJECT:        G3g
* SW-COMPONENT:   
*----------------------------------------------------------------------
*
* DESCRIPTION:    TUNMASTERer component, Project specific configuration.
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 20.01.05       | CM-DI/ESA2 ( RBIN ) Dinesh  		    | Initial version.
* 25.04.13  	 | NGP1KOR    						    | First version of the G3g after porting from NISSAN LCN2Kai 
				
				
*************************************************************************/
#ifndef TUNMASTERMASTER_PRJCONFIG_H
#define TUNMASTERMASTER_PRJCONFIG_H

#define TUNMASTER_COUNTRY_CODE_EUROPE         0x00


// Hardware informatio from the platform defines
#define TUNMASTER_PRJ_BP_FORD_LSRNS           0x03

#define TUNMASTER_PRODUCT_BP_FORD_LSRNS       0x03
#define TUNMASTER_PRODUCT_BP_VW_LL_NF         0x07

#define TUNMASTER_PRODUCT_BP_VW_CHINA         0x10


#define TUNMASTER_PRODUCT_BP_NISSAN_EU        0x0B
#define TUNMASTER_PRODUCT_BP_NISSAN_NAR       0x0C
#define TUNMASTER_PRODUCT_BP_MC_NAR           0x0F
#define TUNMASTER_PRODUCT_BP_MC_EU            0x0E
#define TUNMASTER_PRODUCT_BP_NISSAN_LCN2_NAR  0x11 
#define TUNMASTER_PRODUCT_BP_NISSAN_LCN2_EU   0x13
#define TUNMASTER_PRODUCT_BP_NISSAN_LCN2_EU_DAB   0x14

//Enumeration for KDS configuration parameters
enum T_e8_KDSParameter
{
	TUNMASTER_KDS_INVALID_PARAMETER = 255,
	TUNMASTER_KDS_TUNER_AREA = 0,
	TUNMASTER_KDS_FM_ANTENNA_TYPE,
  TUNMASTER_KDS_TUNMASTER_AVAILABLE,
  TUNMASTER_KDS_TMC_SERVER,
  TUNMASTER_KDS_LANDSCAPESEEK_NEEDED,
  TUNMASTER_KDS_ANTENNA_CURRENT,
  TUNMASTER_KDS_CMCONFIG_STRING,
  TUNMASTER_KDS_DAB_ANTENNA_LEVEL
};
enum T_e8_TUNMASTER_ANTENNA_LEVEL
{
	TUNMASTER_FM_ANTENNA_LEVEL_OPEN_0,
	TUNMASTER_FM_ANTENNA_LEVEL_CLOSE_0,
	TUNMASTER_FM_ANTENNA_LEVEL_SHORT_0,
	TUNMASTER_FM_ANTENNA_LEVEL_OPEN_1,
	TUNMASTER_FM_ANTENNA_LEVEL_CLOSE_1,
	TUNMASTER_FM_ANTENNA_LEVEL_SHORT_1,	
	TUNMASTER_DAB_ANTENNA_LEVEL_OPEN_0,
	TUNMASTER_DAB_ANTENNA_LEVEL_CLOSE_0,
	TUNMASTER_DAB_ANTENNA_LEVEL_SHORT_0
};

#define TUNMASTER_BIT_FIVE 0x20

/*Defines for position of configuration data in KDS as obtained from
LCN2_DiagnosticServices.pdf*/
#define DIA_KDS_AREA_POS 12 //Taken from FM/AM Tuner Parameter Set in KDS
#define DIA_KDS_FM_ANTENNA_TYPE_POS           48 //Taken from System Configuration 2 in KDS
#define DIA_KDS_TUNER_MASTER_AVAILABLE_POS    11  
#define DIA_KDS_TUNER_MASTER_TMC_SERVER_POS   35
#define DIA_KDS_LANDSCAPESEEK_NEEDED_POS      11
#define DIA_KDS_DAB_AVAIL_INFO			      04

#define DIA_KDS_TUNER_MASTER_ANTENNA_OPEN_0_LEVEL 		36
#define DIA_KDS_TUNER_MASTER_ANTENNA_CLOSE_0_LEVEL 		38
#define DIA_KDS_TUNER_MASTER_ANTENNA_SHORT_0_LEVEL 		40
#define DIA_KDS_TUNER_MASTER_ANTENNA_OPEN_1_LEVEL  		42
#define DIA_KDS_TUNER_MASTER_ANTENNA_CLOSE_1_LEVEL 		44
#define DIA_KDS_TUNER_MASTER_ANTENNA_SHORT_1_LEVEL 		46
#define TUNER_MASTER_ANTENNA_REDUCTION_FACTOR           0x0A
#define DIA_KDS_TUNER_MASTER_ANTENNA_2BYTE              0X02
#define DIA_KDS_TUNER_MASTER_DABANTENNA_OPEN_0_LEVEL 	218
#define DIA_KDS_TUNER_MASTER_DABANTENNA_CLOSE_0_LEVEL 	220
#define DIA_KDS_TUNER_MASTER_DABANTENNA_SHORT_0_LEVEL 	222
#define DIA_KDS_TOTAL_ANTENNA_CURRENT_LEVELS_TOBE_READ 	(tU8)9
#define KDS_READ_ERROR(u8Return) ((u8Return==DP_U8_ELEM_STATUS_VALID)?0:1)

#define DIA_KDS_TMC_FM  0x00
#define DIA_KDS_TMC_DAB 0x01
#define DIA_KDS_TMC_XM  0x04
#define TUNMSTR_TMC_SERVER 0x07

//The antenna information is available in bit position 3-5,hence ANDing with 0011 1000(0X38) is required
#define DIA_ANTENNA_TYPE_EXTRACT 0X07
#define DIA_TUNER_MASTER_AVAILABLE  0x01
#define DIA_TUNER_LANDSCAPESEEK_NEEDED 0x02

//Enumeration for possible Antenna Types read from KDs
enum T_e8_KDSAntennaType
{
	INVALID_ANTENNA_TYPE = 255,
	PASSIVE_1 = 0,
    ACTIVE_AGC_1,
    ACTIVE_ELCAA,
    PASSIVE_PLUS_AGC_DIVERSITY,
    PASSIVE_2,
    ACTIVE_AGC_2,
    ACTIVE_AGC_WITH_PHANTOM_SUPPLY,
    NEW_2,
	UNKNOWN

};

//Enumeration for possible number of antennas
enum T_e8_NoOfAntenna
{
	NO_ANTENNA = 0,
	SINGLE_ANTENNA,
	DOUBLE_ANTENNA
};

//Enumeration for possible areas read from KDS
enum T_e8_KDSTunerArea
{
	INVALID_AREA = 255,
    EUROPE = 0,
	RUSSIA,
	NORTH_AMERICA,
    SOUTH_AFRICA,
	GOLF_COAST,
    AUSTRALIA_AND_OCEANIA
};
#define TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND             0x05
#define TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_FM_MASKVAL   0x01
#define TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_AM_MASKVAL   0x06
#define TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_DRM_MASKVAL   0x06 // value will be changed later
#define TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_TRF_MASKVAL   0x10
#define TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL	   0x08
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI

/**============================= defines for KDS AMFM PARAMETER SET ==================*/
#define TUNMSTR_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_LW                    0xAAAAAAAA   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_LW                   0xAAAAAAAA   // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUNMSTR_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz

/**============================= defines for KDS GENERIC PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001

#define TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE				0x01

/**============================= defines for KDS VARIANT CODING PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3 0x00
#define TUNMSTR_CONFIG_DEFAULT_DABAVAIL 0x00

#define TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x01


#define TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3


#define TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE					0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK       	6
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK       	6
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK       	0
/*Until KDS for DRM Preset list is defined the value is hardcoded as 0*/
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK       	0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK       	0

#else

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_JACCII

/**============================= defines for KDS AMFM PARAMETER SET ==================*/
#define TUNMSTR_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_LW                    0xAAAAAAAA   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_LW                   0xAAAAAAAA   // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUNMSTR_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz

/**============================= defines for KDS GENERIC PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001

#define TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE				0x01

/**============================= defines for KDS VARIANT CODING PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3 0x00
#define TUNMSTR_CONFIG_DEFAULT_DABAVAIL 0x00

#define TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x01


#define TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3


#define TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE					0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK       	30
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK       	30
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK       	0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK       	0


#else

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_VW_MIBE

/**============================= defines for KDS AMFM PARAMETER SET ==================*/
#define TUNMSTR_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_LW                    0xAAAAAAAA   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_LW                   0xAAAAAAAA   // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUNMSTR_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz

/**============================= defines for KDS GENERIC PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001

#define TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE			0x01

/**============================= defines for KDS VARIANT CODING PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3 0x00
#define TUNMSTR_CONFIG_DEFAULT_DABAVAIL 0x00

#define TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x01


#define TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3

#define TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE					0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK       	12
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK       	12
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK       	0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK       	0


#else

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC

/**============================= defines for KDS AMFM PARAMETER SET ==================*/
#define TUNMSTR_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_LW                    153   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_LW                   279   // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUNMSTR_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz

/**============================= defines for KDS GENERIC PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001

#define TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE			0x01

/**============================= defines for KDS VARIANT CODING PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3 0x00
#define TUNMSTR_CONFIG_DEFAULT_DABAVAIL 0x00

#define TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x02


#define TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3


#define TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE					2

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK       	0
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK       	0
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK       	0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK       	15

#define TUNMSTR_CONFIG_DEFAULT_AM_AVAILABLE   							0
#define TUNMSTR_CONFIG_DEFAULT_COUNTRY_CODE								0
#define TUNMSTR_CONFIG_AM_AVAIL_EU							  			6
#define TUNMSTR_CONFIG_AM_AVAIL_RESTAREA								4
#define TUNMSTR_CONFIG_LW_NOTAVAIL  									0xFFFFFFFD
#define TUNMSTR_CONFIG_AM_NOTAVAIL                        				0xFFFFFFF9
#define TUNMSTR_EOL_AM_AVAILABLE										16	/*Byte 3 and bit 4*/
#define TUNMSTR_EOL_COUNTRY_CODE										0xE0 /*Byte 3 and bit 5-7*/

/*FM1 and FM2 Antenna type from PSA EOL parameter */
#define TUNMSTR_CONFIG_DEFAULT_FMANTENNATYPE                            0 /*0 Passive, 1 Active*/
#define TUNMSTR_EOL_FM1ANTENTYPE1_BIT                                   2 /*Byte 3, Bit 1*/
#define TUNMSTR_EOL_FM2ANTENTYPE1_BIT                                   4 /*Byte 3, Bit 2*/

enum enTunerArea
{
  enPSA_TunerArea_Europe                 = 0x00,
  enPSA_TunerArea_Japan	                 = 0x01,
  enPSA_TunerArea_South_America          = 0x02,
  enPSA_TunerArea_Asia_China           	 = 0x03,
  enPSA_TunerArea_Arabia				 = 0x04,
  enPSA_TunerArea_North_America  	     = 0x05,
  enPSA_TunerArea_Korea					 = 0x06,
  enPSA_TunerArea_Brazil				 = 0x07
};

#define TUNMSTR_CONFIG_EU_LOW_FM                     		87500   // kHz;
#define TUNMSTR_CONFIG_EU_HIGH_FM                   		108000  // kHz

#define TUNMSTR_CONFIG_EU_LOW_MW                    	531     // kHz
#define TUNMSTR_CONFIG_EU_HIGH_MW                   	1629    // kHz

#define TUNMSTR_CONFIG_EU_LOW_LW                   		 	144     // kHz
#define TUNMSTR_CONFIG_EU_HIGH_LW                   		288    // kHz

#define TUNMSTR_CONFIG_NAR_LOW_FM                     		87900   // kHz;
#define TUNMSTR_CONFIG_NAR_HIGH_FM                   		107900  // kHz

#define TUNMSTR_CONFIG_NAR_LOW_MW                    		530     // kHz
#define TUNMSTR_CONFIG_NAR_HIGH_MW                   		1710    // kHz

#define TUNMSTR_CONFIG_SAR_LOW_FM                     		87500   // kHz;
#define TUNMSTR_CONFIG_SAR_HIGH_FM                   		107900  // kHz

#define TUNMSTR_CONFIG_SAR_LOW_MW                    		530     // kHz
#define TUNMSTR_CONFIG_SAR_HIGH_MW                   		1710    // kHz

#define TUNMSTR_CONFIG_JP_LOW_FM                    		76000   // kHz;
#define TUNMSTR_CONFIG_JP_HIGH_FM                   		90000  	// kHz

#define TUNMSTR_CONFIG_JP_LOW_MW                    		522     // kHz
#define TUNMSTR_CONFIG_JP_HIGH_MW                  		 	1629    // kHz

#define TUNMSTR_CONFIG_ASIA_CN_LOW_FM                     	87500   // kHz;
#define TUNMSTR_CONFIG_ASIA_CN_HIGH_FM                   	108000  // kHz

#define TUNMSTR_CONFIG_ASIA_CN_LOW_MW                     	531	    // kHz;
#define TUNMSTR_CONFIG_ASIA_CN_HIGH_MW                   	1629   	// kHz

#define TUNMSTR_CONFIG_ARABIA_LOW_FM                     	87500   // kHz;
#define TUNMSTR_CONFIG_ARABIA_HIGH_FM                   	108000  // kHz

#define TUNMSTR_CONFIG_ARABIA_LOW_MW                     	531	   	// kHz;
#define TUNMSTR_CONFIG_ARABIA_HIGH_MW                   	1602  	// kHz


#else

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_CAF

/**============================= defines for KDS AMFM PARAMETER SET ==================*/
#define TUNMSTR_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_LW                    0xAAAAAAAA   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_LW                   0xAAAAAAAA   // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUNMSTR_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz

/**============================= defines for KDS GENERIC PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001

#define TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE				0x01

/**============================= defines for KDS VARIANT CODING PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3 0x00
#define TUNMSTR_CONFIG_DEFAULT_DABAVAIL 0x00

#define TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x01


#define TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3


#define TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE					0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK       	6
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK       	6
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK       	0
/*Until KDS for DRM Preset list is defined the value is hardcoded as 0*/
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK       	0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK       	0

#else

/**============================= defines for KDS AMFM PARAMETER SET ==================*/
#define TUNMSTR_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_LW                    0xAAAAAAAA   // kHz;
#define TUNMSTR_CONFIG_DEFAULT_HIGH_LW                   0xAAAAAAAA   // kHz
#define TUNMSTR_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUNMSTR_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz

/**============================= defines for KDS GENERIC PARAMETER SET =======================*/

#define TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001

#define TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE			0x01

/**============================= defines for KDS VARIANT CODING PARAMETER SET =======================*/
#define TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3 0x00
#define TUNMSTR_CONFIG_DEFAULT_DABAVAIL 0x00

#define TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x01


#define TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3

#define TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE					0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK       	12
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK       	12
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK       	0
/*Until KDS for DRM Preset list is defined the value is hardcoded as 0*/
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK       	0

#define TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK       	0

#endif /** END CAF */
#endif /** END PSA */
#endif /** END VW_MIBE */
#endif /** END JAC */
#endif /** END SUZUKI */
/*Until KDS for DRM Preset list is defined the value is hardcoded as 0*/
#define TUNMSTR_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK       	0
#endif//TUNMASTER_PRJCONFIG_H
