///////////////////////////////////////////////////////////
//  tunermaster_PMClient.h
//  Implementation of the Class tunermaster_PMClient
//  Created on:      26-Jun-2017 11:42:28 AM
//  Original author: MHV6KOR
///////////////////////////////////////////////////////////


#ifndef TUNERMASTER_PM_CLIENT_H
#define TUNERMASTER_PM_CLIENT_H

#ifdef VARIANT_S_FTR_ENABLE_AMT_MOCK
#include "amt_mock/amt_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif


// Use OSAL defines
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_STDVISITORS
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#ifdef INCLUDE_PROFILE_MANAGER
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_STDVISITORS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_FUNCTIONIDS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_SERVICEINFO
#include "profile_fi_if.h"
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_AUDIOFI_ERRORCODES

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fc_tunermaster_featureControl.h"

#include "midw_ext_fi_if.h"
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
#ifndef TUNERMASTER_SXM_CLIENT_H
#include "tunermaster_SXMClient.h"
#endif
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/audio/clAudioSession.h"
#include "sessionManagement/clArlSourceImpl.h" 
using namespace tuner::sessionManagement::audio;
#endif

#include "datatypes/tMap.h"
#include "datatypes/tVector.h"

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
//#include "../../utest/Mocks/tunmstr_Preset_Handler.h"
#else
#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#endif
#endif
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define KDS_BIT_0  0x01000000
#define KDS_BIT_1  0x02000000
#define KDS_BIT_2  0x04000000
#define KDS_BIT_3  0x08000000
#define KDS_BIT_4  0x10000000
#define KDS_BIT_5  0x20000000
#define KDS_BIT_6  0x40000000
#define KDS_BIT_7  0x80000000
#define KDS_BIT_8  0x00010000
#define KDS_BIT_9  0x00020000
#define KDS_BIT_10 0x00040000
#define KDS_BIT_11 0x00080000
#define KDS_BIT_12 0x00100000
#define KDS_BIT_13 0x00200000
#define KDS_BIT_14 0x00400000
#define KDS_BIT_15 0x00800000
#define KDS_BIT_16 0x00000100
#define KDS_BIT_17 0x00000200
#define KDS_BIT_18 0x00000400
#define KDS_BIT_19 0x00000800
#define KDS_BIT_20 0x00001000
#define KDS_BIT_21 0x00002000
#define KDS_BIT_22 0x00004000
#define KDS_BIT_23 0x00008000
#define KDS_BIT_24 0x00000001
#define KDS_BIT_25 0x00000002
#define KDS_BIT_26 0x00000004
#define KDS_BIT_27 0x00000008
#define KDS_BIT_28 0x00000010
#define KDS_BIT_29 0x00000020
#define KDS_BIT_30 0x00000040
#define KDS_BIT_31 0x00000080

#define TUN_ECC_UPPERNIBBLE_MASK 0x00F00000
#define TUN_ECC_LOWERNIBBLE_MASK 0x000F0000
#define TUN_ECC_UPPERNIBBLE_RSHIFT 20
#define TUN_ECC_LOWERNIBBLE_RSHIFT 16

#define DAB_ECC_VALIDATION (((u8ECC_UpperNibble == 0xA) && (u8ECC_LowerNibble <= 6)) ||\
							((u8ECC_UpperNibble == 0xD) && (u8ECC_LowerNibble <= 3)) ||\
							((u8ECC_UpperNibble == 0xE) && (u8ECC_LowerNibble <= 4)) ||\
							((u8ECC_UpperNibble == 0xF) && (u8ECC_LowerNibble <= 3))\
							)
typedef enum
{
	en_actionNone = 0,
	en_ActionChangeProfile  = 01,
	en_ActionCopy  = 02,
	en_ActionDelete  =03,
}ten_ProfileManagerAction;

struct stTunermasterPresetListMap
{
	tU32 u32KDSPresetListMapping;
	midw_fi_tcl_e8_List::tenType midw_fi_TunerMasterPresetListId;
	tU8 u8LastPresetelementNoOfPresetList;
};

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class clConfigInterface;
class clProfileInterface;
class tunmstr_Preset_Handler;
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
class tunermaster_SXMClient;
#endif

class TunerMasterPresetList : public midw_fi_tcl_TunMst_PresetListElement
{
public:
	tU8 m_u8IndividualTunerPresetID;
	midw_fi_tcl_e8_List m_e8ListType;
	TunerMasterPresetList(){m_u8IndividualTunerPresetID = 0; m_e8ListType.enType = midw_fi_tcl_e8_List::FI_EN_BANK_NONE;}
	~TunerMasterPresetList(){m_u8IndividualTunerPresetID = 0;m_e8ListType.enType = midw_fi_tcl_e8_List::FI_EN_BANK_NONE;}
};

class tunermaster_PMClient : public ahl_tclBaseWork
{

private:
	/*	Added the below constructor for purpose of unit testing  */
	tunermaster_PMClient(){};
   	tunmaster_tclApp*   poGWMain;
	tU16 m_u16SrvRegID;
#ifdef INCLUDE_PROFILE_MANAGER
	profile_fi_tcl_e8_profileStatus m_u8PMState;
	tU16 m_u16DestAppID;
   tU16 m_u16CmdCtr;
   tU16 m_u16GetFunctionID;
   tU16 m_u16GetRegisterID;
#endif
	tU8 m_u8UserID;
	ten_ProfileManagerAction m_u8Action;
	tBool m_bResponseSentToPM;
	tU8 m_u8MasterListLastPresetID;/*Added as variable as SXM not part of the preset information*/
	tU8 m_u8RadioProfileSettingRequestCount;
	tU8 m_u8NoOfPresetListUpdateRequest;
	tBool m_bRadioSettingResponseSent;
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;
	tunmstr_TunerClientHandler* m_potunmstr_TunClnt_Handlr;
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;
	tunmstr_Preset_Handler*	m_potunmstr_Preset_Handler;
	clConfigInterface* m_poclConfigInterface;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tuner::sessionManagement::audio::clArlSourceImpl* m_poArlSourceImpl;
#endif
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tunermaster_SXMClient* m_potunmstr_SXMClient_Handler;
#endif
	tBool m_bDeleteOthersOption;

	  /*---------------------------------------------------------------------*/

	   // Function to register for required service


	  /*---------------------------------------------------------------------*/

	  // Function to unregister for required service
	   tVoid fUnregisterForService();

	  // Function to register for FID (upreg)
	  tBool fRegisterForFID(tU16 u16FID);

	  /*---------------------------------------------------------------------*/

	  // Function to unregister for FID (relupreg)
	  tBool fUnregisterForFID(tU16 u16FID);

	  /*---------------------------------------------------------------------*/
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	  tVoid vHandleSXMProfileOperations(tU8 u8ProfileAction, tU8 u8SrcID_DeleteID, tU8 u8DstID);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	  tVoid vHandleSXM360LProfileOperations(tU8 u8ProfileAction, tU8 u8SrcID_DeleteID, tU8 u8DstID);
#endif

protected:
  /*---------------------------------------------------------------------*/
     // Function to handle unknown messages
   virtual tVoid vOnUnknownMessage
                  (
                  amt_tclBaseMessage* poMessage
                  );

public:

	tunermaster_PMClient (tunmaster_tclApp* poMain);
	virtual ~tunermaster_PMClient();


	   tVoid vOnServiceState
	      (
	      tU16 u16ServiceId,
	      tU16 u16ServerId,
	      tU16 u16RegisterId,
	      tU8  u8ServiceState,
	      tU16 u16SubId
	      );

	   // Function to handle new app state
	   tVoid vOnNewAppState
	      (
	      tU32 u32OldAppState,
	      tU32 u32AppState
	      );

		//Sned Messages to CCA component
	  tVoid vSendMessage( tU16             u16DestAppID,
				const fi_tclTypeBase&  oOutData,
				tU16             u16Fid,
				tU8              u8OpCode,
				tU16             u16CmdCtr);

	// Set the comp stability after comp becomes stable
	tVoid vSetCompStabilityState (tBool fStatus)const;
	tVoid vRegisterClient();

	tVoid  vHandleActiveProfile (amt_tclServiceData* poMessage);
	tVoid  vHandleStatus (amt_tclServiceData* poMessage);
	tVoid  vHandleDataChanged (amt_tclServiceData* poMessage);
	tVoid  vHandleCopyProfile (amt_tclServiceData* poMessage);
	tVoid  vHandleDeleteProfile (amt_tclServiceData* poMessage);
	tVoid  vHandleDoRegisterClient (amt_tclServiceData* poMessage);
	tVoid vSet_tunmaster_ClientHandler_Ptr( tunmstr_TunerClientHandler* ptunmaster_ClientHandler );
	tVoid vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler);
	tVoid vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI );
	tVoid vHandleOnDataChanged(tU8 u8Result );
	tVoid vHandleOnDataChanged_Prepare(tU8 Result );
	tVoid vHandleOnProfileCopied(tU8 u8Result) ;
	tVoid vHandleOnProfileDeleted(tU8 u8Result );
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tVoid vSet_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tVoid vSet_tunmstr_ArlSourceImplPtr(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl);
#endif
	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tVoid vSet_tunmstr_SXMClient_Ptr( tunermaster_SXMClient* potunmstr_SXMClient_Handler );
#endif
	tVoid vUpdateStatusTo_ARLandHMI();
	virtual tVoid fRegisterForService();
	tVoid  vSendProfileOperationToClients(tU8 u8SrcID_DeleteID, tU8 u8DstID , ten_ProfileManagerAction enUserAction);
	tVoid  vPrepareDataChanged();
	tBool bGetKeepOtherPreset();


#ifdef INCLUDE_PROFILE_MANAGER
	tVoid  vHandle_s_Radio_Profile_Setting (amt_tclServiceData* poMessage);
	tVoid  vHandle_s_RadioProfileSettings_Request (amt_tclServiceData* poMessage);
	tVoid  vUpdateAMSwitchSettings(tBool bAMSwitchStatus);
	tU8  vHandleRadioProfileSettings_ValidateAMFMParams(midw_fi_tcl_TunMst_PresetListElement& Element , midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response );
	tU8  vHandleRadioProfileSettings_ValidateDABParams(midw_fi_tcl_TunMst_PresetListElement& Element , midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response );
	tU8  vHandleRadioProfileSettings_ValidateSXMParams(midw_fi_tcl_TunMst_PresetListElement& Element , midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response );
	tVoid vCreateIndividualTunerListKeepOthers(midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& oMsgMethodStart );
	tVoid vCreateIndividualTunerListDeleteOthers(midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& oMsgMethodStart );
	tVoid  vCreateTunerElement(midw_fi_tcl_TunMst_PresetListElement& Element, midw_ext_fi_tcl_DAB_PresetListElement& DABList );
	tVoid  vCreateTunerElement(midw_fi_tcl_TunMst_PresetListElement& Element, midw_fi_tcl_TunerListElement& AMFMList );
	tVoid  vCreateTunerElement(midw_fi_tcl_TunMst_PresetListElement& Element, midw_ext_fi_tcl_PresetEntry& SXMList );
	tVoid  vInitializeAMFMListDeleteOthers(midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& AMFMList);
	tVoid  vInitializeDABListDeleteOthers(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& DABList);
	tVoid  vIndividualTunerPresetListUpdate(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus);
	tVoid  vIndividualTunerPresetListUpdate(midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus oStatus);
	tVoid  vIndividualTunerPresetListUpdate(midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus oStatus);
	tVoid  vSendResponseToRadioSetting(midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response , tU8 u8FailedPresetID=0);
	tVoid  vSendRadioSettingNotification(std::vector<tU8> u8PresetID );
	tVoid  vClearAMPresetsWhenDisableAM();
	tVoid  vPrintMasterList();
	tVoid  vPersonalizationMasterListCreation();
	tU8	vGetEndPresetIDForListID(midw_fi_tcl_e8_List ListID);
#endif

	virtual tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData )const;
	#ifdef INCLUDE_PROFILE_MANAGER
	DECLARE_MSG_MAP(tunermaster_PMClient)
	#endif
	tunerVector<TunerMasterPresetList> oPresetMasterList;
};
#endif //TUNERMASTER_PM_CLIENT_H

