/************************************************************************
* FILE:           tunmstr_antdiag_Manager.cpp
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class  tunmstr_antdiag_Manager
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author                            | Modification
* 25/05/2012| ECV4 ( RBEI ) Priya Prabhuswamy   | Initial version.
* 25.04.13  | NGP1KOR							| First version of the G3g after porting 
* 03.03.14  | ECV3 ( RBEI ) Priya Prabhuswamy   | adaptation for Different Type of External Power supply
*************************************************************************/
// System includes.
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "tunmstr_antdiag_Manager.h"
#include "tunmstr_antdiag_Measure.h"
#include "tunmstr_MsgToHMI.h"
#include "tunmstr_antdiag_i2cHandler.h"
#include "tunmstr_antdiag_Debounce.h"
#include "tunermaster_Config.h"
#include "tunmstr_DiagLogClientHandler.h"
#include "kdsconfig/clConfigInterface.h"
#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif
//etg trace
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_ANTDIAG 
#include "trcGenProj/Header/tunmstr_antdiag_Manager.cpp.trc.h"
#endif

OSAL_tTimerHandle  tunmstr_antdiag_Manager::m_hTxTimerTunMstr_1secTimer = 0;
OSAL_tTimerHandle  tunmstr_antdiag_Manager::m_hTxTimerTunMstr_200msecTimer = 0;


/*************************************************************************
* FUNCTION:     tunmstr_antdiag_Manager::tunmstr_antdiag_Manager( )
*
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*************************************************************************/
tunmstr_antdiag_Manager::tunmstr_antdiag_Manager()
{
   ETG_TRACE_USR4(("tunmstr_antdiag_Manager() TID = %i",OSAL_ThreadWhoAmI()));
   mThreadID = OSAL_ERROR;
	m_potunmstr_MsgToHMI=NULL;
	m_potunmstr_antdiag_Measure=NULL;
	m_potunmstr_antdiag_i2cHandler=NULL;
	m_potunmstr_antdiag_Debounce=NULL;
	m_potunmstr__DiagLog=NULL;
	m_potunmstr_MsgFromHMI=NULL;
	m_poclConfigInterface = NULL;
   m_potunmstr_DiaglibListner = nullptr;
   tS32 s32OsalError = OSAL_s32TimerCreate( ( OSAL_tpfCallback )vOnMonitorCycleTimerExpiry,
		( tPVoid )this, &m_hTxTimerTunMstr_1secTimer );
	if( s32OsalError == OSAL_ERROR )
	{
		NORMAL_M_ASSERT( s32OsalError != OSAL_ERROR );
	}
	s32OsalError = OSAL_s32TimerCreate( ( OSAL_tpfCallback )VGetTxTimeout_For200mSecTimer,
		( tPVoid )this, &m_hTxTimerTunMstr_200msecTimer );
	if( s32OsalError == OSAL_ERROR )
	{
		NORMAL_M_ASSERT( s32OsalError != OSAL_ERROR );
	}
	m_blnfineon_IC=FALSE;
	m_blnfineon_IC2=FALSE;
	m_blMax_IC=FALSE;
	m_blELMOS1_1_IC=FALSE;
	m_blELMOS1_2_IC=FALSE;
	m_blELMOS2_1_IC=FALSE;
	m_blELMOS2_2_IC=FALSE;
	m_blELMOS3_1_IC=FALSE;
	m_blELMOS3_2_IC=FALSE;
	m_blELMOS4_1_IC=FALSE;
	m_blELMOS4_2_IC=FALSE;

	m_blnfineon_ENState=FALSE;
	m_blnfineon2_ENState=FALSE;
	m_blMax_SHDNState=FALSE;
	m_blELMOS_EN1State=FALSE;
	m_blELMOS_EN2State=FALSE;
	m_blELMOS_EN3State=FALSE;
	m_blELMOS_EN4State=FALSE;

	m_u32MointorTime=TUNMSTR_ANTENNA_DIAGNOSIS_TIMER;
	m_blTimerActive=FALSE;
	m_blAntennaDiagState=FALSE;
	m_u8PendingStateReqClient=enClientNone;
	m_fBatteryVg=0;
	m_hIODescriptor = OSAL_ERROR;
	m_u8ElmosUpdateOverCurrentRegiser=0;

	for(tU8 u8Index=enFM1;u8Index<enClientNone;u8Index++)
	{
		m_enCMExtPowerSupply[u8Index]=enunknown;
		m_enAntennaTyp[u8Index]=enNone;
		m_blConsider_CriticalHgVg[u8Index]=FALSE;
	}
	m_blMAX20084_1_1_IC = false;
	m_blMAX20084_1_2_IC = false;
	m_blMAX20084_2_1_IC = false;
	m_blMAX20084_2_2_IC = false;
	m_blMAX20084_3_1_IC = false;
	m_blMAX20084_3_2_IC = false;
	m_blTPS7B7701_1_IC = false;
	m_blTPS7B7702_1_1_IC = false;
	m_blTPS7B7702_1_2_IC = false;

	m_blMax20084_1_ENState = false;
	m_blMax20084_2_ENState = false;
	m_blMax20084_3_ENState = false;
	m_blTPS7B7702_1_EN1State = false;
	m_blTPS7B7702_1_EN2State = false;
	m_blTPS7B7701_1_ENState = false;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	m_blA2S1Bsample = false;
#endif
	m_u8AntennaKDSReadRet = enAntennaKDSReadFail;
   m_EventHandle = OSAL_NULL;
   vInitialize();

}
/*************************************************************************
* FUNCTION:     tunmstr_antdiag_Manager::~tunmstr_antdiag_Manager( )
*
* DESCRIPTION:  Destructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*************************************************************************/
tunmstr_antdiag_Manager::~tunmstr_antdiag_Manager( )
{
	m_potunmstr_MsgToHMI=NULL;
	m_potunmstr_antdiag_Measure=NULL;
	m_potunmstr_antdiag_i2cHandler=NULL;
	m_potunmstr_antdiag_Debounce=NULL;
	m_potunmstr__DiagLog=NULL;
	m_potunmstr_MsgFromHMI=NULL;
	m_poclConfigInterface = NULL;
   m_potunmstr_DiaglibListner = nullptr;
	m_blnfineon_IC=FALSE;
	m_blnfineon_IC2=FALSE;
	m_blMax_IC=FALSE;
	m_blELMOS1_1_IC=FALSE;
	m_blELMOS1_2_IC=FALSE;
	m_blELMOS2_1_IC=FALSE;
	m_blELMOS2_2_IC=FALSE;
	m_blELMOS3_1_IC=FALSE;
	m_blELMOS3_2_IC=FALSE;
	m_blELMOS4_1_IC=FALSE;
	m_blELMOS4_2_IC=FALSE;

	m_blnfineon_ENState=FALSE;
	m_blnfineon2_ENState=FALSE;
	m_blMax_SHDNState=FALSE;
	m_blELMOS_EN1State=FALSE;
	m_blELMOS_EN2State=FALSE;
	m_blELMOS_EN3State=FALSE;
	m_blELMOS_EN4State=FALSE;

	m_u32MointorTime=TUNMSTR_ANTENNA_DIAGNOSIS_TIMER;
	m_blTimerActive=FALSE;
	m_blAntennaDiagState=FALSE;
	m_u8PendingStateReqClient=enClientNone;

	m_fBatteryVg=0;
	m_hIODescriptor = OSAL_ERROR;
	m_u8ElmosUpdateOverCurrentRegiser=0;

	for(tU8 u8Index=enFM1;u8Index<enClientNone;u8Index++)
	{
		m_enCMExtPowerSupply[u8Index]=enunknown;
		m_enAntennaTyp[u8Index]=enNone;
		m_blConsider_CriticalHgVg[u8Index]=FALSE;
	}
	m_blMAX20084_1_1_IC = false;
	m_blMAX20084_1_2_IC = false;
	m_blMAX20084_2_1_IC = false;
	m_blMAX20084_2_2_IC = false;
	m_blMAX20084_3_1_IC = false;
	m_blMAX20084_3_2_IC = false;
	m_blTPS7B7701_1_IC = false;
	m_blTPS7B7702_1_1_IC = false;
	m_blTPS7B7702_1_2_IC = false;

	m_blMax20084_1_ENState = false;
	m_blMax20084_2_ENState = false;
	m_blMax20084_3_ENState = false;
	m_blTPS7B7702_1_EN1State = false;
	m_blTPS7B7702_1_EN2State = false;
	m_blTPS7B7701_1_ENState = false;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	m_blA2S1Bsample = false;
#endif
	m_u8AntennaKDSReadRet = enAntennaKDSReadFail;
   if(mThreadID != OSAL_ERROR)
   {
      OSAL_s32ThreadDelete(mThreadID);
   }
   mThreadID = OSAL_ERROR;
   if( m_EventHandle != OSAL_NULL)
   {
       OSAL_s32EventClose( m_EventHandle );
       OSAL_s32EventDelete("TUNMSTR_ANTDIAG_EVN");
   }
}
tVoid tunmstr_antdiag_Manager::vInitialize()
{
   ETG_TRACE_USR4(("vInitialize() TID = %i m_EventHandle=%i",OSAL_ThreadWhoAmI(),m_EventHandle));
   tS32 s32Result = OSAL_ERROR;
   s32Result = OSAL_s32EventCreate("TUNMSTR_ANTDIAG_EVN", &m_EventHandle);
   s32Result = (tS32)OSAL_u32ErrorCode( );
   if(s32Result == OSAL_ERROR)
   {
      ETG_TRACE_USR1(("vInitialize()->Event creation FAILED with error = %s!", OSAL_coszErrorText(s32Result)));
   }
   ETG_TRACE_USR4(("vInitialize() TID = %i m_EventHandle=%i",OSAL_ThreadWhoAmI(),m_EventHandle));
   OSAL_trThreadAttribute thread;
   tS32 u32Priority  = OSAL_C_U32_THREAD_PRIORITY_NORMAL;
   tS32 u32StackSize = 10000;
   thread.szName       = (char*)"TUNMSTR_ANTDIAG";;
   thread.pfEntry      = (OSAL_tpfThreadEntry) &vThreadCallback ;
   thread.u32Priority  = u32Priority;
   thread.s32StackSize = u32StackSize;
   thread.pvArg        = this;
   mThreadID = OSAL_ThreadSpawn(&thread);
   if (mThreadID == OSAL_ERROR)
   {
      ETG_TRACE_USR1(("vInitialize()->Error in spawning thread"));
      s32Result = OSAL_ERROR;
   }
   else
   {
      ETG_TRACE_USR1(("vInitialize()->thread is running"));
   }
}
tVoid tunmstr_antdiag_Manager::vThreadCallback(tVoid* pvArg)
{
   ETG_TRACE_USR4(("vThreadCallback() TID = %i",OSAL_ThreadWhoAmI()));
   tunmstr_antdiag_Manager* ptunmstr_antdiag_Manager = static_cast<tunmstr_antdiag_Manager*>(pvArg);
   if (nullptr == ptunmstr_antdiag_Manager)
   {
      ETG_TRACE_FATAL(("vThreadCallback() invoked with NULL"))
                        return;
   }
   tBool bStopThread = false;
   OSAL_tEventMask u32EventMaskResult = 0;
   while (false == bStopThread)
   {
      if (OSAL_s32EventWait(ptunmstr_antdiag_Manager->m_EventHandle, TUNMSTR_ANTDIAG_U32_EVENT_MASK_ALL, \
                            OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &u32EventMaskResult) == OSAL_OK)
      {
         if (OSAL_s32EventPost(ptunmstr_antdiag_Manager->m_EventHandle, ~u32EventMaskResult, OSAL_EN_EVENTMASK_AND) == OSAL_OK)
         {
#ifdef GTEST_x86LINUX_BUILD
   u32EventMaskResult = ptunmstr_antdiag_Manager->u32unitestmask;
   bStopThread = true;
#endif
            ETG_TRACE_USR4( ( "vThreadCallback(): event %08x received", u32EventMaskResult))
            if (u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_THREAD)
            {
               bStopThread = true;
            }
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_START_ANTDIAG)
            {
               ptunmstr_antdiag_Manager->vHandleAntennaSwitching(true);
            }
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_ANTDIAG)
            {
               ptunmstr_antdiag_Manager->vHandleAntennaSwitching(false);
            }
            if (u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_NORMAL)
            {
               ptunmstr_antdiag_Manager->vOnNewAppState(AMT_C_U32_STATE_NORMAL);
            }
            if (u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_OFF)
            {
               ptunmstr_antdiag_Manager->vOnNewAppState(AMT_C_U32_STATE_OFF);
            }
            if (u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_SET_DTV_ANT_REG_REQ)
            {
               ptunmstr_antdiag_Manager->vSetDTVAntennaRegister();
            }
            if((u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_LOWVG_START) && (!ptunmstr_antdiag_Manager->m_blCriticalLowVg))
            {
               ptunmstr_antdiag_Manager->m_blCriticalLowVg = true;
               ptunmstr_antdiag_Manager->vHandleCriticalLowVg(true);
            }
            if((u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_LOWVG_END) && (ptunmstr_antdiag_Manager->m_blCriticalLowVg))
            {
               ptunmstr_antdiag_Manager->m_blCriticalLowVg = false;
               ptunmstr_antdiag_Manager->vHandleCriticalLowVg(false);
            }
            if((u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_HIGHVG_START) && (!ptunmstr_antdiag_Manager->m_blCriticalHighVg))
            {
               ptunmstr_antdiag_Manager->m_blCriticalHighVg = true;
               ptunmstr_antdiag_Manager->vHandleCriticalHgVg(true);
            }
            if((u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_HIGHVG_END) && (ptunmstr_antdiag_Manager->m_blCriticalHighVg))
            {
               ptunmstr_antdiag_Manager->m_blCriticalHighVg = false;
               ptunmstr_antdiag_Manager->vHandleCriticalHgVg(false);
            }
#ifndef GTEST_x86LINUX_BUILD
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_ROUTINE_REQ)
            {
               if(ptunmstr_antdiag_Manager->m_potunmstr_DiaglibListner!=nullptr)
               {
                  ptunmstr_antdiag_Manager->m_potunmstr_DiaglibListner->vProcessRoutineControlReq();
               }
            }
#endif
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_STATUS_REQ)
            {
               tenAntDiagClients enAntDiagClient = (tenAntDiagClients)ptunmstr_antdiag_Manager->u8GetPendingAntennaStateReqClient();
               ptunmstr_antdiag_Manager->vHandle_s_Rf_Antenna_TestReq(enAntDiagClient);
            }
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_UPREG_REQ)
            {
               ptunmstr_antdiag_Manager->vSendCurrnetAntennaStatus();
            }
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_ITC_UPDATE_REQ)
            {
               ptunmstr_antdiag_Manager->m_potunmstr__DiagLog->vHandleSendNextTestResultReq();
            }
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_200MS_TIMER_EXPIRY)
            {
               ptunmstr_antdiag_Manager->vHandle200msTimerExpiry();
            }
            if(u32EventMaskResult & TUNMSTR_ANTDIAG_U32_EVENT_MASK_MONITORCYCLE_TIMER_EXPIRY)
            {
               ptunmstr_antdiag_Manager->vHandleMonitorCycleTimerExpiry();
            }
         }
      }
      else
      {
         bStopThread = true;
      }
   }
}
tVoid tunmstr_antdiag_Manager::vPostEvent(tU32 u32EventID)
{
   OSAL_tEventHandle hEvent = 0;
   if( OSAL_s32EventOpen( "TUNMSTR_ANTDIAG_EVN", &hEvent) == OSAL_OK)
   {
      ETG_TRACE_USR4(("vPostEvent() TID = %i hEvent=%i u32EventID =%i",OSAL_ThreadWhoAmI(),hEvent, u32EventID));
      if(OSAL_s32EventPost( hEvent, u32EventID, OSAL_EN_EVENTMASK_OR) != OSAL_OK)
      {
         NORMAL_M_ASSERT_ALWAYS();
      }
      (tVoid)OSAL_s32EventClose( hEvent);
   }
}
/*************************************************************************
* FUNCTION:    vSet_tunmstr_MsgToHMI_Ptr
*
* DESCRIPTION: update tunmstr_MsgToHMI pointer variable
*
* PARAMETER:   tunmstr_MsgToHMI* potunmstr_MsgToHMI
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI)
{
	if(potunmstr_MsgToHMI!=NULL)
	{
		m_potunmstr_MsgToHMI =(tunmstr_MsgToHMI*) potunmstr_MsgToHMI;
	}
}
/*************************************************************************
* FUNCTION:    vSet_tunmstr_antdiag_Measure_Ptr( tunmstr_antdiag_Measure* potunmstr_antdiag_Measure )
*
* DESCRIPTION: update tunmstr_antdiag_Measure pointer variable
*
* PARAMETER:   tunmstr_antdiag_Measure* potunmstr_antdiag_Measure
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_antdiag_Measure_Ptr
(tunmstr_antdiag_Measure* potunmstr_antdiag_Measure)
{
	if( potunmstr_antdiag_Measure != NULL )
	{
		m_potunmstr_antdiag_Measure = ( tunmstr_antdiag_Measure* )potunmstr_antdiag_Measure;
	}
}
/******************************************************************************
*	FUNCTION:      vSet_tunmstr_antdiag_i2cHandler

*	DESCRIPTION:   function to update m_potunmstr_antdiag_i2cHandler

*	PARAMETERS:    tunmstr_antdiag_i2cHandler* Ptunmstr_antdiag_i2cHandler

*	RETURN TYPE:   tVoid
*********************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_antdiag_i2cHandler
(tunmstr_antdiag_i2cHandler* Ptunmstr_antdiag_i2cHandler)
{
	m_potunmstr_antdiag_i2cHandler=Ptunmstr_antdiag_i2cHandler;
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_antdiag_Debounce_Ptr()
 *
 * DESCRIPTION: function to update m_potunmstr_antdiag_Debounce
 *
 * PARAMETER:   tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_antdiag_Debounce_Ptr
(tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce)
{
	if( potunmstr_antdiag_Debounce != NULL )
	{
		m_potunmstr_antdiag_Debounce = ( tunmstr_antdiag_Debounce* )potunmstr_antdiag_Debounce;
	}
}
/*************************************************************************
* FUNCTION:    vSet_tunmstr_antdiag_Measure_Ptr( tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler )
*
* DESCRIPTION: update tunmstr_DiagLogClientHandler pointer variable
*
* PARAMETER:   tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_DiagLogClientHandler_Ptr
(tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler)
{
	if( potunmstr_DiagLogClientHandler != NULL )
	{
		m_potunmstr__DiagLog = ( tunmstr_DiagLogClientHandler* )potunmstr_DiagLogClientHandler;
	}
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_MsgFromHMI_Ptr()
 *
 * DESCRIPTION: function to update m_potunmstr_MsgFromHMI
 *
 * PARAMETER:   tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_MsgFromHMI_Ptr(tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI = ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}

}

/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}
tVoid tunmstr_antdiag_Manager::vSet_tunmstr_DiaglibListner_Ptr(tunmstr_DiaglibListner* potunmstr_DiaglibListner)
{
   m_potunmstr_DiaglibListner = potunmstr_DiaglibListner;
}

/*************************************************************************
* FUNCTION:     tunmstr_antdiag_Manager::vInitializeAntennaDiagTimer( )
*
* DESCRIPTION:  Start the all timer required for antenna diag.
*
* PARAMETER:    -
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vInitializeAntennaDiagTimer(  )
{
	ETG_TRACE_USR4(("entered into vInitializeAntennaDiagTimer"));
	//Start the timer only if the Timer is not started
	if(m_blTimerActive==FALSE)
	{
      tunmstr_antdiag_Manager::vSetMonitorCycleTimer((tU32)m_u32MointorTime);
		m_blTimerActive =TRUE;
	}
}
/*************************************************************************
* FUNCTION:     tunmstr_antdiag_Manager::vResetAntennaDiagTimers( )
*
* DESCRIPTION:  Reset all the timers
*
* PARAMETER:    -
*
* RETURNVALUE:  void
*************************************************************************/

tVoid tunmstr_antdiag_Manager::vResetAntennaDiagTimers( )
{
	ETG_TRACE_USR1(("entered into vResetAntennaDiagTimers"));
	if(m_blTimerActive==TRUE)
	{
      tunmstr_antdiag_Manager::vSetMonitorCycleTimer(0);
		m_blTimerActive=FALSE;
	}
}
/*************************************************************************
 * FUNCTION:     tunmstr_antdiag_Manager::vSetMonitorCycleTimer( )
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vSetMonitorCycleTimer( tU32 u32MsTimeout)
{
	//Timer active
   ETG_TRACE_USR4(("vSetMonitorCycleTimer() m_hTxTimerTunMstr_1secTimer=%d"
		"u32MsTimeout=%d",
            m_hTxTimerTunMstr_1secTimer, u32MsTimeout
		));
	(tVoid)OSAL_s32TimerSetTime( m_hTxTimerTunMstr_1secTimer,u32MsTimeout , 0 );
}
/*************************************************************************
 * FUNCTION:     tunmstr_antdiag_Manager::vOnMonitorCycleTimerExpiry( )
 *************************************************************************/
OSAL_tpfCallback tunmstr_antdiag_Manager::vOnMonitorCycleTimerExpiry( tVoid* pArg )
{
   ETG_TRACE_USR4(("vOnMonitorCycleTimerExpiry() TID = %i",OSAL_ThreadWhoAmI()));
	tunmstr_antdiag_Manager*   potunmstr_antdiag_Manager;
	potunmstr_antdiag_Manager = (tunmstr_antdiag_Manager*) pArg;
   potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_MONITORCYCLE_TIMER_EXPIRY);
   return 0;
}// end of function vOnMonitorCycleTimerExpiry
tVoid tunmstr_antdiag_Manager::vHandleMonitorCycleTimerExpiry()
{
   ETG_TRACE_USR4(("vHandleMonitorCycleTimerExpiry() TID = %i",OSAL_ThreadWhoAmI()));
	/*Fix for JIRA issue SUZUKI-17229*/
	//potunmstr_antdiag_Manager->vReadUbatterVg();
	for(tU8 enAntDiagClient=enFM1;enAntDiagClient<enClientNone; enAntDiagClient++)
	{
      ETG_TRACE_USR1(("************************Start reading %02x Antenna Current************************"
               ,ETG_CENUM(tenAntDiagClients,enAntDiagClient)));
      vReadCurrent((tenAntDiagClients)enAntDiagClient);
      ETG_TRACE_USR1(("************************End of reading %02x Antenna Current************************"
               ,ETG_CENUM(tenAntDiagClients,enAntDiagClient)));
	}
   vSetMonitorCycleTimer((tU32)m_u32MointorTime );
   if(nullptr != m_potunmstr__DiagLog)
   {
      m_potunmstr__DiagLog->vValidateIgnitionState();
   }
}// end of function VGetTxTimeout_For1SecTimer
/*************************************************************************
* FUNCTION:     tunmstr_antdiag_Manager::VGetTxTimeout_For200mSecTimer( )
*************************************************************************/
OSAL_tpfCallback tunmstr_antdiag_Manager::VGetTxTimeout_For200mSecTimer( tVoid* pArg )
{
   ETG_TRACE_USR4(("VGetTxTimeout_For200mSecTimer() TID = %i",OSAL_ThreadWhoAmI()));
tunmstr_antdiag_Manager*   potunmstr_antdiag_Manager;
potunmstr_antdiag_Manager = (tunmstr_antdiag_Manager*) pArg;
   potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_200MS_TIMER_EXPIRY);
   return 0;
}// end of function vOnMonitorCycleTimerExpiry
/*************************************************************************
 * FUNCTION:     tunmstr_antdiag_Manager::VSetTxTimeOut_For200mSecTimer( )
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::VSetTxTimeOut_For200mSecTimer( tU32 u32MsTimeout)
{
   //Timer active
   tS32 ret = OSAL_s32TimerSetTime( m_hTxTimerTunMstr_200msecTimer,u32MsTimeout , 0 );
   ETG_TRACE_USR4(("VSetTxTimeOut_For200mSecTimer() m_hTxTimerTunMstr_200msecTimer=%d ret=%d"
            "u32MsTimeout=%d",
            m_hTxTimerTunMstr_200msecTimer,ret,u32MsTimeout
   ));

}
tVoid tunmstr_antdiag_Manager::vHandle200msTimerExpiry()
{
   //ETG_TRACE_USR4(("vHandle200msTimerExpiry() TID = %i",OSAL_ThreadWhoAmI()));
   ETG_TRACE_USR4(("vHandle200msTimerExpiry()"));
   if((nullptr == m_potunmstr_antdiag_i2cHandler) || (nullptr == m_potunmstr_antdiag_Debounce))
   {
      return;
   }
   if(ISUPDATE_ELMOS_1_SHORTREGISTER(m_u8ElmosUpdateOverCurrentRegiser))
   {
      for(tU8 enCMExtPowerSupplyType=enELMOS1_1;enCMExtPowerSupplyType<=enELMOS1_2;enCMExtPowerSupplyType++)
      {
         m_potunmstr_antdiag_i2cHandler->vWriteOverCurrentReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType,
                                                              m_potunmstr_antdiag_Debounce->u8GetShortCurrent
                                                              (enGetAntDiagClient((tenCMExtPowerSupplyType)enCMExtPowerSupplyType)));
         m_u8ElmosUpdateOverCurrentRegiser = m_u8ElmosUpdateOverCurrentRegiser & 0xfe;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
         m_potunmstr_antdiag_i2cHandler->vWriteSupplyOverVoltageReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
#endif

	}
}
   if(ISUPDATE_ELMOS_2_SHORTREGISTER(m_u8ElmosUpdateOverCurrentRegiser))
{
	for(tU8 enCMExtPowerSupplyType=enELMOS2_1;enCMExtPowerSupplyType<=enELMOS2_2;enCMExtPowerSupplyType++)
	{
         m_potunmstr_antdiag_i2cHandler->vWriteOverCurrentReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType,
                                                              m_potunmstr_antdiag_Debounce->u8GetShortCurrent
                                                              (enGetAntDiagClient((tenCMExtPowerSupplyType)enCMExtPowerSupplyType)));
         m_u8ElmosUpdateOverCurrentRegiser= m_u8ElmosUpdateOverCurrentRegiser & 0xfd;
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
         m_potunmstr_antdiag_i2cHandler->vWriteSupplyOverVoltageReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
		#endif
	}
}
   if(ISUPDATE_ELMOS_3_SHORTREGISTER(m_u8ElmosUpdateOverCurrentRegiser))
{
	for(tU8 enCMExtPowerSupplyType=enELMOS3_1;enCMExtPowerSupplyType<=enELMOS3_2;enCMExtPowerSupplyType++)
	{
         m_potunmstr_antdiag_i2cHandler->vWriteOverCurrentReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType,
                                                              m_potunmstr_antdiag_Debounce->u8GetShortCurrent
                                                              (enGetAntDiagClient((tenCMExtPowerSupplyType)enCMExtPowerSupplyType)));
         m_u8ElmosUpdateOverCurrentRegiser= m_u8ElmosUpdateOverCurrentRegiser & 0xfb;
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
         m_potunmstr_antdiag_i2cHandler->vWriteSupplyOverVoltageReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
		#endif
	}
}
   if(ISUPDATE_ELMOS_4_SHORTREGISTER(m_u8ElmosUpdateOverCurrentRegiser))
{
	for(tU8 enCMExtPowerSupplyType=enELMOS4_1;enCMExtPowerSupplyType<=enELMOS4_2;enCMExtPowerSupplyType++)
	{
         m_potunmstr_antdiag_i2cHandler->vWriteOverCurrentReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType,
                                                              m_potunmstr_antdiag_Debounce->u8GetShortCurrent
                                                              (enGetAntDiagClient((tenCMExtPowerSupplyType)enCMExtPowerSupplyType)));
         m_u8ElmosUpdateOverCurrentRegiser= m_u8ElmosUpdateOverCurrentRegiser & 0xf7;
	}
}
//Stop Timer
VSetTxTimeOut_For200mSecTimer(0);
   vInitializeAntennaDiagTimer();
}
tenAntDiagClients tunmstr_antdiag_Manager::enGetAntDaigClientInx(tenAntDiagKDS enAntDiagKDS)
{
	switch((tU8)enAntDiagKDS)
	{
		case enkdsFM1:
		case enkdsFM2:
		case enkdsDAB1:
		{
			return (tenAntDiagClients)enAntDiagKDS;
			break;
		}
		case enkdsDAB2:
		{
			return enDAB2;
			break;
		}
		case enkdsGPS:
		case enkdsDTV1:
		case enkdsDTV2:
		case enkdsDTV3:
		case enkdsDTV4:
		{
			return (tenAntDiagClients)(enAntDiagKDS-1);
			break;
		}
		default:
			return enClientNone;
			break;
	}
	return enClientNone;
}
/*************************************************************************
 * FUNCTION:    vReadKDSAntennaParameterSet()
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vReadKDSAntennaParameterSet(tunerVector<tU8> &AntennaPar)
{
   ETG_TRACE_USR4(("vReadKDSAntennaParameterSet() TID = %i",OSAL_ThreadWhoAmI()));
	ETG_TRACE_USR1(("ANTDIAG::KDSREAD "));
	if((NULL==m_poclConfigInterface)||(NULL==m_potunmstr_antdiag_Debounce)||(NULL==m_potunmstr__DiagLog))
	{
		return;
	}
	m_u8AntennaKDSReadRet = m_poclConfigInterface->vReadAntennaParameter(AntennaPar);
	ETG_TRACE_USR1(("ANTDIAG::KDS vReadAntennaParameter Return=%d",m_u8AntennaKDSReadRet));
	ETG_TRACE_USR1(("ANTDIAG::KDS vReadAntennaParameter KDS Size=%d",AntennaPar.size()));
	if((m_u8AntennaKDSReadRet) && ((AntennaPar.size()== (enAntennaParameter_idx_end+1)) ||
			(AntennaPar.size()== (enAntennaParameter_idx_ResSec1_End+1))))
	{

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		tunerString sAntennaParTag = {""};
		sAntennaParTag.assign(AntennaPar.begin(),(AntennaPar.begin()+enAntennaParameter_idx_MajorVer));
		tSize s32found = sAntennaParTag.find("b");
		if(s32found!=std::string::npos)
		{
			m_blA2S1Bsample = true;
			ETG_TRACE_USR1(("ANTDIAG::KDS AIVI2 B samble"));
		}
#endif
		m_u32MointorTime=(AntennaPar.at(enAntennaParameter_idx_FM1MonitorCycle))*100;
		ETG_TRACE_USR1(("ANTDIAG::KDS MointorTime=%d",m_u32MointorTime));

		for(tU16 u16KDSindex= (tU8)enAntennaParameter_idx_FM1AntennaType;u16KDSindex<=(tU8)enAntennaParameter_idx_DTV4AntennaType;)
		{
			for(tU8 u8index=(tU8)enkdsFM1;u8index<enkdsNone;u8index++)
			{
				tU8 u8AntDaigClientInx= enGetAntDaigClientInx((tenAntDiagKDS)u8index);
				if(u16KDSindex < AntennaPar.size())
				{
					m_enAntennaTyp[u8AntDaigClientInx]=(tenAntennaType)(AntennaPar.at(u16KDSindex));
					ETG_TRACE_USR1(("ANTDIAG::KDS %02x Antenna type is %02x u16KDSindex=%d",
							ETG_CENUM(tenAntDiagClients,u8AntDaigClientInx),ETG_CENUM(tenAntennaType,m_enAntennaTyp[u8AntDaigClientInx]),u16KDSindex));
					u16KDSindex=(tU16)(u16KDSindex+TUNMSTR_ANTDIAG_DIFFERENCE_BTW_ANT_CLIENT_INDEX);
				}
				else
				{
					ETG_TRACE_USR1(("ANTDIAG::KDS Trying to access out_of_range KDS element"));
					return;
				}
			}
		}
		vReadKDSAntennaParameter_ConsiderCriticalHg_Vg(AntennaPar);
		m_potunmstr_antdiag_Debounce->vUpdateAntennaParam_FromKDS(AntennaPar);
		m_potunmstr__DiagLog->vUpdateAntennaParam_FromKDS(AntennaPar);
		vReadExtAntennaSupplyTypeFromKDS();
		vHandleKDSAntennaData();
	}
	else
	{
		ETG_TRACE_USR1(("ANTDIAG::KDS Read error"));
	}
}
/*************************************************************************
* FUNCTION:    vReadKDSAntennaParameter_ConsiderCriticalHg_Vg()
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vReadKDSAntennaParameter_ConsiderCriticalHg_Vg(tunerVector<tU8> &KDSParam)
{
		for(tU16 u16KDSindex=(tU8)enAntennaParameter_idx_FM1ConsiderCriticalHg_Vg;u16KDSindex<=enAntennaParameter_idx_DTV4ConsiderCriticalHg_Vg;)
		{
			for(tU8 u8index=(tU8)enkdsFM1;u8index<enkdsNone;u8index++)
			{
				tU8 u8AntDaigClientInx= enGetAntDaigClientInx((tenAntDiagKDS)u8index);
				m_blConsider_CriticalHgVg[u8AntDaigClientInx]= FALSE;
				if(u16KDSindex < KDSParam.size())
				{
					if(KDSParam.at(u16KDSindex) ==TRUE)
					{
						m_blConsider_CriticalHgVg[u8AntDaigClientInx]=TRUE;
					}
					ETG_TRACE_USR4(("ANTDIAG::KDS Consider_CriticalHgVg for %02x = %02x u16KDSindex=%d",
						ETG_CENUM(tenAntDiagClients,u8AntDaigClientInx),
						ETG_CENUM(tenTrueOrFalse,m_blConsider_CriticalHgVg[u8AntDaigClientInx]),u16KDSindex));
					u16KDSindex=(tU16)(u16KDSindex+TUNMSTR_ANTDIAG_DIFFERENCE_BTW_ANT_CLIENT_INDEX);
				}
				else
				{
					ETG_TRACE_USR1(("ANTDIAG::KDS Trying to access out_of_range KDS element"));
					return;
				}
			}
		}
}
/*************************************************************************
 * FUNCTION:    vReadExtAntennaSupplyTypeFromKDS()
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vReadExtAntennaSupplyTypeFromKDS()
{
	if(m_poclConfigInterface!=NULL)
	{
	tU8 u8ExtSupInfoBuffer[enClientNone] {enunknown};
	m_poclConfigInterface->vReadAntennaExtSupInfo(u8ExtSupInfoBuffer);
	m_enCMExtPowerSupply[enFM1]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enFM1]);
	m_enCMExtPowerSupply[enFM2]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enFM2]);
	m_enCMExtPowerSupply[enDAB1]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enDAB1] );
	m_enCMExtPowerSupply[enGPS]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enGPS]);
    m_enCMExtPowerSupply[enDTV1]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enDTV1]);
	m_enCMExtPowerSupply[enDTV2]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enDTV2]);
	m_enCMExtPowerSupply[enDTV3]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enDTV3]);
	m_enCMExtPowerSupply[enDTV4]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enDTV4]);
	m_enCMExtPowerSupply[enDAB2]=tenCMExtPowerSupplyType(u8ExtSupInfoBuffer[enDAB2]);
	ETG_TRACE_USR4(("ANTDIAG::KDS FM1PowersupplyType is %02x FM2PowersupplyType is %02x DAB1PowersupplyType is %02x GPSPowersupplyType is %02x ",
	ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enFM1]),ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enFM2]),
	ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enDAB1]),ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enGPS])));
	ETG_TRACE_USR4(("ANTDIAG::KDS DTV1PowersupplyType is %02x DTV2PowersupplyType is %02x DTV3PowersupplyType is %02x DTV4PowersupplyType is %02x",
	ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enDTV1]),ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enDTV2]),
	ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enDTV3]),ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enDTV4])));
	ETG_TRACE_USR4(("ANTDIAG::KDS DAB2PowersupplyType is %02x",ETG_CENUM(tenCMExtPowerSupplyType,m_enCMExtPowerSupply[enDAB2])));
	}
}
/*************************************************************************
 * FUNCTION:    vHandleKDSAntennaData()
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vHandleKDSAntennaData()
{
	if(NULL== m_poclConfigInterface)
	{
		NORMAL_M_ASSERT (m_poclConfigInterface != NULL);
		return;
	}

    	for(tU8 u8index=(tU8)enFM1;u8index<(tU8)enClientNone;u8index++)
		{
    		tBool blSetExtPowerSupply= false;
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		//Read Antenna type from EOL config
			if(
			( (enFM1==u8index) && (enEOLAntenna_Passive==m_poclConfigInterface->u32GetConfigData("RADIOAntennaAMFM1Type"))) ||
			( (enFM2==u8index) && (enEOLAntenna_Passive==m_poclConfigInterface->u32GetConfigData("RADIOAntennaFM2Type"))))
			{
				vUpdateAntenaaStatetoHMI(u8index,enAntennState_Passive,TUNMSTR_ANTDIAG_ZERO_FLOAT);
				continue;
			}
		#endif
			if((m_enAntennaTyp[u8index]==enNone)|| (m_enAntennaTyp[u8index]==enPassive))
			{
				ETG_TRACE_USR4(("vHandleKDSAntennaData()->Power supply type of Client %02x is not enabled, since antenna type= %02x",
					ETG_CENUM(tenAntDiagClients,u8index),
					ETG_CENUM(tenAntennaType,m_enAntennaTyp[u8index])));
				vUpdateAntenaaStatetoHMI(u8index,u8ConvertAntTypeNonePassiveToU8AntennaStatus(m_enAntennaTyp[u8index]),TUNMSTR_ANTDIAG_ZERO_FLOAT);
			}
			else
			 {
				if(enunknown!=m_enCMExtPowerSupply[u8index])
				{
					if((enDAB1==u8index) && (!m_poclConfigInterface->u32GetConfigData("DABSupported")))
					{
					}
					else
					{
						blSetExtPowerSupply = true;
					}
					//vSetExtPowerSupply(m_enCMExtPowerSupply[u8index],TRUE);
				}
			 }
			if(((m_enCMExtPowerSupply[u8index])>enELMOS4_2) && (m_u8AntennaKDSReadRet != (tU8)enAntennaKDSRead_NewParamSuc))
			{
				blSetExtPowerSupply = false;
			}
			vSetExtPowerSupply(m_enCMExtPowerSupply[u8index],blSetExtPowerSupply);
		}
}
/*************************************************************************
 * FUNCTION:    u8ConvertAntTypeNonePassiveToU8AntennaStatus()
 *************************************************************************/
tU8 tunmstr_antdiag_Manager::u8ConvertAntTypeNonePassiveToU8AntennaStatus(tenAntennaType enAntennaType)
{
	if(enAntennaType == enNone)
	{
		return enAntennState_Unknown;
	}
	else if(enAntennaType == enPassive)
	{
		return enAntennState_Passive;
	}
	else
	{
		return enAntennState_Unknown;
	}
}
/*************************************************************************
 * FUNCTION:    vSetExtPowerSupply()
 * 				To be used only for updating KDS parameter
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vSetExtPowerSupply
(tenCMExtPowerSupplyType enCMExtPowerSupplyType, tBool blSet)
{
    switch(enCMExtPowerSupplyType)
    {
        case enELMOS1_1:
        {
            m_blELMOS1_1_IC=blSet;
            break;
        }
        case enELMOS1_2:
        {
            m_blELMOS1_2_IC=blSet;
            break;
        }
        case enELMOS2_1:
        {
            m_blELMOS2_1_IC=blSet;
            break;
        }
        case enELMOS2_2:
        {
            m_blELMOS2_2_IC=blSet;
            break;
        }
        case enInfineonTLF4277_1:
        {
            m_blnfineon_IC=blSet;
            break;
        }
        case enMAXIM_16946:
        {
            m_blMax_IC=blSet;
            break;
        }
        case enInfineonTLF4277_2:
        {
            m_blnfineon_IC2=blSet;
            break;
        }
        case enELMOS3_1:
        {
            m_blELMOS3_1_IC=blSet;
            break;
        }
        case enELMOS3_2:
        {
            m_blELMOS3_2_IC=blSet;
            break;
        }
       case enELMOS4_1:
        {
            m_blELMOS4_1_IC=blSet;
            break;
        }
        case enELMOS4_2:
        {
            m_blELMOS4_2_IC=blSet;
            break;
        }
        case enMAX20084_1_1:
        {
        	m_blMAX20084_1_1_IC = blSet;
        	break;
        }
        case enMAX20084_1_2:
        {
        	m_blMAX20084_1_2_IC = blSet;
        	break;
        }
        case enMAX20084_2_1:
        {
        	m_blMAX20084_2_1_IC = blSet;
        	break;
        }
        case enMAX20084_2_2:
        {
        	m_blMAX20084_2_2_IC = blSet;
        	break;
        }
        case enMAX20084_3_1:
        {
        	m_blMAX20084_3_1_IC = blSet;
        	break;
        }
        case enMAX20084_3_2:
        {
        	m_blMAX20084_3_2_IC = blSet;
        	break;
        }
        case enTPS7B7701_1:
        {
        	m_blTPS7B7701_1_IC = blSet;
        	break;
        }
        case enTPS7B7702_1_1:
        {
        	m_blTPS7B7702_1_1_IC = blSet;
        	break;
        }
        case enTPS7B7702_1_2:
        {
        	m_blTPS7B7702_1_2_IC = blSet;
        	break;
        }
        default:
        {
            break;
        }
    }
}
/*************************************************************************
* FUNCTION:    vSetExtPwrSupEN_PinState
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vSetExtPwrSupEN_PinState
(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tBool blGPIOPinState)
{
	ETG_TRACE_USR4(("ANTDIAG:: Set the GPIO Pin =%02x state =%02x",
		ETG_CENUM(tenCMExtPowerSupplyType,enCMExtPowerSupplyType),
		ETG_CENUM(ten_GPIOPinState,blGPIOPinState)));
	switch(enCMExtPowerSupplyType)
	{
	case enInfineonTLF4277_1:
	{
		m_blnfineon_ENState=blGPIOPinState;
		break;
	}
	case enInfineonTLF4277_2:
	{
		m_blnfineon2_ENState=blGPIOPinState;
		break;
	}
	case enMAXIM_16946:
	{
		m_blMax_SHDNState=blGPIOPinState;
		break;
	}
	case enELMOS1_1:
	case enELMOS1_2:
	{
		m_blELMOS_EN1State=blGPIOPinState;
		break;
	}
	case enELMOS2_1:
	case enELMOS2_2:
	{
		m_blELMOS_EN2State=blGPIOPinState;
		break;
	}
	case enELMOS3_1:
	case enELMOS3_2:
	{
		m_blELMOS_EN3State=blGPIOPinState;
		break;
	}
	case enELMOS4_1:
	case enELMOS4_2:
	{
		m_blELMOS_EN4State=blGPIOPinState;
		break;
	}
	case enMAX20084_1_1:
	case enMAX20084_1_2:
	{
		m_blMax20084_1_ENState = blGPIOPinState;
		break;
	}
	case enMAX20084_2_1:
	case enMAX20084_2_2:
	{
		m_blMax20084_2_ENState = blGPIOPinState;
		break;
	}
	case enMAX20084_3_1:
	case enMAX20084_3_2:
	{
		m_blMax20084_3_ENState = blGPIOPinState;
		break;
	}
    case enTPS7B7701_1:
    {
    	m_blTPS7B7701_1_ENState = blGPIOPinState;
    	break;
    }
    case enTPS7B7702_1_1:
    {
    	m_blTPS7B7702_1_EN1State = blGPIOPinState;
    	break;
    }
    case enTPS7B7702_1_2:
    {
    	m_blTPS7B7702_1_EN2State = blGPIOPinState;
    	break;
    }
	default:
		{
			break;
		}
	}
}
/*************************************************************************
* FUNCTION:    vSetPendingAntennaStateReqClient()
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vSetPendingAntennaStateReqClient(tU8 u8WhichClient)
{
	ETG_TRACE_USR4(("vSetPendingAntennaStateReqClient()-> client = %02x",
			ETG_CENUM(tenAntDiagClients,u8WhichClient)));
   std::lock_guard<std::mutex> lock(m_ReadAntStateRegLock);
		m_u8PendingStateReqClient=u8WhichClient;
}
/*************************************************************************
* FUNCTION:    vUpdateAntenaaStatetoHMI()
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vUpdateAntenaaStatetoHMI(tU8 u8Client, tU8 u8AntennaStatus, tFloat fCurrent)
{
	if(NULL!=m_potunmstr_MsgToHMI)
        {
			m_potunmstr_MsgToHMI->vSend_g_RFAntennaTest(u8Client,u8AntennaStatus,fCurrent);
		}
}
/*************************************************************************
* FUNCTION:    enGetExtPowerSupplyType
*************************************************************************/
tenCMExtPowerSupplyType tunmstr_antdiag_Manager::enGetExtPowerSupplyType
(tenAntDiagClients enAntDiagClients)const
{
	if(enAntDiagClients>=enClientNone)
	{
		return enunknown;
	}
	/*ETG_TRACE_USR4(("enGetExtPowerSupplyType()-> m_enCMExtPowerSupply[%06x] = %06x",
		ETG_CENUM(tenAntDiagClients, enAntDiagClients),ETG_CENUM(tenCMExtPowerSupplyType, m_enCMExtPowerSupply[enAntDiagClients])));*/
	return m_enCMExtPowerSupply[enAntDiagClients];
}
/*************************************************************************
* FUNCTION:    enGetAntDiagClient
*************************************************************************/
tenAntDiagClients tunmstr_antdiag_Manager::enGetAntDiagClient
(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const
{
	tenAntDiagClients enAntDiagClient=enClientNone;
	for(tU8 u8Index=(tU8)enFM1;u8Index<(tU8)enClientNone;u8Index++)
	{
		if(enCMExtPowerSupplyType==enGetExtPowerSupplyType((tenAntDiagClients)u8Index))
		{
			/*ETG_TRACE_USR4(("enGetAntDiagClient()-> =%02x client is =%02x",
			ETG_CENUM(tenCMExtPowerSupplyType,enCMExtPowerSupplyType),
			ETG_CENUM(tenAntDiagClients,u8Index)));*/
			return (tenAntDiagClients)u8Index;
		}
	}
	return enAntDiagClient;
}
/*************************************************************************
 * FUNCTION:    blIsExtSup_Supports()
 *************************************************************************/
tBool tunmstr_antdiag_Manager::blIsExtSup_Supports
(tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	tBool blRet=FALSE;
	switch(enCMExtPowerSupplyType)
	{
	case enInfineonTLF4277_1:
		{
			blRet=m_blnfineon_IC;
			break;
		}
	case enInfineonTLF4277_2:
	{
		blRet=m_blnfineon_IC2;
		break;
	}
	case enMAXIM_16946:
		{
			blRet=m_blMax_IC;
			break;
		}
	case enELMOS1_1:
		{
			blRet=m_blELMOS1_1_IC;
			break;
		}
	case enELMOS1_2:
		{
			blRet=m_blELMOS1_2_IC;
			break;
		}
    case enELMOS2_1:
        {
            blRet=m_blELMOS2_1_IC;
            break;
        }
    case enELMOS2_2:
        {
            blRet=m_blELMOS2_2_IC;
            break;
        }
    case enELMOS3_1:
    {
    	blRet=m_blELMOS3_1_IC;
    	break;
    }
    case enELMOS3_2:
    {
    	blRet=m_blELMOS3_2_IC;
    	break;
    }
    case enELMOS4_1:
    {
    	blRet=m_blELMOS4_1_IC;
    	break;
    }
    case enELMOS4_2:
    {
    	blRet=m_blELMOS4_2_IC;
    	break;
    }
    case enMAX20084_1_1:
    {
    	blRet=m_blMAX20084_1_1_IC;
    	break;
    }
    case enMAX20084_1_2:
    {
    	blRet=m_blMAX20084_1_2_IC;
    	break;
    }
    case enMAX20084_2_1:
    {
    	blRet=m_blMAX20084_2_1_IC;
    	break;
    }
    case enMAX20084_2_2:
    {
    	blRet=m_blMAX20084_2_2_IC;
    	break;
    }
    case enMAX20084_3_1:
    {
    	blRet=m_blMAX20084_3_1_IC;
    	break;
    }
    case enMAX20084_3_2:
    {
    	blRet=m_blMAX20084_3_2_IC;
    	break;
    }
    case enTPS7B7701_1:
    {
    	blRet=m_blTPS7B7701_1_IC;
    	break;
    }
    case enTPS7B7702_1_1:
    {
    	blRet=m_blTPS7B7702_1_1_IC;
    	break;
    }
    case enTPS7B7702_1_2:
    {
    	blRet=m_blTPS7B7702_1_2_IC;
    	break;
    }
	default:
		{
			break;
		}
	}
	ETG_TRACE_USR4(("blIsExtSup_Supports()-> =%02x =%02x",
	ETG_CENUM(tenCMExtPowerSupplyType,enCMExtPowerSupplyType),
	ETG_CENUM(tenTrueOrFalse,blRet)));
	return blRet;
}
/*************************************************************************
* FUNCTION:    u8GetAntennatype
*************************************************************************/
tU8 tunmstr_antdiag_Manager::u8GetAntennatype(tU8 u8Client)const
{
	if(u8Client>=enClientNone)
	{
		return (tU8)enNone;
	}
	else
	{
		/*ETG_TRACE_USR4(("u8GetAntennatype()-> =%02x antenna type is =%02x",
		ETG_CENUM(tenAntDiagClients,u8Client),ETG_CENUM(tenAntennaType,m_enAntennaTyp[u8Client])));*/
		return (tU8)m_enAntennaTyp[u8Client];
	}
}
/*************************************************************************
* FUNCTION:    blGetExtPwrSupEN_PinState
*************************************************************************/
tBool tunmstr_antdiag_Manager::blGetExtPwrSupEN_PinState
(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const
{
	tBool blRet=FALSE;
	if(m_potunmstr_antdiag_i2cHandler==NULL)
	{
		return blRet;
	}
	switch(enCMExtPowerSupplyType)
	{
	case enInfineonTLF4277_1:
		{
			blRet=m_blnfineon_ENState;
			break;
		}
	case enInfineonTLF4277_2:
	{
		blRet=m_blnfineon2_ENState;
		break;
	}
	case enMAXIM_16946:
		{
			blRet=m_blMax_SHDNState;
			break;
		}
	case enELMOS1_1:
    case enELMOS1_2:
		{
			if(m_blELMOS_EN1State)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			};
			break;
		}
	case enELMOS2_1:
    case enELMOS2_2:
		{
			if(m_blELMOS_EN2State)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			}
			break;
		}
	case enELMOS3_1:
    case enELMOS3_2:
		{
			if(m_blELMOS_EN3State)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			}
			break;
		}
	case enELMOS4_1:
    case enELMOS4_2:
		{
			if(m_blELMOS_EN4State)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			}
			break;
		}
	case enMAX20084_1_1:
    case enMAX20084_1_2:
		{
			if(m_blMax20084_1_ENState)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			}
			break;
		}
	case enMAX20084_2_1:
    case enMAX20084_2_2:
		{
			if(m_blMax20084_2_ENState)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			}
			break;
		}
	case enMAX20084_3_1:
    case enMAX20084_3_2:
		{
			if(m_blMax20084_3_ENState)
			{
				blRet=m_potunmstr_antdiag_i2cHandler->IsOutputPinIsEnabled(enCMExtPowerSupplyType);
			}
			break;
		}
    case enTPS7B7701_1:
    {
    	blRet=m_blTPS7B7701_1_ENState;
    	break;
    }
    case enTPS7B7702_1_1:
    {
    	blRet=m_blTPS7B7702_1_EN1State;
    	break;
    }
    case enTPS7B7702_1_2:
    {
    	blRet=m_blTPS7B7702_1_EN2State;
    	break;
    }
	default:
		{
			break;
		}
	}
	ETG_TRACE_USR4(("blGetExtPwrSupEN_PinState()-> =%02x Pin state =%d",
		ETG_CENUM(tenCMExtPowerSupplyType,enCMExtPowerSupplyType),
		ETG_CENUM(tenTrueOrFalse,blRet)));
	return blRet;
}
/*************************************************************************
* FUNCTION:    enGetOSALGPIOPinName
*************************************************************************/
OSAL_enGpioPins tunmstr_antdiag_Manager::enGetOSALGPIOPinName
(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const
{
	OSAL_enGpioPins enGpio=(OSAL_enGpioPins)0;
	switch(enCMExtPowerSupplyType)
	{
		case enInfineonTLF4277_1:
		{
			enGpio= OSAL_EN_TLF4277_EN;
			break;
		}
		case enInfineonTLF4277_2:
		{
			enGpio= OSAL_EN_TLF4277_EN_2;
			break;
		}
		case enMAXIM_16946:
		{
			enGpio= OSAL_EN_MAX16946_SHDN;
			break;
		}
		case enELMOS1_1:
		case enELMOS1_2:
		{
			enGpio= OSAL_EN_ELMOS52240_EN_1;
			break;
		}
		case enELMOS2_1:
		case enELMOS2_2:
		{
			enGpio= OSAL_EN_ELMOS52240_EN_2;
			break;
		}
		case enMAX20084_2_1:
		case enMAX20084_2_2:
		{
			enGpio= OSAL_EN_MAX20084_EN_1;
			break;
		}
		case enMAX20084_1_1:
		case enMAX20084_1_2:
		case enMAX20084_3_1:
		case enMAX20084_3_2:
		{
			/*AIVI2 Max ic_2 nd ic_3 is used for DTV. In case of DTV, EN pin is connected to FPGA instead of GPIO */
			break;
		}
		case enTPS7B7701_1:
		{
			/*AIVI2 Device with TPS7B7701 IC still not yet availabel for testing*/
			//enGpio= OSAL_EN_TPS7B7701_EN_1;
			break;
		}
		case enTPS7B7702_1_1:
		{
			enGpio= OSAL_EN_TPS7B7702_EN_1;
			break;
		}
		case enTPS7B7702_1_2:
		{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
/*In AIVI2 B samble device, TPS7B7702 IC EN1 and EN2 pins are connected each others*/
			if(m_blA2S1Bsample)
			enGpio= OSAL_EN_TPS7B7702_EN_1;
			else
			enGpio = OSAL_EN_TPS7B7702_EN_2;
#endif
			break;
		}
		default:
		{
			break;
		}
	}
	return enGpio;
}
/*************************************************************************
* FUNCTION:     u8GetPendingAntennaStateReqClient()
*************************************************************************/
tU8 tunmstr_antdiag_Manager::u8GetPendingAntennaStateReqClient()
{
   std::lock_guard<std::mutex> lock(m_ReadAntStateRegLock);
	ETG_TRACE_USR4(("u8PendingStateReqClient()-->m_u8PendingStateReqClient=%d",m_u8PendingStateReqClient));
	return m_u8PendingStateReqClient;
}
/*************************************************************************
* FUNCTION:     tunmstr_antdiag_Manager::vOnNewAppState
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vOnNewAppState(tU32 u32NewAppState)
{
   ETG_TRACE_USR1(("vOnNewAppState()->NewAppState= %d",u32NewAppState));
    switch(u32NewAppState)
	{
	case AMT_C_U32_STATE_NORMAL:
		{
			if(!m_blAntennaDiagState)
			{
				vHandleAntennaSwitching(TRUE);
				m_blAntennaDiagState=TRUE;
			}
			break;
		}
	case AMT_C_U32_STATE_OFF:
		{
			if(m_blAntennaDiagState)
			{
				vHandleAntennaSwitching(FALSE);
				m_blAntennaDiagState=FALSE;
			}
			break;
		}
	default:
		{
			break;
		}
	}
}
/*************************************************************************
* FUNCTION:    vHandleAntennaSwitching
*
* DESCRIPTION: This function will handle antenna switching
*
* PARAMETER:   tBool blOnorOff
*
* RETURNVALUE:  tVoid
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vHandleAntennaSwitching(tBool blOnorOff)
{
	ETG_TRACE_USR1(("vHandleAntennaSwitching()"));
	tunerVector<tU8> AntennaPar;
	AntennaPar.clear();
	vReadKDSAntennaParameterSet(AntennaPar);
	if(blOnorOff)
	{
		vTurnOnExtPowerSupply();
	}
	else
	{
		vResetAntennaDiagTimers();
		vTurnOffExtPowerSupply();
	}
}
/*************************************************************************
* FUNCTION:    vTurnOnExtPowerSupply
*
* DESCRIPTION: Function to turn on Different external Power supply
*
* PARAMETER:   tVoid
*
* RETURNVALUE:  tVoid
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vTurnOnExtPowerSupply()
{
	if(NULL==m_potunmstr_antdiag_Measure)
	{
		return;
	}
	for(tU8 enCMExtPowerSupplyType=enELMOS1_1; enCMExtPowerSupplyType<=enTPS7B7702_1_2; enCMExtPowerSupplyType++)
	{
		if(blIsExtSup_Supports((tenCMExtPowerSupplyType)enCMExtPowerSupplyType))
		{
			switch(enCMExtPowerSupplyType)
			{
			case enInfineonTLF4277_1:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn on Infineon_IC"));
					m_blnfineon_ENState=blTurnOnGPIOPin(OSAL_EN_TLF4277_EN);
					m_potunmstr_antdiag_Measure->vOpenlnfineonADCChannel();
					break;
				}
			case enInfineonTLF4277_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn on Infineon2_IC"));
					m_blnfineon2_ENState=blTurnOnGPIOPin(OSAL_EN_TLF4277_EN_2);
					m_potunmstr_antdiag_Measure->vOpenlnfineon2ADCChannel();
					break;
				}
			case enMAXIM_16946:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn on Max_IC"));
					m_blMax_SHDNState=blTurnOnGPIOPin(OSAL_EN_MAX16946_SHDN);
					m_potunmstr_antdiag_Measure->vOpenMAXADCChannel();
					break;
				}
			case enELMOS1_1:
            case enELMOS1_2:
				{
					   m_blELMOS_EN1State=blTurnOnELMOSIC((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
					   m_u8ElmosUpdateOverCurrentRegiser |=TUNMSTR_ANTDIAG_ELMOS1_OVERCURRENTREGITER;
					break;
				}
			case enELMOS2_1:
            case enELMOS2_2:
				{
						m_blELMOS_EN2State=blTurnOnELMOSIC((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
						m_u8ElmosUpdateOverCurrentRegiser |=TUNMSTR_ANTDIAG_ELMOS2_OVERCURRENTREGITER;
					break;
				}
            case enELMOS3_1:
            case enELMOS3_2:
            {
            	m_blELMOS_EN3State=blTurnOnELMOSIC((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
            	m_u8ElmosUpdateOverCurrentRegiser|= TUNMSTR_ANTDIAG_ELMOS3_OVERCURRENTREGITER;
            	break;
            }
            case enELMOS4_1:
            case enELMOS4_2:
            {
            	m_blELMOS_EN4State=blTurnOnELMOSIC((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
            	m_u8ElmosUpdateOverCurrentRegiser|= TUNMSTR_ANTDIAG_ELMOS4_OVERCURRENTREGITER;
            	break;
            }
            case enMAX20084_1_1:
            case enMAX20084_1_2:
            case enMAX20084_2_1:
            case enMAX20084_2_2:
            case enMAX20084_3_1:
            case enMAX20084_3_2:
            {
            	blTurnOnMAX20084Antenna((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
            	break;
            }
    		case enTPS7B7701_1:
    		{
    			/*AIVI2 device with TPS7B7701 is not yet available for testing*/
				//m_blTPS7B7701_1_ENState = blTurnOnGPIOPin(OSAL_EN_TPS7B7701_EN_1);
    			break;
    		}
    		case enTPS7B7702_1_1:
    		{
    			m_blTPS7B7702_1_EN1State = blTurnOnGPIOPin(OSAL_EN_TPS7B7702_EN_1);
    			m_potunmstr_antdiag_Measure->vOpenTPS7B7702_1_1ADCChannel();
    			break;
    		}
    		case enTPS7B7702_1_2:
    		{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
    			if(m_blA2S1Bsample)
				{
    				m_blTPS7B7702_1_EN2State = blTurnOnGPIOPin(OSAL_EN_TPS7B7702_EN_1);
				}
				else
				{
					m_blTPS7B7702_1_EN2State = blTurnOnGPIOPin(OSAL_EN_TPS7B7702_EN_2);
				}
				m_potunmstr_antdiag_Measure->vOpenTPS7B7702_1_2ADCChannel();
#endif
    			break;
    		}
			default:
				{
					break;
				}
			}
      }
   }
			if(blStartTimer())
			{
				tunmstr_antdiag_Manager::VSetTxTimeOut_For200mSecTimer(200);
	}
}
tBool tunmstr_antdiag_Manager::blStartTimer()
{
	if((m_blnfineon_ENState)|| (m_blnfineon2_ENState) ||(m_blMax_SHDNState)||
			(m_blELMOS_EN1State)||(m_blELMOS_EN2State) ||(m_blELMOS_EN3State) || (m_blELMOS_EN4State) ||
			(m_blMax20084_1_ENState)|| (m_blMax20084_2_ENState) || (m_blMax20084_3_ENState)|| (m_blTPS7B7702_1_EN1State)||
			(m_blTPS7B7702_1_EN2State)||(m_blTPS7B7701_1_ENState))
	{
		return true;
	}
	return false;
}
/*************************************************************************
* FUNCTION:    blTurnOnGPIOPin
*
* DESCRIPTION: Fucntion to turn on GPIO Pin
*
* PARAMETER:   OSAL_enGpioPins enGPIOPin
*
* RETURNVALUE:  tVoid
*************************************************************************/
tBool tunmstr_antdiag_Manager::blTurnOnGPIOPin(OSAL_enGpioPins enGPIOPin)const
{
	tBool blRet=FALSE;
	if(enGPIOPin)
	{
		OSAL_tIODescriptor hDev;
		hDev = OSAL_IOOpen(OSAL_C_STRING_DEVICE_GPIO, OSAL_EN_READWRITE);
		if (hDev ==OSAL_ERROR)
		{
			ETG_TRACE_ERR(("ANTDIAG::Error in Opening OSAL GPIO IO devices with error=%d",(int)hDev));
			OSAL_s32IOClose(hDev);
			return blRet;
		}
		OSAL_tGPIODevID devID;
		devID	= (OSAL_tGPIODevID)enGPIOPin;
		OSAL_trGPIOData Data = {devID, TRUE};
		tS32 _s32OutPutErrorCode=OSAL_s32IOControl(hDev, OSAL_C_32_IOCTRL_GPIO_SET_ACTIVE_STATE , (intptr_t) &Data);
		if(OSAL_ERROR	!=_s32OutPutErrorCode)
		{
			ETG_TRACE_USR1(("ANTDIAG::GPIO =%02x pin is turned on",ETG_CENUM(OSAL_enGpioPins,enGPIOPin)));
			blRet=TRUE;
		}
		else
		{
			ETG_TRACE_USR1(("ANTDIAG::failed to turn on GPIO =%02x pin with ERROR=%u",ETG_CENUM(OSAL_enGpioPins,enGPIOPin),_s32OutPutErrorCode));
		}
		OSAL_s32IOClose(hDev);
	}
	return blRet;
}
/*************************************************************************
* FUNCTION:    blTurnOnELMOSIC()
*
* DESCRIPTION: function to turn on ELMOS EN pin during start up
//1.	Disable over current detection by writing 0xff into high current detection. 
//2.	Update the ELMOS status register to de-active the power supply for required client of ELMOS IC
//3.	Clear the auto latch bit by writing 0x00 into error register of ELMOS 
//4.    Turn on ELMOS IC
//4.	Wait for 200msec
//5.	Enable over current detection by writing short current value configured in KDS to high current register after the 200msec timer expire.
*************************************************************************/
tBool tunmstr_antdiag_Manager::blTurnOnELMOSIC(tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	tBool blRes=FALSE;
	if(NULL!=m_potunmstr_antdiag_i2cHandler)
	{
		switch(enCMExtPowerSupplyType)
		{
			case enELMOS1_1:
			case enELMOS1_2:
			{
				if(!m_blELMOS_EN1State)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS1_1,m_blELMOS1_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS1_2,m_blELMOS1_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseElmosRegisters(enCMExtPowerSupplyType);
					if(blTurnOnUsingGPIO(enCMExtPowerSupplyType))
					{
						blRes=blTurnOnGPIOPin(OSAL_EN_ELMOS52240_EN_1);
					}
					else
					{
						blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
					}
				}
				else
				{
					blRes =m_blELMOS_EN1State;
				}
				break;
			}
			case enELMOS2_1:
			case enELMOS2_2:
			{
				if(!m_blELMOS_EN2State)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS2_1,m_blELMOS2_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS2_2,m_blELMOS2_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseElmosRegisters(enCMExtPowerSupplyType);
					if(blTurnOnUsingGPIO(enCMExtPowerSupplyType))
					{
						blRes=blTurnOnGPIOPin(OSAL_EN_ELMOS52240_EN_2);
					}
					else
					{
						blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
					}
				}
				else
				{
					blRes =m_blELMOS_EN2State;
				}
				break;
			}
			case enELMOS3_1:
			case enELMOS3_2:
			{
				if(!m_blELMOS_EN3State)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS3_1,m_blELMOS3_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS3_2,m_blELMOS3_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseElmosRegisters(enCMExtPowerSupplyType);
					blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
						TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
				}
				else
				{
					blRes =m_blELMOS_EN3State;
				}
				break;
			}
			/*case enELMOS4_1:
			case enELMOS4_2:
			{
				if(!m_blELMOS_EN4State)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS4_1,m_blELMOS4_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enELMOS4_2,m_blELMOS4_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseElmosRegisters(enCMExtPowerSupplyType);
					blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
						TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
				}
				else
				{
					blRes =m_blELMOS_EN4State;
				}
				break;
			}*/
			default: break;
		}
		ETG_TRACE_USR4(("blTurnOnELMOSIC() result=%d",blRes));
	}
	return blRes;
}
/*************************************************************************
* FUNCTION:    vTurnOffExtPowerSupply
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vTurnOffExtPowerSupply()
{
	if((NULL==m_potunmstr_antdiag_Measure)|| (NULL==m_potunmstr_antdiag_i2cHandler))
	{
		return;
	}
	ETG_TRACE_USR1(("vTurnOffExtPowerSupply()"));
	for(tU8 u8ExtPowerSupply=enELMOS1_1; u8ExtPowerSupply<=enTPS7B7702_1_2; u8ExtPowerSupply++)
	{
		if(blIsExtSup_Supports((tenCMExtPowerSupplyType)u8ExtPowerSupply))
		{
			switch(u8ExtPowerSupply)
			{
				case enInfineonTLF4277_1:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off Infineon1 IC"));
					m_blnfineon_ENState=!blTurnOffGPIOPin(OSAL_EN_TLF4277_EN);
					m_potunmstr_antdiag_Measure->vCloselnfineonADCChannel();
					break;
				}
				case enInfineonTLF4277_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off Infineon2 IC"));
					m_blnfineon2_ENState=!blTurnOffGPIOPin(OSAL_EN_TLF4277_EN_2);
					m_potunmstr_antdiag_Measure->vCloselnfineon2ADCChannel();
					break;
				}
				case enMAXIM_16946:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off MAX IC"));
					m_blMax_SHDNState=!blTurnOffGPIOPin(OSAL_EN_MAX16946_SHDN);
					m_potunmstr_antdiag_Measure->vCloseMAXADCChannel();
					break;
				}
				case enELMOS1_1:
				case enELMOS1_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off ELMOS1 IC"));
					if(blTurnOnUsingGPIO((tenCMExtPowerSupplyType)u8ExtPowerSupply))
					{
						m_blELMOS_EN1State=!blTurnOffGPIOPin(OSAL_EN_ELMOS52240_EN_1);

					}
					else
					{
						m_blELMOS_EN1State=!(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
								TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
					}
					break;
				}
				case enELMOS2_1:
				case enELMOS2_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off ELMOS2 IC"));
					if(blTurnOnUsingGPIO((tenCMExtPowerSupplyType)u8ExtPowerSupply))
					{
						m_blELMOS_EN2State=!blTurnOffGPIOPin(OSAL_EN_ELMOS52240_EN_2);
					}
					else
					{
						m_blELMOS_EN2State=!(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
								TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
					}
					break;
				}
				case enELMOS3_1:
				case enELMOS3_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off ELMOS3 IC"));
					m_blELMOS_EN3State= !(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
					break;
				}
				case enMAX20084_1_1:
				case enMAX20084_1_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off Max20084_1 IC"));
					if(m_blMax20084_1_ENState)
					{
						m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled((tenCMExtPowerSupplyType)u8ExtPowerSupply,FALSE);
						m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output((tenCMExtPowerSupplyType)u8ExtPowerSupply);
					}
					if(blTurnOnUsingGPIO((tenCMExtPowerSupplyType)u8ExtPowerSupply))
					{
						//m_blMax20084_1_ENState=!blTurnOffGPIOPin(OSAL_EN_MAX20084_EN_2);// DTV uses FPGA

					}
					else
					{
						m_blMax20084_1_ENState=!(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
								TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
					}
					break;
				}
				case enMAX20084_2_1:
				case enMAX20084_2_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off Max20084_2 IC"));
					if(m_blMax20084_2_ENState)
					{
						m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled((tenCMExtPowerSupplyType)u8ExtPowerSupply,FALSE);
						m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output((tenCMExtPowerSupplyType)u8ExtPowerSupply);
					}
					if(blTurnOnUsingGPIO((tenCMExtPowerSupplyType)u8ExtPowerSupply))
					{
						m_blMax20084_2_ENState=!blTurnOffGPIOPin(OSAL_EN_MAX20084_EN_1);

					}
					else
					{
						m_blMax20084_2_ENState=!(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
								TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
					}
					break;
				}
				case enMAX20084_3_1:
				case enMAX20084_3_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off Max20084_3 IC"));
					if(m_blMax20084_3_ENState)
					{
						m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled((tenCMExtPowerSupplyType)u8ExtPowerSupply,FALSE);
						m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output((tenCMExtPowerSupplyType)u8ExtPowerSupply);
					}
					if(blTurnOnUsingGPIO((tenCMExtPowerSupplyType)u8ExtPowerSupply))
					{
						//m_blMax20084_3_ENState=!blTurnOffGPIOPin(OSAL_EN_MAX20084_EN_3); // DTV uses FPGA

					}
					else
					{
						m_blMax20084_3_ENState=!(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
								TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
					}
					break;
				}
				/*case enELMOS4_1:
				case enELMOS4_2:
					{
						ETG_TRACE_USR2(("ANTDIAG::Turn off ELMOS4 IC"));
						m_blELMOS_EN4State= !(m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,(tenCMExtPowerSupplyType)u8ExtPowerSupply)));
						break;
					}*/
				case enTPS7B7702_1_1:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off enTPS7B7702_1_1 IC"));
					m_blTPS7B7702_1_EN1State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7702_EN_1);
					m_potunmstr_antdiag_Measure->vCloseTPS7B7702_1_1ADCChannel();
					break;
				}
				case enTPS7B7702_1_2:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off enTPS7B7702_1_2 IC"));
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
					if(m_blA2S1Bsample)
					{
						m_blTPS7B7702_1_EN2State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7702_EN_1);
					}
					else
					{
						m_blTPS7B7702_1_EN2State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7702_EN_2);
					}
					m_potunmstr_antdiag_Measure->vCloseTPS7B7702_1_2ADCChannel();
#endif
					break;
				}
				/*case enTPS7B7701_1:
				{
					ETG_TRACE_USR2(("ANTDIAG::Turn off enTPS7B7701_1 IC"));
					m_blnfineon_ENState=!blTurnOffGPIOPin(OSAL_EN_TPS7B7701_EN_1);
					m_potunmstr_antdiag_Measure->vCloseTPS7B7701ADCChannel();
					break;
				}*/
				default:
				{
					break;
				}
			}
		}
	}
}
/*************************************************************************
* FUNCTION:    blTurnOffGPIOPin
*
* DESCRIPTION: Fucntion to turn off GPIO Pin
*
* PARAMETER:   OSAL_enGpioPins enGPIOPin
*
* RETURNVALUE:  tVoid
*************************************************************************/
tBool tunmstr_antdiag_Manager::blTurnOffGPIOPin(OSAL_enGpioPins enGPIOPin)const
{
	tBool blRet=FALSE;
	if(enGPIOPin)
	{
		OSAL_tIODescriptor hDev;
		hDev = OSAL_IOOpen(OSAL_C_STRING_DEVICE_GPIO, OSAL_EN_READWRITE);
		if (hDev ==OSAL_ERROR)
		{
			ETG_TRACE_ERR(("ANTDIAG::Error in Opening OSAL GPIO IO devices with error=%d",(int)hDev));
			OSAL_s32IOClose(hDev);
			return blRet;
		}
		OSAL_tGPIODevID devID;
		devID	= (OSAL_tGPIODevID)enGPIOPin;
		OSAL_trGPIOData Data = {devID, FALSE};
		tS32 _s32OutPutErrorCode=OSAL_s32IOControl(hDev, OSAL_C_32_IOCTRL_GPIO_SET_INACTIVE_STATE , (intptr_t) &Data);
		if(OSAL_OK	==_s32OutPutErrorCode)
		{
			ETG_TRACE_USR1(("ANTDIAG::GPIO =%02x pin is turned off",ETG_CENUM(OSAL_enGpioPins,enGPIOPin)));
			blRet=TRUE;
		}
		OSAL_s32IOClose(hDev);
	}
	return blRet;
}
/*************************************************************************
* FUNCTION:    vReadCurrent
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vReadCurrent(tenAntDiagClients enAntDiagClients)
{
	if((NULL == m_potunmstr_antdiag_Measure) || (NULL == m_potunmstr_antdiag_i2cHandler))
	{
		return;
	}
	tenCMExtPowerSupplyType enCMExtPowerSupplyType=enGetExtPowerSupplyType(enAntDiagClients);
	if(blIsExtSup_Supports(enCMExtPowerSupplyType))
	{
		switch(enCMExtPowerSupplyType)
		{
		case enInfineonTLF4277_1:
		{
			m_potunmstr_antdiag_Measure->vReadInfineonIC_ADCVal();
			break;
		}
		case enInfineonTLF4277_2:
		{
			m_potunmstr_antdiag_Measure->vReadInfineon2IC_ADCVal();
			break;
		}
		case enMAXIM_16946:
		{
			m_potunmstr_antdiag_Measure->vReadMAXIC_ADCVal();
			break;
		}
		case enELMOS1_1:
		case enELMOS1_2:
		case enELMOS2_1:
		case enELMOS2_2:
		case enELMOS3_1:
		case enELMOS3_2:
		case enELMOS4_1:
		case enELMOS4_2:
		{
			m_potunmstr_antdiag_i2cHandler->vReadELMOSCurrent(enCMExtPowerSupplyType,enAntDiagClients);
			break;
		}
		case enTPS7B7702_1_1:
		{
			m_potunmstr_antdiag_Measure->vReadTPS7B7702_1_1ADCVal(enAntDiagClients);
			break;
		}
		case enTPS7B7702_1_2:
		{
			m_potunmstr_antdiag_Measure->vReadTPS7B7702_1_2ADCVal(enAntDiagClients);
			break;
		}
		case enTPS7B7701_1:
		{
			m_potunmstr_antdiag_Measure->vReadTPS7B7701_ADCVal();
			break;
		}
		case enMAX20084_1_1:
		case enMAX20084_1_2:
		case enMAX20084_2_1:
		case enMAX20084_2_2:
		case enMAX20084_3_1:
		case enMAX20084_3_2:
		{
			m_potunmstr_antdiag_i2cHandler->vReadMax20084Current(enCMExtPowerSupplyType,enAntDiagClients);
			break;
		}
		default:
		{
			break;
		}
		}
	}
}
/*************************************************************************
 * FUNCTION:    vHandle_s_Rf_Antenna_TestReq()
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vHandle_s_Rf_Antenna_TestReq(tenAntDiagClients enAntDiagClient)
{
	if((NULL==m_potunmstr__DiagLog) ||(NULL==m_potunmstr_antdiag_Debounce)||(NULL==m_potunmstr_MsgFromHMI))
	{
		return;
	}
	tBool blSendMethodResult=TRUE;
	tU8 u8AntennaStatus= (tU8)enAntennState_Unknown;
	tenCMExtPowerSupplyType enCMExtPowerSupplyType=enGetExtPowerSupplyType(enAntDiagClient);
	ETG_TRACE_USR4(("ANTDIAG::REQUEST from the client to read the current antenna status for =%02x ",
		ETG_CENUM(tenAntDiagClients,enAntDiagClient)));	
	if(blIsExtSup_Supports(enCMExtPowerSupplyType))
	{
		u8AntennaStatus=m_potunmstr__DiagLog->u8GetAntenanstate(enAntDiagClient);
		if(blGetExtPwrSupEN_PinState(enCMExtPowerSupplyType))
		{
			//Read current
			blSendMethodResult=FALSE;
		}
		//Antenna power is switched off due to short circuit 
		else if( (enAntennState_Short==u8AntennaStatus) && (!blGetExtPwrSupEN_PinState(enCMExtPowerSupplyType)))
		{
			ETG_TRACE_USR4(("vHandle_s_Rf_Antenna_TestReq()->%02x is short, turning on",
					ETG_CENUM(tenAntDiagClients, enAntDiagClient)));
			vResetAntennaDiagTimers();
			//turn on antenna and Turn on timer
			vTurnOnExtPowerSupplyType(enCMExtPowerSupplyType);
			blSendMethodResult=FALSE;
			vInitializeAntennaDiagTimer();
		}
	}
	if(blSendMethodResult)
	{
		ETG_TRACE_USR4(("vHandle_s_Rf_Antenna_TestReq()->Sending method result for client %02x",
				ETG_CENUM(tenAntDiagClients, enAntDiagClient)));
      vSetPendingAntennaStateReqClient(enClientNone);
		m_potunmstr_MsgFromHMI->vSendRfAntenna_TestMethodResult(enAntDiagClient,u8AntennaStatus,(tFloat)0.0);
	}

}
/*************************************************************************
 * FUNCTION:    vTurnOffExtPowerSupply()
 * Need to be used only for if diagnosis request to disable the power supply
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vTurnOffExtPowerSupply(tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	if((NULL==m_potunmstr_antdiag_Measure) ||(NULL==m_potunmstr_antdiag_i2cHandler))
	{
		return;
	}
	switch(enCMExtPowerSupplyType)
	{
	case enInfineonTLF4277_1:
	{
		ETG_TRACE_USR2(("ANTDIAG::Turn off Infineon1 IC"));
		m_blnfineon_ENState=!blTurnOffGPIOPin(OSAL_EN_TLF4277_EN);
		m_potunmstr_antdiag_Measure->vCloselnfineonADCChannel();
		break;
	}
	case enInfineonTLF4277_2:
	{
		ETG_TRACE_USR2(("ANTDIAG::Turn off Infineon2 IC"));
		m_blnfineon2_ENState=!blTurnOffGPIOPin(OSAL_EN_TLF4277_EN_2);
		m_potunmstr_antdiag_Measure->vCloselnfineon2ADCChannel();
		break;
	}
	case enMAXIM_16946:
	{
		ETG_TRACE_USR2(("ANTDIAG::Turn off MAX IC"));
		m_blMax_SHDNState=!blTurnOffGPIOPin(OSAL_EN_MAX16946_SHDN);
		m_potunmstr_antdiag_Measure->vCloseMAXADCChannel();
		break;
	}
	case enELMOS1_1:
	case enELMOS1_2:
	{
		if(m_blELMOS_EN1State)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
		}
		break;
	}
	case enELMOS2_1:
	case enELMOS2_2:
	{
		if(m_blELMOS_EN2State)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
		}
		break;
	}
	case enELMOS3_1:
	case enELMOS3_2:
	{
		if(m_blELMOS_EN3State)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
		}
		break;
	}
	case enELMOS4_1:
	case enELMOS4_2:
	{
		if(m_blELMOS_EN4State)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
		}
		break;
	}
	case enMAX20084_1_1:
	case enMAX20084_1_2:
	{
		if(m_blMax20084_1_ENState)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
		}
		break;
	}
	case enMAX20084_2_1:
	case enMAX20084_2_2:
	{
		if(m_blMax20084_2_ENState)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
		}
		break;
	}
	case enMAX20084_3_1:
	case enMAX20084_3_2:
	{
		if(m_blMax20084_3_ENState)
		{
			m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,FALSE);
			m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
		}
		break;
	}
	case enTPS7B7702_1_1:
	{
		ETG_TRACE_USR2(("ANTDIAG::Turn off TPS7B7702_1_1 IC"));
		m_blTPS7B7702_1_EN1State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7702_EN_1);
		m_potunmstr_antdiag_Measure->vCloseTPS7B7702_1_1ADCChannel();
		break;
	}
	case enTPS7B7702_1_2:
	{
		ETG_TRACE_USR2(("ANTDIAG::Turn off TPS7B7702_1_2 IC"));
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		if(m_blA2S1Bsample)
		{
			m_blTPS7B7702_1_EN2State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7702_EN_1);
		}
		else
		{
			m_blTPS7B7702_1_EN2State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7702_EN_2);
		}
		m_potunmstr_antdiag_Measure->vCloseTPS7B7702_1_2ADCChannel();
#endif
		break;
	}
	/*case enTPS7B7701_1:
	{
		ETG_TRACE_USR2(("ANTDIAG::Turn off enTPS7B7701_1 IC"));
		m_blTPS7B7702_1_EN1State=!blTurnOffGPIOPin(OSAL_EN_TPS7B7701_EN_1);
		m_potunmstr_antdiag_Measure->vCloseTPS7B7701ADCChannel();
		break;
	}*/
	default:
	{
		break;
	}
	}
}
/*************************************************************************
 * FUNCTION:    vTurnOnExtPowerSupplyType()
 * DESCRIPTION: Turn on IC of singly requested client
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vTurnOnExtPowerSupplyType(tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	if((NULL==m_potunmstr_antdiag_Measure)||(NULL==m_potunmstr_antdiag_i2cHandler))
	{
		return;
	}
	switch(enCMExtPowerSupplyType)
	{
	case enInfineonTLF4277_1:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on Infineon_IC"));
			m_blnfineon_ENState=blTurnOnGPIOPin(OSAL_EN_TLF4277_EN);
			m_potunmstr_antdiag_Measure->vOpenlnfineonADCChannel();
			break;
		}
	case enInfineonTLF4277_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on Infineon2_IC"));
			m_blnfineon2_ENState=blTurnOnGPIOPin(OSAL_EN_TLF4277_EN_2);
			m_potunmstr_antdiag_Measure->vOpenlnfineon2ADCChannel();
			break;
		}
	case enMAXIM_16946:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on Max_IC"));
			m_blMax_SHDNState=blTurnOnGPIOPin(OSAL_EN_MAX16946_SHDN);
			m_potunmstr_antdiag_Measure->vOpenMAXADCChannel();
			break;
		}
	case enELMOS1_1:
	case enELMOS1_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on ELMOS1_IC"));
			if(m_blELMOS_EN1State)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
			}
			break;
		}
	case enELMOS2_1:
	case enELMOS2_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on ELMOS2_IC"));
			if(m_blELMOS_EN2State)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
			}
			break;
		}
	case enELMOS3_1:
	case enELMOS3_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on ELMOS3_IC"));
			if(m_blELMOS_EN3State)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
			}
			break;
		}
	case enELMOS4_1:
	case enELMOS4_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on ELMOS4_IC"));
			if(m_blELMOS_EN4State)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blWriteELMOSStatusReg(enCMExtPowerSupplyType);
			}
			break;
		}
	case enMAX20084_1_1:
	case enMAX20084_1_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on enMAX20084_1"));
			if(m_blMax20084_1_ENState)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
			}
			break;
		}
	case enMAX20084_2_1:
	case enMAX20084_2_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on enMAX20084_2"));
			if(m_blMax20084_2_ENState)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
			}
			break;
		}
	case enMAX20084_3_1:
	case enMAX20084_3_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on enMAX20084_3"));
			if(m_blMax20084_3_ENState)
			{
				m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,TRUE);
				m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
			}
			break;
		}
	case enTPS7B7702_1_1:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on enTPS7B7702_1_1"));
			m_blTPS7B7702_1_EN1State=blTurnOnGPIOPin(OSAL_EN_TPS7B7702_EN_1);
			m_potunmstr_antdiag_Measure->vOpenTPS7B7702_1_1ADCChannel();
			break;
		}
	case enTPS7B7702_1_2:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on enTPS7B7702_1_2"));
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			if(m_blA2S1Bsample)
			{
				m_blTPS7B7702_1_EN2State = blTurnOnGPIOPin(OSAL_EN_TPS7B7702_EN_1);
			}
			else
			{
				m_blTPS7B7702_1_EN2State = blTurnOnGPIOPin(OSAL_EN_TPS7B7702_EN_2);
			}
			    m_potunmstr_antdiag_Measure->vOpenTPS7B7702_1_2ADCChannel();
			
#endif
			break;
		}
	/*case enTPS7B7702_1_1:
		{
			ETG_TRACE_USR2(("ANTDIAG::Turn on enTPS7B7702_1_1"));
			m_blTPS7B7702_1_EN1State=blTurnOnGPIOPin(OSAL_EN_TPS7B7701_EN_1);
			m_potunmstr_antdiag_Measure->vOpenTPS7B7701ADCChannel();
			break;
		}*/
	default:
		{
			break;
		}
	}
}
/*************************************************************************
 * FUNCTION:    vSendCurrnetAntennaStatus()
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vSendCurrnetAntennaStatus()
{
	if((NULL==m_potunmstr__DiagLog) ||(NULL==m_potunmstr_antdiag_Debounce)||
	(NULL==m_potunmstr_MsgToHMI)||(NULL==m_potunmstr_antdiag_Measure))
	{
		return;
	}
	for(tU8 u8Client=(tU8)enFM1;u8Client<(tU8)enClientNone;u8Client++)
	{
		tU8 u8AntennaStatus=m_potunmstr__DiagLog->u8GetAntenanstate((tenAntDiagClients)u8Client);
		ETG_TRACE_USR2(("ANTDIAG:u8AntennaStatus=%d u8GetAntennatype=%d", u8AntennaStatus, u8GetAntennatype(u8Client)));
		tFloat fCurrent = m_potunmstr_antdiag_Debounce->fGetAntennaCurrent(u8Client);
		//Send Property update
		if(enGetExtPowerSupplyType((tenAntDiagClients)u8Client)==enMAXIM_16946)
		{
			fCurrent=m_potunmstr_antdiag_Measure->fGetMaxIC_CalculatedCur();
		}
		if ((enAntennState_Unknown == u8AntennaStatus) && (u8GetAntennatype(u8Client) == enPassive))
		{
			u8AntennaStatus = enAntennState_Passive;
		}
		m_potunmstr_MsgToHMI->vSend_g_RFAntennaTest(u8Client,u8AntennaStatus,fCurrent);
	}
}
/*************************************************************************
 * FUNCTION:    vHandleCriticalHgVg()
 *
 * DESCRIPTION: function to handle Critical High Voltage
 *
 * PARAMETER:   tBool blTurnOff
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_antdiag_Manager::vHandleCriticalHgVg(tBool blTurnOff)
{
	if((NULL==m_potunmstr_antdiag_Debounce)||(NULL==m_potunmstr_antdiag_i2cHandler))
	{
		return;
	}
    vResetAntennaDiagTimers();
	for(tenAntDiagClients enAntDiagClient=enFM1;enAntDiagClient<enClientNone;)
	{
		tenCMExtPowerSupplyType enCMExtPowerSupplyType = enGetExtPowerSupplyType(enAntDiagClient);
		if(blIsExtSup_Supports(enCMExtPowerSupplyType))
		{
			ETG_TRACE_USR4(("vHandleCriticalHgVg() Consider_CriticalHgVg=%d",m_blConsider_CriticalHgVg[enAntDiagClient]));
			if((m_blConsider_CriticalHgVg[enAntDiagClient])&&(blTurnOff))
			{
				//Turn off GPIO Pin and update the GPIO pin state
				if((ISPOWERSUPPLY_ELMOS(enCMExtPowerSupplyType) )|| (ISPOWERSUPPLY_MAX20084(enCMExtPowerSupplyType)))
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,false);
					m_potunmstr_antdiag_i2cHandler->blEnableOutput(enCMExtPowerSupplyType);
					tBool blRet= false;
					if(TURN_ON_OFF_USING_GPIOREGISTER(enCMExtPowerSupplyType))
					{
						blRet = m_potunmstr_antdiag_i2cHandler->blTurnOffUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(false,enCMExtPowerSupplyType));
					}
					else
					{
						blRet = blTurnOffGPIOPin(enGetOSALGPIOPinName(enCMExtPowerSupplyType));
					}
					vSetExtPwrSupEN_PinState(enCMExtPowerSupplyType,(!blRet));
				}
				else
				{
					vSetExtPwrSupEN_PinState(enCMExtPowerSupplyType,!(blTurnOffGPIOPin(enGetOSALGPIOPinName(enCMExtPowerSupplyType))));
				}
				//Clear the Counter
				m_potunmstr_antdiag_Debounce->vClearCounter(enAntDiagClient);
				m_potunmstr_MsgToHMI->vSend_g_RFAntennaTest(enAntDiagClient,enAntennState_Deactivated_HighVg,(tFloat)0.0);
				m_potunmstr__DiagLog->blUpdateAntennaStatus(enAntDiagClient,enAntennState_Deactivated_HighVg);
			}
			else if((m_blConsider_CriticalHgVg[enAntDiagClient])&&(!blTurnOff))
			{
				//Turn on GPIO Pin
				if((ISPOWERSUPPLY_ELMOS(enCMExtPowerSupplyType))|| (ISPOWERSUPPLY_MAX20084(enCMExtPowerSupplyType)))
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enCMExtPowerSupplyType,true);
					if(ISPOWERSUPPLY_ELMOS(enCMExtPowerSupplyType))
					m_potunmstr_antdiag_i2cHandler->blEnableOutput(enCMExtPowerSupplyType);
					tBool blRet= false;
					if(TURN_ON_OFF_USING_GPIOREGISTER(enCMExtPowerSupplyType))
					{
						blRet = m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
					}
					else
					{
						blRet = blTurnOnGPIOPin(enGetOSALGPIOPinName(enCMExtPowerSupplyType));
						if(ISPOWERSUPPLY_MAX20084(enCMExtPowerSupplyType))
						{
							m_potunmstr_antdiag_i2cHandler->vInitialiseMax20084Rg(enCMExtPowerSupplyType);
							blRet = m_potunmstr_antdiag_i2cHandler->blEnableOutput(enCMExtPowerSupplyType);
						}
					}
					vSetExtPwrSupEN_PinState(enCMExtPowerSupplyType,blRet);
				}
				else
				{
					vSetExtPwrSupEN_PinState(enCMExtPowerSupplyType,(blTurnOnGPIOPin(enGetOSALGPIOPinName(enCMExtPowerSupplyType))));
				}
			}
		}
		enAntDiagClient=(tenAntDiagClients)((tU8)enAntDiagClient+1);
	}
   if(!blTurnOff)
   {
      vInitializeAntennaDiagTimer();
   }
}
/*************************************************************************
* FUNCTION:    vReadUbatterVg()
*
* DESCRIPTION: fucntion to read the battery volatge from dev/volt interface
*
* PARAMETER:   tVoid
*
* RETURNVALUE:  tVoid
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vReadUbatterVg()
{
	tU16 u16BoardVoltageMv=0;
	m_hIODescriptor = OSAL_IOOpen(OSAL_C_STRING_DEVICE_VOLT, OSAL_EN_READONLY);
	if (OSAL_s32IOControl(m_hIODescriptor, OSAL_C_S32_IOCTRL_VOLT_GET_BOARD_VOLTAGE,(intptr_t)&u16BoardVoltageMv) == OSAL_OK)
	{
			m_fBatteryVg=u16BoardVoltageMv;
			m_fBatteryVg=(tFloat)(m_fBatteryVg * 0.001);
			ETG_TRACE_USR4(("vReadUbatterVg()-->u16BoardVoltageMv=%d m_fBatteryVg=%f",u16BoardVoltageMv,m_fBatteryVg));
	}
	OSAL_s32IOClose(m_hIODescriptor);
}
/*************************************************************************
* FUNCTION:    fGet_BatteryVg()
*
* DESCRIPTION: fucntion to return the battery vg
*
* PARAMETER:   tVoid
*
* RETURNVALUE:  m_fBatteryVg
*************************************************************************/
tFloat tunmstr_antdiag_Manager::fGet_BatteryVg()
{
	return m_fBatteryVg;
}

/*************************************************************************
* FUNCTION:     vHandleTTFiS_CMD( )
*************************************************************************/
tVoid tunmstr_antdiag_Manager::vHandleTTFiS_CMD(const tU8* u8DataSpecial)
{
	ETG_TRACE_USR4(("vHandleTTFiS_CMD()"));
	tU8 u8WhichFunction = u8DataSpecial[0];
	switch (u8WhichFunction)
	{
	case TUNMSTR_ANTDIAG::vStartAntennaDiag:
		{
         vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_START_ANTDIAG);
			break;
		}
	case TUNMSTR_ANTDIAG::vStopAntennaDiag:
		{
         vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_ANTDIAG);
			break;
		}
	default:
		{
			break;
		}
	}
}
/******************************************************************************
FUNCTION:      vDeleteNoThrow
*********************************************************************************/
template< class T > void tunmstr_antdiag_Manager::vDeleteNoThrow( T*& rfpArg ) throw()
{
	OSAL_DELETE rfpArg;
	rfpArg = 0;
}
tVoid tunmstr_antdiag_Manager::vClearAllInternalState()
{
	m_blnfineon_IC=FALSE;
	m_blnfineon_IC2=FALSE;
	m_blMax_IC=FALSE;
	m_blELMOS2_1_IC=FALSE;
	m_blELMOS2_2_IC=FALSE;
	m_blELMOS1_1_IC=FALSE;
	m_blELMOS1_2_IC=FALSE;
	m_blELMOS_EN1State=FALSE;
	m_blELMOS_EN2State=FALSE;
	m_blnfineon_ENState=FALSE;
	m_blnfineon2_ENState=FALSE;
	m_blMax_SHDNState=FALSE;
	m_u32MointorTime=TUNMSTR_ANTENNA_DIAGNOSIS_TIMER;
	m_blTimerActive=FALSE;
	//Don't uncomment the below line,
	//m_blAntennaDiagState=FALSE;
	vSetPendingAntennaStateReqClient(enClientNone);
	m_fBatteryVg=0;
	m_hIODescriptor = OSAL_ERROR;
	m_blELMOS3_1_IC=FALSE;
	m_blELMOS3_2_IC=FALSE;
	m_blELMOS_EN3State=FALSE;
	m_blELMOS4_1_IC=FALSE;
	m_blELMOS4_2_IC=FALSE;
	m_blELMOS_EN4State=FALSE;
	m_blMAX20084_1_1_IC = false;
	m_blMAX20084_1_2_IC = false;
	m_blMAX20084_2_1_IC = false;
	m_blMAX20084_2_2_IC = false;
	m_blMAX20084_3_1_IC = false;
	m_blMAX20084_3_2_IC = false;
	m_blTPS7B7701_1_IC = false;
	m_blTPS7B7702_1_1_IC = false;
	m_blTPS7B7702_1_2_IC = false;

	m_blMax20084_1_ENState = false;
	m_blMax20084_2_ENState = false;
	m_blMax20084_3_ENState = false;
	m_blTPS7B7702_1_EN1State = false;
	m_blTPS7B7702_1_EN2State = false;
	m_blTPS7B7701_1_ENState = false;
	for(tU8 u8Index=enFM1;u8Index<enClientNone;u8Index++)
	{
		m_enCMExtPowerSupply[u8Index]=enunknown;
		m_enAntennaTyp[u8Index]=enNone;
		m_blConsider_CriticalHgVg[u8Index]=FALSE;
	}
}
tBool tunmstr_antdiag_Manager::blTurnOnUsingGPIO(tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	tenAntDiagClients enAntDiagClient = enGetAntDiagClient(enCMExtPowerSupplyType);
	if((enDTV1 == enAntDiagClient)|| (enDTV2 == enAntDiagClient) || (enDTV3 == enAntDiagClient) || (enDTV4 == enAntDiagClient))
	{
		return false;
	}
	return true;
}
tU8 tunmstr_antdiag_Manager::u8GetDTVAntennaGpipMaskVal(tBool blTurnOn, tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	tenAntDiagClients enAntDiagClient = enGetAntDiagClient(enCMExtPowerSupplyType);
	if((enDTV1 == enAntDiagClient)|| (enDTV2 == enAntDiagClient))
	{
		if(blTurnOn)
		{
			return TUNMSTR_ANTDIAG_FPGA_EN1_ON;
		}
		else
		{
			return TUNMSTR_ANTDIAG_FPGA_EN1_OFF;
		}
	}
	else if((enDTV3 == enAntDiagClient) || (enDTV4 == enAntDiagClient))
	{
		if(blTurnOn)
		{
			return TUNMSTR_ANTDIAG_FPGA_EN2_ON;
		}
		else
		{
			return TUNMSTR_ANTDIAG_FPGA_EN2_OFF;
		}
	}
	else
	{
		return NULL;
	}
}

tVoid tunmstr_antdiag_Manager::vSetDTVAntennaRegister()
{
	for(tU8 enCMExtPowerSupplyType=enELMOS1_1; enCMExtPowerSupplyType<=enMAX20084_3_2; enCMExtPowerSupplyType++)
	{
		if (enInfineonTLF4277_1 == enCMExtPowerSupplyType)
		{
			enCMExtPowerSupplyType = enInfineonTLF4277_2;
		}
		if(blIsExtSup_Supports((tenCMExtPowerSupplyType)enCMExtPowerSupplyType) &&
				(!(blTurnOnUsingGPIO((tenCMExtPowerSupplyType)enCMExtPowerSupplyType))))
		{
			if(ISPOWERSUPPLY_ELMOS(enCMExtPowerSupplyType))
			{
				m_potunmstr_antdiag_i2cHandler->vWriteOverCurrentReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType,
							m_potunmstr_antdiag_Debounce->u8GetShortCurrent(enGetAntDiagClient((tenCMExtPowerSupplyType)enCMExtPowerSupplyType)));
				#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
				m_potunmstr_antdiag_i2cHandler->vWriteSupplyOverVoltageReg((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
				#endif
			}
			else if(ISPOWERSUPPLY_MAX20084(enCMExtPowerSupplyType))
			{
				vSetExtPwrSupEN_PinState((tenCMExtPowerSupplyType)enCMExtPowerSupplyType,false);
				blTurnOnMAX20084Antenna((tenCMExtPowerSupplyType)enCMExtPowerSupplyType);
			}
		}
	}
}
/*Turn On sequence
 * 1. Set EN pin to High
 * 2. Set output current limit, default value 270ma
 * 3. Set Over and open current register according to KDS
 * 4. Set warning current according to KDS
 * 5. Set output voltage according to KDS
 * 6. Set setup2 register with warning temp as 95 and blank time as 50ms
 * 7. set Mask register to assert FLT low when for reverse current, over current, short to battery i.e x001 0111
 * 8. set setup1 register*/
tBool tunmstr_antdiag_Manager::blTurnOnMAX20084Antenna(tenCMExtPowerSupplyType enCMExtPowerSupplyType)
{
	tBool blRes=FALSE;
	if(NULL!=m_potunmstr_antdiag_i2cHandler)
	{
		switch(enCMExtPowerSupplyType)
		{
			case enMAX20084_1_1:
			case enMAX20084_1_2:
			{
				if(!m_blMax20084_1_ENState)
				{
					/*In AIV2 Max IC 1 and 3 will be used for DTV*/
					/*if(blTurnOnUsingGPIO(enCMExtPowerSupplyType))
					{
						blRes=blTurnOnGPIOPin(OSAL_EN_MAX20084_EN_2);
					}
					else*/
					{
						blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
					}
					m_blMax20084_1_ENState =blRes;
				}
				if(m_blMax20084_1_ENState)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enMAX20084_1_1,m_blMAX20084_1_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enMAX20084_1_2,m_blMAX20084_1_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseMax20084Rg(enCMExtPowerSupplyType);
					m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
				}
				break;
			}
			case enMAX20084_2_1:
			case enMAX20084_2_2:
			{
				if(!m_blMax20084_2_ENState)
				{

					if(blTurnOnUsingGPIO(enCMExtPowerSupplyType))
					{
						blRes=blTurnOnGPIOPin(OSAL_EN_MAX20084_EN_1);
					}
					else
					{
						blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
					}
					m_blMax20084_2_ENState = blRes;
				}
				if(m_blMax20084_2_ENState)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enMAX20084_2_1,m_blMAX20084_2_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enMAX20084_2_2,m_blMAX20084_2_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseMax20084Rg(enCMExtPowerSupplyType);
					m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
				}
				break;
			}
			case enMAX20084_3_1:
			case enMAX20084_3_2:
			{
				if(!m_blMax20084_3_ENState)
				{
					/*In AIV2 Max IC 1 and 3 will be used for DTV*/
					/*if(blTurnOnUsingGPIO(enCMExtPowerSupplyType))
					{
						blRes=blTurnOnGPIOPin(OSAL_EN_MAX20084_EN_3);
					}
					else*/
					{
						blRes=m_potunmstr_antdiag_i2cHandler->blTurnOnUsingGPIORegister(TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS,
							TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS,u8GetDTVAntennaGpipMaskVal(true,enCMExtPowerSupplyType));
					}
					m_blMax20084_3_ENState = blRes;
				}
				if(m_blMax20084_3_ENState)
				{
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enMAX20084_3_1,m_blMAX20084_3_1_IC);
					m_potunmstr_antdiag_i2cHandler->vSetOutputEnabled(enMAX20084_3_2,m_blMAX20084_3_2_IC);
					m_potunmstr_antdiag_i2cHandler->vInitialiseMax20084Rg(enCMExtPowerSupplyType);
					m_potunmstr_antdiag_i2cHandler->blEnableMAX20084Output(enCMExtPowerSupplyType);
				}
				break;
			}
			default:
				break;
		}
	}
	return blRes;
}
tBool tunmstr_antdiag_Manager::blIsB1A2S1Sample()
{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	return m_blA2S1Bsample;
#endif
	return false;
}
tVoid tunmstr_antdiag_Manager::vHandleCriticalLowVg(tBool blCriticalLowVgStart)
{
   vHandleAntennaSwitching(!blCriticalLowVgStart);
   if((blCriticalLowVgStart) && (nullptr != m_potunmstr_MsgToHMI) && (nullptr != m_potunmstr__DiagLog))
   {
      for(tU8 u8Client = enFM1;u8Client < enClientNone;u8Client++)
      {
         m_potunmstr_MsgToHMI->vSend_g_RFAntennaTest(u8Client,enAntennState_Deactivated_LowVg,(tFloat)0.0);
         m_potunmstr__DiagLog->blUpdateAntennaStatus((tenAntDiagClients)u8Client,enAntennState_Deactivated_LowVg);
      }
   }
}
