
 /************************************************************************
* FILE:           tunmstr_antdiag_Manager.h
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    This class will handle source change logic functionalty.
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author							         | Modification
* 25/05/2012  | RBEI/ECV4 Priya Prabhuswamy(rrb1kor)     | Initial version.
* 25.04.13	  |	NGP1KOR									 | First version of the G3g after porting from NISSAN LCN2Kai
*************************************************************************/

#ifndef tunmstr_antdiag_Manager_H
#define tunmstr_antdiag_Manager_H
#ifndef _TUNMSTR_ANTDIAG_DEFINES_H
#include "tunmstr_antdiag_Defines.h"
#endif
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#ifndef TUNERMASTER_TRACE_H
#include "tunermaster_trace.h"
#endif
#ifndef TUNMASTERMASTER_PRJCONFIG_H
#include "tunermaster_PrjConfig.h"
#endif

#ifndef TUNERMASTER_DEFINES_H
#include "tunermaster_defines.h"
#endif

#include "diaglib_if.h"
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#define DIAGLIB_INCLUDE_SYSTEM_SET
/*--------------------------------*/
/* class tunmstr_antdiag_Manager definition */
/*--------------------------------*/

#ifndef tunmstr_DiaglibListner_H
#include "tunmstr_DiaglibListner.h"
#endif
#include <mutex>
class tunmstr_MsgToHMI;
class tunmstr_antdiag_i2cHandler;
class tunmstr_antdiag_Debounce;
class tunmstr_DiagLogClientHandler;
class tunmstr_MsgFromHMI;
class clConfigInterface;
class tunmstr_DiaglibListner;
class tunmstr_antdiag_Manager
{
private:
	tunmstr_MsgToHMI*				m_potunmstr_MsgToHMI;
	tunmstr_antdiag_Measure*		m_potunmstr_antdiag_Measure;
	tunmstr_antdiag_i2cHandler*		m_potunmstr_antdiag_i2cHandler;
	tunmstr_antdiag_Debounce*		m_potunmstr_antdiag_Debounce;
	tunmstr_DiagLogClientHandler*   m_potunmstr__DiagLog;
	tunmstr_MsgFromHMI*				m_potunmstr_MsgFromHMI;
	clConfigInterface* 				m_poclConfigInterface;
	tunmstr_DiaglibListner*    m_potunmstr_DiaglibListner;
	
	tBool m_blnfineon_IC;
	tBool m_blnfineon_IC2;
	tBool m_blMax_IC;
	tBool m_blELMOS1_1_IC;
	tBool m_blELMOS1_2_IC;
	tBool m_blELMOS2_1_IC;
	tBool m_blELMOS2_2_IC;
	tBool m_blELMOS3_1_IC;
	tBool m_blELMOS3_2_IC;
	tBool m_blELMOS4_1_IC;
	tBool m_blELMOS4_2_IC;
	tBool m_blMAX20084_1_1_IC;
	tBool m_blMAX20084_1_2_IC;
	tBool m_blMAX20084_2_1_IC;
	tBool m_blMAX20084_2_2_IC;
	tBool m_blMAX20084_3_1_IC;
	tBool m_blMAX20084_3_2_IC;
	tBool m_blTPS7B7701_1_IC;
	tBool m_blTPS7B7702_1_1_IC;
	tBool m_blTPS7B7702_1_2_IC;
	
	tBool m_blELMOS_EN1State;
	tBool m_blELMOS_EN2State;
	tBool m_blELMOS_EN3State;
	tBool m_blELMOS_EN4State;
	tBool m_blnfineon_ENState;
	tBool m_blnfineon2_ENState;
	tBool m_blMax_SHDNState;
	tBool m_blMax20084_1_ENState;
	tBool m_blMax20084_2_ENState;
	tBool m_blMax20084_3_ENState;
	tBool m_blTPS7B7702_1_EN1State;
	tBool m_blTPS7B7702_1_EN2State;
	tBool m_blTPS7B7701_1_ENState;

	tU8   m_u8PendingStateReqClient;
	//Timer related variable
	tU32 m_u32MointorTime;
	tBool m_blTimerActive;
	
	tBool m_blAntennaDiagState;
	tFloat m_fBatteryVg;
	tU8 m_u8ElmosUpdateOverCurrentRegiser;
	tenAntennaType m_enAntennaTyp[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];
	tenCMExtPowerSupplyType m_enCMExtPowerSupply[enClientNone];
	OSAL_tIODescriptor m_hIODescriptor;
	tBool m_blConsider_CriticalHgVg[enClientNone];
	OSAL_tThreadID mThreadID = OSAL_ERROR;
	OSAL_tEventHandle m_EventHandle = OSAL_NULL;
	tBool m_blCriticalLowVg = false;
	tBool m_blCriticalHighVg = false;
	#ifdef GTEST_x86LINUX_BUILD
	tU32 u32unitestmask;
	#endif
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	/*In A2S1 B sample device, TPS7B7702 IC pin EN1 & EN2 pins are connected together,
	 hence only one GPIO pin to control both FM1 and GPS antenna power */
	tBool m_blA2S1Bsample;
#endif
	tU8 m_u8AntennaKDSReadRet;
	static OSAL_tpfCallback vOnMonitorCycleTimerExpiry(tVoid* pArg);
	static OSAL_tpfCallback VGetTxTimeout_For200mSecTimer(tVoid* pArg);
	static tVoid vSetMonitorCycleTimer(tU32 u32MsTimeout );
	static tVoid VSetTxTimeOut_For200mSecTimer(tU32 u32MsTimeout );
	std::mutex m_ReadAntStateRegLock;
public:

	tunmstr_antdiag_Manager();
	virtual ~tunmstr_antdiag_Manager( );
	static OSAL_tTimerHandle    m_hTxTimerTunMstr_1secTimer;
	static OSAL_tTimerHandle    m_hTxTimerTunMstr_200msecTimer;
	static tVoid MyCallback(tVoid);
	
	tVoid vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI);
	tVoid vSet_tunmstr_antdiag_Measure_Ptr( tunmstr_antdiag_Measure* potunmstr_antdiag_Measure );
	tVoid vSet_tunmstr_antdiag_i2cHandler(tunmstr_antdiag_i2cHandler* Ptunmstr_antdiag_i2cHandler);
	tVoid vSet_tunmstr_antdiag_Debounce_Ptr( tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce );
	tVoid vSet_tunmstr_DiagLogClientHandler_Ptr(tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler);
	tVoid vSet_tunmstr_MsgFromHMI_Ptr(tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tVoid vSet_tunmstr_DiaglibListner_Ptr(tunmstr_DiaglibListner* potunmstr_DiaglibListner);

	tVoid vOnNewAppState (tU32 u32AppState);//no utest, invoking same class function
	tVoid vHandleAntennaSwitching(tBool blOnorOff);//no utest, invoking same class function
	tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);//no utest
	tVoid vInitializeAntennaDiagTimer( );//utest
	tVoid vResetAntennaDiagTimers( );//no utest, invoking same class function
	tVoid vHandle_s_Rf_Antenna_TestReq(tenAntDiagClients enAntDiagClient);//utest
	tVoid vTurnOnExtPowerSupply();//utest
	tVoid vTurnOffExtPowerSupply();//utest
	tVoid vReadCurrent(tenAntDiagClients enAntDiagClients);//utest
	tVoid vSetExtPwrSupEN_PinState(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tBool blGPIOPinState);//utest
	tVoid vHandleCriticalHgVg(tBool blTurnOff);//utest
	tVoid vSendCurrnetAntennaStatus();//utest
	tVoid vReadUbatterVg();//no utest, not being used in any of the project
	tVoid vReadKDSAntennaParameterSet(tunerVector<tU8> &AntennaPar);//utest
	tVoid vReadExtAntennaSupplyTypeFromKDS();//no utest, no logic
	tVoid vReadKDSAntennaParameter_ConsiderCriticalHg_Vg(tunerVector<tU8> &KDSParam);//no utest, function is invoking the same class function
	tVoid vHandleKDSAntennaData();//no utest, function is invoking the same class function
	tVoid vUpdateAntenaaStatetoHMI(tU8 u8Client, tU8 u8AntennaState, tFloat fCurrent);//utest
	tVoid vSetExtPowerSupply(tenCMExtPowerSupplyType enCMExtPowerSupplyType, tBool blSet);//utest
	tVoid vTurnOnExtPowerSupplyType(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
	tVoid vSetPendingAntennaStateReqClient(tU8 u8WhichClient);//utest
	tVoid vTurnOffExtPowerSupply(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
	tVoid vClearAllInternalState(); // no utest
	
	tBool blTurnOnGPIOPin(OSAL_enGpioPins)const; //utest
	tBool blTurnOffGPIOPin(OSAL_enGpioPins)const;	//utest
	tBool blIsExtSup_Supports(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
	tBool blGetExtPwrSupEN_PinState(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const;//utest
	tBool blStartTimer();//utest
	tBool blTurnOnELMOSIC(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
	tBool blTurnOnUsingGPIO(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
	tVoid vSetDTVAntennaRegister();//utest
	tBool blTurnOnMAX20084Antenna(tenCMExtPowerSupplyType enCMExtPowerSupplyType);// no utest. function is invoking the same class function return false, because of gpio turn on
	tBool blIsB1A2S1Sample();
	
	tFloat fGet_BatteryVg();//no utest, getter function 
	OSAL_enGpioPins enGetOSALGPIOPinName(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const;//utest
	tenAntDiagClients enGetAntDiagClient(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const;//utest
	tenCMExtPowerSupplyType enGetExtPowerSupplyType(tenAntDiagClients enAntDiagClients)const;//utest
	tU8 u8GetPendingAntennaStateReqClient();//utest
	tU8 u8ConvertAntTypeNonePassiveToU8AntennaStatus(tenAntennaType enAntennaType);//no utest
	tU8 u8GetAntennatype(tU8)const;//utest
	tU8 u8GetDTVAntennaGpipMaskVal(tBool blTurnOn, tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
	tenAntDiagClients enGetAntDaigClientInx(tenAntDiagKDS enAntDiagKDS);//no utest
	template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
	tVoid vInitialize();
	static tVoid vThreadCallback(tVoid* pvArg);
	tVoid vPostEvent(tU32 u32EventID);
	tVoid vHandle200msTimerExpiry();
	tVoid vHandleMonitorCycleTimerExpiry();
	tVoid vHandleCriticalLowVg(tBool blCriticalLowVgStart);

};
#endif // tunmstr_antdiag_Manager_H
