
 /************************************************************************
* FILE:           TUNMSTR_ANTDIAG_DEFINES.H
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Defines related to Antenna Diagnosis
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author							| Modification
* 18.05.2012  | Pallavi HN RBEI\ECV4            | Initial version.
* 25.04.13	  | NGP1KOR						    | First version of the G3g after porting from NISSAN LCN2Kai
				
*************************************************************************/

#ifndef _TUNMSTR_ANTDIAG_DEFINES_H
#define _TUNMSTR_ANTDIAG_DEFINES_H
#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
   #define DP_S_IMPORT_INTERFACE_FI
   #include "dp_generic_if.h"
#endif
#include "tunermaster_PrjConfig.h"
#include "datatypes/tVector.h"
/*************************************************************************@DA*
 * @Filename          : _TUNMSTR_ANTDIAG_DEFINES.H
 * @Module            : fc_tunermaster
 * @Project           : LCN2Kai
 *----------------------------------------------------------------------------
 * @Copyright         : (c) 2012 RBEI/ECV4
 * @Author            : Pallavi HN RBEI\ECV4
 *----------------------------------------------------------------------------
 * @Description       :Defines related to Antenna Diagnosis
 *
 *----------------------------------------------------------------------------
 * @History           :  18.05.2012 Initial Version
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
 ************************************************************************@DE*/
/*** define timing constants */
// for 1sec timer define
#define TUNMSTR_ANTENNA_DIAGNOSIS_TIMER                   1000

typedef enum 
{
   enFM1,
   enFM2,
   enDAB1,
   enGPS,
   enDTV1,
   enDTV2,
   enDTV3,
   enDTV4,
   enDAB2,
   enClientNone
}tenAntDiagClients;

typedef enum 
{
   enkdsFM1,
   enkdsFM2,
   enkdsDAB1,
   enkdsDAB2,
   enkdsGPS,
   enkdsDTV1,
   enkdsDTV2,
   enkdsDTV3,
   enkdsDTV4,
   enkdsNone
}tenAntDiagKDS;

typedef enum
{
   enNone,
   enPassive,
   enActive,
   enPhantom
}tenAntennaType;   //AntennaType defined in DiagnosticServices.pdf

typedef enum 
{
   enEOLAntenna_Passive,
   enEOLAntenna_Active,
}tenEOLAntennaType;  ////AntennaType defined in EOL PSA DiagnosticServices.pdf
typedef enum
{
enunknown,
enELMOS1_1, 
enELMOS1_2, 
enELMOS2_1, 
enELMOS2_2, 
enInfineonTLF4277_1,
enMAXIM_16946, 
enInfineonTLF4277_2,
enELMOS3_1,
enELMOS3_2,
enELMOS4_1,
enELMOS4_2,
enMAX20084_1_1,
enMAX20084_1_2,
enMAX20084_2_1,
enMAX20084_2_2,
enMAX20084_3_1,
enMAX20084_3_2,
enTPS7B7701_1,
enTPS7B7702_1_1,
enTPS7B7702_1_2
}tenCMExtPowerSupplyType;  //CMExtPowerSupplyDiagInfoType defined in DiagnosticServices.pdf (cm_variant coding)

typedef enum
{
   enFail,
   enSuccess,
}tenResult;
typedef enum
{
	enAntennState_Unknown,
	enAntennState_Ok,
	enAntennState_Open,
	enAntennState_Short,
	enAntennState_Deactivated,
	enAntennState_Deactivated_LowVg,
	enAntennState_Deactivated_HighVg,
	enAntennState_OpentoAmplifier,
	enAntennState_Passive,
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	enAntennState_ELMOSOpen_Noresult,
#endif
	TUNMSTR_ANTDIAG_ANTENNA_STATE_NUMBER_OF_ITEM
}tenRfAntennaStatus;  //Antenna status defined in tunermaster_fi.pdf
//GPIO Pin state
typedef enum
{
	TUNMSTR_ANTDIAG_GPIO_STATE_OUTPUT,
	TUNMSTR_ANTDIAG_GPIO_STATE_INPUT
}tenGpioPinState;



typedef enum
{
	enNormalState,
	enNotExistingstate,
	enNotAccesible
}TUNMSTR_ANTDIAG__IgnitionSignalState;

typedef enum
{
	enCriticalLowVgStart,
	enCriticalLowVgEnd,
	enLowVgStart,
	enLowVgEnd,
	enHighVgStart,
	enHighVgEnd,
	enCriticalHighVgStart,
	enCriticalHighVgEnd,
	enCriticalNoEvent=15
}TUNMSTR_ANTDIAG_CVM_EVENT;
typedef enum
{
	enReadI2CRegister=1,
	enWriteI2CRegister
}TUNMSTR_ANTDIAG_ttfi;

typedef enum
{
	enErrorReg=0,
	enStatusReg,
	enSUP_VoltageReg,
	enSUP_OverVoltageReg,
	enA1_VoltageReg,
	enA1_LowCurrentReg,
	enA1_HighCurrentReg,
	enA1_OverCurrentReg,
	enA1_OpenCurrentReg,
	enA2_VoltageReg,
	enA2_LowCurrentReg,
	enA2_HighCurrentReg,
	enA2_OverCurrentReg,
	enA2_OpenCurrentReg,
	enAINReg,
	AIN_LevelReg,
	NoneReg=0xff
}tenElmosRegAddress;

typedef enum
{
	enOpenInd=0,
	enOpen2AmpInd,
	enShortInd,
	enOkInd,
	enAntennaStateIndexMaxVal
}ten_AntennaStateIndex;

typedef enum
{
	enGPIO_TurnedOff,
	enGPIO_TurnedOn
}ten_GPIOPinState;

typedef enum
{
	False,
	True
}tenTrueOrFalse;
typedef enum
{
	enAntennaParameter_idx_Tag=							0,
	enAntennaParameter_idx_MajorVer=					8,
	enAntennaParameter_idx_FM1AntennaType=				11,
	enAntennaParameter_idx_FM1OpenCur=					12,
	enAntennaParameter_idx_FM1OpenClearCur=				13,
	enAntennaParameter_idx_FM1ConsiderVg_Open=			14,
	enAntennaParameter_idx_FM1ConsiderIgn_Open=			15,
	enAntennaParameter_idx_FM1Open2Amp=					16,
	enAntennaParameter_idx_FM1Open2AmpClearCur_Lw=  	17,
	enAntennaParameter_idx_FM1Open2AmpClearCur_Hg=		18,
	enAntennaParameter_idx_FM1ConsiderVg_Open2Amp=		19,
	enAntennaParameter_idx_FM1ConsiderIgn_Open2Amp=		20,
	enAntennaParameter_idx_FM1ShortCur=					21,
	enAntennaParameter_idx_FM1ShortClearCur=			22,
	enAntennaParameter_idx_FM1ConsiderVg_Short=			23,
	enAntennaParameter_idx_FM1ConsiderIgn_Short=		24,
	enAntennaParameter_idx_FM1MonitorCycle=				25,
	enAntennaParameter_idx_FM1NoOfMonitorCycle=			26,
	enAntennaParameter_idx_FM1ShortCircuitWait=			27,
	enAntennaParameter_idx_FM1ConsiderCriticalHg_Vg=	28,
	enAntennaParameter_idx_FM1OutputVoltage=			29,
	enAntennaParameter_idx_FM1WarningCur=				30,
	/*31 to 36 reserved bytes*/	
	enAntennaParameter_idx_FM2AntennaType=				37,
	enAntennaParameter_idx_FM2OpenCur=					38,
	enAntennaParameter_idx_FM2OpenClearCur=				39,
	enAntennaParameter_idx_FM2ConsiderVg_Open=			40,
	enAntennaParameter_idx_FM2ConsiderIgn_Open=			41,
	enAntennaParameter_idx_FM2Open2Amp=					42,
	enAntennaParameter_idx_FM2Open2AmpClearCur_Lw=		43,
	enAntennaParameter_idx_FM2Open2AmpClearCur_Hg=		44,
	enAntennaParameter_idx_FM2ConsiderVg_Open2Amp=		45,
	enAntennaParameter_idx_FM2ConsiderIgn_Open2Amp=		46,
	enAntennaParameter_idx_FM2ShortCur=					47,
	enAntennaParameter_idx_FM2ShortClearCur=			48,
	enAntennaParameter_idx_FM2ConsiderVg_Short=			49,
	enAntennaParameter_idx_FM2ConsiderIgn_Short=		50,
	enAntennaParameter_idx_FM2MonitorCycle=				51,
	enAntennaParameter_idx_FM2NoOfMonitorCycle=			52,
	enAntennaParameter_idx_FM2ShortCircuitWait=			53,
	enAntennaParameter_idx_FM2ConsiderCriticalHg_Vg=	54,
	enAntennaParameter_idx_FM2OutputVoltage=			55,
	enAntennaParameter_idx_FM2WarningCur=				56,
	/*57 to 62 reserved bytes*/	
	enAntennaParameter_idx_DAB1AntennaType=				63,
	enAntennaParameter_idx_DAB1OpenCur=					64,
	enAntennaParameter_idx_DAB1OpenClearCur=			65,
	enAntennaParameter_idx_DAB1ConsiderVg_Open=			66,
	enAntennaParameter_idx_DAB1ConsiderIgn_Open=		67,
	enAntennaParameter_idx_DAB1Open2Amp=				68,
	enAntennaParameter_idx_DAB1Open2AmpClearCur_Lw=		69,
	enAntennaParameter_idx_DAB1Open2AmpClearCur_Hg=		70,
	enAntennaParameter_idx_DAB1ConsiderVg_Open2Amp=		71,
	enAntennaParameter_idx_DAB1ConsiderIgn_Open2Amp=	72,
	enAntennaParameter_idx_DAB1ShortCur=				73,
	enAntennaParameter_idx_DAB1ShortClearCur=			74,
	enAntennaParameter_idx_DAB1ConsiderVg_Short=		75,
	enAntennaParameter_idx_DAB1ConsiderIgn_Short=		76,
	enAntennaParameter_idx_DAB1MonitorCycle=			77,
	enAntennaParameter_idx_DAB1NoOfMonitorCycle=		78,
	enAntennaParameter_idx_DAB1ShortCircuitWait=		79,
	enAntennaParameter_idx_DAB1ConsiderCriticalHg_Vg=	80,
	enAntennaParameter_idx_DAB1OutputVoltage=			81,	
	enAntennaParameter_idx_DAB1WarningCur=				82,
	/*83 to 88 reserved bytes*/	
	enAntennaParameter_idx_DAB2AntennaType=				89,
	enAntennaParameter_idx_DAB2OpenCur=					90,
	enAntennaParameter_idx_DAB2OpenClearCur=			91,
	enAntennaParameter_idx_DAB2ConsiderVg_Open=			92,
	enAntennaParameter_idx_DAB2ConsiderIgn_Open=		93,
	enAntennaParameter_idx_DAB2Open2Amp=				94,
	enAntennaParameter_idx_DAB2Open2AmpClearCur_Lw=		95,
	enAntennaParameter_idx_DAB2Open2AmpClearCur_Hg=		96,
	enAntennaParameter_idx_DAB2ConsiderVg_Open2Amp=		97,
	enAntennaParameter_idx_DAB2ConsiderIgn_Open2Amp=	98,
	enAntennaParameter_idx_DAB2ShortCur=				99,
	enAntennaParameter_idx_DAB2ShortClearCur=			100,
	enAntennaParameter_idx_DAB2ConsiderVg_Short=		101,
	enAntennaParameter_idx_DAB2ConsiderIgn_Short=		102,
	enAntennaParameter_idx_DAB2MonitorCycle=			103,
	enAntennaParameter_idx_DAB2NoOfMonitorCycle=		104,
	enAntennaParameter_idx_DAB2ShortCircuitWait=		105,
	enAntennaParameter_idx_DAB2ConsiderCriticalHg_Vg=	106,
	enAntennaParameter_idx_DAB2OutputVoltage=			107,
	enAntennaParameter_idx_DAB2WarningCur=				108,
	/*109 to 114 reserved bytes*/	
	enAntennaParameter_idx_GPSAntennaType=				115,
	enAntennaParameter_idx_GPSOpenCur=					116,
	enAntennaParameter_idx_GPSOpenClearCur=				117,
	enAntennaParameter_idx_GPSConsiderVg_Open=      	118,
	enAntennaParameter_idx_GPSConsiderIgn_Open=	    	119,
	enAntennaParameter_idx_GPSOpen2Amp=					120,
	enAntennaParameter_idx_GPSOpen2AmpClearCur_Lw=		121,
	enAntennaParameter_idx_GPSOpen2AmpClearCur_Hg=		122,
	enAntennaParameter_idx_GPSConsiderVg_Open2Amp=		123,
	enAntennaParameter_idx_GPSConsiderIgn_Open2Amp= 	124,
	enAntennaParameter_idx_GPSShortCur=					125,
	enAntennaParameter_idx_GPSShortClearCur=			126,
	enAntennaParameter_idx_GPSConsiderVg_Short=			127,
	enAntennaParameter_idx_GPSConsiderIgn_Short=    	128,
	enAntennaParameter_idx_GPSMonitorCycle=				129,
	enAntennaParameter_idx_GPSNoOfMonitorCycle=     	130,
	enAntennaParameter_idx_GPSShortCircuitWait=     	131,
	enAntennaParameter_idx_GPSConsiderCriticalHg_Vg=	132,
	enAntennaParameter_idx_GPSOutputVoltage=			133,
	enAntennaParameter_idx_GPSWarningCur=				134,
	/*135 to 140 reserved bytes*/	
	enAntennaParameter_idx_DTV1AntennaType=				141,
	enAntennaParameter_idx_DTV1OpenCur=					142,
	enAntennaParameter_idx_DTV1OpenClearCur=			143,
	enAntennaParameter_idx_DTV1ConsiderVg_Open=			144,
	enAntennaParameter_idx_DTV1ConsiderIgn_Open=		145,
	enAntennaParameter_idx_DTV1Open2Amp=				146,
	enAntennaParameter_idx_DTV1Open2AmpClearCur_Lw=		147,
	enAntennaParameter_idx_DTV1Open2AmpClearCur_Hg=		148,
	enAntennaParameter_idx_DTV1ConsiderVg_Open2Amp=		149,
	enAntennaParameter_idx_DTV1ConsiderIgn_Open2Amp=	150,
	enAntennaParameter_idx_DTV1ShortCur=				151,
	enAntennaParameter_idx_DTV1ShortClearCur=			152,
	enAntennaParameter_idx_DTV1ConsiderVg_Short=		153,
	enAntennaParameter_idx_DTV1ConsiderIgn_Short=		154,
	enAntennaParameter_idx_DTV1MonitorCycle=			155,
	enAntennaParameter_idx_DTV1NoOfMonitorCycle=		156,
	enAntennaParameter_idx_DTV1ShortCircuitWait=		157,
	enAntennaParameter_idx_DTV1ConsiderCriticalHg_Vg=	158,
	enAntennaParameter_idx_DTV1OutputVoltage=			159,
	enAntennaParameter_idx_DTV1WarningCur=				160,
	/*161 to 166 reserved bytes*/	
	enAntennaParameter_idx_DTV2AntennaType=				167,
	enAntennaParameter_idx_DTV2OpenCur=					168,
	enAntennaParameter_idx_DTV2OpenClearCur=			169,
	enAntennaParameter_idx_DTV2ConsiderVg_Open=			170,
	enAntennaParameter_idx_DTV2ConsiderIgn_Open=		171,
	enAntennaParameter_idx_DTV2Open2Amp=				172,
	enAntennaParameter_idx_DTV2Open2AmpClearCur_Lw=		173,
	enAntennaParameter_idx_DTV2Open2AmpClearCur_Hg=		174,
	enAntennaParameter_idx_DTV2ConsiderVg_Open2Amp=		175,
	enAntennaParameter_idx_DTV2ConsiderIgn_Open2Amp=	176,
	enAntennaParameter_idx_DTV2ShortCur=				177,
	enAntennaParameter_idx_DTV2ShortClearCur=			178,
	enAntennaParameter_idx_DTV2ConsiderVg_Short=		179,
	enAntennaParameter_idx_DTV2ConsiderIgn_Short=		180,
	enAntennaParameter_idx_DTV2MonitorCycle=			181,
	enAntennaParameter_idx_DTV2NoOfMonitorCycle=		182,
	enAntennaParameter_idx_DTV2ShortCircuitWait=		183,
	enAntennaParameter_idx_DTV2ConsiderCriticalHg_Vg=	184,
	enAntennaParameter_idx_DTV2OutputVoltage=		 	185,
	enAntennaParameter_idx_DTV2WarningCur=			 	186,
	/*187 to 192 reserved bytes*/
	enAntennaParameter_idx_DTV3AntennaType=				193,
	enAntennaParameter_idx_DTV3OpenCur=					194,
	enAntennaParameter_idx_DTV3OpenClearCur=			195,
	enAntennaParameter_idx_DTV3ConsiderVg_Open=			196,
	enAntennaParameter_idx_DTV3ConsiderIgn_Open=		197,
	enAntennaParameter_idx_DTV3Open2Amp=				198,
	enAntennaParameter_idx_DTV3Open2AmpClearCur_Lw=		199,
	enAntennaParameter_idx_DTV3Open2AmpClearCur_Hg=		200,
	enAntennaParameter_idx_DTV3ConsiderVg_Open2Amp=		201,
	enAntennaParameter_idx_DTV3ConsiderIgn_Open2Amp=	202,
	enAntennaParameter_idx_DTV3ShortCur=				203,
	enAntennaParameter_idx_DTV3ShortClearCur=			204,
	enAntennaParameter_idx_DTV3ConsiderVg_Short=		205,
	enAntennaParameter_idx_DTV3ConsiderIgn_Short=		206,
	enAntennaParameter_idx_DTV3MonitorCycle=			207,
	enAntennaParameter_idx_DTV3NoOfMonitorCycle=		208,
	enAntennaParameter_idx_DTV3ShortCircuitWait=		209,
	enAntennaParameter_idx_DTV3ConsiderCriticalHg_Vg=	210,
	enAntennaParameter_idx_DTV3OutputVoltage=		 	211,
	enAntennaParameter_idx_DTV3WarningCur=			 	212,
	/*213 to 218 reserved bytes*/
	enAntennaParameter_idx_DTV4AntennaType=				219,
	enAntennaParameter_idx_DTV4OpenCur=					220,
	enAntennaParameter_idx_DTV4OpenClearCur=			221,
	enAntennaParameter_idx_DTV4ConsiderVg_Open=			222,
	enAntennaParameter_idx_DTV4ConsiderIgn_Open=		223,
	enAntennaParameter_idx_DTV4Open2Amp=				224,
	enAntennaParameter_idx_DTV4Open2AmpClearCur_Lw=		225,
	enAntennaParameter_idx_DTV4Open2AmpClearCur_Hg=		226,
	enAntennaParameter_idx_DTV4ConsiderVg_Open2Amp=		227,
	enAntennaParameter_idx_DTV4ConsiderIgn_Open2Amp=	228,
	enAntennaParameter_idx_DTV4ShortCur=				229,
	enAntennaParameter_idx_DTV4ShortClearCur=			230,
	enAntennaParameter_idx_DTV4ConsiderVg_Short=		231,
	enAntennaParameter_idx_DTV4ConsiderIgn_Short=		232,
	enAntennaParameter_idx_DTV4MonitorCycle=			233,
	enAntennaParameter_idx_DTV4NoOfMonitorCycle=		234,
	enAntennaParameter_idx_DTV4ShortCircuitWait=		235,
	enAntennaParameter_idx_DTV4ConsiderCriticalHg_Vg=	236,
	enAntennaParameter_idx_DTV4OutputVoltage=		 	237,
	enAntennaParameter_idx_DTV4WarningCur=			 	238,
	enAntennaParameter_idx_ResSec1_End=			 		244,
	enAntennaParameter_idx_end= 						296
	/*239 to 296 reserved bytes*/

}tenAntennaParameter;

typedef enum
{
	enA1_VoltageError		= 0x04,
	enA1_OverCurrentError	= 0x0c,
	enA2_VoltageError       = 0x10,
	enA2_OverCurrentError   = 0x30
}ten_ELMOSError;

typedef enum
{
	enA1_ShortDetectionMask  = 0x0c,
	enA2_ShortDetectionMask  = 0x30
}ten_ELMOSShortDetectionMask;

typedef enum 
{
   enDisablePower = 0,
   enEnablePower =  1,
   enPhantomPower = 2,
   enNonePower
}tenAntennaFeed;

typedef enum 
{
	enMaxICOpenGPIOPinActive = 	0,
	enMaxICShortGPIOPinActive =	1,
	enMaxICShortndOpenGPIOPinInActive
}tenMaxICGPIOPinState;

namespace TUNMSTR_ANTDIAG{
enum tenSystemSetInterfaces
{
	vOnSystemSetPrepare=		1,
	vOnSystemSet,
	vOnSystemSetFinished,
	vOnRoutineControlStart,
	vStartAntennaDiag=			0x0a,
	vStopAntennaDiag,
	vTurnOnDABAntenna,
	vTurnOffDABAntenna,
	vTurnOnFMAntenna,
	vTurnOffFMAntenna,
	vTurnOnSUZA_Sample_ExtSup,
	vTurnOffSUZA_Sample_ExtSup
};
}
//ELMOS IC System register values
typedef enum
{
	enDisableBothA1AndA2=	0xA0,
	enEnableOnlyA1=			0xA1,
	enEnableOnlyA2=			0xA2,
	enEnableBothA1AndA2=	0xA3
} ten_ELMOSStatusReg;

typedef enum
{
	enELMOS1_IcIndex,
	enELMOS2_IcIndex,
	enELMOS3_IcIndex,
	enELMOS4_IcIndex,
	enELMOSIcIndex
}tenELMOSPowerICIndex;

typedef enum
{
	enMAX20084_1_IcIndex,
	enMAX20084_2_IcIndex,
	enMAX20084_3_IcIndex,
	enMAX20084IcIndex
}tenMAX20084IcIndex;
typedef enum
{
	enMax20084DevIDRg,
	enMax20084ILim1Rg,
	enMax20084ILim2Rg,
	enMax20084OIOL1Rg,
	enMax20084OIOL2Rg,
	enMax20084WarIRg,
	enMax20084OutV1Rg,
	enMax20084OutV2Rg,
	enMax20084SetUp1Rg,
	enMax20084SetUp2Rg,
	enMax20084OutI1Rg,
	enMax20084OutLw1Rg,
	enMax20084OutI2Rg,
	enMax20084OutLw2Rg,
	enMax20084Diag1Rg,
	enMax20084Diag2Rg,
	enMax20084MaskRg,
	enMax2008RgNone
}tenMax20084ICReg;
//max20084 IC setup1 reg value
typedef enum
{
	enMax20084DisableBothA1AndA2=	0b00000000,
	enMax20084EnableOnlyA1=			0b00010000,
	enMax20084EnableOnlyA2=			0b00001000,
	enMax20084EnableBothA1AndA2=	0b00011000
}ten_Max20084Setup1Reg;

struct trI2CRead
{
	tBool blReadSucess;
	tU8 u8Value;
	trI2CRead()
	{
		blReadSucess = true;
		u8Value =0;
	}
};
struct trI2CReadCurrent
{
	tBool blReadSucess;
	tFloat fValue;
	trI2CReadCurrent()
	{
		blReadSucess = true;
		fValue =0.0;
	}
};
#define TUNMSTR_ANTDIAG_U8MAX								0xff
#define TUNMSTR_ANTDIAG_U8ZERO								0x00
const tFloat TUNMSTR_ANTDIAG_U8MAX_FLOAT = 					(tFloat)255.0;
const tFloat TUNMSTR_ANTDIAG_ZERO_FLOAT = 					(tFloat)0.0;

#define TUNMSTR_ANTDIAG_ELMOS1ADDRESS						0x51
#define TUNMSTR_ANTDIAG_ELMOS2ADDRESS						0x53
#define TUNMSTR_ANTDIAG_ELMOS3ADDRESS						0x54

#define TUNMSTR_ANTDIAG_MAX20084_1_ADDRESS					0x3B
#define TUNMSTR_ANTDIAG_MAX20084_2_ADDRESS					0x3C
#define TUNMSTR_ANTDIAG_MAX20084_3_ADDRESS					0x3D


#define TUNERMSTR_ANTDIAG_GPIOREGISTER_ADDRESS				0x22
#define TUNERMSTR_ANTDIAG_FPGA_SLAVE_ADDRESS				0x10
#define TUNMSTR_ANTDIAG_2BYTE								2
#define TUNMSTR_ANTDIAG_3BYTE								3

#define TUNMSTR_ANTDIAG_FMANT_OPENCUR						(tU16)10
#define TUNMSTR_ANTDIAG_FMANT_CLOSECUR						(tU16)10
#define TUNMSTR_ANTDIAG_FMANT_SHORTCUR						(tU16)135
#define TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTENNAPERCLIENT		0x02
#define TUNMSTR_ANTDIAG_CONV_MILL_AMP						1000
#define TUNMSTR_ANTDIAG_FM_ANT1_PIN_NAME					"GPIO_FM_ANT_PWR_ON"
#define TUNMSTR_ANTDIAG_FM_PHANTOM_ANT1_PIN_NAME			"GPIO_REAL_PHANTOM_ON"
#define TUNMSTR_ANTDIAG_DAB_ANT1_PIN_NAME					"GPIO_XM_DAB_ANT_PWR_ON"
#define TUNMSTR_ANTDIAG_FM_CPLD								"GPIO_FM_ANT_ERR"
#define TUNMSTR_ANTDIAG_DAB_CPLD							"GPIO_XM_DAB_ANT_ERR"

#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define TUNMSTR_ANTDIAG_ANTENNAPARAMETER_COMPLETE 131
#else
#define TUNMSTR_ANTDIAG_ANTENNAPARAMETER_COMPLETE			(DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE + 40 + 1)
#endif
//For zero current
#define TUNMSTR_ANTDIAG_ZERO_CURRENT						(tU8)0
#define TUNMSTR_SYSTEM_SET_TYPE_TEF							(tU8)1
#define DIAGLIB_U8_MAJOR_VERSION							1
#define DIAGLIB_U8_MINOR_VERSION        					0

#define TUNMSTR_ANTDIAG_MAX_NUMBEROF_EXTPOWER_SUPPLY        4
#define TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT			enClientNone
#define TUNMSTR_ANTDIAG_DIFFERENCE_BTW_ANT_CLIENT_INDEX		26

/*AntennaDTV4ConsiderVoltageForOpenAmplidier(222)+26 = 246 - AntennaFM1ConsiderVoltageForOpenAmplidier(19)--> 246-19*/
#define TUNMSTR_ANTDIAG_DIFFERENCE_BTW_ANT_START_ND_END_INDEX					229
//    Over current Thresold=110/0.786
#define TUNMSTR_ANTDIAG_ELMOS_OVERCURRENT_THRESHOLD                     		0xff
//    Open current Thresold=10/0.196
#define TUNMSTR_ANTDIAG_ELMOS_OPENLOADCURRENT_THRESHOLD                 		51
const tFloat TUNMSTR_ANTDIAG_ELMOS_SHORTCKTOUTVG = 								(tFloat)2.0;
const tFloat TUNMSTR_ANTDIAG_ELMOS_OUTPUT_VG_MUL_FAC = 							(tFloat)0.0706;
const tFloat TUNMSTR_ANTDIAG_ELMOS_LOWCURRENT_REG_MUL_FAC =						(tFloat)0.196;
const tFloat TUNMSTR_ANTDIAG_ELMOS_HIGHCURRENT_REG_MUL_FAC =					(tFloat)0.784;
const tFloat TUNMSTR_ANTDIAG_ELMOS_ADD_AROUND_CUR =								(tFloat)0.0;

#define TUNMSTR_ANTDIAG_PSA_DAB_OPENCUR_RANGE									8
const tFloat  TUNMSTR_ANTDIAG_ELMOS_SUPPLY_VG_MUL_FAC =							(tFloat)0.100;
const tFloat TUNMSTR_ANTDIAG_ELMOS_SUPPLY_VG =									(tFloat)10.3;

const tU16 TUNMSTR_ANTDIAG_MAX20084_LIMI_DEFAULT = 								270;
//Set setup2 register with warning temp as 95 and blank time as 50ms
const tU16 TUNMSTR_ANTDIAG_MAX20084_SETUPREG2_DEFAULT = 						0x01;
//set Mask register to assert FLT low when for reverse current, over current, short to battery i.e x001 0111
const tU16 TUNMSTR_ANTDIAG_MAX20084_MASKREG_DEFAULT = 							0x17;




#define TUNMSTR_ANTDIAG_I2C_FILE_NAME "/dev/i2c-1"

#define ISPOWERSUPPLY_ELMOS(enCMExtPowerSupplyType)((enCMExtPowerSupplyType==enELMOS1_1)||(enCMExtPowerSupplyType==enELMOS1_2)\
							||(enCMExtPowerSupplyType==enELMOS2_1)||(enCMExtPowerSupplyType==enELMOS2_2)\
							||(enCMExtPowerSupplyType==enELMOS3_1)|| (enCMExtPowerSupplyType==enELMOS3_2)\
							|| (enCMExtPowerSupplyType==enELMOS4_1) || (enCMExtPowerSupplyType==enELMOS4_2))

#define ISPOWERSUPPLY_MAX20084(enCMExtPowerSupplyType)((enCMExtPowerSupplyType==enMAX20084_1_1)||(enCMExtPowerSupplyType==enMAX20084_1_2)\
							||(enCMExtPowerSupplyType==enMAX20084_2_1)||(enCMExtPowerSupplyType==enMAX20084_2_2)\
							||(enCMExtPowerSupplyType==enMAX20084_3_1)|| (enCMExtPowerSupplyType==enMAX20084_3_2))

#define TURN_ON_OFF_USING_GPIOREGISTER(enCMExtPowerSupplyType) ((enCMExtPowerSupplyType ==enELMOS3_1) || (enCMExtPowerSupplyType==enELMOS3_2)\
	|| (enCMExtPowerSupplyType==enELMOS4_2) || (enCMExtPowerSupplyType==enELMOS4_1))



//Default Current range
#define TUNMSTR_ANTDIAG_OpenCur						10
#define TUNMSTR_ANTDIAG_OpenClearCur				10
#define TUNMSTR_ANTDIAG_ShortCur					110
#define TUNMSTR_ANTDIAG_ShortClearCur			    110
#define TUNMSTR_ANTDIAG_NO_OF_ELMOSIC				1

#define TUNMSTR_ANTDIAG_ELMOS1_OVERCURRENTREGITER	0x1
#define TUNMSTR_ANTDIAG_ELMOS2_OVERCURRENTREGITER	0x2
#define TUNMSTR_ANTDIAG_ELMOS3_OVERCURRENTREGITER	0x4
#define TUNMSTR_ANTDIAG_ELMOS4_OVERCURRENTREGITER	0x8

#define ISUPDATE_ELMOS_1_SHORTREGISTER(u8ElmosIc) (u8ElmosIc & TUNMSTR_ANTDIAG_ELMOS1_OVERCURRENTREGITER)
#define ISUPDATE_ELMOS_2_SHORTREGISTER(u8ElmosIc) (u8ElmosIc & TUNMSTR_ANTDIAG_ELMOS2_OVERCURRENTREGITER)
#define ISUPDATE_ELMOS_3_SHORTREGISTER(u8ElmosIc) (u8ElmosIc & TUNMSTR_ANTDIAG_ELMOS3_OVERCURRENTREGITER)
#define ISUPDATE_ELMOS_4_SHORTREGISTER(u8ElmosIc) (u8ElmosIc & TUNMSTR_ANTDIAG_ELMOS4_OVERCURRENTREGITER)

#define TUNMSTR_ANTDIAG_FPGA_EN1_ON 				0x10   //Bit 4 
#define TUNMSTR_ANTDIAG_FPGA_EN1_OFF 				0xef  //Bit 4

#define TUNMSTR_ANTDIAG_FPGA_EN2_ON 				0x20   //Bit 5
#define TUNMSTR_ANTDIAG_FPGA_EN2_OFF 				0xdf  //Bit 5

#define TUNMSTR_ANTDIAG_ADC_READ_2BYTE				0x02
#define TUNMSTR_ANTDIAG_SHIFT_4BIT					0x04
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_NORMAL                 ((tU32)0x10000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_OFF                    ((tU32)0x20000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_THREAD                     ((tU32)0x40000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_LOWVG_START                 ((tU32)0x80000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_LOWVG_END                   ((tU32)0x01000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_HIGHVG_START                ((tU32)0x02000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_HIGHVG_END                  ((tU32)0x04000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_MONITORCYCLE_TIMER_EXPIRY       ((tU32)0x08000000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_200MS_TIMER_EXPIRY              ((tU32)0x00100000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_START_ANTDIAG                   ((tU32)0x00200000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_ANTDIAG                    ((tU32)0x00400000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_ITC_UPDATE_REQ                  ((tU32)0x00800000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_STATUS_REQ             ((tU32)0x00010000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_UPREG_REQ              ((tU32)0x00020000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_SET_DTV_ANT_REG_REQ             ((tU32)0x00040000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_ROUTINE_REQ                      ((tU32)0x00080000)
#define TUNMSTR_ANTDIAG_U32_EVENT_MASK_ALL \
         ( TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_NORMAL   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_APPSTATE_OFF   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_THREAD   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_LOWVG_START   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_LOWVG_END   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_HIGHVG_START   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_SPM_HIGHVG_END   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_MONITORCYCLE_TIMER_EXPIRY   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_200MS_TIMER_EXPIRY   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_START_ANTDIAG   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_STOP_ANTDIAG   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_ROUTINE_REQ    \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_STATUS_REQ   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_UPREG_REQ   \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_SET_DTV_ANT_REG_REQ  \
                  | TUNMSTR_ANTDIAG_U32_EVENT_MASK_ITC_UPDATE_REQ)
#endif
/*** END OF FILE************************************************************/
