/************************************************************************
* FILE:           tunmstr_DiaglibListner.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    This class will handle source change logic functionalty.
*  
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author							    | Modification
* 25/05/2012  | ECV4 ( RBEI ) Priya Prabhuswamy     | Initial version.
* 25.04.13    | NGP1KOR    					    | First version of the G3g after porting from NISSAN LCN2Kai
				
 *************************************************************************/
#ifndef tunmstr_DiaglibListner_H
#define tunmstr_DiaglibListner_H

#define DIAGLIB_INCLUDE_SYSTEM_SET
//#define DIAGLIB_INCLUDE_IO_CONTROL
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#include "diaglib_if.h"
#include "fc_tunermaster_featureControl.h"

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clArlSourceImpl.h"
using namespace tuner::sessionManagement::audio;
#endif
#include <cstddef>
#include <mutex>
#include <queue>
using namespace std;

#define TUNERMASTER_SYSTEMSETID(u32SystemSetID)(u32SystemSetID==SYSSETID_TUNE_MASTER)
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define TUNERMASTER_REGISTERED_SYSTEMSETTYEP(u32SystemSetType)(u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF ||\
		u32SystemSetType==(tU32)diaglib::EN_TYPE_CODING|| u32SystemSetType==diaglib::EN_TYPE_UM_RESET_ALL || u32SystemSetType==diaglib::EN_TYPE_UM_RESET_USER ||\
		u32SystemSetType==diaglib::EN_TYPE_UM_SWITCH_USER)
#else
#define TUNERMASTER_REGISTERED_SYSTEMSETTYEP(u32SystemSetType)(u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF ||\
		u32SystemSetType==(tU32)diaglib::EN_TYPE_CODING)
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define TUNERMASTER_HANDLE_PRESETLIST(u32SystemSetType) (u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF ||\
		 u32SystemSetType==diaglib::EN_TYPE_UM_RESET_ALL || u32SystemSetType==diaglib::EN_TYPE_UM_RESET_USER ||\
		u32SystemSetType==diaglib::EN_TYPE_UM_SWITCH_USER)
#else
#define TUNERMASTER_HANDLE_PRESETLIST(u32SystemSetType) (u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF)
#endif

#define TUNMSTR_DIAGLIB_ANTENNA_FEEDREQ_INDEX 0
#include "tunmstr_antdiag_Defines.h"
/*--------------------------------*/
/* class tunmstr_DiaglibListner definition */
/*--------------------------------*/
class tunmaster_tclApp;
class tunmstr_antdiag_Manager;
class tunmaster_Config;
class tunmstr_antdiag_Measure;
class tunmstr_MsgToHMI;
class tunmstr_DiagLogClientHandler;
class tunmstr_antdiag_i2cHandler;
class tunmstr_antdiag_Debounce;
class tunmstr_antdiag_Measure;
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
class tunmstr_Preset_Handler;
class clConfigInterface;
#endif
struct stTunmstrRoutineControlMsg
{
   tenAntDiagClients enAntDiagClient;
   tenAntennaFeed enAntennaFeed;
   diaglib::tContext MsgContext;
   stTunmstrRoutineControlMsg()
   {
      enAntDiagClient = enClientNone;
      enAntennaFeed = enNonePower;
      MsgContext = 0;
   };
};
class tunmstr_DiaglibListner : public diaglib::tclRoutineControlListenerIF, public diaglib::tclSystemSetListenerIF
{
private:
   
	tunmaster_tclApp*				m_potunermaster_main;
	tunmstr_antdiag_Manager*        m_potunmstr_antdiag_Manager;
	tunmstr_MsgToHMI*			   m_potunmstr_MsgToHMI;
	tunmstr_DiagLogClientHandler*   m_potunmstr__DiagLog;
	tunmstr_antdiag_i2cHandler* m_potunmstr_antdiag_i2cHandler;
	tunmstr_antdiag_Debounce* m_potunmstr_antdiag_Debounce;
	tunmstr_antdiag_Measure*		m_potunmstr_antdiag_Measure;
	queue<stTunmstrRoutineControlMsg> m_stTunmstrRoutineControlMsg;
	std::mutex m_TunmstrRoutineControlMsgLock;
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	tunmstr_Preset_Handler*	m_potunmstr_Preset_Handler;
	clConfigInterface* m_poclConfigInterface;
#endif
	diaglib::tclDiagnosisInterfaceFactory* m_poFactory;
	diaglib::tclDiagnosisIF*      m_poDiagIF;
	diaglib::tclCCAServiceIF*     m_poCcaIF;
	diaglib::tclSystemSetIF*		 m_poSystemSetIF;
	diaglib::tclRoutineControlIF*	m_poRoutineCtrlIF;
	diaglib::tContext m_MsgContext;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tuner::sessionManagement::audio::clArlSourceImpl* m_poArlSourceImpl;
#endif

public:
	/*-------------*/
	/* Constructor */
	/*-------------*/
	 virtual ~tunmstr_DiaglibListner( );
	tunmstr_DiaglibListner(tunmaster_tclApp* poMain);
	tVoid vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState);
	tU16 u16GetServiceId();
	tBool bGetServiceVersion (tU16& rfu16MajorVersion, 
                             tU16& rfu16MinorVersion, 
                             tU16& rfu16PatchVersion);
	tVoid vDiagLibDispatchMessage(amt_tclServiceData* poMessage);

	// handler SystemSet
	 tU32 vOnSystemSet( tU32 u32SystemSetID,diaglib::tenSystemSetType u32SystemSetType,
			diaglib::tContext MsgContext );
	 tU32 vOnSystemSetFinished( tU32 u32SystemSetID, 
			diaglib::tenSystemSetType u32SystemSetType,
			diaglib::tContext MsgContext
	);
	 tU32 vOnSystemSetPrepare( tU32 u32SystemSetID,
			diaglib::tenSystemSetType u32SystemSetType,
			diaglib::tContext MsgContext
	);
	// handler for IO Control
/*	virtual tU32 vOnIoControl (
			tU32 u32IoControlId,
			diaglib::tenIoControlAction enActionId,
			const diaglib::tclParameterVector& oParameterVector,
			diaglib::tContext MsgContext
	);
	virtual tU32 vOnIoControlFreeze (
			tU32 u32IoControlId,
			diaglib::tContext MsgContext
	);
	virtual tU32 vOnIoControlUnfreeze (
			tU32 u32IoControlId,
			diaglib::tContext MsgContext
	);*/
	virtual tU32 vOnRoutineControlAbort ( 
            tU32 u32RoutineId, 
            diaglib::tContext MsgContext
    );
	virtual tU32 vOnGetRoutineResult ( 
            tU32 u32RoutineId,
            diaglib::tContext MsgContext
    );
	 virtual tU32 vOnRoutineControlStart ( 
            tU32 u32RoutineId, 
            tU32 u32Bitmask, 
            const diaglib::tclParameterVector& oParamVector,
            diaglib::tContext MsgContext
   );
	tVoid vBuildResultVector (diaglib::tclParameterVector &oResultVector, tU8 u8Param1) const;
	tVoid vSendError (diaglib::tenInternalError enErrorCode, diaglib::tContext MsgContext) const;
	//Set Pointer to tunmstr_MsgToHMI
	tVoid vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI);
   	//Set Pointer to tunmstr_antdiag_Manager
	tVoid vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager );
	//Set Pointer to tunmstr_antdiag_Measuer
	tVoid vSet_tunmstr_antdiag_Measure_Ptr( tunmstr_antdiag_Measure* potunmstr_antdiag_Measure );
	tVoid vSet_tunmstr_DiagLogClientHandler_Ptr(tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler);
	tVoid vSet_tunmstr_antdiag_i2cHandler(tunmstr_antdiag_i2cHandler* Ptunmstr_antdiag_i2cHandler);
	tVoid vSet_tunmstr_antdiag_Debounce_Ptr(tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tVoid vSet_tunmstr_ArlSourceImpl_Ptr(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl);
#endif
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	tVoid vSet_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
#endif


	tenAntennaFeed enGetRoutineCntrlAntennaFeedReq(const diaglib::tclParameterVector& oParamVector,tU32 u32RoutineId);
	tenAntDiagClients enRoutineCntrlAntDiagClient(tU32 u32RoutineId);
	tU32 u32GetParam1(tU32 u32RoutineId)const;
	tU32 u32GetStartLength(tU32 u32RoutineId)const;
	tBool blHandleGPIOstateOff(tenAntDiagClients enAntDiagClient);
	tU32 u32HandleRoutineControlStart(tU32 u32RoutineId,tenAntennaFeed enAntennaFeed,diaglib::tContext MsgContext);
	tVoid vHandleEnablePowerRequest(tenAntDiagClients enAntDiagClient,diaglib::tContext MsgContext);
	tVoid vHandleEnablePhantomPowerRequest(tenAntDiagClients enAntDiagClient,diaglib::tContext MsgContext);
	tVoid vHandleDisablePowerRequest(tenAntDiagClients enAntDiagClient,diaglib::tContext MsgContext);
	tVoid vHandleSystemSetRequest(tU32 u32SystemSetType);
	tVoid vHandleSystemSetFinishRequest(tU32 u32SystemSetType);
	tVoid vHandleSystemSet_CodingRequest();
	tVoid vHandleTTFiS_CMD();
	tVoid vSendSystemSetResult();
	tVoid vInsertMsgToRoutineControlMsgQ(stTunmstrRoutineControlMsg ostTunmstrRoutineControlMsg);
	tBool IsQEmpty();
	tVoid vProcessRoutineControlReq();
	tVoid vHandleRoutineControlReq(stTunmstrRoutineControlMsg ostTunmstrRoutineControlMsg);


   /*-------------*/
   /* Destructors */
   /*-------------*/

};
#endif // tunmstr_DiaglibListner_H

