/************************************************************************
* FILE:           tunmstr_DiagLogClientHandler
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    This class will handle source change logic functionalty.
*  
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date         | Author							    | Modification
* 25/05/2012   | ECV4 ( RBEI ) Priya Prabhuswamy    | Initial version.
* 25.04.13     | NGP1KOR    					    | First version of the G3g after porting from NISSAN LCN2Kai
				
 *************************************************************************/
#ifndef tunmstr_DiagLogClientHandler_H
#define tunmstr_DiagLogClientHandler_H

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

// Include Diaglog interface
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS // not sure
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 


#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"


#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#include "midw_ext_fi_if.h" 
#endif

#include "tunmstr_antdiag_Defines.h"
/*--------------------------------*/
/* class tunmstr_DiagLogClientHandler definition */
/*--------------------------------*/
class tunmstr_antdiag_Manager;
class tunermaster_cfcVehicleClientHandler;
class tunmstr_MsgToHMI;
class tunmaster_tclApp;
class tunmstr_antdiag_Debounce;
class tunmstr_antdiag_Measure;
class tunmstr_antdiag_i2cHandler;
class clConfigInterface;
class tunmaster_tclSPMClient;
class tunmstr_DiagLogClientHandler : public ahl_tclBaseWork
{
private:
	tunmaster_tclApp*				poGWMain;
	tunmstr_antdiag_Manager*		m_potunmstr_antdiag_Manager;
	tunmstr_antdiag_Debounce*		m_potunmstr_antdiag_Debounce;
	tunmstr_antdiag_i2cHandler*     m_potunmstr_antdiag_i2cHandler;
	tunermaster_cfcVehicleClientHandler* m_pocfcVehicleClientHand;
	tunmstr_MsgToHMI*					 m_potunmstr_MsgToHMI;
	tunmstr_antdiag_Measure*		m_potunmstr_antdiag_Measure;
	clConfigInterface* 				m_poclConfigInterface;
	tunmaster_tclSPMClient* 		m_potunermaster_SPM_Client;
	
	static OSAL_tSemHandle			m_hNotTable_SemHandle;
	tU16 m_u16RegID;
	tVoid vHandle_s_UnUsedMessages();
	
	tBool m_blConsider_Vg[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT][enAntennaStateIndexMaxVal];
	tBool m_blConsider_Ign[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT][enAntennaStateIndexMaxVal];
	tFloat f_32BatterVgState[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT][enAntennaStateIndexMaxVal];
	tU8  m_u8IgnCounter,u8IgnTime_InSec;
	tBool m_blPreviousIgnState;
	tU8 m_u8AntennaStatus[TUNMSTR_ANTDIAG_MAX_NUMBEROF_ANTDIAGCLIENT];

public:

	tunmstr_DiagLogClientHandler( tunmaster_tclApp* poMain );
	tunmstr_DiagLogClientHandler();
	virtual ~tunmstr_DiagLogClientHandler( );
	
	tVoid vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager );
	tVoid vSet_tunmstr_antdiag_Debounce( tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce );
	tVoid vSet_tunmstr_cfcVehicleClientHand_Ptr( tunermaster_cfcVehicleClientHandler* pocfcVehicleClientHand );
	tVoid vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI);
	tVoid vSet_tunmstr_antdiag_Measure_Ptr( tunmstr_antdiag_Measure* potunmstr_antdiag_Measure );
	tVoid vSet_tunmstr_antdiag_i2cHandler(tunmstr_antdiag_i2cHandler* Ptunmstr_antdiag_i2cHandler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tVoid vSet_tunermaster_SPM_Client_Ptr(tunmaster_tclSPMClient* potunermaster_SPM_Client);
	tVoid vSet_tunmstr_DiaglibListner();
	
	tVoid vHandle_g_Send_Next_Test_Result( amt_tclServiceData* poMessage );//no utest
	tVoid vHandleErrorLog(tenAntDiagClients enAntDiagClient,tU8 u8AntennaStatus,tFloat fCurrent);//no utest
	tVoid vHandleSendNextTestResultReq();//utest
	tVoid vUpdateErrorLog(tU16 u16ITCOpen,tU16 u16ITCShort,tU16 u16ITCOpen2Amp, tU8 u8AntennaStatus);//no utest
	tBool blUpdateAntennaStatus(tenAntDiagClients enAntDiagClient,tU8 u8AntennaStatus);//utest
	tVoid vClearAllAntennaStatus();//No logic, hence no utest
	tVoid vValidateIgnitionState();//utest
	tVoid vUpdateAntennaParam_FromKDS(tunerVector<tU8> &AntennaPar);//utest
	tVoid vHandleAntennaStateShort(tenAntDiagClients enAntDiagClient);//utest
	tVoid vTraceKDSParam();//No logic, hence no utest
	tVoid vUpdateAntennaITC();//No logic, hence no utest
	tVoid vClearAllInternalState();//No logic, hence no utest
	tVoid vUpdateITCAsNoResult();//utest
	
	
	tVoid vSendMessage( tU16             u16DestAppID,
			const fi_tclTypeBase&  oOutData,
			tU16             u16Fid,
			tU8              u8OpCode,
			tU16             u16CmdCtr,
			tU16             u16RegId);
	tVoid vOnNewAppState(   tU32 u32OldAppState,  tU32 u32AppState  );
	tVoid vRegisterForService(void);
	tVoid vOnServiceState(   tU16  u16ServiceId ,
			tU16  u16ServerId ,
			tU16  u16RegisterId,
			tU8   u8ServiceState,
			tU16  u16SubId      );
	tBool fregisterForFID(tU16 u16FID);
	tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData )const;

	
	tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);
	
	tU16   u16GetITCCodeForOpen(tenAntDiagClients enAntDiagClient)const;//utest
	tU16   u16GetITCCodeForShort(tenAntDiagClients enAntDiagClient)const;//utest
	tU16   u16GetITCCodeForOpen2Amp(tenAntDiagClients enAntDiagClient)const;//utest

	tBool blCheckBoundaryCond(tU8 u8AntennaStatus,tenAntDiagClients enAntDiagClient);//utest
	
	tU8 u8GetIndex(tU8 u8AntennaStatus)const;//utest
	tU8 u8GetAntenanstate(tenAntDiagClients enAntDiagClients);//utest
	tBool blGetIgnitationState(tU8 u8Client, tU8 u8AntStateInd)const;//utest
	tBool blBatterVgState(tU8 u8Client, tU8 u8AntStateInd)const;//utest
	
	DECLARE_MSG_MAP( tunmstr_DiagLogClientHandler )
};
#endif 
