/**************************************************************************//**
* \file     clTpeg_TunerControl.h
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTpeg_TunerControl_h
#define clTpeg_TunerControl_h

#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "fc_tpeg_types.h"
#include <string>


class clTpeg_Tuner_ImpInterface;


class clTpeg_TunerControl
{
   public:
      virtual ~clTpeg_TunerControl();
      clTpeg_TunerControl();
      tVoid vSetTunerImpl(clTpeg_Tuner_ImpInterface* poImpl);
      tVoid vSetDABTunerImpl(clTpeg_Tuner_ImpInterface* poDabImpl);
      tVoid vSetAMFMTunerImpl(clTpeg_Tuner_ImpInterface* poDabImpl);
      tVoid vSetSXMTunerImpl(clTpeg_Tuner_ImpInterface* poSxmImpl);
      tVoid vSetRDBIDListToTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds);
      tVoid vSetTpegChannel(std::string oTpegUriChn, tBool bOnOff);
   
   private:
      tVoid vSendWishListToDabTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds);
      tVoid vSendWishListToAMFMTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds);
      tVoid vSendWishListToSXMTuner(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds);
      tVoid vSetWishList(std::vector<fi_tcl_TunerRdbId, std::allocator<fi_tcl_TunerRdbId> > &ListOfRdbIds);
};

#endif
