/**************************************************************************//**
* \file     clTpeg_TMCTunerControl.cpp
*
*           clTpeg_TMCTunerControl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "interface/clTpeg_TMCTuner_ImpInterface.h"
#include "interface/clTpeg_TMCTunerControl.h"
#ifdef VARIANT_S_FTR_ENABLE_TPEG
#include "TpegApplication/clTpeg_Data.h"
#include "TpegApplication/clTpeg_TpegMonitor.h"
#endif

static clTpeg_TMCTuner_ImpInterface* m_poTunerImpl = NULL;
static clTpeg_TMCTuner_ImpInterface* m_poTestModeImpl = NULL;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_TMCTunerControl::~clTpeg_TMCTunerControl()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_TMCTunerControl::clTpeg_TMCTunerControl()
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TMCTunerControl::vSetTMCTunerImpl(clTpeg_TMCTuner_ImpInterface* poTunerImpl)
{
   m_poTunerImpl = poTunerImpl;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TMCTunerControl::vSetTestModeScreenImpl(clTpeg_TMCTuner_ImpInterface* poTunerImpl)
{
   m_poTestModeImpl = poTunerImpl;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TMCTunerControl::vOnNewTpegData(std::list<clTpeg_Data> &oTrafficInfoList)
{
   if (NULL != m_poTunerImpl)
   {
      m_poTunerImpl->vOnNewTpegData(oTrafficInfoList);
   }
}



/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_TMCTunerControl::vOnNewFrameData(clTpeg_TpegMonitor & oMonitor)
{
   if (NULL != m_poTestModeImpl)
   {
      m_poTestModeImpl->vOnNewFrameData(oMonitor);
   }
}

