/**************************************************************************//**
* \file     fc_tpegMain.cpp
*
*           fc_tpegMain method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "fc_tpegMain.h"

#include "fc_tpeg_tclServiceHdlTmcTuner.h"

#ifdef VARIANT_S_FTR_ENABLE_TMC
#include "fc_tpeg_tclClientHdlAmFmTuner.h"
#include "AMFMTuner/clTpeg_Method_SetRDBID.h"
#include "AMFMTuner/clTpeg_Property_TunGetDataTMC.h"
#include "AMFMTuner/clTpeg_Property_TunRDBIDACTUALLIST.h"
#include "AMFMTuner/clTpeg_Property_TunTMCInfo.h"
#include "AMFMTuner/clTpeg_AMFMTunerImpl.h"
#include "fc_tpeg_tclClientHdlSxmTuner.h"
#include "SXMTuner/clTpeg_Method_TrafficSetRDBID.h"
#include "SXMTuner/clTpeg_Property_TrafficTMCData.h"
#include "SXMTuner/clTpeg_Property_TrafficRDBIDACTUALLIST.h"
#include "SXMTuner/clTpeg_Property_TrafficTMCInfo.h"
#include "SXMTuner/clTpeg_SXMTunerImpl.h"
#endif

#include "interface/clTpeg_TunerControl.h"
#include "interface/clTpeg_TMCTunerControl.h"

#include "TMCTuner/clTpeg_Method_ExchangeTMCCapabilities.h"
#include "TMCTuner/clTpeg_Method_ExchangeCapabilities.h"
#include "TMCTuner/clTpeg_Method_SetRdbIdWishList.h"
#include "TMCTuner/clTpeg_Method_SwitchOnOff.h"
#include "TMCTuner/clTpeg_Property_OperationMode.h"
#include "TMCTuner/clTpeg_Property_RdbIdActualList.h"
#include "TMCTuner/clTpeg_Property_TMCData.h"
#include "TMCTuner/clTpeg_Property_TunerMode.h"
#include "TMCTuner/clTpeg_Property_TunerStateAndMode.h"

#include "TpegApplication/clTpeg_TMCConfiguration.h"
#include "TpegApplication/clTpeg_TpegConfiguration.h"
#include "TpegApplication/clTpeg_CommonCapability.h"
#include "TpegApplication/clTpeg_KDSConfiguration.h"

#ifdef VARIANT_S_FTR_ENABLE_TPEG
#include "fc_tpeg_tclClientHdlDabTuner.h"
#include "fc_tpeg_tclServiceHdlTpeg.h"

#include "Tpeg/clTpeg_Property_StreamInformation.h"

#include "TMCTuner/clTpeg_Property_Tpeg.h"

#include "DABTuner/clTpeg_Property_TpegData.h"
#include "DABTuner/clTpeg_Method_RDBID_WISH_LIST.h"
#include "DABTuner/clTpeg_Method_SET_TPEG_CHN.h"
#include "DABTuner/clTpeg_Method_TPEG_URI_LIST.h"
#include "DABTuner/clTpeg_Property_TPEG_URI_LIST.h"
#include "DABTuner/clTpeg_DABTunerImpl.h"


#include "TpegApplication/clTpeg_PreDecoderInterface.h"
#include "TpegApplication/clTpeg_Message.h"
#include "TpegApplication/clTpeg_Filter.h"
#include "TpegApplication/clTpeg_WishList.h"
#include "TpegApplication/clTpeg_Uri.h"
#include "TpegApplication/clTpeg_TunerImpl.h"
#include "TpegApplication/clTpeg_PersistentData.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX "FC_TPEG_"
#define ETG_I_TRACE_CHANNEL TR_TTFIS_FC_TPEG
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_TPEG_APPLICATION
#include "trcGenProj/Header/fc_tpegMain.cpp.trc.h"
#endif


/**************************************************************************//**
* Defines
******************************************************************************/
#define HANDLE_DELETE(poClass)   if (poClass) { delete poClass; poClass = NULL;}


/**************************************************************************//**
* Input Commands
******************************************************************************/
ETG_I_CMD_DEFINE((fc_tpeg_tclMain::vShowSupportedClientHandlers, "vShowSupportedClientHandlers", ETG_I_CONST_ARG(0), ETG_I_CONST_ARG(255)))


fc_tpeg_tclMain* fc_tpeg_tclMain::_poMainAppInstance = NULL;


/**************************************************************************//**
* Creates new server object by using the singleton pattern.
******************************************************************************/
fc_tpeg_tclMain* fc_tpeg_tclMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new fc_tpeg_tclMain();
   }
   return _poMainAppInstance;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
fc_tpeg_tclMain::fc_tpeg_tclMain():ahl_tclBaseOneThreadApp()
, _poTmcTunerServer(NULL)
, _poTMCConfiguration(NULL)
, _poTpegConfiguration(NULL)
, _poCommonCapability(NULL)
, _poRdbIdActualList(NULL)
, tunerControl(NULL)
,_poKDSConfiguration(NULL)

#ifdef VARIANT_S_FTR_ENABLE_TMC
, _poAmFmTunerClient(NULL)
, _poSxmTunerClient(NULL)
#endif

#ifdef VARIANT_S_FTR_ENABLE_TPEG
, _poDabTunerClient(NULL)
, _poTpegServer(NULL)
, _poPreDecoderInterface(NULL)
, _poUri(NULL)
, _poPersistentData(NULL)
#endif 

{
   ETG_TRACE_USR4(("fc_tpeg_tclMain() entered."));
   fc_tpeg_tclMain::_poMainAppInstance   = this;

}


/**************************************************************************//**
* Destructor
******************************************************************************/
fc_tpeg_tclMain::~fc_tpeg_tclMain()
{
   ETG_TRACE_USR4(("~fc_tpeg_tclMain() entered."));
   ETG_I_UNREGISTER_FILE();
   ETG_I_UNREGISTER_CHN(); 

   HANDLE_DELETE(_poTmcTunerServer);
   HANDLE_DELETE(_poTMCConfiguration);
   HANDLE_DELETE(_poTpegConfiguration);
   HANDLE_DELETE(_poCommonCapability);
   HANDLE_DELETE(_poRdbIdActualList);
   HANDLE_DELETE(tunerControl);
   HANDLE_DELETE(_poKDSConfiguration);

#ifdef VARIANT_S_FTR_ENABLE_TMC
   HANDLE_DELETE(_poAmFmTunerClient);
   HANDLE_DELETE(_poSxmTunerClient);
#endif

#ifdef VARIANT_S_FTR_ENABLE_TPEG
   HANDLE_DELETE(_poTpegServer);
   HANDLE_DELETE(_poDabTunerClient);
   HANDLE_DELETE(_poPreDecoderInterface);
   HANDLE_DELETE(_poUri);
   HANDLE_DELETE(_poPersistentData);
#endif 
   fc_tpeg_tclMain::_poMainAppInstance = NULL;
}


/**************************************************************************//**
* bOnInit:: Function will create all required function/class objects.
******************************************************************************/
tBool fc_tpeg_tclMain::bOnInit()
{
   ETG_I_REGISTER_CHN(fc_tpeg_tclMain::vTrace_Rx);
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("Function bOnInit() entered."));
   if (bCreateCommonObjects() && bCreateTmcObjects() && bCreateTpegObjects() )
   {
      return TRUE;
   }
   return FALSE;
}


/**************************************************************************//**
* 
******************************************************************************/
tBool fc_tpeg_tclMain::bCreateCommonObjects()
{
   if (_poTmcTunerServer == NULL) {
      _poTmcTunerServer = OSAL_NEW fc_tpeg_tclServiceHdlTmcTuner(this);
      TPEG_NULL_POINTER_CHECK_VAL(_poTmcTunerServer);
      _poRdbIdActualList = OSAL_NEW clTpeg_Property_RdbIdActualList(_poTmcTunerServer);
      _poTmcTunerServer->vAddFunction(_poRdbIdActualList);

      _poTMCConfiguration = OSAL_NEW clTpeg_TMCConfiguration();
      _poTpegConfiguration = OSAL_NEW clTpeg_TpegConfiguration();
      _poCommonCapability = OSAL_NEW clTpeg_CommonCapability();
      _poKDSConfiguration = OSAL_NEW clTpeg_KDSConfiguration();

		tunerControl =  new clTpeg_TunerControl;
		if (_poTmcTunerServer != NULL)
		{
			if((_poTMCConfiguration != NULL) && (_poTpegConfiguration != NULL) && (_poCommonCapability != NULL))
			{
				_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Method_ExchangeTMCCapabilities(_poTmcTunerServer, _poTMCConfiguration));
				_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Method_ExchangeCapabilities(_poTmcTunerServer, _poTMCConfiguration, _poTpegConfiguration, _poCommonCapability));
			}

			_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Method_SetRdbIdWishList(_poTmcTunerServer));
			_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Method_SwitchOnOff(_poTmcTunerServer));
			_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Property_OperationMode(_poTmcTunerServer));
			_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Property_TunerMode(_poTmcTunerServer));
			_poTmcTunerServer->vAddFunction(OSAL_NEW clTpeg_Property_TunerStateAndMode(_poTmcTunerServer));
		}
	}
	return TRUE;
}


/**************************************************************************//**
* 
******************************************************************************/
tBool fc_tpeg_tclMain::bCreateTmcObjects()
{
#ifdef VARIANT_S_FTR_ENABLE_TMC 
   if (_poAmFmTunerClient == NULL) {
      _poAmFmTunerClient = OSAL_NEW fc_tpeg_tclClientHdlAmFmTuner(this);
      TPEG_NULL_POINTER_CHECK_VAL(_poAmFmTunerClient);
   }

   if (_poSxmTunerClient == NULL) {
	   _poSxmTunerClient = OSAL_NEW fc_tpeg_tclClientHdlSxmTuner(this);
         TPEG_NULL_POINTER_CHECK_VAL(_poSxmTunerClient);
   }
   if ( tunerControl!= NULL && _poTmcTunerServer!= NULL)
   {
      clTpeg_Property_TMCData *poTMCData  = OSAL_NEW clTpeg_Property_TMCData(_poTmcTunerServer);
      _poTmcTunerServer->vAddFunction(poTMCData);

	  if(_poKDSConfiguration != NULL)
	  {
		  if(_poKDSConfiguration->bIsSXMTMCServer())
		  {
			  ETG_TRACE_USR4(("SXM Active"));
				clTpeg_Method_TrafficSetRDBID *poTrafficSetRDBID = OSAL_NEW clTpeg_Method_TrafficSetRDBID(_poSxmTunerClient);
				_poSxmTunerClient->vAddFunction(poTrafficSetRDBID);
				clTpeg_SXMTunerImpl* poSXMTunerImpl = OSAL_NEW clTpeg_SXMTunerImpl(poTrafficSetRDBID);
				if(poSXMTunerImpl != NULL)
				tunerControl->vSetSXMTunerImpl(poSXMTunerImpl);
				
				_poSxmTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TrafficTMCData(_poSxmTunerClient, poTMCData));
				if(_poRdbIdActualList !=NULL)
				_poSxmTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TrafficRDBIDACTUALLIST(_poSxmTunerClient, _poRdbIdActualList));
				_poSxmTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TrafficTMCInfo(_poSxmTunerClient));
				
				return TRUE;
		  }
	  }
	 
	  
	  ETG_TRACE_USR4(("AMFM Active"));
	  clTpeg_Method_SetRDBID *poSetRDBID = OSAL_NEW clTpeg_Method_SetRDBID(_poAmFmTunerClient);
	  _poAmFmTunerClient->vAddFunction(poSetRDBID);
  
	  clTpeg_AMFMTunerImpl* poAMFMTunerImpl = OSAL_NEW clTpeg_AMFMTunerImpl(poSetRDBID);
	  tunerControl->vSetAMFMTunerImpl(poAMFMTunerImpl);

	  _poAmFmTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TunGetDataTMC(_poAmFmTunerClient, poTMCData));
	  if(_poRdbIdActualList !=NULL)
	  _poAmFmTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TunRDBIDACTUALLIST(_poAmFmTunerClient, _poRdbIdActualList));
	  //_poAmFmTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TunTMCInfo(_poAmFmTunerClient));
  
	  

   }
#endif
   return TRUE;
}


/**************************************************************************//**
* 
******************************************************************************/
tBool fc_tpeg_tclMain::bCreateTpegObjects()
{
#ifdef VARIANT_S_FTR_ENABLE_TPEG
   if (_poDabTunerClient == NULL) {
    _poDabTunerClient = OSAL_NEW fc_tpeg_tclClientHdlDabTuner(this);
    TPEG_NULL_POINTER_CHECK_VAL(_poDabTunerClient);
   }

   if (_poTpegServer == NULL) {
      _poTpegServer = OSAL_NEW fc_tpeg_tclServiceHdlTpeg(this);
      TPEG_NULL_POINTER_CHECK_VAL(_poTpegServer);
   }

   if (_poTmcTunerServer!= NULL && tunerControl!= NULL)
   {
   _poPersistentData = OSAL_NEW clTpeg_PersistentData("/dev/ffs2/tpeg.ini");
   _poUri = OSAL_NEW clTpeg_Uri(_poPersistentData);
   clTpeg_Method_SET_TPEG_CHN *poMethod_SET_TPEG_CHN = OSAL_NEW clTpeg_Method_SET_TPEG_CHN(_poDabTunerClient, _poUri);
   _poDabTunerClient->vAddFunction(poMethod_SET_TPEG_CHN);
   

   clTpeg_WishList *poWishList = OSAL_NEW clTpeg_WishList(_poUri);

   clTpeg_Method_RDBID_WISH_LIST* poRDBID_WISH_LIST = OSAL_NEW clTpeg_Method_RDBID_WISH_LIST(_poDabTunerClient, _poRdbIdActualList);
   _poDabTunerClient->vAddFunction(poRDBID_WISH_LIST);

   clTpeg_TunerImpl*  poTunerImpl = OSAL_NEW clTpeg_TunerImpl(poWishList);
   clTpeg_DABTunerImpl* poDABTunerImpl = OSAL_NEW clTpeg_DABTunerImpl(poRDBID_WISH_LIST, poMethod_SET_TPEG_CHN);
   tunerControl->vSetTunerImpl(poTunerImpl);
   tunerControl->vSetDABTunerImpl(poDABTunerImpl);
   
   clTpeg_Filter *poTpegFilter = OSAL_NEW clTpeg_Filter(poWishList, _poTpegConfiguration);
   clTpeg_Message *poTpegMessage = OSAL_NEW clTpeg_Message(poTpegFilter, poWishList , _poUri);

   _poDabTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TpegData(_poDabTunerClient, poTpegMessage));
   _poDabTunerClient->vAddFunction(OSAL_NEW clTpeg_Method_TPEG_URI_LIST(_poDabTunerClient, _poUri));
   _poDabTunerClient->vAddFunction(OSAL_NEW clTpeg_Property_TPEG_URI_LIST(_poDabTunerClient, _poUri));

   clTpeg_Property_StreamInformation *poStreamInformation = OSAL_NEW clTpeg_Property_StreamInformation(_poTpegServer);
   _poTpegServer->vAddFunction(poStreamInformation);
   clTpeg_TMCTunerControl  TMCService;
   TMCService.vSetTestModeScreenImpl(poStreamInformation);

   clTpeg_Property_Tpeg *poTpeg = OSAL_NEW clTpeg_Property_Tpeg(_poTmcTunerServer, _poTpegConfiguration);
   _poTmcTunerServer->vAddFunction(poTpeg);

   TMCService.vSetTMCTunerImpl(poTpeg);
   }
#endif
   return TRUE;
}


/**************************************************************************//**
* vOnApplicationClose:: Function will destroy all member objects, timers if any
******************************************************************************/
tVoid fc_tpeg_tclMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));
   //bStopTimer(FC_PDC_TIMER_ID);
 //  vOnSaveSettings(); // only for testing
   try  
   {
#ifdef VARIANT_S_FTR_ENABLE_TMC 
      HANDLE_DELETE(_poAmFmTunerClient);
      HANDLE_DELETE(_poSxmTunerClient);
#endif
      HANDLE_DELETE(_poTmcTunerServer);
#ifdef VARIANT_S_FTR_ENABLE_TPEG
      HANDLE_DELETE(_poDabTunerClient);
#endif
   }
   catch (...) 
   { 
   } 
   
   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}


/**************************************************************************//**
* vOnTimer:: Overrides base timer implementation
******************************************************************************/
tVoid fc_tpeg_tclMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer() entered."));
   u16TimerId = u16TimerId;
}


/**************************************************************************//**
* vOnLoopback:: Overrides base implementation to handle self pointed messages
******************************************************************************/
tVoid fc_tpeg_tclMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* /*poMessage*/)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));
}


/**************************************************************************//**
* vTracePlugIn::  Activate the TTFIS command channel
******************************************************************************/
tVoid fc_tpeg_tclMain::vTracePlugIn(tVoid)
{
//  Funciton are no where being called
//   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
//   tS32 s32Err;
//   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
//   if (desc != OSAL_ERROR) { 
//      MyTraceChannel.enTraceChannel = TR_TTFIS_FC_TPEG;
//      MyTraceChannel.pCallback      = (OSAL_tpfCallback)fc_tpeg_tclMain::vTrace_Rx;
//      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (tS32) &MyTraceChannel);
//      if (s32Err == OSAL_OK) {
//      } else {
//         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
//      }
//      OSAL_s32IOClose(desc);   
//   }
//
}


/**************************************************************************//**
* vTracePlugIn::  Deactivate the TTFIS command channel
******************************************************************************/
tVoid fc_tpeg_tclMain::vTraceUnplug(tVoid)
{
//  Funciton are no where being called
//   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
//   tS32 s32Err;
//   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
//   if (desc != OSAL_ERROR) { 
//      MyTraceChannel.enTraceChannel = TR_TTFIS_FC_TPEG;
//      MyTraceChannel.pCallback      = (OSAL_tpfCallback)fc_tpeg_tclMain::vTrace_Rx ;
//      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (tS32) &MyTraceChannel);
//     if (s32Err == OSAL_OK) {
//      } else {
//        ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
//      }
//      OSAL_s32IOClose(desc);   
//   }
//
}


/**************************************************************************//**
*
******************************************************************************/
tVoid fc_tpeg_tclMain::vOnLoadSettings()
{
#ifdef VARIANT_S_FTR_ENABLE_TPEG
   if (NULL != _poPersistentData)
   {
      _poPersistentData->vLoad();
   }
   if ( NULL != _poUri)
   {
      _poUri->vInitializeMap();
   }
#endif
}


/**************************************************************************//**
*
******************************************************************************/
tVoid fc_tpeg_tclMain::vOnSaveSettings()
{
#ifdef VARIANT_S_FTR_ENABLE_TPEG
   if (NULL != _poPersistentData)
   {
      _poPersistentData->vStore();
   }
#endif
}


/**************************************************************************//**
*
******************************************************************************/
tVoid fc_tpeg_tclMain::vTrace_Rx(const tUChar*)
{
   ETG_TRACE_USR4(("Default input handler entered"));
}


/**************************************************************************//**
*
******************************************************************************/
tVoid fc_tpeg_tclMain::vShowSupportedClientHandlers(tU8, tU8)
{
   ETG_TRACE_USR4(("1.  AMFMTuner"));
   ETG_TRACE_USR4(("2.  DABTuner"));
   ETG_TRACE_USR4(("3.  SXMTuner"));
}




