/**************************************************************************//**
* \file     clTpeg_TpegConfiguration.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#ifndef clTpeg_TpegConfiguration_h
#define clTpeg_TpegConfiguration_h


#include "TMCTuner/tpeg_TMCTuner_fi.h"
#include "fc_tpeg_types.h"
#include <vector>
#include <map>


typedef enum
{
  enTpegCapability_idx_Reserved = 0,
  enTpegCapability_idx_MaxNmbOfTuners = 2,
  enTpegCapability_idx_TunerRoundRobin = 3,
  enTpegCapability_idx_ProgramServiceName = 4,
  enTpegCapability_idx_ServiceProviderName = 5,
  enTpegCapability_idx_MessageDataAmount = 8,
  enTpegCapability_max
} tenTpegCapability;

struct trTpegCapabilityElem {
           trTpegCapabilityElem():
               enTpegCapability(enTpegCapability_idx_Reserved),
               u8Value(0)
           {}
           tenTpegCapability enTpegCapability;
           tU8  u8Value;
   };


class clTpeg_TpegConfiguration
{
public:
    clTpeg_TpegConfiguration( );
    virtual ~clTpeg_TpegConfiguration( );
    tVoid vSetMaxNmbOfTuner(tU8 u8MaxNmbOfTuner) {m_aTpegCapability[enTpegCapability_idx_MaxNmbOfTuners] = u8MaxNmbOfTuner;};
    tVoid vSetRoundRobin(tBool bRoundRobin) {m_aTpegCapability[enTpegCapability_idx_TunerRoundRobin] = bRoundRobin;};
    tVoid vSetProgramServiceNameLen(tU8 u8ProgramServiceNameLen) {m_aTpegCapability[enTpegCapability_idx_ProgramServiceName] = u8ProgramServiceNameLen;};
    tVoid vSetServiceProviderNameLen(tU8 u8ServiceProviderNameLen) {m_aTpegCapability[enTpegCapability_idx_ServiceProviderName] = u8ServiceProviderNameLen;};
    tVoid vSetMessageDataAmount(tU8 u8MessageDataAmount) {m_aTpegCapability[enTpegCapability_idx_MessageDataAmount] = u8MessageDataAmount;};
    tVoid vSetSupportedLocationReferences(std::vector<fi_tcl_e8_TpegLocReferencing> oSupportedTpegLocReferences){ SupportedTpegLocReferences = oSupportedTpegLocReferences;};

    tU8   u8GetMaxNmbOfTuner() { return (tU8)m_aTpegCapability[enTpegCapability_idx_MaxNmbOfTuners];};
    tBool bGetRoundRobin() { return (tBool)m_aTpegCapability[enTpegCapability_idx_TunerRoundRobin];};
    tU8   u8GetProgramServiceNameCount() { return (tU8)m_aTpegCapability[enTpegCapability_idx_ProgramServiceName];};
    tU8   u8GetServiceProviderNameCount() { return (tU8)m_aTpegCapability[enTpegCapability_idx_ServiceProviderName];};
    tU8   u8GetMessageDataAmount() { return (tU8)m_aTpegCapability[enTpegCapability_idx_MessageDataAmount];};
    tVoid vSetTimer_Group8AMsgSend( tU32 u32Time ) { _u32Timer_Group8AMsg = u32Time;};
    tU32  u32GetTimer_Group8AMsgSend() { return _u32Timer_Group8AMsg;};

    tU32  u32GetNumberTpegMsgIn() { return ++_u32CounterTpegMsgIn;};
    tU32  u32GetNumberTpegMsgOut() { return ++_u32CounterTpegMsgOut;};
    tU8 u8GetCapability(tU8 u8CapabilityIndex);
    std::vector<tU8> oGetSupportedApplicationVersions(tU8 u8ApplicationId);
    std::vector<fi_tcl_e8_TpegLocReferencing> oGetSupportedLocationReferences(){ return SupportedTpegLocReferences;};

    tBool bIsApplicationInList(tU8 u8ApplicationId);
    tBool bIsCapabilityInList(tU8 u8CapabilityIndex);

protected:
    tU8 u8GetTpegCapability(tU8 u8CapabilityIndex) {return m_aTpegCapability[u8CapabilityIndex]; };

private:
    tVoid vInitConfig();
    tVoid vInitTpegCapability();
    tVoid vInitSupportedTpegApplications();
    std::map<tU8, tU8 > m_aTpegCapability;
    std::map<tU8, std::vector<tU8> > SupportedMajorVersions;
    tU32 _u32Timer_Group8AMsg;
    tU32 _u32CounterTpegMsgIn;
    tU32 _u32CounterTpegMsgOut;
    std::vector<fi_tcl_e8_TpegLocReferencing> SupportedTpegLocReferences;
};

#endif // clTpeg_TpegConfiguration_h
