/**************************************************************************//**
* \file     clTpeg_TMCConfiguration.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#ifndef clTpeg_TMCConfiguration_h
#define clTpeg_TMCConfiguration_h


#include "fc_tpeg_types.h"


typedef enum
{
  enTmcCapability_idx_Reserved = 0,
  enTmcCapability_idx_EncryptedTmc,
  enTmcCapability_idx_MaxNmbOfTuners,
  enTmcCapability_idx_TunerRoundRobin,
  enTmcCapability_idx_ProgramServiceName,
  enTmcCapability_idx_ServiceProviderName,
  enTmcCapability_idx_MGMDecoding,
  enTmcCapability_idx_MaxNmbRdbIds,
  enTmcCapability_idx_MessageDataAmount,
  enTmcCapability_idx_PriorisedRdbIdList,
  enTmcCapability_idx_BSASupported,
  enTmcCapability_idx_DuplicationResendCycle,
  enTmcCapability_idx_UserSelectedTmcStation,
  enTmcCapability_max
} tenTmcCapability;

struct trTmcCapabilityElem {
           trTmcCapabilityElem():
               enTmcCapability(enTmcCapability_idx_Reserved),
               u8Value(0)
           {}
           tenTmcCapability enTmcCapability;
           tU8  u8Value;
   };


class clTpeg_TMCConfiguration
{
public:
    clTpeg_TMCConfiguration( );
    virtual ~clTpeg_TMCConfiguration( );
    tVoid vInitConfig();
    tVoid vSetEncryptedTMC(tBool bEncryptedTMC) {m_aTmcCapability[enTmcCapability_idx_EncryptedTmc] = bEncryptedTMC;};
    tVoid vSetMaxNmbOfTuner(tU8 u8MaxNmbOfTuner) {m_aTmcCapability[enTmcCapability_idx_MaxNmbOfTuners] = u8MaxNmbOfTuner;};
    tVoid vSetRoundRobin(tBool bRoundRobin) {m_aTmcCapability[enTmcCapability_idx_TunerRoundRobin] = bRoundRobin;};
    tVoid vSetProgramServiceNameLen(tU8 u8ProgramServiceNameLen) {m_aTmcCapability[enTmcCapability_idx_ProgramServiceName] = u8ProgramServiceNameLen;};
    tVoid vSetServiceProviderNameLen(tU8 u8ServiceProviderNameLen) {m_aTmcCapability[enTmcCapability_idx_ServiceProviderName] = u8ServiceProviderNameLen;};
    tVoid vSetMGMDecoding(tBool bMGMDecoding) {m_aTmcCapability[enTmcCapability_idx_MGMDecoding]= bMGMDecoding;};
    tVoid vSetMaxNmbRdbIds(tU8 u8MaxNmbRdbIds) {m_aTmcCapability[enTmcCapability_idx_MaxNmbRdbIds] = u8MaxNmbRdbIds;};
    tVoid vSetMessageDataAmount(tU8 u8MessageDataAmount) {m_aTmcCapability[enTmcCapability_idx_MessageDataAmount] = u8MessageDataAmount;};
    tVoid vSetPriorisedRDBIdList(tBool bPriorisedRDBIdList) {m_aTmcCapability[enTmcCapability_idx_PriorisedRdbIdList] = bPriorisedRDBIdList;};

    tBool bGetEncryptedTMC() { return (tBool)m_aTmcCapability[enTmcCapability_idx_EncryptedTmc];};
    tU8   u8GetMaxNmbOfTuner() { return (tU8)m_aTmcCapability[enTmcCapability_idx_MaxNmbOfTuners];};
    tBool bGetRoundRobin() { return (tBool)m_aTmcCapability[enTmcCapability_idx_TunerRoundRobin];};
    tU8   u8GetProgramServiceNameCount() { return (tU8)m_aTmcCapability[enTmcCapability_idx_ProgramServiceName];};
    tU8   u8GetServiceProviderNameCount() { return (tU8)m_aTmcCapability[enTmcCapability_idx_ServiceProviderName];};
    tBool bGetMGMDecoding() { return (tBool)m_aTmcCapability[enTmcCapability_idx_MGMDecoding];};
    tU8   u8GetMaxNmbRdbIds() { return (tU8)m_aTmcCapability[enTmcCapability_idx_MaxNmbRdbIds];};
    tU8   u8GetMessageDataAmount() { return (tU8)m_aTmcCapability[enTmcCapability_idx_MessageDataAmount];};
    tBool bGetPriorisedRDBIdList() { return (tBool)m_aTmcCapability[enTmcCapability_idx_PriorisedRdbIdList];};
    tVoid vSetTimer_Group8AMsgSend( tU32 u32Time ) { _u32Timer_Group8AMsg = u32Time;};
    tU32  u32GetTimer_Group8AMsgSend() { return _u32Timer_Group8AMsg;};

    tU32  u32GetNumberTmcMsgIn() { return ++_u32CounterTmcMsgIn;};
    tU32  u32GetNumberTmcMsgOut() { return ++_u32CounterTmcMsgOut;};
    tU8 u8GetCapability(tU8 u8CapabilityIndex){ return m_aTmcCapability[u8CapabilityIndex];};

private:
    tU8 m_aTmcCapability[(tU8)enTmcCapability_max];
    tU32 _u32Timer_Group8AMsg;
    tU32 _u32CounterTmcMsgIn;
    tU32 _u32CounterTmcMsgOut;
};

#endif // clTpeg_TMCConfiguration_h
