/**************************************************************************//**
* \file     clTpeg_KDSConfiguration.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clTpeg_KDSConfiguration_h
#define clTpeg_KDSConfiguration_h


#include "fc_tpeg_types.h"

typedef enum
{
  enKdsGenericTunerParameter_idx_TMCServer1						=  93, enKdsGenericTunerParameter_len_TMCServer1					=   1
} tenKdsGenericTunerParameter;

class fc_tpeg_tclServiceHdlTmcTuner;


class clTpeg_KDSConfiguration
{
   public:
      clTpeg_KDSConfiguration( );
      virtual ~clTpeg_KDSConfiguration( );
      tBool bIsSXMTMCServer();

private:
      tU8 u8ReadFMConfiguration();
      tVoid vTriggerServiceStateChange(tBool bEnableService);
      tVoid vReadKDSGenericTunerParameterSet();
	  tS32 s32ReadKDS(OSAL_tIODescriptor IOKdsHandle, tU8* u8Buf, tU16 u16KdsKey, tU16 u16Len) const;
	  tVoid vParse( tU8* pu8KdsBuffer, tU32 u32Length);

      tU8   u8TMCServer1;
};

#endif // clTpeg_KDSConfiguration_h
