/**************************************************************************//**
* \file     clTpeg_File.cpp
*
*           clTpeg_File method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "TpegApplication/clTpeg_File.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_File::clTpeg_File()
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_File::~clTpeg_File()
{
}


/**************************************************************************//**
* 
******************************************************************************/
std::vector< tU8> clTpeg_File::read(std::string oFileName )
{
   std::vector< tU8> BinData;
   if (!oFileName.empty())
   {
      OSAL_tIODescriptor tpegFile = OSAL_IOOpen(oFileName.c_str(), OSAL_EN_READONLY);
      if (tpegFile >= 0)
      {
         tS32 u32Size = 0;
         OSALUTIL_s32FSeek(tpegFile, 0, OSAL_C_S32_SEEK_END);
         u32Size = OSALUTIL_s32FTell( tpegFile );
         if(u32Size > 0)
		 {
        	 try{
        		 BinData.reserve(u32Size);
        	 }
        	 catch(std::bad_alloc &obj)
        	 {
        		 OSAL_s32IOClose(tpegFile);
        		 BinData.clear();
        		 return BinData;
        	 }
        	 tS32 sReturnValue = OSAL_OK;
			 if((sReturnValue = OSALUTIL_s32FSeek(tpegFile, 0, OSAL_C_S32_SEEK_SET)) == OSAL_OK){
				 sReturnValue = OSAL_s32IORead(tpegFile, reinterpret_cast<tPS8>(&BinData[0]), u32Size);
			 }
	         if(sReturnValue == OSAL_ERROR)
	         {
	        	 BinData.clear();
	         }
	       }
      }
      OSAL_s32IOClose(tpegFile);
   }
   return BinData;
}



/**************************************************************************//**
* 
******************************************************************************/
tVoid clTpeg_File::write(std::string oFileName, std::vector< tU8> oBinData )
{
   if (!oFileName.empty())
   {
      OSAL_tIODescriptor tpegFile = OSAL_IOOpen(oFileName.c_str(), OSAL_EN_READWRITE);
      if (tpegFile < 0)
      {
         tpegFile = OSAL_IOCreate(oFileName.c_str(), OSAL_EN_READWRITE);
      }
      if (tpegFile >= 0)
      {
    	 if(!oBinData.empty())
    	 {
    		 OSAL_s32IOWrite(tpegFile, reinterpret_cast<tPS8>(&oBinData[0]), (tU32)oBinData.size());
    	 }
         OSAL_s32IOClose(tpegFile);
      }
   }
}
