/**************************************************************************//**
* \file     clTpeg_Property_TunerStateAndMode.cpp
*
*           RdbIdActualList property implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "TMCTuner/clTpeg_Property_TunerStateAndMode.h"
#include "CcaApp/clCCAhandler.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clTpeg_Property_TunerStateAndMode::~clTpeg_Property_TunerStateAndMode()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTpeg_Property_TunerStateAndMode::clTpeg_Property_TunerStateAndMode(clCCAhandler* poCCAhandler)
   : clServerProperty(TMCTUNERFI_C_U16_TUNERSTATEANDMODE, poCCAhandler)
{
   m_oTunerStatus.TunerState.enType = fi_tcl_e8_TunerState::FI_EN_TUNER_STATE_ON;
   m_oTunerStatus.OperationMode.enType = fi_tcl_e8_OperationMode::FI_EN_TUNER_OP_MODE_FULLY_OPERABLE;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunerStateAndMode::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunerStateAndMode::vGet(amt_tclServiceData* /*poInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunerStateAndMode::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTpeg_Property_TunerStateAndMode::vSendStatus()
{
   vStatus(m_oTunerStatus);
}
